/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.logging.LogService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public abstract class SocketIOWithTimeout {
    private static final Logger logger = LogService.getLogger();
    private SelectableChannel channel;
    private long timeout;
    private boolean closed = false;
    private static final SelectorPool selector = new SelectorPool();
    private static final long SELECTOR_TIME_OUT = Long.getLong("gemfire.SELECTOR_TIME_OUT", 120L);
    private static ScheduledExecutorService cleanUpExecutor = SocketIOWithTimeout.startSelectorCleanUpThread();

    SocketIOWithTimeout(SelectableChannel channel, long timeout) throws IOException {
        SocketIOWithTimeout.checkChannelValidity(channel);
        this.channel = channel;
        this.timeout = timeout;
        channel.configureBlocking(false);
    }

    void close() {
        this.closed = true;
    }

    boolean isOpen() {
        return !this.closed && this.channel.isOpen();
    }

    SelectableChannel getChannel() {
        return this.channel;
    }

    static void checkChannelValidity(Object channel) throws IOException {
        if (channel == null) {
            throw new IOException("Channel is null. Check how the channel or socket is created.");
        }
        if (!(channel instanceof SelectableChannel)) {
            throw new IOException("Channel should be a SelectableChannel");
        }
    }

    abstract int performIO(ByteBuffer var1) throws IOException;

    int doIO(ByteBuffer buf, int ops) throws IOException {
        if (!buf.hasRemaining()) {
            throw new IllegalArgumentException("Buffer has no data left.");
        }
        while (buf.hasRemaining()) {
            if (this.closed) {
                return -1;
            }
            try {
                int n = this.performIO(buf);
                if (n != 0) {
                    return n;
                }
            }
            catch (IOException e) {
                if (!this.channel.isOpen()) {
                    this.closed = true;
                }
                throw e;
            }
            int count = 0;
            try {
                count = selector.select(this.channel, ops, this.timeout);
            }
            catch (IOException e) {
                this.closed = true;
                throw e;
            }
            if (count != 0) continue;
            throw new SocketTimeoutException(SocketIOWithTimeout.timeoutExceptionString(this.channel, this.timeout, ops));
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    static void connect(SocketChannel channel, SocketAddress endpoint, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void waitForIO(int ops) throws IOException {
        if (selector.select(this.channel, ops, this.timeout) == 0) {
            throw new SocketTimeoutException(SocketIOWithTimeout.timeoutExceptionString(this.channel, this.timeout, ops));
        }
    }

    public void setTimeout(long timeoutMs) {
        this.timeout = timeoutMs;
    }

    private static String timeoutExceptionString(SelectableChannel channel, long timeout, int ops) {
        String waitingFor;
        switch (ops) {
            case 1: {
                waitingFor = "read";
                break;
            }
            case 4: {
                waitingFor = "write";
                break;
            }
            case 8: {
                waitingFor = "connect";
                break;
            }
            default: {
                waitingFor = "" + ops;
            }
        }
        return timeout + " millis timeout while " + "waiting for channel to be ready for " + waitingFor + ". ch : " + channel;
    }

    public static ScheduledExecutorService startSelectorCleanUpThread() {
        ScheduledExecutorService cleanUpExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r, "selector-pool-cleanup");
                result.setDaemon(true);
                return result;
            }
        });
        cleanUpExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                selector.trimIdleSelectors();
            }
        }, SELECTOR_TIME_OUT, SELECTOR_TIME_OUT, TimeUnit.SECONDS);
        return cleanUpExecutor;
    }

    public static void stopSelectorCleanUpThread() {
        if (cleanUpExecutor != null) {
            cleanUpExecutor.shutdownNow();
        }
    }

    private static class SelectorPool {
        private final ConcurrentHashMap<SelectorProvider, LinkedBlockingDeque<SelectorInfo>> providerList = new ConcurrentHashMap();

        private SelectorPool() {
        }

        int select(SelectableChannel channel, int ops, long timeout) throws IOException {
            SelectorInfo info = this.get(channel);
            SelectionKey key2 = null;
            int ret = 0;
            try {
                do {
                    long start = timeout == 0L ? 0L : System.currentTimeMillis();
                    key2 = channel.register(info.selector, ops);
                    ret = info.selector.select(timeout);
                    if (ret != 0) {
                        int n = ret;
                        return n;
                    }
                    if (timeout <= 0L || (timeout -= System.currentTimeMillis() - start) > 0L) continue;
                    int n = 0;
                    return n;
                } while (!Thread.currentThread().isInterrupted());
                throw new InterruptedIOException("Interruped while waiting for IO on channel " + channel + ". " + timeout + " millis timeout left.");
            }
            finally {
                if (key2 != null) {
                    key2.cancel();
                }
                try {
                    info.selector.selectNow();
                }
                catch (IOException e) {
                    logger.info("Unexpected Exception while clearing selector : ", (Throwable)e);
                    info.close();
                    return ret;
                }
                this.release(info);
            }
        }

        private SelectorInfo get(SelectableChannel channel) throws IOException {
            SelectorInfo selInfo;
            LinkedBlockingDeque<SelectorInfo> presentValue;
            SelectorProvider provider = channel.provider();
            LinkedBlockingDeque<SelectorInfo> deque = this.providerList.get(provider);
            if (deque == null && (presentValue = this.providerList.putIfAbsent(provider, deque = new LinkedBlockingDeque())) != null && deque != presentValue) {
                deque = presentValue;
            }
            if ((selInfo = deque.pollFirst()) != null) {
                selInfo.markForClean = false;
            } else {
                AbstractSelector selector = provider.openSelector();
                selInfo = new SelectorInfo();
                selInfo.selector = selector;
                selInfo.deque = deque;
            }
            return selInfo;
        }

        private void release(SelectorInfo info) {
            info.deque.addFirst(info);
        }

        private void trimIdleSelectors() {
            for (LinkedBlockingDeque<SelectorInfo> selectorPool : this.providerList.values()) {
                this.trimSelectorPool(selectorPool);
            }
        }

        private void trimSelectorPool(LinkedBlockingDeque<SelectorInfo> selectorPool) {
            SelectorInfo selectorInfo = selectorPool.peekLast();
            while (selectorInfo != null && selectorInfo.markForClean) {
                selectorInfo = selectorPool.pollLast();
                if (selectorInfo.markForClean) {
                    selectorInfo.close();
                } else {
                    selectorPool.addFirst(selectorInfo);
                }
                selectorInfo = selectorPool.peekLast();
            }
            Iterator<SelectorInfo> selectorIterator = selectorPool.iterator();
            while (selectorIterator.hasNext()) {
                selectorIterator.next().markForClean = true;
            }
        }

        private static class SelectorInfo {
            Selector selector;
            LinkedBlockingDeque<SelectorInfo> deque;
            volatile boolean markForClean = false;

            private SelectorInfo() {
            }

            void close() {
                if (this.selector != null) {
                    try {
                        this.selector.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unexpected exception while closing selector : ", (Throwable)e);
                    }
                }
            }
        }
    }
}

