/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.StatisticDescriptorImpl;
import com.gemstone.gemfire.internal.StatisticsTypeImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class StatisticsTypeFactoryImpl
implements StatisticsTypeFactory {
    private static final StatisticsTypeFactoryImpl singleton = new StatisticsTypeFactoryImpl();
    private final HashMap statTypes = new HashMap();

    public static final StatisticsTypeFactory singleton() {
        return singleton;
    }

    protected static final void clear() {
        StatisticsTypeFactoryImpl.singleton.statTypes.clear();
    }

    private StatisticsTypeFactoryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsType addType(StatisticsType t) {
        StatisticsType result = t;
        HashMap hashMap = this.statTypes;
        synchronized (hashMap) {
            StatisticsType currentValue = this.findType(result.getName());
            if (currentValue == null) {
                this.statTypes.put(result.getName(), result);
            } else if (result.equals(currentValue)) {
                result = currentValue;
            } else {
                throw new IllegalArgumentException(LocalizedStrings.StatisticsTypeFactoryImpl_STATISTICS_TYPE_NAMED_0_ALREADY_EXISTS.toLocalizedString(result.getName()));
            }
        }
        return result;
    }

    @Override
    public StatisticsType createType(String name, String description, StatisticDescriptor[] stats) {
        return this.addType(new StatisticsTypeImpl(name, description, stats));
    }

    @Override
    public StatisticsType findType(String name) {
        return (StatisticsType)this.statTypes.get(name);
    }

    @Override
    public StatisticsType[] createTypesFromXml(Reader reader) throws IOException {
        return StatisticsTypeImpl.fromXml(reader, this);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units) {
        return StatisticDescriptorImpl.createIntCounter(name, description, units, true);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units) {
        return StatisticDescriptorImpl.createLongCounter(name, description, units, true);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units) {
        return StatisticDescriptorImpl.createDoubleCounter(name, description, units, true);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units) {
        return StatisticDescriptorImpl.createIntGauge(name, description, units, false);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units) {
        return StatisticDescriptorImpl.createLongGauge(name, description, units, false);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units) {
        return StatisticDescriptorImpl.createDoubleGauge(name, description, units, false);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createIntCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createDoubleCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createIntGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean largerBetter) {
        return StatisticDescriptorImpl.createDoubleGauge(name, description, units, largerBetter);
    }
}

