/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.VMStatsContract;

public class VMStats
implements VMStatsContract {
    private static final StatisticsType vmType;
    private static final int cpusId;
    private static final int freeMemoryId;
    private static final int totalMemoryId;
    private static final int maxMemoryId;
    private final Statistics vmStats;

    public VMStats(StatisticsFactory f, long id) {
        this.vmStats = f.createStatistics(vmType, "vmStats", id);
    }

    @Override
    public void refresh() {
        Runtime rt = Runtime.getRuntime();
        this.vmStats.setInt(cpusId, rt.availableProcessors());
        this.vmStats.setLong(freeMemoryId, rt.freeMemory());
        this.vmStats.setLong(totalMemoryId, rt.totalMemory());
        this.vmStats.setLong(maxMemoryId, rt.maxMemory());
    }

    @Override
    public void close() {
        this.vmStats.close();
    }

    public long getFdsOpen() {
        return -1L;
    }

    public long getFdLimit() {
        return 0L;
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        vmType = f.createType("VMStats", "Stats available on any java virtual machine.", new StatisticDescriptor[]{f.createIntGauge("cpus", "Number of cpus available to the java VM on its machine.", "cpus", true), f.createLongGauge("freeMemory", "An approximation fo the total amount of memory currently available for future allocated objects, measured in bytes.", "bytes", true), f.createLongGauge("totalMemory", "The total amount of memory currently available for current and future objects, measured in bytes.", "bytes"), f.createLongGauge("maxMemory", "The maximum amount of memory that the VM will attempt to use, measured in bytes.", "bytes", true)});
        cpusId = vmType.nameToId("cpus");
        freeMemoryId = vmType.nameToId("freeMemory");
        totalMemoryId = vmType.nameToId("totalMemory");
        maxMemoryId = vmType.nameToId("maxMemory");
    }
}

