/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin;

import com.gemstone.gemfire.internal.admin.ApplicationVM;
import com.gemstone.gemfire.internal.admin.CacheSnapshot;
import com.gemstone.gemfire.internal.admin.CompoundEntrySnapshot;
import com.gemstone.gemfire.internal.admin.CompoundRegionSnapshot;
import com.gemstone.gemfire.internal.admin.EntrySnapshot;
import com.gemstone.gemfire.internal.admin.GemFireVM;
import com.gemstone.gemfire.internal.admin.GfManagerAgent;
import com.gemstone.gemfire.internal.admin.RegionSnapshot;
import com.gemstone.gemfire.internal.admin.SnapshotClient;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.List;

public class CacheCollector {
    private List notHeardFrom;
    private List heardFrom;
    private final GfManagerAgent systemAgent;
    private final SnapshotClient view;
    private static int snapshotCount;
    private CacheSnapshot snaps;

    public CacheCollector(GfManagerAgent agent, SnapshotClient view) {
        this.view = view;
        this.systemAgent = agent;
        this.systemAgent.setCacheCollector(this);
    }

    public synchronized void takeSnapshot(String regionName) {
        this.flush();
        ApplicationVM[] apps = this.systemAgent.listApplications();
        for (int j = 0; j < apps.length; ++j) {
            this.notHeardFrom.add(apps[j]);
            apps[j].takeRegionSnapshot(regionName, snapshotCount);
        }
    }

    public synchronized void flush() {
        ++snapshotCount;
        this.clear();
    }

    public void close() {
        this.flush();
        this.systemAgent.setCacheCollector(null);
    }

    private synchronized void clear() {
        this.snaps = null;
        this.notHeardFrom = new ArrayList();
        this.heardFrom = new ArrayList();
    }

    private CacheSnapshot updateResultSet(CacheSnapshot update, GemFireVM poster) {
        this.noteResponse(poster);
        if (update instanceof EntrySnapshot) {
            if (this.snaps instanceof CompoundRegionSnapshot) {
                throw new IllegalStateException(LocalizedStrings.CacheCollector_UNABLE_TO_MIX_REGION_AND_ENTRY_SNAPSHOTS_IN_CACHECOLLECTOR.toLocalizedString());
            }
            if (this.snaps == null) {
                this.snaps = new CompoundEntrySnapshot(update.getName());
            }
            ((CompoundEntrySnapshot)this.snaps).addCache(poster, (EntrySnapshot)update);
        } else if (update instanceof RegionSnapshot) {
            if (this.snaps instanceof CompoundEntrySnapshot) {
                throw new IllegalStateException(LocalizedStrings.CacheCollector_UNABLE_TO_MIX_REGION_AND_ENTRY_SNAPSHOTS_IN_CACHECOLLECTOR.toLocalizedString());
            }
            if (this.snaps == null) {
                this.snaps = new CompoundRegionSnapshot(update.getName().toString());
            }
            ((CompoundRegionSnapshot)this.snaps).addCache(poster, (RegionSnapshot)update);
        }
        return this.snaps;
    }

    private void noteResponse(GemFireVM responder) {
        if (this.notHeardFrom.remove(responder)) {
            this.heardFrom.add(responder);
        }
    }

    public synchronized void resultsReturned(CacheSnapshot snap, GemFireVM member, int snapshotId) {
        if (snapshotId == snapshotCount) {
            if (snap == null) {
                this.noteResponse(member);
            } else {
                this.view.updateSnapshot(this.updateResultSet(snap, member), new ArrayList(this.heardFrom));
            }
        }
    }
}

