/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.admin.StatAlert;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import com.gemstone.gemfire.internal.admin.remote.AlertsNotificationMessage;
import com.gemstone.gemfire.internal.admin.statalerts.StatisticInfo;
import com.gemstone.gemfire.internal.admin.statalerts.StatisticInfoImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class StatAlertsManager {
    private static final Logger logger = LogService.getLogger();
    private static StatAlertsManager alertManager;
    private long refreshInterval;
    protected final HashMap alertDefinitionsMap = new HashMap();
    private SystemTimer timer;
    private boolean refreshAtFixedRate;
    protected final DistributionManager dm;

    private StatAlertsManager(DistributionManager dm) {
        this.dm = dm;
        logger.info(LocalizedMessage.create(LocalizedStrings.StatAlertsManager_STATALERTSMANAGER_CREATED));
    }

    public static synchronized StatAlertsManager getInstance(DistributionManager dm) {
        if (alertManager != null && StatAlertsManager.alertManager.dm == dm) {
            return alertManager;
        }
        if (alertManager != null) {
            alertManager.close();
        }
        dm.getCancelCriterion().checkCancelInProgress(null);
        alertManager = new StatAlertsManager(dm);
        return alertManager;
    }

    private static synchronized void closeInstance() {
        alertManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAlertDefinition(StatAlertDefinition[] defns, int actionCode) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entered StatAlertsManager.updateAlertDefinition *****");
        }
        HashMap hashMap = this.alertDefinitionsMap;
        synchronized (hashMap) {
            if (actionCode == 3) {
                for (int i = 0; i < defns.length; ++i) {
                    this.alertDefinitionsMap.remove(defns[i].getId());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Removed StatAlertDefinition: {}", defns[i].getName());
                }
            } else {
                StatAlertDefinition[] alertDefns = this.createMemberStatAlertDefinition(this.dm, defns);
                for (int i = 0; i < alertDefns.length; ++i) {
                    StatAlertDefinition defn = alertDefns[i];
                    this.alertDefinitionsMap.put(defns[i].getId(), defn);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exiting StatAlertsManager.updateAlertDefinition *****");
        }
    }

    private synchronized void rescheduleTimer() {
        InternalDistributedSystem system;
        if (this.timer != null) {
            this.timer.cancel();
        }
        if ((system = this.dm.getSystem()) == null || system.getDistributionManager() != this.dm) {
            throw new DistributedSystemDisconnectedException("This manager has been cancelled");
        }
        this.timer = new SystemTimer(system, true);
        EvaluateAlertDefnsTask task = new EvaluateAlertDefnsTask();
        if (this.refreshAtFixedRate) {
            this.timer.scheduleAtFixedRate(task, 0L, this.refreshInterval);
        } else {
            this.timer.schedule(task, 0L, this.refreshInterval);
        }
    }

    public synchronized void setRefreshTimeInterval(long interval) {
        this.refreshInterval = interval;
        this.rescheduleTimer();
    }

    public synchronized long getRefreshTimeInterval() {
        return this.refreshInterval;
    }

    public synchronized boolean isRefreshAtFixedRate() {
        return this.refreshAtFixedRate;
    }

    public synchronized void setRefreshAtFixedRate(boolean refreshAtFixedRate) {
        this.refreshAtFixedRate = refreshAtFixedRate;
        this.rescheduleTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatAlert[] getAlerts() {
        HashSet<StatAlert> alerts = new HashSet<StatAlert>();
        HashMap hashMap = this.alertDefinitionsMap;
        synchronized (hashMap) {
            Set keyset = this.alertDefinitionsMap.keySet();
            Iterator iter = keyset.iterator();
            Date now = new Date();
            while (iter.hasNext()) {
                Integer key2 = (Integer)iter.next();
                StatAlertDefinition defn = (StatAlertDefinition)this.alertDefinitionsMap.get(key2);
                StatAlert alert = defn.evaluateAndAlert();
                if (alert == null) continue;
                alert.setTime(now);
                alerts.add(alert);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("getAlerts:  found alert {}", alert);
            }
        }
        return alerts.toArray(new StatAlert[alerts.size()]);
    }

    private StatAlertDefinition[] createMemberStatAlertDefinition(DistributionManager dm, StatAlertDefinition[] defns) {
        dm.getCancelCriterion().checkCancelInProgress(null);
        boolean skipDefinition = false;
        ArrayList<StatAlertDefinition> result = new ArrayList<StatAlertDefinition>();
        for (int i = 0; i < defns.length; ++i) {
            skipDefinition = false;
            StatAlertDefinition defn = defns[i];
            StatisticInfo[] statInfos = defn.getStatisticInfo();
            for (int ii = 0; ii < statInfos.length && !skipDefinition; ++ii) {
                String textId = statInfos[ii].getStatisticsTextId();
                Statistics[] statistics = dm.getSystem().findStatisticsByTextId(textId);
                if (statistics.length == 0) {
                    logger.error(LocalizedMessage.create(LocalizedStrings.StatAlertsManager_STATALERTSMANAGER_CREATEMEMBERSTATALERTDEFINITION_STATISTICS_WITH_GIVEN_TEXTID_0_NOT_FOUND, textId));
                    skipDefinition = true;
                    continue;
                }
                StatisticsType type = statistics[0].getType();
                StatisticDescriptor desc = type.nameToDescriptor(statInfos[ii].getStatisticName());
                statInfos[ii] = new StatisticInfoImpl(statistics[0], desc);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("StatAlertsManager.createMemberStatAlertDefinition: created statInfo {}", statInfos[ii]);
            }
            if (!skipDefinition) {
                defn.setStatisticInfo(statInfos);
                result.add(defn);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("StatAlertsManager.createMemberStatAlertDefinition :: {}", defns[i].getStringRepresentation());
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("StatAlertsManager.createMemberStatAlertDefinition :: StatAlertDefinition {} is excluded", defn.getName());
        }
        return result.toArray(new StatAlertDefinition[result.size()]);
    }

    protected synchronized void close() {
        StatAlertsManager.closeInstance();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    class EvaluateAlertDefnsTask
    extends SystemTimer.SystemTimerTask {
        EvaluateAlertDefnsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run2() {
            boolean isDebugEnabled = logger.isDebugEnabled();
            StatAlertsManager statAlertsManager = StatAlertsManager.this;
            synchronized (statAlertsManager) {
                if (StatAlertsManager.this.dm.getCancelCriterion().cancelInProgress() != null) {
                    return;
                }
                Set adminMemberSet = StatAlertsManager.this.dm.getAdminMemberSet();
                if (adminMemberSet == null || adminMemberSet.isEmpty()) {
                    return;
                }
                if (isDebugEnabled) {
                    logger.debug("EvaluateAlertDefnsTask: starting");
                }
                try {
                    StatAlert[] alerts = StatAlertsManager.this.getAlerts();
                    if (alerts.length == 0) {
                        if (isDebugEnabled) {
                            logger.debug("EvaluateAlertsDefnsTask: no alerts");
                        }
                        return;
                    }
                    AlertsNotificationMessage request = new AlertsNotificationMessage();
                    request.setAlerts(alerts);
                    if (isDebugEnabled) {
                        Iterator iterator = adminMemberSet.iterator();
                        while (iterator.hasNext()) {
                            logger.debug("EvaluateAlertDefnsTask: sending {} alerts to {}", alerts.length, iterator.next());
                        }
                    }
                    request.setRecipients(adminMemberSet);
                    StatAlertsManager.this.dm.putOutgoing(request);
                }
                catch (CancelException e) {
                    logger.debug("EvaluateAlertDefnsTask: system closed: {}", e.getMessage(), e);
                    StatAlertsManager.this.close();
                }
                catch (Exception e) {
                    logger.error(LocalizedMessage.create(LocalizedStrings.StatAlertsManager_EVALUATEALERTDEFNSTASK_FAILED_WITH_AN_EXCEPTION), (Throwable)e);
                    StatAlertsManager.this.close();
                }
                if (isDebugEnabled) {
                    logger.debug("EvaluateAlertDefnsTask: done ");
                }
            }
        }
    }
}

