/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.RuntimeAdminException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminFailureResponse;
import com.gemstone.gemfire.internal.admin.remote.AdminReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.AdminWaiters;
import com.gemstone.gemfire.internal.admin.remote.InspectionClasspathManager;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public abstract class AdminRequest
extends PooledDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private String modifiedClasspath = "";
    protected transient String friendlyName = "";
    private transient AdminReplyProcessor processor;
    protected int msgId;

    public int getMsgId() {
        return this.msgId;
    }

    public AdminResponse sendAndWait(DistributionManager dm) {
        InternalDistributedMember recipient = this.getRecipient();
        if (dm.getId().equals(recipient)) {
            this.msgId = -1;
        } else {
            this.processor = new AdminReplyProcessor(dm.getSystem(), recipient);
            this.msgId = this.processor.getProcessorId();
        }
        return AdminWaiters.sendAndWait(this, dm);
    }

    boolean waitForResponse(long timeout) throws InterruptedException {
        try {
            return this.processor.waitForReplies(timeout);
        }
        catch (ReplyException ex) {
            for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RuntimeAdminException)) continue;
                throw (RuntimeAdminException)cause;
            }
            throw new RuntimeAdminException(LocalizedStrings.AdminRequest_A_REPLYEXCEPTION_WAS_THROWN_WHILE_WAITING_FOR_A_REPLY.toLocalizedString(), ex);
        }
    }

    AdminResponse getResponse() {
        return this.processor.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        AdminResponse response = null;
        InspectionClasspathManager cpMgr = InspectionClasspathManager.getInstance();
        try {
            cpMgr.jumpToModifiedClassLoader(this.modifiedClasspath);
            response = this.createResponse(dm);
        }
        catch (Exception ex) {
            response = AdminFailureResponse.create(dm, this.getSender(), ex);
        }
        finally {
            cpMgr.revertToOldClassLoader();
        }
        if (response != null) {
            response.setMsgId(this.getMsgId());
            dm.putOutgoing(response);
        } else {
            logger.info(LocalizedMessage.create(LocalizedStrings.AdminRequest_RESPONSE_TO__0__WAS_CANCELLED, this.getClass().getName()));
        }
    }

    protected abstract AdminResponse createResponse(DistributionManager var1);

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgId);
        DataSerializer.writeString(this.modifiedClasspath, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgId = in.readInt();
        this.modifiedClasspath = DataSerializer.readString(in);
    }

    public void setModifiedClasspath(String path) {
        this.modifiedClasspath = path == null ? "" : path;
    }

    public InternalDistributedMember getRecipient() {
        InternalDistributedMember[] recipients = this.getRecipients();
        int size2 = recipients.length;
        if (size2 == 0) {
            return null;
        }
        if (size2 > 1) {
            throw new IllegalStateException(LocalizedStrings.AdminRequest_COULD_NOT_RETURN_ONE_RECIPIENT_BECAUSE_THIS_MESSAGE_HAS_0_RECIPIENTS.toLocalizedString(size2));
        }
        return recipients[0];
    }
}

