/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.RegionAdminMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public final class DestroyRegionMessage
extends RegionAdminMessage {
    private static final Logger logger = LogService.getLogger();
    private ExpirationAction action;

    public static DestroyRegionMessage create(ExpirationAction action) {
        DestroyRegionMessage m = new DestroyRegionMessage();
        m.action = action;
        return m;
    }

    @Override
    public void process(DistributionManager dm) {
        Region r = this.getRegion(dm.getSystem());
        if (r != null) {
            try {
                if (this.action == ExpirationAction.LOCAL_DESTROY) {
                    r.localDestroyRegion();
                } else if (this.action == ExpirationAction.DESTROY) {
                    r.destroyRegion();
                } else if (this.action == ExpirationAction.INVALIDATE) {
                    r.invalidateRegion();
                } else if (this.action == ExpirationAction.LOCAL_INVALIDATE) {
                    r.localInvalidateRegion();
                }
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.DestroRegionMessage_FAILED_ATTEMPT_TO_DESTROY_OR_INVALIDATE_REGION_0_FROM_CONSOLE_AT_1, new Object[]{r.getFullPath(), this.getSender()}));
            }
        }
    }

    @Override
    public int getDSFID() {
        return 1020;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.action, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.action = (ExpirationAction)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return LocalizedStrings.DestroyRegionMessage_DESTROYREGIONMESSAGE_FROM_0.toLocalizedString(this.getSender());
    }
}

