/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.DLockToken;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.DLockInfo;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.RemoteDLockInfo;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class FetchDistLockInfoResponse
extends AdminResponse {
    DLockInfo[] lockInfos;

    public static FetchDistLockInfoResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        FetchDistLockInfoResponse m = new FetchDistLockInfoResponse();
        InternalDistributedMember id = dm.getDistributionManagerId();
        Set<Map.Entry<String, DLockService>> entries = DLockService.snapshotAllServices().entrySet();
        ArrayList<RemoteDLockInfo> infos = new ArrayList<RemoteDLockInfo>();
        for (Map.Entry<String, DLockService> entry : entries) {
            String serviceName = entry.getKey().toString();
            DLockService service = entry.getValue();
            Set<Map.Entry<Object, DLockToken>> serviceEntries = service.snapshotService().entrySet();
            for (Map.Entry<Object, DLockToken> token : serviceEntries) {
                infos.add(new RemoteDLockInfo(serviceName, token.getKey().toString(), token.getValue(), id));
            }
        }
        m.lockInfos = infos.toArray(new DLockInfo[0]);
        m.setRecipient(recipient);
        return m;
    }

    public DLockInfo[] getLockInfos() {
        return this.lockInfos;
    }

    @Override
    public int getDSFID() {
        return 1022;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.lockInfos, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.lockInfos = (DLockInfo[])DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return LocalizedStrings.FetchDistLockInfoResponse_FETCHDISTLOCKINFORESPONSE_FROM_0.toLocalizedString(this.getSender());
    }
}

