/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.internal.admin.remote.RemoteGemFireVM;
import com.gemstone.gemfire.internal.admin.remote.RemoteGfManagerAgent;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class HealthListenerMessage
extends PooledDistributionMessage
implements AdminMessageType {
    private int listenerId;
    private GemFireHealth.Health status;

    public static HealthListenerMessage create(int listenerId, GemFireHealth.Health status) {
        HealthListenerMessage m = new HealthListenerMessage();
        m.listenerId = listenerId;
        m.status = status;
        return m;
    }

    @Override
    public void process(DistributionManager dm) {
        RemoteGemFireVM mgr;
        RemoteGfManagerAgent agent = dm.getAgent();
        if (agent != null && (mgr = agent.getMemberById(this.getSender())) != null) {
            mgr.callHealthListeners(this.listenerId, this.status);
        }
    }

    @Override
    public int getDSFID() {
        return 1034;
    }

    @Override
    public boolean sendViaJGroups() {
        return true;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.listenerId);
        DataSerializer.writeObject(this.status, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.listenerId = in.readInt();
        this.status = (GemFireHealth.Health)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return LocalizedStrings.HealthListenerMessage_THE_STATUS_OF_LISTENER_0_IS_1.toLocalizedString(this.listenerId, this.status);
    }
}

