/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

public final class LicenseInfoResponse
extends AdminResponse {
    private static final Logger logger = LogService.getLogger();
    private Properties p;

    public static LicenseInfoResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        LicenseInfoResponse m = new LicenseInfoResponse();
        m.setRecipient(recipient);
        try {
            LicenseChecker lc = dm.getSystem().getLicenseChecker();
            m.p = lc == null ? new Properties() : lc.getLicenseProperties();
        }
        catch (LicenseException le) {
            if (dm != null && dm.getCancelCriterion().cancelInProgress() == null) {
                le.fillInStackTrace();
                logger.warn(le.getMessage(), (Throwable)le);
            }
            m.p = new Properties();
        }
        return m;
    }

    public Properties getLicenseInfo() {
        return this.p;
    }

    @Override
    public int getDSFID() {
        return 1036;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.p, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.p = (Properties)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "LicenseInfoResponse from " + this.getSender();
    }
}

