/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.RemoteCacheStatistics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class RegionStatisticsResponse
extends AdminResponse {
    RemoteCacheStatistics regionStatistics;

    public static RegionStatisticsResponse create(DistributionManager dm, InternalDistributedMember recipient, Region r) {
        RegionStatisticsResponse m = new RegionStatisticsResponse();
        m.setRecipient(recipient);
        m.regionStatistics = new RemoteCacheStatistics(r.getStatistics());
        return m;
    }

    public CacheStatistics getRegionStatistics() {
        return this.regionStatistics;
    }

    @Override
    public int getDSFID() {
        return 1048;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.regionStatistics, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regionStatistics = (RemoteCacheStatistics)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "RegionStatisticsResponse from " + this.getRecipient();
    }
}

