/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.admin.EntrySnapshot;
import com.gemstone.gemfire.internal.admin.remote.RemoteCacheStatistics;
import com.gemstone.gemfire.internal.admin.remote.RemoteObjectName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RemoteEntrySnapshot
implements EntrySnapshot,
DataSerializable {
    private static final long serialVersionUID = 1360498801579593535L;
    private Object name;
    private Object value;
    private Object userAttribute;
    private RemoteCacheStatistics stats;

    public RemoteEntrySnapshot(Region.Entry entry, boolean statsEnabled) throws CacheException {
        Object entryName = entry.getKey();
        this.name = entryName instanceof String || entryName instanceof Number ? entryName : new RemoteObjectName(entryName);
        Object val = entry.getValue();
        this.value = val != null ? val.getClass().getName() + "\"" + val.toString() + "\"" : null;
        Object attr = entry.getUserAttribute();
        this.userAttribute = attr != null ? attr.getClass().getName() + "\"" + attr.toString() + "\"" : null;
        this.stats = statsEnabled ? new RemoteCacheStatistics(entry.getStatistics()) : new RemoteCacheStatistics();
    }

    public RemoteEntrySnapshot() {
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public long getLastModifiedTime() {
        return this.stats.getLastModifiedTime();
    }

    @Override
    public long getLastAccessTime() {
        return this.stats.getLastAccessedTime();
    }

    @Override
    public long getNumberOfHits() {
        return this.stats.getHitCount();
    }

    @Override
    public long getNumberOfMisses() {
        return this.stats.getMissCount();
    }

    @Override
    public float getHitRatio() {
        return this.stats.getHitRatio();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getUserAttribute() {
        return this.userAttribute;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RemoteEntrySnapshot) {
            RemoteEntrySnapshot snap = (RemoteEntrySnapshot)other;
            return this.name.equals(snap.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.name, out);
        DataSerializer.writeObject(this.value, out);
        DataSerializer.writeObject(this.stats, out);
        DataSerializer.writeObject(this.userAttribute, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readObject(in);
        this.value = DataSerializer.readObject(in);
        this.stats = (RemoteCacheStatistics)DataSerializer.readObject(in);
        this.userAttribute = DataSerializer.readObject(in);
    }
}

