/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.admin.SSLConfig;
import com.gemstone.gemfire.internal.admin.TransportConfig;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class RemoteTransportConfig
implements TransportConfig {
    private final boolean mcastEnabled;
    private final boolean mcastDiscovery;
    private final boolean tcpDisabled;
    private final boolean disableAutoReconnect;
    private final DistributionLocatorId mcastId;
    private final Set ids;
    private final String bindAddress;
    private final SSLConfig sslConfig;
    private final String membershipPortRange;
    private int tcpPort;
    private boolean isReconnectingDS;
    private Object oldDSMembershipInfo;

    public RemoteTransportConfig(int port) {
        this(port, null);
    }

    public RemoteTransportConfig(int port, String bindAddress) {
        this.bindAddress = bindAddress == null ? "" : bindAddress;
        this.sslConfig = new SSLConfig();
        this.mcastEnabled = false;
        this.mcastDiscovery = false;
        this.tcpDisabled = false;
        this.disableAutoReconnect = false;
        this.mcastId = null;
        this.ids = Collections.singleton(new DistributionLocatorId(port, bindAddress));
        this.membershipPortRange = RemoteTransportConfig.getMembershipPortRangeString(DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE);
    }

    public RemoteTransportConfig(DistributionConfig config) {
        this.bindAddress = config.getBindAddress() == null ? "" : config.getBindAddress();
        this.tcpPort = config.getTcpPort();
        this.membershipPortRange = RemoteTransportConfig.getMembershipPortRangeString(config.getMembershipPortRange());
        this.sslConfig = new SSLConfig();
        String initialHosts = config.getLocators();
        if (initialHosts == null) {
            initialHosts = "";
        }
        initialHosts = initialHosts.trim();
        if (config.getMcastPort() > 0) {
            this.mcastId = new DistributionLocatorId(config.getMcastAddress(), config.getMcastPort(), config.getBindAddress(), this.sslConfig);
            this.mcastEnabled = true;
        } else {
            this.mcastEnabled = false;
            this.mcastId = null;
        }
        this.tcpDisabled = config.getDisableTcp();
        this.disableAutoReconnect = config.getDisableAutoReconnect();
        if (initialHosts.length() == 0) {
            if (!this.mcastEnabled) {
                this.mcastDiscovery = false;
                this.ids = Collections.EMPTY_SET;
            } else {
                this.mcastDiscovery = true;
                this.ids = Collections.singleton(this.mcastId);
            }
            return;
        }
        this.mcastDiscovery = false;
        HashSet<DistributionLocatorId> locators = new HashSet<DistributionLocatorId>();
        int startIdx = 0;
        int endIdx = -1;
        do {
            String locator;
            if ((endIdx = initialHosts.indexOf(44, startIdx)) == -1) {
                locator = initialHosts.substring(startIdx);
            } else {
                locator = initialHosts.substring(startIdx, endIdx);
                startIdx = endIdx + 1;
            }
            locators.add(new DistributionLocatorId(locator));
        } while (endIdx != -1);
        if (this.mcastEnabled) {
            locators.add(this.mcastId);
        }
        this.ids = Collections.unmodifiableSet(locators);
        if (this.mcastEnabled) {
            Assert.assertTrue(this.mcastId != null);
        }
    }

    public RemoteTransportConfig(boolean isMcastEnabled, boolean isMcastDiscovery, boolean isTcpDisabled, boolean isAutoReconnectDisabled, String bindAddress, SSLConfig sslConfig, Collection ids, String membershipPortRange, int tcpPort) {
        DistributionLocatorId mid = null;
        this.bindAddress = bindAddress == null ? "" : bindAddress;
        this.sslConfig = sslConfig;
        this.mcastEnabled = isMcastEnabled;
        this.mcastDiscovery = isMcastDiscovery;
        this.tcpDisabled = isTcpDisabled;
        this.disableAutoReconnect = isAutoReconnectDisabled;
        if (isMcastEnabled) {
            if (ids.size() < 1) {
                throw new IllegalArgumentException(LocalizedStrings.RemoteTransportConfig_EXPECTED_AT_LEAST_ONE_HOSTPORT_ID.toLocalizedString());
            }
            Iterator it = ids.iterator();
            while (it.hasNext() && mid == null) {
                DistributionLocatorId id = (DistributionLocatorId)it.next();
                if (!id.isMcastId()) continue;
                mid = id;
            }
        }
        this.ids = Collections.unmodifiableSet(new HashSet(ids));
        this.mcastId = mid;
        if (this.mcastEnabled) {
            Assert.assertTrue(this.mcastId != null);
        }
        this.membershipPortRange = membershipPortRange;
        this.tcpPort = tcpPort;
    }

    private static String getMembershipPortRangeString(int[] membershipPortRange) {
        String membershipPortRangeString = "";
        if (membershipPortRange != null && membershipPortRange.length == 2) {
            membershipPortRangeString = membershipPortRange[0] + "-" + membershipPortRange[1];
        }
        return membershipPortRangeString;
    }

    public Set getIds() {
        return this.ids;
    }

    public boolean isMcastDiscovery() {
        return this.mcastDiscovery;
    }

    public boolean isMcastEnabled() {
        return this.mcastEnabled;
    }

    public DistributionLocatorId getMcastId() {
        return this.mcastId;
    }

    public boolean isTcpDisabled() {
        return this.tcpDisabled;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public String getMembershipPortRange() {
        return this.membershipPortRange;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public boolean getIsReconnectingDS() {
        return this.isReconnectingDS;
    }

    public void setIsReconnectingDS(boolean isReconnectingDS) {
        this.isReconnectingDS = isReconnectingDS;
    }

    public Object getOldDSMembershipInfo() {
        return this.oldDSMembershipInfo;
    }

    public void setOldDSMembershipInfo(Object oldDSMembershipInfo) {
        this.oldDSMembershipInfo = oldDSMembershipInfo;
    }

    Properties toDSProperties() {
        Properties props = new Properties();
        props.setProperty("bind-address", this.bindAddress);
        if (this.membershipPortRange != null) {
            props.setProperty("membership-port-range", this.membershipPortRange);
        }
        if (this.tcpPort != 0) {
            props.setProperty("tcp-port", String.valueOf(this.tcpPort));
        }
        if (this.mcastEnabled) {
            props.setProperty("mcast-address", String.valueOf(this.mcastId.getHost().getHostAddress()));
            props.setProperty("mcast-port", String.valueOf(this.mcastId.getPort()));
        } else {
            props.setProperty("mcast-port", String.valueOf(0));
        }
        if (!this.mcastDiscovery) {
            StringBuffer locators = new StringBuffer();
            Iterator iter = this.ids.iterator();
            while (iter.hasNext()) {
                DistributionLocatorId locator = (DistributionLocatorId)iter.next();
                if (locator.isMcastId()) continue;
                String baddr = locator.getBindAddress();
                if (baddr != null && baddr.trim().length() > 0) {
                    locators.append(baddr);
                } else {
                    locators.append(locator.getHost().getCanonicalHostName());
                }
                locators.append("[");
                locators.append(locator.getPort());
                locators.append("]");
                if (!iter.hasNext()) continue;
                locators.append(",");
            }
            props.setProperty("locators", locators.toString());
        }
        this.sslConfig.toDSProperties(props);
        props.setProperty("disable-tcp", this.tcpDisabled ? "true" : "false");
        props.setProperty("disable-auto-reconnect", this.disableAutoReconnect ? "true" : "false");
        return props;
    }

    private String toString(boolean noMcast) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (DistributionLocatorId dli : this.ids) {
            if (noMcast && dli.isMcastId()) continue;
            if (!first) {
                result.append(',');
            } else {
                first = false;
            }
            result.append(dli.toString());
        }
        return result.toString();
    }

    public String locatorsString() {
        return this.toString(true);
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof RemoteTransportConfig) {
            RemoteTransportConfig other = (RemoteTransportConfig)o;
            return this.mcastEnabled == other.mcastEnabled && this.mcastDiscovery == other.mcastDiscovery && this.ids.equals(other.ids);
        }
        return false;
    }

    public int hashCode() {
        return this.ids.hashCode() + (this.isMcastDiscovery() ? 1 : 0);
    }
}

