/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.statalerts;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.admin.statalerts.StatisticInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StatisticInfoImpl
implements StatisticInfo {
    private static final long serialVersionUID = -1525964578728218894L;
    protected transient Statistics statistics;
    protected transient StatisticDescriptor descriptor;

    public StatisticInfoImpl(Statistics statistics, StatisticDescriptor descriptor) {
        this.statistics = statistics;
        this.descriptor = descriptor;
    }

    @Override
    public String getStatisticName() {
        return this.descriptor.getName();
    }

    @Override
    public String getStatisticsTextId() {
        return this.statistics.getTextId();
    }

    @Override
    public void setStatisticName(String statisticName) {
        throw new UnsupportedOperationException("StatisticInfoImpl class does not support setStatisticName method.");
    }

    @Override
    public void setStatisticsTextId(String statisticsTextId) {
        throw new UnsupportedOperationException("StatisticInfoImpl class does not support setStatisticsTextId method.");
    }

    @Override
    public Number getValue() {
        return this.statistics.get(this.descriptor);
    }

    @Override
    public StatisticDescriptor getStatisticDescriptor() {
        return this.descriptor;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public String getStatisticsTypeName() {
        return this.statistics.getType().getName();
    }

    @Override
    public void setStatisticsTypeName(String statisticsType) {
        throw new UnsupportedOperationException("StatisticInfoImpl class does not support setStatisticsTypeName method.");
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof StatisticInfoImpl)) {
            return false;
        }
        String statisticsTextId = this.getStatisticsTextId();
        StatisticInfoImpl other = (StatisticInfoImpl)object;
        return this.getStatisticName() == other.getStatisticName() && statisticsTextId != null && statisticsTextId.equals(other.getStatisticsTextId());
    }

    @Override
    public void toData(DataOutput out) throws IOException {
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    public int hashCode() {
        return (this.getStatisticName() + ":" + this.getStatisticsTextId()).hashCode();
    }

    public String toString() {
        return this.statistics.getType().getName() + " [" + this.descriptor.getName() + "]";
    }

    public static StatisticInfoImpl create(String toString, StatisticsFactory f) {
        int startBrack = toString.indexOf("[");
        int endBrack = toString.indexOf("]");
        if (startBrack == -1 || endBrack == -1) {
            return null;
        }
        String name = toString.substring(0, startBrack).trim();
        String ids = toString.substring(startBrack + 1, endBrack).trim();
        StatisticsType type = f.findType(name);
        if (type == null) {
            return null;
        }
        Statistics[] stats = f.findStatisticsByType(type);
        if (stats.length == 0) {
            return null;
        }
        StatisticDescriptor[] descs = type.getStatistics();
        for (int i = 0; i < descs.length; ++i) {
            if (!descs[i].getName().equalsIgnoreCase(ids)) continue;
            return new StatisticInfoImpl(stats[0], descs[i]);
        }
        return null;
    }
}

