/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.GatewayHubImpl;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public abstract class AbstractGateway
implements Gateway {
    protected final Object controlLock = new Object();
    protected volatile boolean _isRunning = false;
    protected final GatewayHubImpl _hub;
    protected final String _id;
    protected final Cache _cache;
    protected GatewayStats _statistics;
    private Gateway.OrderPolicy _orderPolicy;

    AbstractGateway(GatewayHubImpl hub, String id, String statisticsName, GatewayStats allStatistics) {
        this._cache = hub.getCache();
        this._hub = hub;
        this._id = id;
        this._statistics = new GatewayStats(this._cache.getDistributedSystem(), this._hub.getId(), statisticsName, allStatistics);
    }

    protected GatewayHub getGatewayHub() {
        return this._hub;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getGatewayHubId() {
        return this._hub.getId();
    }

    protected GatewayStats getStatistics() {
        return this._statistics;
    }

    protected void setStatistics(GatewayStats statistics) {
        this._statistics = statistics;
    }

    @Override
    public void setEarlyAck(boolean earlyAck) {
        if (earlyAck) {
            throw new UnsupportedOperationException(LocalizedStrings.GatewayImpl_GATEWAY_COMMUNICATION_NO_LONGER_SUPPORTS_EARLYACK_BECAUSE_OF_DEPRECATION.toLocalizedString());
        }
    }

    @Override
    public boolean getEarlyAck() {
        return false;
    }

    protected abstract void setPrimary(boolean var1);

    public abstract void emergencyClose();

    protected abstract void becomePrimary();

    protected abstract void distribute(EnumListenerEvent var1, EntryEventImpl var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureFrom(Gateway other) throws GatewayException {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            this.setQueueAttributes(other.getQueueAttributes());
            this.setEarlyAck(other.getEarlyAck());
            this.setSocketBufferSize(other.getSocketBufferSize());
            if (other.getSocketReadTimeout() != 0) {
                this.setSocketReadTimeout(other.getSocketReadTimeout());
            }
            this.setOrderPolicy(other.getOrderPolicy());
            for (Gateway.Endpoint otherEndpoint : other.getEndpoints()) {
                this.addEndpoint(otherEndpoint.getId(), otherEndpoint.getHost(), otherEndpoint.getPort());
            }
            for (GatewayEventListener otherListener : other.getListeners()) {
                this.addListener(otherListener);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this._isRunning;
    }

    protected void checkRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException(LocalizedStrings.GatewayImpl_A_GATEWAYS_CONFIGURATION_CANNOT_BE_CHANGED_ONCE_IT_IS_RUNNING.toLocalizedString());
        }
    }

    @Override
    public void setOrderPolicy(Gateway.OrderPolicy orderPolicy) throws GatewayException {
        if (orderPolicy != null) {
            if (this.getConcurrencyLevel() == 1) {
                throw new GatewayException(LocalizedStrings.CacheXmlParser_INVALID_GATEWAY_ORDER_POLICY_CONCURRENCY_0.toLocalizedString(this.getId()));
            }
            this._orderPolicy = orderPolicy;
        }
    }

    @Override
    public Gateway.OrderPolicy getOrderPolicy() {
        return this._orderPolicy;
    }
}

