/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.HeapEvictor;
import com.gemstone.gemfire.internal.cache.lru.HeapLRUCapacityController;
import com.gemstone.gemfire.internal.cache.lru.LRUAlgorithm;
import com.gemstone.gemfire.internal.cache.lru.LRUEntry;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.lru.MemLRUCapacityController;
import com.gemstone.gemfire.internal.cache.lru.NewLIFOClockHand;
import com.gemstone.gemfire.internal.cache.lru.NewLRUClockHand;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLRURegionMap
extends AbstractRegionMap {
    private static final Logger logger = LogService.getLogger();
    private LRUAlgorithm evictionController;
    private final ThreadLocal lruDelta = new ThreadLocal();
    private final ThreadLocal mustRemove = new ThreadLocal();
    private final ThreadLocal callbackDisabled = new ThreadLocal();

    protected abstract void _setCCHelper(EnableLRU var1);

    protected abstract EnableLRU _getCCHelper();

    protected abstract void _setLruList(NewLRUClockHand var1);

    protected abstract NewLRUClockHand _getLruList();

    protected AbstractLRURegionMap(InternalRegionArguments internalRegionArgs) {
        super(internalRegionArgs);
    }

    protected void initialize(Object owner, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs) {
        LRUAlgorithm ec;
        EvictionAlgorithm ea;
        super.initialize(owner, attr, internalRegionArgs, true);
        if (owner instanceof LocalRegion) {
            ea = ((LocalRegion)owner).getEvictionAttributes().getAlgorithm();
            ec = ((LocalRegion)owner).getEvictionController();
        } else if (owner instanceof PlaceHolderDiskRegion) {
            ea = ((PlaceHolderDiskRegion)owner).getActualLruAlgorithm();
            ec = ((EvictionAttributesImpl)((PlaceHolderDiskRegion)owner).getEvictionAttributes()).createEvictionController(null);
        } else {
            throw new IllegalStateException("expected LocalRegion or PlaceHolderDiskRegion");
        }
        this.evictionController = ec;
        if (ea.isLRUMemory()) {
            ((MemLRUCapacityController)ec).setEntryOverHead(this.getEntryOverHead());
        }
        if (ea.isLRUHeap()) {
            ((HeapLRUCapacityController)ec).setEntryOverHead(this.getEntryOverHead());
        }
        this._setCCHelper(AbstractLRURegionMap.getHelper(ec));
        if (ea == EvictionAlgorithm.LIFO_ENTRY || ea == EvictionAlgorithm.LIFO_MEMORY) {
            this._setLruList(new NewLIFOClockHand(owner, this._getCCHelper(), internalRegionArgs));
        } else {
            this._setLruList(new NewLRUClockHand(owner, this._getCCHelper(), internalRegionArgs));
        }
    }

    @Override
    public void changeOwner(LocalRegion r) {
        super.changeOwner(r);
        this._getLruList().setBucketRegion(r);
        this.evictionController.setBucketRegion(r);
    }

    private int getDelta() {
        Object d = this.lruDelta.get();
        this.lruDelta.set(null);
        if (d == null) {
            return 0;
        }
        return (Integer)d;
    }

    private void setDelta(int delta) {
        Integer delt;
        if (!this.getCallbackDisabled()) {
            if (this.getMustRemove()) {
                this.lruUpdateCallback();
            }
            this.setMustRemove(true);
        }
        if ((delt = (Integer)this.lruDelta.get()) != null) {
            delta += delt.intValue();
        }
        this.lruDelta.set(delta);
    }

    public boolean beginChangeValueForm(LRUEntry le, CachedDeserializable cd2, Object v) {
        Object curVal = le._getValue();
        if (curVal != cd2) {
            return false;
        }
        boolean result = false;
        int delta = le.updateEntrySize(this._getCCHelper(), new CDValueWrapper(v));
        if (delta != 0) {
            boolean needToDisableCallbacks;
            result = true;
            boolean bl = needToDisableCallbacks = !this.getCallbackDisabled();
            if (needToDisableCallbacks) {
                this.setCallbackDisabled(true);
            }
            this.setDelta(delta);
            if (needToDisableCallbacks) {
                this.setCallbackDisabled(false);
            }
        }
        if (this._getCCHelper().getEvictionAlgorithm().isLRUHeap() && this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion && HeapEvictor.EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST) {
            result = false;
        }
        return result;
    }

    public void finishChangeValueForm() {
        this.lruUpdateCallback();
    }

    private boolean getMustRemove() {
        Object d = this.mustRemove.get();
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    private void setMustRemove(boolean b) {
        this.mustRemove.set(b ? Boolean.TRUE : null);
    }

    private boolean getCallbackDisabled() {
        Object d = this.callbackDisabled.get();
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    private void setCallbackDisabled(boolean b) {
        this.callbackDisabled.set(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getEntryOverHead() {
        RegionEntryFactory f = this.getEntryFactory();
        if (f == null) {
            return 0;
        }
        return (int)ReflectionSingleObjectSizer.sizeof(f.getEntryClass());
    }

    public final void audit() {
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "Size of LRUMap = {}", this.sizeInVM());
        }
        this._getLruList().audit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int evictEntry(LRUEntry entry, LRUStatistics stats) throws RegionClearedException {
        EvictionAction action = this._getCCHelper().getEvictionAction();
        LocalRegion region = this._getOwner();
        if (action.isLocalDestroy()) {
            int size2 = entry.getEntrySize();
            if (region.evictDestroy(entry)) {
                return size2;
            }
            return 0;
        }
        if (action.isOverflowToDisk()) {
            boolean result;
            Assert.assertTrue(entry instanceof DiskEntry);
            int change = 0;
            LRUEntry lRUEntry = entry;
            synchronized (lRUEntry) {
                if (entry.isInUseByTransaction()) {
                    entry.unsetEvicted();
                    if (logger.isTraceEnabled(LogMarker.LRU)) {
                        logger.trace(LogMarker.LRU, "No eviction of transactional entry for key={}", entry.getKey());
                    }
                    return 0;
                }
                if (entry.isInvalidOrRemoved()) {
                    if (logger.isTraceEnabled(LogMarker.LRU)) {
                        logger.trace(LogMarker.LRU, "no need to evict invalid/localInvalid/destroyed token for key={}", entry.getKey());
                    }
                    return 0;
                }
                entry.setEvicted();
                change = DiskEntry.Helper.overflowToDisk((DiskEntry)((Object)entry), region, this._getCCHelper());
            }
            boolean bl = result = change < 0;
            if (result) {
                if (this._getOwner() instanceof BucketRegion) {
                    BucketRegion bucketRegion = (BucketRegion)this._getOwner();
                    bucketRegion.updateCounter(change);
                    stats.updateCounter(change);
                } else {
                    stats.updateCounter(change);
                }
            } else if (logger.isTraceEnabled(LogMarker.LRU)) {
                logger.trace(LogMarker.LRU, "no need to evict token for key={} because moving its value to disk resulted in a net change of {} bytes.", entry.getKey(), change);
            }
            return change * -1;
        }
        throw new InternalGemFireException(LocalizedStrings.AbstractLRURegionMap_UNKNOWN_EVICTION_ACTION_0.toLocalizedString(action));
    }

    protected final void changeTotalEntrySize(int delta) {
        if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            bucketRegion.updateCounter(delta);
        }
        this._getLruList().stats().updateCounter(delta);
        if (delta > 0 && logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "total lru size is now: {}", this.getTotalEntrySize());
        }
    }

    private static EnableLRU getHelper(LRUAlgorithm ec) {
        return ec.getLRUHelper();
    }

    @Override
    public void evictValue(Object key2) {
        throw new IllegalStateException("The evictValue is not supported on regions with eviction attributes.");
    }

    protected final long getLimit() {
        if (this._getOwner() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            return bucketRegion.getLimit();
        }
        return this._getLruList().stats().getLimit();
    }

    public final LRUStatistics getLRUStatistics() {
        return this._getLruList().stats();
    }

    protected final long getTotalEntrySize() {
        if (this._getOwnerObject() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            return bucketRegion.getCounter();
        }
        return this._getLruList().stats().getCounter();
    }

    @Override
    public final void lruUpdateCallback() {
        boolean isDebugEnabled_LRU;
        block30: {
            int delta;
            isDebugEnabled_LRU = logger.isTraceEnabled(LogMarker.LRU);
            if (this.getCallbackDisabled()) {
                return;
            }
            int bytesToEvict = delta = this.getDelta();
            this.resetThreadLocals();
            if (isDebugEnabled_LRU && this._isOwnerALocalRegion()) {
                logger.trace(LogMarker.LRU, "lruUpdateCallback; list size is: {}; actual size is: {}; map size is: {}; delta is: {}; limit is: {}; tombstone count={}", this.getTotalEntrySize(), this._getLruList().getExpensiveListCount(), this.size(), delta, this.getLimit(), this._getOwner().getTombstoneCount());
            }
            LRUStatistics stats = this._getLruList().stats();
            if (!this._isOwnerALocalRegion()) {
                this.changeTotalEntrySize(delta);
            } else {
                if (this._getCCHelper().getEvictionAlgorithm().isLRUHeap()) {
                    this.changeTotalEntrySize(delta);
                    try {
                        while (bytesToEvict > 0 && this._getCCHelper().mustEvict(stats, this._getOwner(), bytesToEvict)) {
                            boolean evictFromThisRegion = true;
                            if (HeapEvictor.EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST && this._getOwner() instanceof BucketRegion) {
                                long bytesEvicted = 0L;
                                long totalBytesEvicted = 0L;
                                List<BucketRegion> regions = ((BucketRegion)this._getOwner()).getPartitionedRegion().getSortedBuckets();
                                Iterator<BucketRegion> iter = regions.iterator();
                                while (iter.hasNext()) {
                                    BucketRegion region = iter.next();
                                    if (region.getBucketAdvisor().isPrimary()) continue;
                                    try {
                                        bytesEvicted = ((AbstractLRURegionMap)region.entries).centralizedLruUpdateCallback();
                                        if (bytesEvicted == 0L) {
                                            iter.remove();
                                        } else {
                                            evictFromThisRegion = false;
                                        }
                                        totalBytesEvicted += bytesEvicted;
                                        bytesToEvict = (int)((long)bytesToEvict - bytesEvicted);
                                        if (bytesEvicted > (long)bytesToEvict) {
                                            bytesToEvict = 0;
                                            break;
                                        }
                                        if (totalBytesEvicted <= (long)bytesToEvict) continue;
                                        break;
                                    }
                                    catch (RegionDestroyedException rd) {
                                        region.cache.getCancelCriterion().checkCancelInProgress(rd);
                                    }
                                    catch (Exception e) {
                                        region.cache.getCancelCriterion().checkCancelInProgress(e);
                                        logger.warn(LocalizedMessage.create(LocalizedStrings.Eviction_EVICTOR_TASK_EXCEPTION, new Object[]{e.getMessage()}), (Throwable)e);
                                    }
                                }
                            }
                            if (!evictFromThisRegion) continue;
                            LRUEntry removalEntry = (LRUEntry)this._getLruList().getLRUEntry();
                            if (removalEntry != null) {
                                int sizeOfValue = this.evictEntry(removalEntry, stats);
                                if (sizeOfValue == 0) continue;
                                bytesToEvict -= sizeOfValue;
                                if (isDebugEnabled_LRU) {
                                    logger.trace(LogMarker.LRU, "evicted entry key={} total entry size is now: {} bytesToEvict :{}", removalEntry.getKey(), this.getTotalEntrySize(), bytesToEvict);
                                }
                                stats.incEvictions();
                                if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
                                    ((BucketRegion)this._getOwner()).incEvictions(1L);
                                }
                                if (isDebugEnabled_LRU) {
                                    logger.trace(LogMarker.LRU, "evictions={}", stats.getEvictions());
                                }
                                this._getCCHelper().afterEviction();
                                continue;
                            }
                            if (this.getTotalEntrySize() != 0L && isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU, "leaving evict loop early");
                            }
                            break block30;
                        }
                        break block30;
                    }
                    catch (RegionClearedException e) {
                        if (isDebugEnabled_LRU) {
                            logger.trace(LogMarker.LRU, "exception ={}", e.getCause());
                        }
                        break block30;
                    }
                }
                try {
                    while (bytesToEvict > 0 && this._getCCHelper().mustEvict(stats, this._getOwner(), bytesToEvict)) {
                        LRUEntry removalEntry = (LRUEntry)this._getLruList().getLRUEntry();
                        if (removalEntry != null) {
                            if (this.evictEntry(removalEntry, stats) == 0) continue;
                            if (isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU, "evicted entry key(2)={} total entry size is now: {} bytesToEvict :", removalEntry.getKey(), this.getTotalEntrySize(), bytesToEvict);
                            }
                            stats.incEvictions();
                            if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
                                ((BucketRegion)this._getOwner()).incEvictions(1L);
                            }
                            if (isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU, "evictions={}", stats.getEvictions());
                            }
                            this._getCCHelper().afterEviction();
                            continue;
                        }
                        if (this.getTotalEntrySize() == 0L || !isDebugEnabled_LRU) break;
                        logger.trace(LogMarker.LRU, "leaving evict loop early");
                        break;
                    }
                    this.changeTotalEntrySize(delta);
                }
                catch (RegionClearedException e) {
                    if (!isDebugEnabled_LRU) break block30;
                    logger.debug("exception ={}", e.getCause());
                }
            }
        }
        if (isDebugEnabled_LRU) {
            logger.trace(LogMarker.LRU, "callback complete.  LRU size is now {}", this._getLruList().stats().getCounter());
        }
    }

    public final int centralizedLruUpdateCallback() {
        int evictedBytes;
        boolean isDebugEnabled_LRU;
        block10: {
            isDebugEnabled_LRU = logger.isTraceEnabled(LogMarker.LRU);
            evictedBytes = 0;
            if (this.getCallbackDisabled()) {
                return evictedBytes;
            }
            this.getDelta();
            this.resetThreadLocals();
            if (isDebugEnabled_LRU) {
                logger.trace(LogMarker.LRU, "centralLruUpdateCallback: lru size is now {}, limit is: {}", this.getTotalEntrySize(), this.getLimit());
            }
            LRUStatistics stats = this._getLruList().stats();
            try {
                while (this._getOwner().getCache().getHeapEvictor().mustEvict() && this.sizeInVM() > 0 && evictedBytes == 0) {
                    LRUEntry removalEntry = (LRUEntry)this._getLruList().getLRUEntry();
                    if (removalEntry != null) {
                        evictedBytes = this.evictEntry(removalEntry, stats);
                        if (evictedBytes == 0) continue;
                        if (this._getOwner() instanceof BucketRegion) {
                            ((BucketRegion)this._getOwner()).incEvictions(1L);
                        }
                        stats.incEvictions();
                        if (isDebugEnabled_LRU) {
                            logger.debug("evictions={}", stats.getEvictions());
                        }
                        this._getCCHelper().afterEviction();
                        continue;
                    }
                    if (this.getTotalEntrySize() != 0L && isDebugEnabled_LRU) {
                        logger.trace(LogMarker.LRU, "leaving evict loop early");
                    }
                    break;
                }
            }
            catch (RegionClearedException rce) {
                if (!isDebugEnabled_LRU) break block10;
                logger.trace(LogMarker.LRU, "exception ={}", rce.getCause());
            }
        }
        if (isDebugEnabled_LRU) {
            logger.trace(LogMarker.LRU, "callback complete");
        }
        return evictedBytes;
    }

    public final void updateStats() {
        int delta = this.getDelta();
        this.resetThreadLocals();
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "updateStats - delta is: {} total is: {} limit is: {}", delta, this.getTotalEntrySize(), this.getLimit());
        }
        if (delta != 0) {
            this.changeTotalEntrySize(delta);
        }
    }

    @Override
    public final boolean disableLruUpdateCallback() {
        if (this.getCallbackDisabled()) {
            return false;
        }
        this.setCallbackDisabled(true);
        return true;
    }

    @Override
    public final void enableLruUpdateCallback() {
        this.setCallbackDisabled(false);
    }

    public final void disableLruUpdateCallbackForInline() {
        this.setCallbackDisabled(true);
    }

    public final void enableLruUpdateCallbackForInline() {
        this.setCallbackDisabled(false);
    }

    @Override
    public final void resetThreadLocals() {
        this.mustRemove.set(null);
        this.lruDelta.set(null);
        this.callbackDisabled.set(null);
    }

    @Override
    public final Set<VersionSource> clear(RegionVersionVector rvv) {
        this._getLruList().clear(rvv);
        return super.clear(rvv);
    }

    @Override
    protected final void lruEntryCreate(RegionEntry re) {
        boolean possibleClear;
        LRUEntry e = (LRUEntry)re;
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "lruEntryCreate for key={}; list size is: {}; actual size is: {}; map size is: {}; entry size: {}; in lru clock: {}", re.getKey(), this.getTotalEntrySize(), this._getLruList().getExpensiveListCount(), this.size(), e.getEntrySize(), !e.testEvicted());
        }
        e.unsetEvicted();
        NewLRUClockHand lruList = this._getLruList();
        DiskRegion disk = this._getOwner().getDiskRegion();
        boolean bl = possibleClear = disk != null && disk.didClearCountChange();
        if (!possibleClear || this._getOwner().basicGetEntry(re.getKey()) == re) {
            lruList.appendEntry(e);
            this.lruEntryUpdate(e);
        }
    }

    @Override
    protected final void lruEntryUpdate(RegionEntry re) {
        LRUEntry e = (LRUEntry)re;
        this.setDelta(e.updateEntrySize(this._getCCHelper()));
        if (logger.isDebugEnabled()) {
            logger.debug("lruEntryUpdate for key={} size={}", re.getKey(), e.getEntrySize());
        }
        NewLRUClockHand lruList = this._getLruList();
        if (this._isOwnerALocalRegion()) {
            boolean possibleClear;
            DiskRegion disk = this._getOwner().getDiskRegion();
            boolean bl = possibleClear = disk != null && disk.didClearCountChange();
            if (!possibleClear || this._getOwner().basicGetEntry(re.getKey()) == re) {
                if (e instanceof DiskEntry && !e.testEvicted()) {
                    lruList.appendEntry(e);
                }
                e.resetRefCount(lruList);
            }
        } else if (!e.testEvicted()) {
            lruList.appendEntry(e);
        }
    }

    @Override
    protected final void lruEntryDestroy(RegionEntry re) {
        LRUEntry e = (LRUEntry)re;
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "lruEntryDestroy for key={}; list size is: {}; actual size is: {}; map size is: {}; entry size: {}; in lru clock: {}", re.getKey(), this.getTotalEntrySize(), this._getLruList().getExpensiveListCount(), this.size(), e.getEntrySize(), !e.testEvicted());
        }
        this._getLruList().unlinkEntry(e);
        this.changeTotalEntrySize(-1 * e.getEntrySize());
        Token vTok = re.getValueAsToken();
        if (vTok == Token.DESTROYED || vTok == Token.TOMBSTONE) {
            e.updateEntrySize(this._getCCHelper());
        }
    }

    @Override
    public final void lruEntryFaultIn(LRUEntry e) {
        if (logger.isDebugEnabled()) {
            logger.debug("lruEntryFaultIn for key={} size={}", e.getKey(), e.getEntrySize());
        }
        NewLRUClockHand lruList = this._getLruList();
        if (this._isOwnerALocalRegion()) {
            boolean possibleClear;
            DiskRegion disk = this._getOwner().getDiskRegion();
            boolean bl = possibleClear = disk != null && disk.didClearCountChange();
            if (!possibleClear || this._getOwner().basicGetEntry(e.getKey()) == e) {
                this.lruEntryUpdate(e);
                e.unsetEvicted();
                lruList.appendEntry(e);
            }
        } else {
            this.lruEntryUpdate(e);
            lruList.appendEntry(e);
        }
    }

    @Override
    public final void decTxRefCount(RegionEntry re) {
        LocalRegion lr = null;
        if (this._isOwnerALocalRegion()) {
            lr = this._getOwner();
        }
        ((LRUEntry)re).decRefCount(this._getLruList(), lr);
    }

    @Override
    public final boolean lruLimitExceeded() {
        return this._getCCHelper().mustEvict(this._getLruList().stats(), null, 0);
    }

    @Override
    public void lruCloseStats() {
        this._getLruList().closeStats();
    }

    @Override
    final boolean confirmEvictionDestroy(RegionEntry re) {
        LRUEntry lruRe = (LRUEntry)re;
        if (lruRe.isInUseByTransaction() || lruRe.isDestroyed()) {
            lruRe.unsetEvicted();
            return false;
        }
        return true;
    }

    public static class CDValueWrapper {
        private final Object v;

        CDValueWrapper(Object v) {
            this.v = v;
        }

        public Object getValue() {
            return this.v;
        }
    }
}

