/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.cache.AbstractDiskRegionEntry;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryBits;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;

public abstract class AbstractOplogDiskRegionEntry
extends AbstractDiskRegionEntry {
    protected AbstractOplogDiskRegionEntry(RegionEntryContext context, Object value2) {
        super(context, value2);
    }

    abstract void setDiskId(RegionEntry var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removePhase1(LocalRegion r, boolean isClear) throws RegionClearedException {
        AbstractOplogDiskRegionEntry abstractOplogDiskRegionEntry = this;
        synchronized (abstractOplogDiskRegionEntry) {
            DiskEntry.Helper.removeFromDisk(this, r, isClear);
            this._removePhase1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhase2() {
        Object syncObj = this.getDiskId();
        if (syncObj == null) {
            syncObj = this;
        }
        DiskId diskId = syncObj;
        synchronized (diskId) {
            super.removePhase2();
        }
    }

    @Override
    public final boolean fillInValue(LocalRegion r, InitialImageOperation.Entry entry, ByteArrayDataInput in, DM mgr) {
        return DiskEntry.Helper.fillInValue(this, entry, r.getDiskRegion(), mgr, in, r);
    }

    @Override
    public final boolean isOverflowedToDisk(LocalRegion r, DistributedRegion.DiskPosition dp) {
        return DiskEntry.Helper.isOverflowedToDisk(this, r.getDiskRegion(), dp, r);
    }

    @Override
    public final Object getValue(RegionEntryContext context) {
        return DiskEntry.Helper.faultInValue(this, (LocalRegion)context);
    }

    @Override
    public final Object getValueInVMOrDiskWithoutFaultIn(LocalRegion owner) {
        return DiskEntry.Helper.getValueInVMOrDiskWithoutFaultIn(this, owner);
    }

    @Override
    public Object getValueOffHeapOrDiskWithoutFaultIn(LocalRegion owner) {
        return DiskEntry.Helper.getValueOffHeapOrDiskWithoutFaultIn(this, owner);
    }

    @Override
    public final Object getValueOnDisk(LocalRegion r) throws EntryNotFoundException {
        return DiskEntry.Helper.getValueOnDisk(this, r.getDiskRegion());
    }

    @Override
    public final Object getSerializedValueOnDisk(LocalRegion r) throws EntryNotFoundException {
        return DiskEntry.Helper.getSerializedValueOnDisk(this, r.getDiskRegion());
    }

    @Override
    public final Object getValueOnDiskOrBuffer(LocalRegion r) throws EntryNotFoundException {
        return DiskEntry.Helper.getValueOnDiskOrBuffer(this, r.getDiskRegion(), r);
    }

    @Override
    public DiskEntry getPrev() {
        return this.getDiskId().getPrev();
    }

    @Override
    public DiskEntry getNext() {
        return this.getDiskId().getNext();
    }

    @Override
    public void setPrev(DiskEntry v) {
        this.getDiskId().setPrev(v);
    }

    @Override
    public void setNext(DiskEntry v) {
        this.getDiskId().setNext(v);
    }

    @Override
    public void persistConflictingTag(LocalRegion region, VersionTag tag) {
        DiskEntry.Helper.updateVersionOnly(this, region, tag);
        this.setRecentlyUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        LocalRegion lr;
        DiskId did = this.getDiskId();
        boolean checkConflicts = true;
        if (did != null && (lr = (LocalRegion)cacheEvent.getRegion()) != null && lr.getDiskRegion().isReadyForRecovery()) {
            DiskId diskId = did;
            synchronized (diskId) {
                checkConflicts = !EntryBits.isRecoveredFromDisk(did.getUserBits());
            }
        }
        this.processVersionTag(cacheEvent, checkConflicts);
    }

    @Override
    public boolean isRemovedFromDisk() {
        return Token.isRemovedFromDisk(this.getValueAsToken());
    }
}

