/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheCallback;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.EvictionAttributesMutator;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionMembershipListener;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.StatisticsDisabledException;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.cache.util.BridgeClient;
import com.gemstone.gemfire.cache.util.BridgeLoader;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.ReliableDistributionData;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.WrappedRegionMembershipListener;
import com.gemstone.gemfire.internal.cache.extension.Extensible;
import com.gemstone.gemfire.internal.cache.extension.ExtensionPoint;
import com.gemstone.gemfire.internal.cache.extension.SimpleExtensionPoint;
import com.gemstone.gemfire.internal.cache.lru.LRUAlgorithm;
import com.gemstone.gemfire.internal.cache.snapshot.RegionSnapshotServiceImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRegion
implements Region,
RegionAttributes,
AttributesMutator,
CacheStatistics,
DataSerializableFixedID,
RegionEntryContext,
Extensible<Region<?, ?>> {
    private static final Logger logger = LogService.getLogger();
    private final int serialNumber;
    private final Object clSync = new Object();
    private final Object imSync = new Object();
    private volatile CacheListener[] cacheListeners;
    private volatile CacheLoader cacheLoader;
    private volatile CacheWriter cacheWriter;
    private LRUAlgorithm evictionController;
    protected int entryIdleTimeout;
    protected ExpirationAction entryIdleTimeoutExpirationAction;
    protected CustomExpiry customEntryIdleTimeout;
    protected int entryTimeToLive;
    protected ExpirationAction entryTimeToLiveExpirationAction;
    protected CustomExpiry customEntryTimeToLive;
    protected int initialCapacity;
    protected Class keyConstraint;
    protected Class valueConstraint;
    protected float loadFactor;
    protected DataPolicy dataPolicy;
    protected int regionIdleTimeout;
    protected ExpirationAction regionIdleTimeoutExpirationAction;
    protected int regionTimeToLive;
    protected ExpirationAction regionTimeToLiveExpirationAction;
    public static final Scope DEFAULT_SCOPE = Scope.DISTRIBUTED_NO_ACK;
    protected Scope scope = DEFAULT_SCOPE;
    protected boolean statisticsEnabled;
    protected boolean isLockGrantor;
    protected boolean mcastEnabled;
    protected int concurrencyLevel;
    protected volatile boolean concurrencyChecksEnabled;
    protected boolean earlyAck;
    protected final boolean isPdxTypesRegion;
    protected boolean enableGateway;
    protected String gatewayHubId;
    protected Set<String> gatewaySenderIds;
    protected boolean isGatewaySenderEnabled = false;
    protected Set<String> asyncEventQueueIds;
    protected Set<String> allGatewaySenderIds;
    protected Set<String> allGatewayHubIds;
    protected boolean enableSubscriptionConflation;
    protected boolean publisher;
    protected boolean enableAsyncConflation;
    protected boolean cloningEnable = false;
    protected DiskWriteAttributes diskWriteAttributes;
    protected File[] diskDirs;
    protected int[] diskSizes;
    protected String diskStoreName;
    protected boolean isDiskSynchronous;
    protected boolean indexMaintenanceSynchronous = false;
    protected volatile IndexManager indexManager = null;
    private final ThreadLocal isIndexCreator = new ThreadLocal();
    protected PartitionAttributes partitionAttributes;
    protected EvictionAttributesImpl evictionAttributes = new EvictionAttributesImpl();
    protected MembershipAttributes membershipAttributes;
    protected SubscriptionAttributes subscriptionAttributes;
    protected boolean ignoreJTA;
    private final AtomicLong lastAccessedTime;
    private final AtomicLong lastModifiedTime;
    private static final boolean trackHits = !Boolean.getBoolean("gemfire.ignoreHits");
    private static final boolean trackMisses = !Boolean.getBoolean("gemfire.ignoreMisses");
    private final AtomicLong hitCount = new AtomicLong();
    private final AtomicLong missCount = new AtomicLong();
    protected String poolName;
    protected Compressor compressor;
    protected ExtensionPoint<Region<?, ?>> extensionPoint = new SimpleExtensionPoint<AbstractRegion>(this, this);
    protected final GemFireCacheImpl cache;
    private volatile ExpirationAttributes regionTimeToLiveAtts;
    private volatile ExpirationAttributes regionIdleTimeoutAtts;
    private volatile ExpirationAttributes entryTimeToLiveAtts;
    private volatile ExpirationAttributes entryIdleTimeoutAtts;
    private static final CacheListener[] EMPTY_LISTENERS = new CacheListener[0];
    private boolean entryExpiryPossible = false;

    protected AbstractRegion(GemFireCacheImpl cache, RegionAttributes attrs, String regionName, InternalRegionArguments internalRegionArgs) {
        this.cache = cache;
        this.serialNumber = DistributionAdvisor.createSerialNumber();
        this.isPdxTypesRegion = "PdxTypes".equals(regionName);
        this.lastAccessedTime = new AtomicLong(this.cacheTimeMillis());
        this.lastModifiedTime = new AtomicLong(this.lastAccessedTime.get());
        this.setAttributes(attrs, regionName, internalRegionArgs);
    }

    @Deprecated
    AbstractRegion(GemFireCacheImpl cache, int serialNumber, boolean isPdxTypeRegion, long lastAccessedTime, long lastModifiedTime) {
        this.cache = cache;
        this.serialNumber = serialNumber;
        this.isPdxTypesRegion = isPdxTypeRegion;
        this.lastAccessedTime = new AtomicLong(lastAccessedTime);
        this.lastModifiedTime = new AtomicLong(lastModifiedTime);
    }

    @Deprecated
    public void setIgnoreJTA(boolean ignore) {
        this.ignoreJTA = ignore;
    }

    public final void create(Object key2, Object value2) throws TimeoutException, EntryExistsException, CacheWriterException {
        this.create(key2, value2, null);
    }

    public final Object destroy(Object key2) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        return this.destroy(key2, null);
    }

    @Override
    public final Object get(Object name) throws CacheLoaderException, TimeoutException {
        return this.get(name, null, true, null);
    }

    @Override
    public final Object put(Object name, Object value2) throws TimeoutException, CacheWriterException {
        return this.put(name, value2, null);
    }

    public Object get(Object name, Object aCallbackArgument) throws CacheLoaderException, TimeoutException {
        return this.get(name, aCallbackArgument, true, null);
    }

    @Override
    public final void localDestroyRegion() {
        this.localDestroyRegion(null);
    }

    abstract Object get(Object var1, Object var2, boolean var3, EntryEventImpl var4) throws TimeoutException, CacheLoaderException;

    @Override
    public final void localDestroy(Object key2) throws EntryNotFoundException {
        this.localDestroy(key2, null);
    }

    @Override
    public final void destroyRegion() throws CacheWriterException, TimeoutException {
        this.destroyRegion(null);
    }

    @Override
    public final void invalidate(Object key2) throws TimeoutException, EntryNotFoundException {
        this.invalidate(key2, null);
    }

    @Override
    public final void localInvalidate(Object key2) throws EntryNotFoundException {
        this.localInvalidate(key2, null);
    }

    @Override
    public final void localInvalidateRegion() {
        this.localInvalidateRegion(null);
    }

    @Override
    public final void invalidateRegion() throws TimeoutException {
        this.invalidateRegion(null);
    }

    abstract void basicClear(RegionEventImpl var1);

    abstract boolean generateEventID();

    protected abstract DistributedMember getMyId();

    @Override
    public void clear() {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl regionEvent = new RegionEventImpl((Region)this, Operation.REGION_CLEAR, null, false, this.getMyId(), this.generateEventID());
        this.basicClear(regionEvent);
    }

    abstract void basicLocalClear(RegionEventImpl var1);

    @Override
    public void localClear() {
        this.checkReadiness();
        this.checkForNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_CLEAR, null, false, this.getMyId(), this.generateEventID());
        this.basicLocalClear(event);
    }

    public Map getAll(Collection keys) {
        return this.getAll(keys, (Object)null);
    }

    public Map getAll(Collection keys, Object callback) {
        if (keys == null) {
            throw new NullPointerException("The collection of keys for getAll cannot be null");
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        return keys.isEmpty() ? new HashMap() : this.basicGetAll(keys, callback);
    }

    abstract Map basicGetAll(Collection var1, Object var2);

    public abstract RegionEntry basicGetEntry(Object var1);

    protected StringBuilder getStringBuilder() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append("[path='").append(this.getFullPath()).append("';scope=").append(this.getScope()).append("';dataPolicy=").append(this.dataPolicy);
        if (this.enableGateway) {
            buf.append("; gatewayEnabled");
        }
        if (this.concurrencyChecksEnabled) {
            buf.append("; concurrencyChecksEnabled");
        }
        return buf;
    }

    public String toString() {
        return this.getStringBuilder().append(']').toString();
    }

    public CacheLoader getCacheLoader() {
        return this.cacheLoader;
    }

    public CacheWriter getCacheWriter() {
        return this.cacheWriter;
    }

    public CacheLoader basicGetLoader() {
        CacheLoader result = this.cacheLoader;
        if (AbstractRegion.isBridgeLoader(result)) {
            result = null;
        }
        return result;
    }

    public CacheWriter basicGetWriter() {
        CacheWriter result = this.cacheWriter;
        if (AbstractRegion.isBridgeWriter(result)) {
            result = null;
        }
        return result;
    }

    public Class getKeyConstraint() {
        return this.keyConstraint;
    }

    public Class getValueConstraint() {
        return this.valueConstraint;
    }

    private void setRegionTimeToLiveAtts() {
        this.regionTimeToLiveAtts = new ExpirationAttributes(this.regionTimeToLive, this.regionTimeToLiveExpirationAction);
    }

    @Override
    public ExpirationAttributes getRegionTimeToLive() {
        return this.regionTimeToLiveAtts;
    }

    private void setRegionIdleTimeoutAtts() {
        this.regionIdleTimeoutAtts = new ExpirationAttributes(this.regionIdleTimeout, this.regionIdleTimeoutExpirationAction);
    }

    @Override
    public ExpirationAttributes getRegionIdleTimeout() {
        return this.regionIdleTimeoutAtts;
    }

    protected void setEntryTimeToLiveAtts() {
        this.entryTimeToLiveAtts = new ExpirationAttributes(this.entryTimeToLive, this.entryTimeToLiveExpirationAction);
    }

    @Override
    public ExpirationAttributes getEntryTimeToLive() {
        return this.entryTimeToLiveAtts;
    }

    public CustomExpiry getCustomEntryTimeToLive() {
        return this.customEntryTimeToLive;
    }

    protected void setEntryIdleTimeoutAtts() {
        this.entryIdleTimeoutAtts = new ExpirationAttributes(this.entryIdleTimeout, this.entryIdleTimeoutExpirationAction);
    }

    @Override
    public ExpirationAttributes getEntryIdleTimeout() {
        return this.entryIdleTimeoutAtts;
    }

    public CustomExpiry getCustomEntryIdleTimeout() {
        return this.customEntryIdleTimeout;
    }

    @Override
    public MirrorType getMirrorType() {
        if (this.dataPolicy.isNormal() || this.dataPolicy.isPreloaded() || this.dataPolicy.isEmpty() || this.dataPolicy.withPartitioning()) {
            return MirrorType.NONE;
        }
        if (this.dataPolicy.withReplication()) {
            return MirrorType.KEYS_VALUES;
        }
        throw new IllegalStateException(LocalizedStrings.AbstractRegion_NO_MIRROR_TYPE_CORRESPONDS_TO_DATA_POLICY_0.toLocalizedString(this.dataPolicy));
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public CacheListener getCacheListener() {
        CacheListener[] listeners = this.fetchCacheListenersField();
        if (listeners == null || listeners.length == 0) {
            return null;
        }
        if (listeners.length == 1) {
            return listeners[0];
        }
        throw new IllegalStateException(LocalizedStrings.AbstractRegion_MORE_THAN_ONE_CACHE_LISTENER_EXISTS.toLocalizedString());
    }

    public final boolean isPdxTypesRegion() {
        return this.isPdxTypesRegion;
    }

    @Override
    public Set<String> getGatewaySenderIds() {
        return this.gatewaySenderIds;
    }

    @Override
    public Set<String> getAsyncEventQueueIds() {
        return this.asyncEventQueueIds;
    }

    public final Set<String> getAllGatewaySenderIds() {
        return Collections.unmodifiableSet(this.allGatewaySenderIds);
    }

    public final boolean checkNotifyGatewaySender() {
        return this.cache.getAllGatewaySenders().size() > 0 && this.allGatewaySenderIds.size() > 0;
    }

    public final Set<String> getActiveGatewaySenderIds() {
        Set<GatewaySender> allGatewaySenders;
        HashSet<String> activeGatewaySenderIds = null;
        int sz = this.gatewaySenderIds.size();
        if (sz > 0 && (allGatewaySenders = this.cache.getGatewaySenders()).size() > 0) {
            for (GatewaySender sender : allGatewaySenders) {
                if (!sender.isRunning() || !this.gatewaySenderIds.contains(sender.getId())) continue;
                if (activeGatewaySenderIds == null) {
                    activeGatewaySenderIds = new HashSet<String>();
                }
                activeGatewaySenderIds.add(sender.getId());
            }
        }
        return activeGatewaySenderIds;
    }

    public final Set<String> getActiveAsyncQueueIds() {
        Set<AsyncEventQueue> allAsyncQueues;
        HashSet<String> activeAsyncQueueIds = null;
        int sz = this.asyncEventQueueIds.size();
        if (sz > 0 && (allAsyncQueues = this.cache.getAsyncEventQueues()).size() > 0) {
            for (AsyncEventQueue asyncQueue : allAsyncQueues) {
                if (!this.asyncEventQueueIds.contains(asyncQueue.getId())) continue;
                if (activeAsyncQueueIds == null) {
                    activeAsyncQueueIds = new HashSet<String>();
                }
                activeAsyncQueueIds.add(asyncQueue.getId());
            }
        }
        return activeAsyncQueueIds;
    }

    public final List<Integer> getRemoteDsIds(Set<String> allGatewaySenderIds) throws IllegalStateException {
        Set<GatewaySender> allGatewaySenders;
        int sz = allGatewaySenderIds.size();
        if ((sz > 0 || this.isPdxTypesRegion) && (allGatewaySenders = this.cache.getAllGatewaySenders()).size() > 0) {
            ArrayList<Integer> allRemoteDSIds = new ArrayList<Integer>(sz);
            for (GatewaySender sender : allGatewaySenders) {
                if (!this.isPdxTypesRegion) {
                    if (!allGatewaySenderIds.contains(sender.getId())) continue;
                    allRemoteDSIds.add(sender.getRemoteDSId());
                    continue;
                }
                allRemoteDSIds.add(sender.getRemoteDSId());
            }
            return allRemoteDSIds;
        }
        return null;
    }

    public boolean isGatewaySenderEnabled() {
        return this.isGatewaySenderEnabled;
    }

    public CacheListener[] getCacheListeners() {
        CacheListener[] listeners = this.fetchCacheListenersField();
        if (listeners == null || listeners.length == 0) {
            return EMPTY_LISTENERS;
        }
        CacheListener[] result = new CacheListener[listeners.length];
        System.arraycopy(listeners, 0, result, 0, listeners.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void storeCacheListenersField(CacheListener[] value2) {
        Object object = this.clSync;
        synchronized (object) {
            if (value2 != null && value2.length != 0) {
                CacheListener[] nv = new CacheListener[value2.length];
                System.arraycopy(value2, 0, nv, 0, nv.length);
                value2 = nv;
            } else {
                value2 = EMPTY_LISTENERS;
            }
            this.cacheListeners = value2;
        }
    }

    protected final CacheListener[] fetchCacheListenersField() {
        return this.cacheListeners;
    }

    @Override
    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public float getLoadFactor() {
        return this.loadFactor;
    }

    protected abstract boolean isCurrentlyLockGrantor();

    @Override
    public boolean isLockGrantor() {
        return this.isLockGrantor;
    }

    @Override
    public boolean getMulticastEnabled() {
        return this.mcastEnabled;
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public boolean getIgnoreJTA() {
        return this.ignoreJTA;
    }

    @Override
    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    @Override
    public boolean getConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    @Override
    public boolean getPersistBackup() {
        return this.getDataPolicy().withPersistence();
    }

    @Override
    public boolean getEarlyAck() {
        return this.earlyAck;
    }

    @Override
    public boolean getEnableWAN() {
        return this.enableGateway;
    }

    @Override
    public boolean getEnableGateway() {
        return this.enableGateway;
    }

    @Override
    @Deprecated
    public boolean getPublisher() {
        return this.publisher;
    }

    @Override
    public String getGatewayHubId() {
        return this.gatewayHubId;
    }

    public Set<String> getAllGatewayHubIds() {
        return this.allGatewayHubIds;
    }

    @Override
    public boolean getEnableConflation() {
        return this.getEnableSubscriptionConflation();
    }

    @Override
    public boolean getEnableBridgeConflation() {
        return this.getEnableSubscriptionConflation();
    }

    @Override
    public boolean getEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    @Override
    public boolean getEnableAsyncConflation() {
        return this.enableAsyncConflation;
    }

    @Override
    @Deprecated
    public DiskWriteAttributes getDiskWriteAttributes() {
        return this.diskWriteAttributes;
    }

    @Override
    public abstract File[] getDiskDirs();

    @Override
    public final String getDiskStoreName() {
        return this.diskStoreName;
    }

    @Override
    public boolean isDiskSynchronous() {
        return this.isDiskSynchronous;
    }

    @Override
    public boolean getIndexMaintenanceSynchronous() {
        return this.indexMaintenanceSynchronous;
    }

    @Override
    public PartitionAttributes getPartitionAttributes() {
        return this.partitionAttributes;
    }

    @Override
    public MembershipAttributes getMembershipAttributes() {
        return this.membershipAttributes;
    }

    @Override
    public SubscriptionAttributes getSubscriptionAttributes() {
        return this.subscriptionAttributes;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public IndexManager setIndexManager(IndexManager indexManager) {
        this.checkReadiness();
        IndexManager oldIdxManager = this.indexManager;
        this.indexManager = indexManager;
        return oldIdxManager;
    }

    public Object getIMSync() {
        return this.imSync;
    }

    public void setFlagForIndexCreationThread(boolean bool) {
        this.isIndexCreator.set(bool ? Boolean.TRUE : null);
    }

    boolean isIndexCreationThread() {
        Boolean bool = (Boolean)this.isIndexCreator.get();
        return bool != null ? bool : false;
    }

    public Region getRegion() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheListener setCacheListener(CacheListener aListener) {
        this.checkReadiness();
        CacheListener result = null;
        CacheListener[] oldListeners = null;
        Object object = this.clSync;
        synchronized (object) {
            oldListeners = this.cacheListeners;
            if (oldListeners != null && oldListeners.length > 1) {
                throw new IllegalStateException(LocalizedStrings.AbstractRegion_MORE_THAN_ONE_CACHE_LISTENER_EXISTS.toLocalizedString());
            }
            this.cacheListeners = new CacheListener[]{aListener};
        }
        if (oldListeners != null && oldListeners.length > 0) {
            if (oldListeners.length == 1) {
                result = oldListeners[0];
            }
            for (int i = 0; i < oldListeners.length; ++i) {
                if (aListener == oldListeners[i]) continue;
                this.closeCacheCallback(oldListeners[i]);
            }
            if (aListener == null) {
                this.cacheListenersChanged(false);
            }
        } else if (aListener != null) {
            this.cacheListenersChanged(true);
        }
        return result;
    }

    @Override
    public void addGatewaySenderId(String gatewaySenderId) {
        this.getGatewaySenderIds().add(gatewaySenderId);
        this.setAllGatewaySenderIds();
    }

    @Override
    public void removeGatewaySenderId(String gatewaySenderId) {
        this.getGatewaySenderIds().remove(gatewaySenderId);
        this.setAllGatewaySenderIds();
    }

    @Override
    public void addAsyncEventQueueId(String asyncEventQueueId) {
        this.getAsyncEventQueueIds().add(asyncEventQueueId);
        this.setAllGatewaySenderIds();
    }

    @Override
    public void removeAsyncEventQueueId(String asyncEventQueueId) {
        this.getAsyncEventQueueIds().remove(asyncEventQueueId);
        this.setAllGatewaySenderIds();
    }

    private void setAllGatewaySenderIds() {
        if (this.getGatewaySenderIds().isEmpty() && this.getAsyncEventQueueIds().isEmpty()) {
            this.allGatewaySenderIds = Collections.emptySet();
        }
        CopyOnWriteArraySet<String> tmp = new CopyOnWriteArraySet<String>();
        tmp.addAll(this.getGatewaySenderIds());
        for (String asyncQueueId : this.getAsyncEventQueueIds()) {
            tmp.add(AsyncEventQueueImpl.getSenderIdFromAsyncEventQueueId(asyncQueueId));
        }
        this.allGatewaySenderIds = tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(CacheListener cl) {
        this.checkReadiness();
        if (cl == null) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_ADDCACHELISTENER_PARAMETER_WAS_NULL.toLocalizedString());
        }
        CacheListener wcl = this.wrapRegionMembershipListener(cl);
        boolean changed = false;
        Object object = this.clSync;
        synchronized (object) {
            Object[] oldListeners = this.cacheListeners;
            if (oldListeners == null || oldListeners.length == 0) {
                this.cacheListeners = new CacheListener[]{wcl};
                changed = true;
            } else {
                List<CacheListener> l = Arrays.asList(oldListeners);
                if (!l.contains(cl)) {
                    this.cacheListeners = (CacheListener[])ArrayUtils.insert(oldListeners, oldListeners.length, wcl);
                }
            }
        }
        if (changed) {
            this.cacheListenersChanged(true);
        }
    }

    private CacheListener wrapRegionMembershipListener(CacheListener cl) {
        if (cl instanceof RegionMembershipListener) {
            return new WrappedRegionMembershipListener((RegionMembershipListener)cl);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initPostCreateRegionMembershipListeners(Set initialMembers) {
        DistributedMember[] initMbrs = null;
        CacheListener[] newcl = null;
        Object object = this.clSync;
        synchronized (object) {
            for (int i = 0; i < this.cacheListeners.length; ++i) {
                WrappedRegionMembershipListener wrml;
                CacheListener cl = this.cacheListeners[i];
                if (!(cl instanceof WrappedRegionMembershipListener) || (wrml = (WrappedRegionMembershipListener)cl).isInitialized()) continue;
                if (initMbrs == null) {
                    initMbrs = initialMembers.toArray(new DistributedMember[initialMembers.size()]);
                }
                wrml.initialMembers((Region)this, initMbrs);
                if (newcl == null) {
                    newcl = new CacheListener[this.cacheListeners.length];
                    System.arraycopy(this.cacheListeners, 0, newcl, 0, newcl.length);
                }
                newcl[i] = wrml.getWrappedListener();
            }
            if (newcl != null) {
                this.cacheListeners = newcl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCacheListeners(CacheListener[] addedListeners) {
        this.checkReadiness();
        CacheListener[] oldListeners = null;
        CacheListener[] listenersToAdd = null;
        if (addedListeners != null) {
            listenersToAdd = new CacheListener[addedListeners.length];
            for (int i = 0; i < addedListeners.length; ++i) {
                listenersToAdd[i] = this.wrapRegionMembershipListener(addedListeners[i]);
            }
        }
        Object i = this.clSync;
        synchronized (i) {
            oldListeners = this.cacheListeners;
            if (listenersToAdd == null || listenersToAdd.length == 0) {
                this.cacheListeners = EMPTY_LISTENERS;
            } else {
                if (Arrays.asList(listenersToAdd).contains(null)) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_INITCACHELISTENERS_PARAMETER_HAD_A_NULL_ELEMENT.toLocalizedString());
                }
                CacheListener[] newListeners = new CacheListener[listenersToAdd.length];
                System.arraycopy(listenersToAdd, 0, newListeners, 0, newListeners.length);
                this.cacheListeners = newListeners;
            }
        }
        if (listenersToAdd == null || listenersToAdd.length == 0) {
            if (oldListeners != null && oldListeners.length > 0) {
                for (int i2 = 0; i2 < oldListeners.length; ++i2) {
                    this.closeCacheCallback(oldListeners[i2]);
                }
                this.cacheListenersChanged(false);
            }
        } else if (oldListeners != null && oldListeners.length > 0) {
            for (int i3 = 0; i3 < oldListeners.length; ++i3) {
                this.closeCacheCallback(oldListeners[i3]);
            }
        } else {
            this.cacheListenersChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheListener(CacheListener cl) {
        this.checkReadiness();
        if (cl == null) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_REMOVECACHELISTENER_PARAMETER_WAS_NULL.toLocalizedString());
        }
        boolean changed = false;
        Object object = this.clSync;
        synchronized (object) {
            ArrayList<CacheListener> l;
            CacheListener[] oldListeners = this.cacheListeners;
            if (oldListeners != null && oldListeners.length > 0 && (l = new ArrayList<CacheListener>(Arrays.asList(oldListeners))).remove(cl)) {
                if (l.isEmpty()) {
                    this.cacheListeners = EMPTY_LISTENERS;
                } else {
                    CacheListener[] newListeners = new CacheListener[l.size()];
                    l.toArray(newListeners);
                    this.cacheListeners = newListeners;
                }
                this.closeCacheCallback(cl);
                if (l.isEmpty()) {
                    changed = true;
                }
            }
        }
        if (changed) {
            this.cacheListenersChanged(false);
        }
    }

    public synchronized CacheLoader setCacheLoader(CacheLoader cl) {
        this.checkReadiness();
        if (cl != null && AbstractRegion.isBridgeLoader(cl) && this.getPoolName() != null) {
            throw new IllegalStateException("A region with a connection pool can not have a BridgeLoader.");
        }
        CacheLoader oldLoader = this.cacheLoader;
        this.assignCacheLoader(cl);
        this.cacheLoaderChanged(oldLoader);
        return oldLoader;
    }

    private synchronized void assignCacheLoader(CacheLoader cl) {
        this.cacheLoader = cl;
        if (cl instanceof BridgeLoader) {
            BridgeLoader bl = (BridgeLoader)cl;
            bl.attach(this);
        } else if (cl instanceof BridgeClient) {
            BridgeClient bc = (BridgeClient)cl;
            bc.attach(this);
        }
    }

    public synchronized CacheWriter setCacheWriter(CacheWriter cacheWriter) {
        this.checkReadiness();
        if (cacheWriter != null && AbstractRegion.isBridgeWriter(cacheWriter) && this.getPoolName() != null) {
            throw new IllegalStateException("A region with a connection pool can not have a BridgeWriter.");
        }
        CacheWriter oldWriter = this.cacheWriter;
        this.assignCacheWriter(cacheWriter);
        this.cacheWriterChanged(oldWriter);
        return oldWriter;
    }

    private synchronized void assignCacheWriter(CacheWriter cacheWriter) {
        this.cacheWriter = cacheWriter;
        if (cacheWriter instanceof BridgeWriter) {
            BridgeWriter bw = (BridgeWriter)cacheWriter;
            bw.attach(this);
        }
    }

    void checkEntryTimeoutAction(String mode, ExpirationAction ea) {
        if ((this.dataPolicy.withReplication() || this.dataPolicy.withPartitioning()) && (ea == ExpirationAction.LOCAL_DESTROY || ea == ExpirationAction.LOCAL_INVALIDATE)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_0_ACTION_IS_INCOMPATIBLE_WITH_THIS_REGIONS_DATA_POLICY.toLocalizedString(mode));
        }
    }

    @Override
    public ExpirationAttributes setEntryIdleTimeout(ExpirationAttributes idleTimeout) {
        this.checkReadiness();
        if (idleTimeout == null) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_IDLETIMEOUT_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.checkEntryTimeoutAction("idleTimeout", idleTimeout.getAction());
        if (!this.statisticsEnabled) {
            throw new IllegalStateException(LocalizedStrings.AbstractRegion_CANNOT_SET_IDLE_TIMEOUT_WHEN_STATISTICS_ARE_DISABLED.toLocalizedString());
        }
        ExpirationAttributes oldAttrs = this.getEntryIdleTimeout();
        this.entryIdleTimeout = idleTimeout.getTimeout();
        this.entryIdleTimeoutExpirationAction = idleTimeout.getAction();
        this.setEntryIdleTimeoutAtts();
        this.updateEntryExpiryPossible();
        this.idleTimeoutChanged(oldAttrs);
        return oldAttrs;
    }

    public CustomExpiry setCustomEntryIdleTimeout(CustomExpiry custom) {
        this.checkReadiness();
        if (custom != null && !this.statisticsEnabled) {
            throw new IllegalStateException(LocalizedStrings.AbstractRegion_CANNOT_SET_IDLE_TIMEOUT_WHEN_STATISTICS_ARE_DISABLED.toLocalizedString());
        }
        CustomExpiry old = this.getCustomEntryIdleTimeout();
        this.customEntryIdleTimeout = custom;
        this.updateEntryExpiryPossible();
        this.idleTimeoutChanged(this.getEntryIdleTimeout());
        return old;
    }

    @Override
    public ExpirationAttributes setEntryTimeToLive(ExpirationAttributes timeToLive) {
        this.checkReadiness();
        if (timeToLive == null) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_TIMETOLIVE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.checkEntryTimeoutAction("timeToLive", timeToLive.getAction());
        if (!this.statisticsEnabled) {
            throw new IllegalStateException(LocalizedStrings.AbstractRegion_CANNOT_SET_TIME_TO_LIVE_WHEN_STATISTICS_ARE_DISABLED.toLocalizedString());
        }
        ExpirationAttributes oldAttrs = this.getEntryTimeToLive();
        this.entryTimeToLive = timeToLive.getTimeout();
        this.entryTimeToLiveExpirationAction = timeToLive.getAction();
        this.setEntryTimeToLiveAtts();
        this.updateEntryExpiryPossible();
        this.timeToLiveChanged(oldAttrs);
        return oldAttrs;
    }

    public CustomExpiry setCustomEntryTimeToLive(CustomExpiry custom) {
        this.checkReadiness();
        if (custom != null && !this.statisticsEnabled) {
            throw new IllegalStateException(LocalizedStrings.AbstractRegion_CANNOT_SET_CUSTOM_TIME_TO_LIVE_WHEN_STATISTICS_ARE_DISABLED.toLocalizedString());
        }
        CustomExpiry old = this.getCustomEntryTimeToLive();
        this.customEntryTimeToLive = custom;
        this.updateEntryExpiryPossible();
        this.timeToLiveChanged(this.getEntryTimeToLive());
        return old;
    }

    @Override
    public ExpirationAttributes setRegionIdleTimeout(ExpirationAttributes idleTimeout) {
        this.checkReadiness();
        if (idleTimeout == null) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_IDLETIMEOUT_MUST_NOT_BE_NULL.toLocalizedString());
        }
        if (idleTimeout.getAction() == ExpirationAction.LOCAL_INVALIDATE && this.dataPolicy.withReplication()) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_0_ACTION_IS_INCOMPATIBLE_WITH_THIS_REGIONS_DATA_POLICY.toLocalizedString("idleTimeout"));
        }
        if (!this.statisticsEnabled) {
            throw new IllegalStateException(LocalizedStrings.AbstractRegion_CANNOT_SET_IDLE_TIMEOUT_WHEN_STATISTICS_ARE_DISABLED.toLocalizedString());
        }
        ExpirationAttributes oldAttrs = this.getRegionIdleTimeout();
        this.regionIdleTimeout = idleTimeout.getTimeout();
        this.regionIdleTimeoutExpirationAction = idleTimeout.getAction();
        this.setRegionIdleTimeoutAtts();
        this.regionIdleTimeoutChanged(oldAttrs);
        return oldAttrs;
    }

    @Override
    public ExpirationAttributes setRegionTimeToLive(ExpirationAttributes timeToLive) {
        this.checkReadiness();
        if (timeToLive == null) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_TIMETOLIVE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        if (timeToLive.getAction() == ExpirationAction.LOCAL_INVALIDATE && this.dataPolicy.withReplication()) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_0_ACTION_IS_INCOMPATIBLE_WITH_THIS_REGIONS_DATA_POLICY.toLocalizedString("timeToLive"));
        }
        if (!this.statisticsEnabled) {
            throw new IllegalStateException(LocalizedStrings.AbstractRegion_CANNOT_SET_TIME_TO_LIVE_WHEN_STATISTICS_ARE_DISABLED.toLocalizedString());
        }
        ExpirationAttributes oldAttrs = this.getRegionTimeToLive();
        this.regionTimeToLive = timeToLive.getTimeout();
        this.regionTimeToLiveExpirationAction = timeToLive.getAction();
        this.setRegionTimeToLiveAtts();
        this.regionTimeToLiveChanged(timeToLive);
        return oldAttrs;
    }

    @Override
    public void becomeLockGrantor() {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        if (this.scope != Scope.GLOBAL) {
            throw new IllegalStateException(LocalizedStrings.AbstractRegion_CANNOT_SET_LOCK_GRANTOR_WHEN_SCOPE_IS_NOT_GLOBAL.toLocalizedString());
        }
        if (this.isCurrentlyLockGrantor()) {
            return;
        }
        this.isLockGrantor = true;
    }

    @Override
    public CacheStatistics getStatistics() {
        this.checkReadiness();
        if (!this.statisticsEnabled) {
            throw new StatisticsDisabledException(LocalizedStrings.AbstractRegion_STATISTICS_DISABLED_FOR_REGION_0.toLocalizedString(this.getFullPath()));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getLastModifiedTime() {
        this.checkReadiness();
        long mostRecent = this.basicGetLastModifiedTime();
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            Iterator<Region<?, ?>> subIt = this.subregions(false).iterator();
            while (subIt.hasNext()) {
                try {
                    LocalRegion r = (LocalRegion)subIt.next();
                    if (!r.isInitialized()) continue;
                    mostRecent = Math.max(mostRecent, r.getLastModifiedTime());
                }
                catch (RegionDestroyedException e) {}
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        return mostRecent;
    }

    protected long basicGetLastModifiedTime() {
        return this.lastModifiedTime.get();
    }

    protected long basicGetLastAccessedTime() {
        return this.lastAccessedTime.get();
    }

    protected void basicSetLastModifiedTime(long t) {
        this.lastModifiedTime.set(t);
    }

    protected void basicSetLastAccessedTime(long t) {
        this.lastAccessedTime.set(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getLastAccessedTime() {
        this.checkReadiness();
        long mostRecent = this.basicGetLastAccessedTime();
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            Iterator<Region<?, ?>> subIt = this.subregions(false).iterator();
            while (subIt.hasNext()) {
                try {
                    LocalRegion r = (LocalRegion)subIt.next();
                    if (!r.isInitialized()) continue;
                    mostRecent = Math.max(mostRecent, r.getLastAccessedTime());
                }
                catch (RegionDestroyedException e) {}
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        return mostRecent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateStats() {
        long mostRecentAccessed = this.basicGetLastAccessedTime();
        long mostRecentModified = this.basicGetLastModifiedTime();
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            Iterator<Region<?, ?>> subIt = this.subregions(false).iterator();
            while (subIt.hasNext()) {
                try {
                    LocalRegion r = (LocalRegion)subIt.next();
                    if (!r.isInitialized()) continue;
                    mostRecentAccessed = Math.max(mostRecentAccessed, r.getLastAccessedTime());
                    mostRecentModified = Math.max(mostRecentModified, r.getLastModifiedTime());
                }
                catch (RegionDestroyedException e) {}
            }
            this.basicSetLastAccessedTime(Math.max(mostRecentAccessed, mostRecentModified));
            this.basicSetLastModifiedTime(mostRecentModified);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    protected void setLastModifiedTime(long time) {
        if (time > this.lastModifiedTime.get()) {
            this.lastModifiedTime.set(time);
        }
        if (time > this.lastAccessedTime.get()) {
            this.lastAccessedTime.set(time);
        }
    }

    protected void setLastAccessedTime(long time, boolean hit) {
        this.lastAccessedTime.set(time);
        if (hit) {
            if (trackHits) {
                this.hitCount.getAndIncrement();
            }
        } else if (trackMisses) {
            this.missCount.getAndIncrement();
        }
    }

    @Override
    public final float getHitRatio() {
        long hits = this.getHitCount();
        long total = hits + this.getMissCount();
        return total == 0L ? 0.0f : (float)hits / (float)total;
    }

    @Override
    public long getHitCount() {
        return this.hitCount.get();
    }

    @Override
    public long getMissCount() {
        return this.missCount.get();
    }

    @Override
    public void resetCounts() {
        if (trackMisses) {
            this.missCount.set(0L);
        }
        if (trackHits) {
            this.hitCount.set(0L);
        }
    }

    protected void closeCacheCallback(CacheCallback cb) {
        if (cb != null) {
            if (cb instanceof BridgeWriter) {
                BridgeWriter bw = (BridgeWriter)cb;
                bw.detach(this);
            } else if (cb instanceof BridgeLoader) {
                BridgeLoader bl = (BridgeLoader)cb;
                bl.detach(this);
            }
            try {
                cb.close();
            }
            catch (RuntimeException ex) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.AbstractRegion_CACHECALLBACK_CLOSE_EXCEPTION), (Throwable)ex);
            }
        }
    }

    protected void cacheLoaderChanged(CacheLoader oldLoader) {
        if (this.cacheLoader != oldLoader) {
            this.closeCacheCallback(oldLoader);
        }
    }

    protected void cacheListenersChanged(boolean nowHasListener) {
    }

    public static boolean isBridgeLoader(CacheLoader cl) {
        return cl instanceof BridgeLoader || cl instanceof BridgeClient;
    }

    public static boolean isBridgeWriter(CacheWriter cw) {
        return cw instanceof BridgeWriter;
    }

    protected void cacheWriterChanged(CacheWriter oldWriter) {
        if (this.cacheWriter != oldWriter) {
            this.closeCacheCallback(oldWriter);
        }
    }

    protected void timeToLiveChanged(ExpirationAttributes oldTimeToLive) {
    }

    protected void idleTimeoutChanged(ExpirationAttributes oldIdleTimeout) {
    }

    protected void regionTimeToLiveChanged(ExpirationAttributes oldTimeToLive) {
    }

    protected void regionIdleTimeoutChanged(ExpirationAttributes oldIdleTimeout) {
    }

    abstract void checkReadiness();

    protected final boolean isProxy() {
        return this.getDataPolicy().isEmpty();
    }

    protected final boolean isCacheContentProxy() {
        return this.isProxy() && this.getSubscriptionAttributes().getInterestPolicy().isCacheContent();
    }

    final boolean isAllEvents() {
        return this.getDataPolicy().withReplication() || this.getSubscriptionAttributes().getInterestPolicy().isAll();
    }

    protected void updateEntryExpiryPossible() {
        this.entryExpiryPossible = !this.isProxy() && (this.entryTimeToLive > 0 || this.entryIdleTimeout > 0 || this.customEntryIdleTimeout != null || this.customEntryTimeToLive != null);
    }

    protected void setAllGatewayHubIds(String gatewayHubId) {
        this.gatewayHubId = gatewayHubId;
        String[] allGatewayHubIdsArr = gatewayHubId.split(",");
        if (allGatewayHubIdsArr.length > 1) {
            this.allGatewayHubIds = new HashSet<String>();
            for (String hubId : allGatewayHubIdsArr) {
                this.allGatewayHubIds.add(hubId);
            }
        }
    }

    protected boolean isEntryExpiryPossible() {
        return this.entryExpiryPossible;
    }

    public ExpirationAction getEntryExpirationAction() {
        if (this.entryIdleTimeoutExpirationAction != null) {
            return this.entryIdleTimeoutExpirationAction;
        }
        if (this.entryTimeToLiveExpirationAction != null) {
            return this.entryTimeToLiveExpirationAction;
        }
        return null;
    }

    public boolean isEntryEvictionPossible() {
        return this.evictionController != null;
    }

    private void setAttributes(RegionAttributes attrs, String regionName, InternalRegionArguments internalRegionArgs) {
        this.dataPolicy = attrs.getDataPolicy();
        this.scope = attrs.getScope();
        this.evictionAttributes = new EvictionAttributesImpl((EvictionAttributesImpl)attrs.getEvictionAttributes());
        if (attrs.getPartitionAttributes() != null && this.evictionAttributes != null && this.evictionAttributes.getAlgorithm().isLRUMemory() && attrs.getPartitionAttributes().getLocalMaxMemory() != 0 && this.evictionAttributes.getMaximum() != attrs.getPartitionAttributes().getLocalMaxMemory()) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.Mem_LRU_Eviction_Attribute_Reset, new Object[]{regionName, this.evictionAttributes.getMaximum(), attrs.getPartitionAttributes().getLocalMaxMemory()}));
            this.evictionAttributes.setMaximum(attrs.getPartitionAttributes().getLocalMaxMemory());
        }
        if (this.evictionAttributes != null && !this.evictionAttributes.getAlgorithm().isNone()) {
            this.setEvictionController(this.evictionAttributes.createEvictionController(this));
        }
        this.storeCacheListenersField(attrs.getCacheListeners());
        this.assignCacheLoader(attrs.getCacheLoader());
        this.assignCacheWriter(attrs.getCacheWriter());
        this.regionTimeToLive = attrs.getRegionTimeToLive().getTimeout();
        this.regionTimeToLiveExpirationAction = attrs.getRegionTimeToLive().getAction();
        this.setRegionTimeToLiveAtts();
        this.regionIdleTimeout = attrs.getRegionIdleTimeout().getTimeout();
        this.regionIdleTimeoutExpirationAction = attrs.getRegionIdleTimeout().getAction();
        this.setRegionIdleTimeoutAtts();
        this.entryTimeToLive = attrs.getEntryTimeToLive().getTimeout();
        this.entryTimeToLiveExpirationAction = attrs.getEntryTimeToLive().getAction();
        this.setEntryTimeToLiveAtts();
        this.customEntryTimeToLive = attrs.getCustomEntryTimeToLive();
        this.entryIdleTimeout = attrs.getEntryIdleTimeout().getTimeout();
        this.entryIdleTimeoutExpirationAction = attrs.getEntryIdleTimeout().getAction();
        this.setEntryIdleTimeoutAtts();
        this.customEntryIdleTimeout = attrs.getCustomEntryIdleTimeout();
        this.updateEntryExpiryPossible();
        this.statisticsEnabled = attrs.getStatisticsEnabled();
        this.ignoreJTA = attrs.getIgnoreJTA();
        this.isLockGrantor = attrs.isLockGrantor();
        this.keyConstraint = attrs.getKeyConstraint();
        this.valueConstraint = attrs.getValueConstraint();
        this.initialCapacity = attrs.getInitialCapacity();
        this.loadFactor = attrs.getLoadFactor();
        this.concurrencyLevel = attrs.getConcurrencyLevel();
        this.concurrencyChecksEnabled = attrs.getConcurrencyChecksEnabled() && this.supportsConcurrencyChecks();
        this.earlyAck = attrs.getEarlyAck();
        this.enableGateway = attrs.getEnableGateway();
        this.setAllGatewayHubIds(attrs.getGatewayHubId());
        this.gatewaySenderIds = attrs.getGatewaySenderIds();
        this.asyncEventQueueIds = attrs.getAsyncEventQueueIds();
        this.setAllGatewaySenderIds();
        this.enableSubscriptionConflation = attrs.getEnableSubscriptionConflation();
        this.publisher = attrs.getPublisher();
        this.enableAsyncConflation = attrs.getEnableAsyncConflation();
        this.indexMaintenanceSynchronous = attrs.getIndexMaintenanceSynchronous();
        this.mcastEnabled = attrs.getMulticastEnabled();
        this.partitionAttributes = attrs.getPartitionAttributes();
        this.membershipAttributes = attrs.getMembershipAttributes();
        this.subscriptionAttributes = attrs.getSubscriptionAttributes();
        this.cloningEnable = attrs.getCloningEnabled();
        this.poolName = attrs.getPoolName();
        if (this.poolName != null) {
            PoolImpl cp = this.getPool();
            if (cp == null) {
                throw new IllegalStateException("The connection pool \"" + this.poolName + "\" has not been created");
            }
            cp.attach();
            if (cp.getMultiuserAuthentication() && !this.dataPolicy.isEmpty()) {
                throw new IllegalStateException("Region must have empty data-policy when multiuser-authentication is true.");
            }
        }
        this.diskStoreName = attrs.getDiskStoreName();
        this.isDiskSynchronous = attrs.isDiskSynchronous();
        if (this.diskStoreName == null) {
            this.diskWriteAttributes = attrs.getDiskWriteAttributes();
            this.isDiskSynchronous = this.diskWriteAttributes.isSynchronous();
            this.diskDirs = attrs.getDiskDirs();
            this.diskSizes = attrs.getDiskDirSizes();
        }
        this.compressor = attrs.getCompressor();
        if (!attrs.getConcurrencyChecksEnabled() && attrs.getDataPolicy().withPersistence() && this.supportsConcurrencyChecks()) {
            throw new IllegalStateException(LocalizedStrings.AttributesFactory_CONCURRENCY_CHECKS_MUST_BE_ENABLED.toLocalizedString());
        }
    }

    public abstract boolean supportsConcurrencyChecks();

    private PoolImpl getPool() {
        PoolImpl result = null;
        if (this.getPoolName() != null) {
            result = (PoolImpl)PoolManager.find(this.getPoolName());
        }
        return result;
    }

    @Override
    public boolean existsValue(String predicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return !this.query(predicate).isEmpty();
    }

    @Override
    public Object selectValue(String predicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults result = this.query(predicate);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new FunctionDomainException(LocalizedStrings.AbstractRegion_SELECTVALUE_EXPECTS_RESULTS_OF_SIZE_1_BUT_FOUND_RESULTS_OF_SIZE_0.toLocalizedString(result.size()));
        }
        return result.iterator().next();
    }

    public Set entrySet(boolean recursive) {
        return this.entries(recursive);
    }

    @Override
    public EvictionAttributes getEvictionAttributes() {
        return this.evictionAttributes;
    }

    @Override
    public EvictionAttributesMutator getEvictionAttributesMutator() {
        return this.evictionAttributes;
    }

    public void setEvictionController(LRUAlgorithm evictionController) {
        this.evictionController = evictionController;
    }

    public LRUAlgorithm getEvictionController() {
        return this.evictionController;
    }

    protected void checkForNoAccess() {
    }

    protected void checkForLimitedOrNoAccess() {
    }

    protected void handleReliableDistribution(ReliableDistributionData data, Set successfulRecipients) {
    }

    public boolean requiresReliabilityCheck() {
        return false;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public final GemFireCacheImpl getCache() {
        return this.cache;
    }

    protected final long cacheTimeMillis() {
        return this.cache.getDistributedSystem().getClock().cacheTimeMillis();
    }

    @Override
    public final RegionService getRegionService() {
        return this.cache;
    }

    public final DM getDistributionManager() {
        return this.getSystem().getDistributionManager();
    }

    public final InternalDistributedSystem getSystem() {
        return this.getCache().getDistributedSystem();
    }

    @Override
    public final int getDSFID() {
        return 26;
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        DataSerializer.writeRegion(this, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public boolean forceCompaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getCloningEnabled() {
        return this.cloningEnable;
    }

    @Override
    public void setCloningEnabled(boolean cloningEnable) {
        this.cloningEnable = cloningEnable;
    }

    protected static Object handleNotAvailable(Object v) {
        if (v == Token.NOT_AVAILABLE) {
            v = null;
        }
        return v;
    }

    public GemFireCacheImpl getGemFireCache() {
        return this.cache;
    }

    public RegionSnapshotService<?, ?> getSnapshotService() {
        return new RegionSnapshotServiceImpl(this);
    }

    @Override
    public Compressor getCompressor() {
        return this.compressor;
    }

    @Override
    public ExtensionPoint<Region<?, ?>> getExtensionPoint() {
        return this.extensionPoint;
    }
}

