/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.IndexMaintenanceException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.util.GatewayConflictHelper;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalStatisticsDisabledException;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.ImageState;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TimestampedEntryEventImpl;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.internal.cache.lru.LRUClockNode;
import com.gemstone.gemfire.internal.cache.lru.NewLRUClockHand;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.BlobHelper;
import com.gemstone.gemfire.internal.util.Versionable;
import com.gemstone.gemfire.internal.util.concurrent.CustomEntryConcurrentHashMap;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxSerializable;
import com.gemstone.gemfire.pdx.PdxSerializationException;
import com.gemstone.gemfire.pdx.PdxSerializer;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRegionEntry
implements RegionEntry,
CustomEntryConcurrentHashMap.HashEntry<Object, Object> {
    private static final Logger logger = LogService.getLogger();
    protected static final boolean DISABLE_ACCESS_TIME_UPDATE_ON_PUT = Boolean.getBoolean("gemfire.disableAccessTimeUpdateOnPut");
    private static final long VALUE_RESULT_OF_SEARCH = 0x100000000000000L;
    private static final long UPDATE_IN_PROGRESS = 0x200000000000000L;
    private static final long TOMBSTONE_SCHEDULED = 0x400000000000000L;
    private static final long LISTENER_INVOCATION_IN_PROGRESS = 0x800000000000000L;
    protected static final long RECENTLY_USED = 0x1000000000000000L;
    protected static final long EVICTED = 0x2000000000000000L;
    protected static final long IN_USE_BY_TX = 0x4000000000000000L;
    private static final long LAST_MODIFIED_MASK = 0xFFFFFFFFFFFFFFL;
    public static final int MAX_INLINE_STRING_KEY_CHAR_ENCODING = 7;
    public static final int MAX_INLINE_STRING_KEY_BYTE_ENCODING = 15;

    protected AbstractRegionEntry(RegionEntryContext context, Object value2) {
        this.setValue(context, AbstractRegionMap.prepareValueForCache(context, value2), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"IMSE_DONT_CATCH_IMSE"})
    public boolean dispatchListenerEvents(EntryEventImpl event) throws InterruptedException {
        LocalRegion rgn = event.getRegion();
        if (event.callbacksInvoked()) {
            return true;
        }
        event.setCallbacksInvokedByCurrentThread();
        if (logger.isDebugEnabled()) {
            logger.debug("{} dispatching event {}", this, event);
        }
        try {
            event.invokeCallbacks(rgn, event.inhibitCacheListenerNotification(), false);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.isRemoved() && !this.isTombstone()) {
                this.removePhase2();
                rgn.getRegionMap().removeEntry(event.getKey(), this, true, event, rgn, rgn.getIndexUpdater());
            }
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        throw new InternalStatisticsDisabledException();
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        throw new InternalStatisticsDisabledException();
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        throw new InternalStatisticsDisabledException();
    }

    protected void setLastModified(long lastModified) {
        this._setLastModified(lastModified);
    }

    @Override
    public void txDidDestroy(long currTime) {
        this.setLastModified(currTime);
    }

    @Override
    public final void updateStatsForPut(long lastModifiedTime) {
        this.setLastModified(lastModifiedTime);
    }

    @Override
    public void setRecentlyUsed() {
    }

    @Override
    public void updateStatsForGet(boolean hit, long time) {
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        throw new InternalStatisticsDisabledException();
    }

    public void _removePhase1() {
        this._setValue(Token.REMOVED_PHASE1);
    }

    @Override
    public void removePhase1(LocalRegion r, boolean isClear) throws RegionClearedException {
        this._removePhase1();
    }

    @Override
    public void removePhase2() {
        this._setValue(Token.REMOVED_PHASE2);
    }

    @Override
    public void makeTombstone(LocalRegion r, VersionTag version) throws RegionClearedException {
        assert (r.getVersionVector() != null);
        assert (version != null);
        if (r.getServerProxy() == null && r.getVersionVector().isTombstoneTooOld(version.getMemberID(), version.getRegionVersion())) {
            if (!this.isTombstone()) {
                this.setValue(r, Token.TOMBSTONE);
                r.incTombstoneCount(1);
            }
            r.getRegionMap().removeTombstone(this, version, false, true);
        } else {
            if (this.isTombstone()) {
                r.unscheduleTombstone(this);
            }
            this.setRecentlyUsed();
            boolean newEntry = this.getValueAsToken() == Token.REMOVED_PHASE1;
            this.setValue(r, Token.TOMBSTONE);
            r.scheduleTombstone(this, version);
            if (newEntry) {
                r.getCachePerfStats().incEntryCount(1);
            }
        }
    }

    @Override
    public void setValueWithTombstoneCheck(Object v, EntryEvent e) throws RegionClearedException {
        if (v == Token.TOMBSTONE) {
            this.makeTombstone((LocalRegion)e.getRegion(), ((EntryEventImpl)e).getVersionTag());
        } else {
            this.setValue((RegionEntryContext)((LocalRegion)e.getRegion()), v, (EntryEventImpl)e);
        }
    }

    @Override
    public final boolean isRemoved() {
        Token o = this.getValueAsToken();
        return o == Token.REMOVED_PHASE1 || o == Token.REMOVED_PHASE2 || o == Token.TOMBSTONE;
    }

    @Override
    public final boolean isDestroyedOrRemoved() {
        return Token.isRemoved(this.getValueAsToken());
    }

    @Override
    public final boolean isDestroyedOrRemovedButNotTombstone() {
        Token o = this.getValueAsToken();
        return o == Token.DESTROYED || o == Token.REMOVED_PHASE1 || o == Token.REMOVED_PHASE2;
    }

    @Override
    public final boolean isTombstone() {
        return this.getValueAsToken() == Token.TOMBSTONE;
    }

    @Override
    public final boolean isRemovedPhase2() {
        return this.getValueAsToken() == Token.REMOVED_PHASE2;
    }

    @Override
    public boolean fillInValue(LocalRegion region, InitialImageOperation.Entry dst, ByteArrayDataInput in, DM mgr) {
        Object v;
        dst.setSerialized(false);
        if (this.isTombstone()) {
            v = Token.TOMBSTONE;
        } else {
            v = this.getValue(region);
            if (v == null) {
                return false;
            }
        }
        boolean isEagerDeserialize = dst.isEagerDeserialize();
        if (isEagerDeserialize) {
            dst.clearEagerDeserialize();
        }
        dst.setLastModified(mgr, this.getLastModified());
        if (v == Token.INVALID) {
            dst.setInvalid();
        } else if (v == Token.LOCAL_INVALID) {
            dst.setLocalInvalid();
        } else if (v == Token.TOMBSTONE) {
            dst.setTombstone();
        } else if (v instanceof CachedDeserializable) {
            Object tmp = ((CachedDeserializable)v).getValue();
            if (tmp instanceof byte[]) {
                byte[] bb = (byte[])tmp;
                dst.value = bb;
            } else if (isEagerDeserialize && tmp instanceof byte[][]) {
                dst.value = tmp;
                dst.setEagerDeserialize();
            } else {
                try {
                    HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                    BlobHelper.serializeTo(tmp, hdos);
                    hdos.trim();
                    dst.value = hdos;
                }
                catch (IOException e) {
                    IllegalArgumentException e2 = new IllegalArgumentException(LocalizedStrings.AbstractRegionEntry_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString());
                    e2.initCause(e);
                    throw e2;
                }
            }
            dst.setSerialized(true);
        } else if (v instanceof byte[]) {
            dst.value = v;
        } else if (isEagerDeserialize && v instanceof byte[][]) {
            dst.value = v;
            dst.setEagerDeserialize();
        } else {
            try {
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                BlobHelper.serializeTo(v, hdos);
                hdos.trim();
                dst.value = hdos;
                dst.setSerialized(true);
            }
            catch (IOException e) {
                IllegalArgumentException e2 = new IllegalArgumentException(LocalizedStrings.AbstractRegionEntry_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString());
                e2.initCause(e);
                throw e2;
            }
        }
        return true;
    }

    @Override
    public boolean isOverflowedToDisk(LocalRegion r, DistributedRegion.DiskPosition dp) {
        return false;
    }

    @Override
    public Object getValue(RegionEntryContext context) {
        Object result = this._getValueUse(context, true);
        if (Token.isRemoved(result)) {
            return null;
        }
        this.setRecentlyUsed();
        return result;
    }

    @Override
    public void setValue(RegionEntryContext context, Object value2) throws RegionClearedException {
        this.setValue(context, value2, true);
    }

    @Override
    public void setValue(RegionEntryContext context, Object value2, EntryEventImpl event) throws RegionClearedException {
        this.setValue(context, value2);
    }

    protected void setValue(RegionEntryContext context, Object value2, boolean recentlyUsed) {
        this._setValue(value2);
        if (recentlyUsed) {
            this.setRecentlyUsed();
        }
    }

    static Object decompress(RegionEntryContext context, Object value2) {
        if (AbstractRegionEntry.isCompressible(context, value2)) {
            long time = context.getCachePerfStats().startDecompression();
            value2 = EntryEventImpl.deserialize(context.getCompressor().decompress((byte[])value2));
            context.getCachePerfStats().endDecompression(time);
        }
        return value2;
    }

    protected static Object compress(RegionEntryContext context, Object value2) {
        return AbstractRegionEntry.compress(context, value2, null);
    }

    protected static Object compress(RegionEntryContext context, Object value2, EntryEventImpl event) {
        if (AbstractRegionEntry.isCompressible(context, value2)) {
            byte[] serializedValue;
            long time = context.getCachePerfStats().startCompression();
            if (event != null && event.getCachedSerializedNewValue() != null) {
                serializedValue = event.getCachedSerializedNewValue();
                if (value2 instanceof CachedDeserializable) {
                    CachedDeserializable cd2 = (CachedDeserializable)value2;
                    serializedValue = !(cd2.getValue() instanceof byte[]) ? EntryEventImpl.serialize(CachedDeserializableFactory.create(serializedValue)) : EntryEventImpl.serialize(cd2);
                }
            } else {
                serializedValue = EntryEventImpl.serialize(value2);
                if (event != null && !(value2 instanceof byte[])) {
                    if (value2 instanceof CachedDeserializable) {
                        CachedDeserializable cd3 = (CachedDeserializable)value2;
                        Object cdVal = cd3.getValue();
                        if (cdVal instanceof byte[]) {
                            event.setCachedSerializedNewValue((byte[])cdVal);
                        }
                    } else {
                        event.setCachedSerializedNewValue(serializedValue);
                    }
                }
            }
            value2 = context.getCompressor().compress(serializedValue);
            context.getCachePerfStats().endCompression(time, serializedValue.length, ((byte[])value2).length);
        }
        return value2;
    }

    @Override
    public final Object getValueInVM(RegionEntryContext context) {
        Object v = this._getValueUse(context, true);
        if (v == null) {
            v = Token.NOT_AVAILABLE;
        }
        return v;
    }

    @Override
    public Object getValueInVMOrDiskWithoutFaultIn(LocalRegion owner) {
        return this.getValueInVM(owner);
    }

    @Override
    public Object getValueOffHeapOrDiskWithoutFaultIn(LocalRegion owner) {
        return this._getValueUse(owner, true);
    }

    @Override
    public Object getValueOnDisk(LocalRegion r) throws EntryNotFoundException {
        throw new IllegalStateException(LocalizedStrings.AbstractRegionEntry_CANNOT_GET_VALUE_ON_DISK_FOR_A_REGION_THAT_DOES_NOT_ACCESS_THE_DISK.toLocalizedString());
    }

    @Override
    public Object getSerializedValueOnDisk(LocalRegion r) throws EntryNotFoundException {
        throw new IllegalStateException(LocalizedStrings.AbstractRegionEntry_CANNOT_GET_VALUE_ON_DISK_FOR_A_REGION_THAT_DOES_NOT_ACCESS_THE_DISK.toLocalizedString());
    }

    @Override
    public Object getValueOnDiskOrBuffer(LocalRegion r) throws EntryNotFoundException {
        throw new IllegalStateException(LocalizedStrings.AbstractRegionEntry_CANNOT_GET_VALUE_ON_DISK_FOR_A_REGION_THAT_DOES_NOT_ACCESS_THE_DISK.toLocalizedString());
    }

    @Override
    public final boolean initialImagePut(LocalRegion region, long lastModifiedTime, Object newValue, boolean wasRecovered, boolean versionTagAccepted) throws RegionClearedException {
        return this.initialImageInit(region, lastModifiedTime, newValue, this.isTombstone(), wasRecovered, versionTagAccepted);
    }

    @Override
    public boolean initialImageInit(LocalRegion region, long lastModifiedTime, Object newValue, boolean create, boolean wasRecovered, boolean versionTagAccepted) throws RegionClearedException {
        boolean result = false;
        Token vTok = this.getValueAsToken();
        if (versionTagAccepted || create || vTok != Token.DESTROYED || vTok != Token.TOMBSTONE) {
            boolean putValue;
            Object newValueToWrite = newValue;
            boolean bl = putValue = versionTagAccepted || create || newValueToWrite != Token.LOCAL_INVALID && (wasRecovered || vTok == Token.LOCAL_INVALID);
            if (region.isUsedForPartitionedRegionAdmin() && newValueToWrite instanceof CachedDeserializable) {
                newValueToWrite = ((CachedDeserializable)newValueToWrite).getDeserializedValue(region, null);
                if (!create && newValueToWrite instanceof Versionable) {
                    Object oldValue = this.getValueInVM(region);
                    if (oldValue == null) {
                        putValue = true;
                    } else if (oldValue instanceof Versionable) {
                        Versionable nv = (Versionable)newValueToWrite;
                        Versionable ov = (Versionable)oldValue;
                        putValue = nv.isNewerThan(ov);
                    }
                }
            }
            if (putValue) {
                if (create || versionTagAccepted) {
                    ImageState imageState = region.getImageState();
                    if (imageState.getRegionInvalidated()) {
                        if (newValueToWrite != Token.TOMBSTONE) {
                            newValueToWrite = Token.INVALID;
                        }
                    } else if (imageState.getClearRegionFlag()) {
                        boolean entryOK = false;
                        RegionVersionVector rvv = imageState.getClearRegionVersionVector();
                        if (rvv != null) {
                            Object id = this.getVersionStamp().getMemberID();
                            if (id == null) {
                                id = region.getVersionMember();
                            }
                            if (!rvv.contains(id, this.getVersionStamp().getRegionVersion())) {
                                entryOK = true;
                            }
                        }
                        if (!entryOK) {
                            newValueToWrite = Token.DESTROYED;
                            imageState.addDestroyedEntry(this.getKey());
                            throw new RegionClearedException(LocalizedStrings.AbstractRegionEntry_DURING_THE_GII_PUT_OF_ENTRY_THE_REGION_GOT_CLEARED_SO_ABORTING_THE_OPERATION.toLocalizedString());
                        }
                    }
                }
                this.setValue(region, AbstractRegionMap.prepareValueForCache(region, newValueToWrite));
                result = true;
                if (newValueToWrite != Token.TOMBSTONE) {
                    if (create) {
                        region.getCachePerfStats().incCreates();
                    }
                    region.updateStatsForPut(this, lastModifiedTime, false);
                }
                if (logger.isTraceEnabled()) {
                    if (newValueToWrite instanceof CachedDeserializable) {
                        logger.trace("ProcessChunk: region={}; put a CachedDeserializable ({},{})", region.getFullPath(), this.getKey(), ((CachedDeserializable)newValueToWrite).getStringForm());
                    } else {
                        logger.trace("ProcessChunk: region={}; put({},{})", region.getFullPath(), this.getKey(), StringUtils.forceToString(newValueToWrite));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public final boolean destroy(LocalRegion region, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException, RegionClearedException {
        boolean proceed = false;
        Object curValue = this._getValueUse(region, true);
        if (curValue == null) {
            curValue = Token.NOT_AVAILABLE;
        }
        if (curValue == Token.NOT_AVAILABLE) {
            if (event.getCallbackArgument() != null && event.getCallbackArgument().equals("WAN_QUEUE_TOKEN") && event.isOriginRemote()) {
                curValue = this.getValueOnDiskOrBuffer(region);
            } else {
                FilterProfile fp = region.getFilterProfile();
                if (fp != null && (fp.getCqCount() > 0 || expectedOldValue != null || event.getRegion().getIndexUpdater() != null)) {
                    curValue = this.getValueOnDiskOrBuffer(region);
                }
            }
        }
        if (expectedOldValue != null && !AbstractRegionEntry.checkExpectedOldValue(expectedOldValue, curValue)) {
            throw new EntryNotFoundException(LocalizedStrings.AbstractRegionEntry_THE_CURRENT_VALUE_WAS_NOT_EQUAL_TO_EXPECTED_VALUE.toLocalizedString());
        }
        if (inTokenMode && event.hasOldValue()) {
            proceed = true;
        } else {
            boolean bl = proceed = event.setOldValue(curValue) || removeRecoveredEntry || forceDestroy || region.getConcurrencyChecksEnabled() || event.getOperation() == Operation.REMOVE && (curValue == null || curValue == Token.LOCAL_INVALID || curValue == Token.INVALID);
        }
        if (proceed) {
            IndexManager indexManager;
            if (!removeRecoveredEntry) {
                region.generateAndSetVersionTag(event, this);
            }
            if (cacheWrite) {
                VersionStamp stamp;
                region.cacheWriteBeforeDestroy(event, expectedOldValue);
                if (event.getRegion().getServerProxy() != null && (stamp = this.getVersionStamp()) != null) {
                    stamp.processVersionTag(event);
                }
            }
            region.recordEvent(event);
            if (!region.isProxy() && !this.isInvalid() && (indexManager = region.getIndexManager()) != null) {
                try {
                    if (this.isValueNull()) {
                        this._setValue(AbstractRegionMap.prepareValueForCache(region, this.getValueInVMOrDiskWithoutFaultIn(region)));
                    }
                    indexManager.updateIndexes(this, 3, 0);
                }
                catch (QueryException e) {
                    throw new IndexMaintenanceException(e);
                }
            }
            boolean removeEntry = false;
            VersionTag v = event.getVersionTag();
            if (region.concurrencyChecksEnabled && !removeRecoveredEntry && !event.isFromRILocalDestroy()) {
                VersionStamp stamp;
                if (!(v != null && v.hasValidVersion() || (stamp = this.getVersionStamp()) == null)) {
                    v = stamp.asVersionTag();
                    event.setVersionTag(v);
                }
                removeEntry = v == null || !v.hasValidVersion();
            } else {
                removeEntry = true;
            }
            if (removeEntry) {
                boolean isThisTombstone = this.isTombstone();
                if (inTokenMode) {
                    this.setValue(region, Token.DESTROYED);
                } else {
                    this.removePhase1(region, false);
                }
                if (isThisTombstone) {
                    region.unscheduleTombstone(this);
                }
            } else {
                this.makeTombstone(region, v);
            }
            return true;
        }
        return false;
    }

    static boolean checkExpectedOldValue(Object expectedOldValue, Object actualValue) {
        if (Token.isInvalid(expectedOldValue)) {
            return actualValue == null || Token.isInvalid(actualValue);
        }
        return AbstractRegionEntry.checkEquals(expectedOldValue, actualValue);
    }

    static boolean checkEquals(Object v1, Object v2) {
        if (v1 instanceof PdxInstance) {
            return AbstractRegionEntry.checkPdxEquals((PdxInstance)v1, v2);
        }
        if (v2 instanceof PdxInstance) {
            return AbstractRegionEntry.checkPdxEquals((PdxInstance)v2, v1);
        }
        if (v1 instanceof CachedDeserializable) {
            return AbstractRegionEntry.checkCDEquals((CachedDeserializable)v1, v2);
        }
        if (v2 instanceof CachedDeserializable) {
            return AbstractRegionEntry.checkCDEquals((CachedDeserializable)v2, v1);
        }
        if (v2 != null) {
            return v2.equals(v1);
        }
        return v1 == null;
    }

    private static boolean checkCDEquals(CachedDeserializable cd2, Object obj) {
        Object cdVal = cd2.getValue();
        if (cdVal instanceof byte[]) {
            Object deserializedObj;
            byte[] cdValBytes = (byte[])cdVal;
            PdxInstance pi = InternalDataSerializer.readPdxInstance(cdValBytes, GemFireCacheImpl.getForPdx("Could not check value equality"));
            if (pi != null) {
                return AbstractRegionEntry.checkPdxEquals(pi, obj);
            }
            if (obj instanceof CachedDeserializable) {
                deserializedObj = ((CachedDeserializable)obj).getDeserializedForReading();
            } else {
                if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
                    return false;
                }
                deserializedObj = obj;
            }
            return cd2.getDeserializedForReading().equals(deserializedObj);
        }
        if (obj instanceof CachedDeserializable) {
            obj = ((CachedDeserializable)obj).getDeserializedForReading();
        }
        return cdVal.equals(obj);
    }

    private static boolean checkPdxEquals(PdxInstance pdx, Object obj) {
        if (!(obj instanceof PdxInstance)) {
            PdxSerializer pdxSerializer;
            GemFireCacheImpl gfc;
            if (obj instanceof CachedDeserializable) {
                Object cdVal = ((CachedDeserializable)obj).getValue();
                if (cdVal instanceof byte[]) {
                    byte[] cdValBytes = (byte[])cdVal;
                    PdxInstance pi = InternalDataSerializer.readPdxInstance(cdValBytes, GemFireCacheImpl.getForPdx("Could not check value equality"));
                    if (pi != null) {
                        return pi.equals(pdx);
                    }
                    return false;
                }
                obj = cdVal;
            }
            if (obj.getClass().getName().equals(pdx.getClassName()) && (gfc = GemFireCacheImpl.getForPdx("Could not access Pdx registry")) != null && ((pdxSerializer = obj instanceof PdxSerializable ? null : gfc.getPdxSerializer()) != null || obj instanceof PdxSerializable)) {
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                try {
                    PdxInstance pi;
                    if ((InternalDataSerializer.autoSerialized(obj, hdos) || InternalDataSerializer.writePdx(hdos, gfc, obj, pdxSerializer)) && (pi = InternalDataSerializer.readPdxInstance(hdos.toByteArray(), gfc)) != null) {
                        obj = pi;
                    }
                }
                catch (IOException ignore) {
                }
                catch (PdxSerializationException ignore) {
                    // empty catch block
                }
            }
        }
        return obj.equals(pdx);
    }

    @Override
    public abstract Object getKey();

    @Override
    public boolean isKeyEqual(Object k) {
        return k.equals(this.getKey());
    }

    protected final void _setLastModified(long lastModifiedTime) {
        long storedValue;
        if (lastModifiedTime < 0L || lastModifiedTime > 0xFFFFFFFFFFFFFFL) {
            throw new IllegalStateException("Expected lastModifiedTime " + lastModifiedTime + " to be >= 0 and <= " + 0xFFFFFFFFFFFFFFL);
        }
        do {
            storedValue = this.getlastModifiedField();
            long newValue = storedValue & 0xFF00000000000000L;
        } while (!this.compareAndSetLastModifiedField(storedValue, newValue |= lastModifiedTime));
    }

    protected abstract long getlastModifiedField();

    protected abstract boolean compareAndSetLastModifiedField(long var1, long var3);

    @Override
    public final long getLastModified() {
        return this.getlastModifiedField() & 0xFFFFFFFFFFFFFFL;
    }

    protected final boolean areAnyBitsSet(long bitMask) {
        return (this.getlastModifiedField() & bitMask) != 0L;
    }

    protected final void setBits(long bitMask) {
        long newBits;
        long bits;
        boolean done = false;
        do {
            if ((bits = this.getlastModifiedField()) != (newBits = bits | bitMask)) continue;
            return;
        } while (!(done = this.compareAndSetLastModifiedField(bits, newBits)));
    }

    protected final void clearBits(long bitMask) {
        long newBits;
        long bits;
        boolean done = false;
        do {
            if ((bits = this.getlastModifiedField()) != (newBits = bits & bitMask)) continue;
            return;
        } while (!(done = this.compareAndSetLastModifiedField(bits, newBits)));
    }

    @Override
    public final boolean isUpdateInProgress() {
        return this.areAnyBitsSet(0x200000000000000L);
    }

    @Override
    public final void setUpdateInProgress(boolean underUpdate) {
        if (underUpdate) {
            this.setBits(0x200000000000000L);
        } else {
            this.clearBits(-144115188075855873L);
        }
    }

    @Override
    public final boolean isCacheListenerInvocationInProgress() {
        return this.areAnyBitsSet(0x800000000000000L);
    }

    @Override
    public final void setCacheListenerInvocationInProgress(boolean listenerInvoked) {
        if (listenerInvoked) {
            this.setBits(0x800000000000000L);
        } else {
            this.clearBits(-576460752303423489L);
        }
    }

    @Override
    public final boolean isInUseByTransaction() {
        return this.areAnyBitsSet(0x4000000000000000L);
    }

    @Override
    public final void setInUseByTransaction(boolean v) {
        if (v) {
            this.setBits(0x4000000000000000L);
        } else {
            this.clearBits(-4611686018427387905L);
        }
    }

    @Override
    public final synchronized void incRefCount() {
        TXManagerImpl.incRefCount(this);
        this.setInUseByTransaction(true);
    }

    @Override
    public final synchronized void decRefCount(NewLRUClockHand lruList, LocalRegion lr) {
        if (TXManagerImpl.decRefCount(this) && this.isInUseByTransaction()) {
            this.setInUseByTransaction(false);
            if (lruList != null) {
                lruList.appendEntry((LRUClockNode)((Object)this));
            }
            if (lr != null && lr.isEntryExpiryPossible()) {
                lr.addExpiryTaskIfAbsent(this);
            }
        }
    }

    @Override
    public final synchronized void resetRefCount(NewLRUClockHand lruList) {
        if (this.isInUseByTransaction()) {
            this.setInUseByTransaction(false);
            if (lruList != null) {
                lruList.appendEntry((LRUClockNode)((Object)this));
            }
        }
    }

    protected final void _setValue(Object val) {
        this.areSetValue(val);
    }

    @Override
    public final Object _getValue() {
        return this.areGetValue();
    }

    @Override
    public Token getValueAsToken() {
        Object v = this.areGetValue();
        if (v == null || v instanceof Token) {
            return (Token)v;
        }
        return Token.NOT_A_TOKEN;
    }

    protected abstract Object areGetValue();

    protected abstract void areSetValue(Object var1);

    @Override
    public Object getTransformedValue() {
        return this._getValueUse(null, false);
    }

    @Override
    public final boolean getValueWasResultOfSearch() {
        return this.areAnyBitsSet(0x100000000000000L);
    }

    @Override
    public final void setValueResultOfSearch(boolean v) {
        if (v) {
            this.setBits(0x100000000000000L);
        } else {
            this.clearBits(-72057594037927937L);
        }
    }

    public boolean hasValidVersion() {
        VersionStamp stamp = (VersionStamp)((Object)this);
        boolean has = stamp.getRegionVersion() != 0L || stamp.getEntryVersion() != 0;
        return has;
    }

    @Override
    public boolean hasStats() {
        return false;
    }

    @Override
    public final Object getMapValue() {
        return this;
    }

    @Override
    public final void setMapValue(Object newValue) {
        if (this != newValue) {
            Assert.fail("AbstractRegionEntry#setMapValue: unexpected setMapValue with newValue=" + newValue + ", this=" + this);
        }
    }

    protected abstract void setEntryHash(int var1);

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append(" (");
        return this.appendFieldsToString(sb).append(')').toString();
    }

    protected StringBuilder appendFieldsToString(StringBuilder sb) {
        sb.append("key=").append(this.getKey()).append("; rawValue=").append(this._getValue());
        VersionStamp stamp = this.getVersionStamp();
        if (stamp != null) {
            sb.append("; version=").append(stamp.asVersionTag() + ";member=" + stamp.getMemberID());
        }
        return sb;
    }

    @Override
    public VersionTag generateVersionTag(VersionSource mbr, boolean withDelta, LocalRegion region, EntryEventImpl event) {
        VersionStamp stamp = this.getVersionStamp();
        if (stamp != null && region.getServerProxy() == null) {
            VersionTag remoteTag;
            VersionSource regionMember;
            int v = stamp.getEntryVersion() + 1;
            if (v > 0xFFFFFF) {
                v -= 0x1000000;
            }
            Object previous = stamp.getMemberID();
            if (mbr == null && (regionMember = region.getVersionMember()) instanceof DiskStoreID) {
                mbr = regionMember;
            }
            VersionTag tag = VersionTag.create(mbr);
            tag.setEntryVersion(v);
            if (region.getVersionVector() != null) {
                tag.setRegionVersion(region.getVersionVector().getNextVersion());
            }
            if (withDelta) {
                tag.setPreviousMemberID(previous);
            }
            if ((remoteTag = event.getVersionTag()) != null && remoteTag.isGatewayTag()) {
                tag.setVersionTimeStamp(remoteTag.getVersionTimeStamp());
                tag.setDistributedSystemId(remoteTag.getDistributedSystemId());
                tag.setAllowedByResolver(remoteTag.isAllowedByResolver());
            } else {
                long time = region.cacheTimeMillis();
                int dsid = region.getDistributionManager().getDistributedSystemId();
                if (time <= stamp.getVersionTimeStamp() && dsid != tag.getDistributedSystemId()) {
                    time = stamp.getVersionTimeStamp() + 1L;
                }
                tag.setVersionTimeStamp(time);
                tag.setDistributedSystemId(dsid);
            }
            stamp.setVersions(tag);
            stamp.setMemberID(mbr);
            event.setVersionTag(tag);
            if (logger.isDebugEnabled()) {
                logger.debug("generated tag {}; region={}; rvv={}", tag, region.getFullPath(), region.getVersionVector());
            }
            return tag;
        }
        return null;
    }

    public void setTombstoneScheduled(boolean scheduled) {
        if (scheduled) {
            this.setBits(0x400000000000000L);
        } else {
            this.clearBits(-288230376151711745L);
        }
    }

    public boolean isTombstoneScheduled() {
        return this.areAnyBitsSet(0x400000000000000L);
    }

    public void processVersionTag(EntryEvent cacheEvent) {
        this.processVersionTag(cacheEvent, true);
    }

    protected void processVersionTag(EntryEvent cacheEvent, boolean conflictCheck) {
        EntryEventImpl event = (EntryEventImpl)cacheEvent;
        VersionTag tag = event.getVersionTag();
        if (tag == null) {
            return;
        }
        try {
            if (tag.isGatewayTag()) {
                if (this.processGatewayTag(cacheEvent)) {
                    return;
                }
                assert (false) : "processGatewayTag failure - returned false";
            }
            if (!tag.isFromOtherMember() && !event.getOperation().isNetSearch()) {
                return;
            }
            InternalDistributedMember originator = (InternalDistributedMember)event.getDistributedMember();
            VersionSource dmId = event.getRegion().getVersionMember();
            LocalRegion r = event.getLocalRegion();
            boolean eventHasDelta = event.getDeltaBytes() != null && event.getRawNewValue() == null;
            VersionStamp stamp = this.getVersionStamp();
            if (stamp != null && !tag.isAllowedByResolver()) {
                int stampDsId = stamp.getDistributedSystemId();
                int tagDsId = tag.getDistributedSystemId();
                if (stampDsId != 0 && stampDsId != tagDsId && stampDsId != -1) {
                    StringBuilder verbose = null;
                    if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
                        verbose = new StringBuilder();
                        verbose.append("processing tag for key " + this.getKey() + ", stamp=" + stamp.asVersionTag() + ", tag=").append(tag);
                    }
                    long stampTime = stamp.getVersionTimeStamp();
                    long tagTime = tag.getVersionTimeStamp();
                    if (stampTime > 0L && (tagTime > stampTime || tagTime == stampTime && tag.getDistributedSystemId() >= stamp.getDistributedSystemId())) {
                        if (verbose != null) {
                            verbose.append(" - allowing event");
                            logger.trace(LogMarker.TOMBSTONE, (Object)verbose);
                        }
                        this.applyVersionTag(r, stamp, tag, originator);
                        return;
                    }
                    if (stampTime > 0L) {
                        if (verbose != null) {
                            verbose.append(" - disallowing event");
                            logger.trace(LogMarker.TOMBSTONE, (Object)verbose);
                        }
                        r.getCachePerfStats().incConflatedEventsCount();
                        this.persistConflictingTag(r, tag);
                        throw new ConcurrentCacheModificationException("conflicting event detected");
                    }
                }
            }
            if (r.getVersionVector() != null && r.getServerProxy() == null && (r.getDataPolicy().withPersistence() || !r.getScope().isLocal())) {
                Object who = tag.getMemberID();
                if (who == null) {
                    who = originator;
                }
                r.getVersionVector().recordVersion(who, tag);
            }
            assert (!tag.isFromOtherMember() || tag.getMemberID() != null) : "remote tag is missing memberID";
            this.basicProcessVersionTag(r, tag, false, eventHasDelta, dmId, originator, conflictCheck);
        }
        catch (ConcurrentCacheModificationException ex) {
            event.isConcurrencyConflict(true);
            throw ex;
        }
    }

    protected final void basicProcessVersionTag(LocalRegion region, VersionTag tag, boolean isTombstoneFromGII, boolean deltaCheck, VersionSource dmId, InternalDistributedMember sender, boolean checkForConflict) {
        StringBuilder verbose = null;
        if (tag != null) {
            VersionTag stampTag;
            VersionStamp stamp = this.getVersionStamp();
            if (logger.isTraceEnabled(LogMarker.TOMBSTONE) && (stampTag = stamp.asVersionTag()).hasValidVersion() && checkForConflict) {
                verbose = new StringBuilder();
                verbose.append("processing tag for key " + this.getKey() + ", stamp=" + stamp.asVersionTag() + ", tag=").append(tag).append(", checkForConflict=").append(checkForConflict);
            }
            if (stamp == null) {
                throw new IllegalStateException("message contained a version tag but this region has no version storage");
            }
            boolean apply = true;
            try {
                if (checkForConflict) {
                    apply = this.checkForConflict(region, stamp, tag, isTombstoneFromGII, deltaCheck, dmId, sender, verbose);
                }
            }
            catch (ConcurrentCacheModificationException e) {
                if (!tag.isGatewayTag() && stamp.getDistributedSystemId() == tag.getDistributedSystemId() && tag.getVersionTimeStamp() > stamp.getVersionTimeStamp()) {
                    stamp.setVersionTimeStamp(tag.getVersionTimeStamp());
                    tag.setTimeStampApplied(true);
                    if (verbose != null) {
                        verbose.append("\nThough in conflict the tag timestamp was more recent and was recorded.");
                    }
                }
                throw e;
            }
            finally {
                if (verbose != null) {
                    logger.trace(LogMarker.TOMBSTONE, (Object)verbose);
                }
            }
            if (apply) {
                this.applyVersionTag(region, stamp, tag, sender);
            }
        }
    }

    private void applyVersionTag(LocalRegion region, VersionStamp stamp, VersionTag tag, InternalDistributedMember sender) {
        Object mbr = tag.getMemberID();
        if (mbr == null) {
            mbr = sender;
        }
        mbr = region.getVersionVector().getCanonicalId(mbr);
        tag.setMemberID(mbr);
        stamp.setVersions(tag);
        if (tag.hasPreviousMemberID()) {
            if (tag.getPreviousMemberID() == null) {
                tag.setPreviousMemberID(stamp.getMemberID());
            } else {
                tag.setPreviousMemberID(region.getVersionVector().getCanonicalId(tag.getPreviousMemberID()));
            }
        }
    }

    protected boolean checkForConflict(LocalRegion region, VersionStamp stamp, VersionTag tag, boolean isTombstoneFromGII, boolean deltaCheck, VersionSource dmId, InternalDistributedMember sender, StringBuilder verbose) {
        long difference;
        int stampVersion = stamp.getEntryVersion();
        int tagVersion = tag.getEntryVersion();
        boolean throwex = false;
        boolean apply = false;
        if (stamp.getVersionTimeStamp() != 0L && (65536L < (difference = (long)(tagVersion - stampVersion)) || difference < -65536L)) {
            if (verbose != null) {
                verbose.append("\nversion rollover detected: tag=" + tagVersion + " stamp=" + stampVersion);
            }
            if (difference < 0L) {
                tagVersion = (int)((long)tagVersion + 0x1000000L);
            } else {
                stampVersion = (int)((long)stampVersion + 0x1000000L);
            }
        }
        if (verbose != null) {
            verbose.append("\nstamp=v").append(stampVersion).append(" tag=v").append(tagVersion);
        }
        if (deltaCheck) {
            this.checkForDeltaConflict(region, stampVersion, tagVersion, stamp, tag, dmId, sender, verbose);
        }
        if (stampVersion == 0 || stampVersion < tagVersion) {
            if (verbose != null) {
                verbose.append(" - applying change");
            }
            apply = true;
        } else if (stampVersion > tagVersion) {
            if (this.overwritingOldTombstone(region, stamp, tag, verbose) && tag.getVersionTimeStamp() > stamp.getVersionTimeStamp()) {
                apply = true;
            } else if (tagVersion > 0 && this.isExpiredTombstone(region, tag.getVersionTimeStamp(), isTombstoneFromGII) && tag.getVersionTimeStamp() > stamp.getVersionTimeStamp()) {
                if (verbose != null) {
                    verbose.append(" - applying change in Delta GII");
                }
                apply = true;
            } else {
                if (verbose != null) {
                    verbose.append(" - disallowing");
                }
                throwex = true;
            }
        } else if (this.overwritingOldTombstone(region, stamp, tag, verbose)) {
            apply = true;
        } else {
            int compare;
            Object tagID;
            Object stampID = stamp.getMemberID();
            if (stampID == null) {
                stampID = dmId;
            }
            if ((tagID = tag.getMemberID()) == null) {
                tagID = sender;
            }
            if (verbose != null) {
                verbose.append("\ncomparing IDs");
            }
            if ((compare = stampID.compareTo(tagID)) < 0) {
                if (verbose != null) {
                    verbose.append(" - applying change");
                }
                apply = true;
            } else if (compare > 0) {
                if (verbose != null) {
                    verbose.append(" - disallowing");
                }
                throwex = true;
            } else if (tag.isPosDup()) {
                if (verbose != null) {
                    verbose.append(" - disallowing duplicate marked with posdup");
                }
                throwex = true;
            } else if (verbose != null) {
                verbose.append(" - allowing duplicate");
            }
        }
        if (!apply && throwex) {
            region.getCachePerfStats().incConflatedEventsCount();
            this.persistConflictingTag(region, tag);
            throw new ConcurrentCacheModificationException();
        }
        return apply;
    }

    private boolean isExpiredTombstone(LocalRegion region, long timestamp, boolean isTombstone) {
        return isTombstone && timestamp + TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT <= region.cacheTimeMillis();
    }

    private boolean overwritingOldTombstone(LocalRegion region, VersionStamp stamp, VersionTag tag, StringBuilder verbose) {
        long stampTime = stamp.getVersionTimeStamp();
        if (this.isExpiredTombstone(region, stampTime, this.isTombstone())) {
            if (verbose != null) {
                verbose.append(" - accepting because local timestamp is old");
            }
            return true;
        }
        return false;
    }

    protected void persistConflictingTag(LocalRegion region, VersionTag tag) {
    }

    private void checkForDeltaConflict(LocalRegion region, long stampVersion, long tagVersion, VersionStamp stamp, VersionTag tag, VersionSource dmId, InternalDistributedMember sender, StringBuilder verbose) {
        Object tagID;
        if (tagVersion != stampVersion + 1L) {
            if (verbose != null) {
                verbose.append("\ndelta requires full value due to version mismatch");
            }
            region.getCachePerfStats().incDeltaFailedUpdates();
            throw new InvalidDeltaException("delta cannot be applied due to version mismatch");
        }
        Object stampID = stamp.getMemberID();
        if (stampID == null) {
            stampID = dmId;
        }
        if ((tagID = tag.getPreviousMemberID()) == null) {
            tagID = sender;
        }
        if (!tagID.equals(stampID)) {
            if (verbose != null) {
                verbose.append("\ndelta requires full value.  tag.previous=").append(tagID).append(" but stamp.current=").append(stampID);
            }
            region.getCachePerfStats().incDeltaFailedUpdates();
            throw new InvalidDeltaException("delta cannot be applied due to version ID mismatch");
        }
    }

    private boolean processGatewayTag(EntryEvent cacheEvent) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.isRemoved() && !this.isTombstone()) {
            return true;
        }
        EntryEventImpl event = (EntryEventImpl)cacheEvent;
        VersionTag tag = event.getVersionTag();
        long stampTime = this.getVersionStamp().getVersionTimeStamp();
        long tagTime = tag.getVersionTimeStamp();
        int stampDsid = this.getVersionStamp().getDistributedSystemId();
        int tagDsid = tag.getDistributedSystemId();
        if (isDebugEnabled) {
            logger.debug("processing gateway version information for {}.  Stamp dsid={} time={} Tag dsid={} time={}", event.getKey(), stampDsid, stampTime, tagDsid, tagTime);
        }
        if (tagTime == Long.MIN_VALUE) {
            return true;
        }
        if (tagDsid == stampDsid || stampDsid == -1) {
            return true;
        }
        GatewayConflictResolver resolver = event.getRegion().getCache().getGatewayConflictResolver();
        if (resolver != null) {
            if (isDebugEnabled) {
                logger.debug("invoking gateway conflict resolver");
            }
            final boolean[] disallow = new boolean[1];
            final Object[] newValue = new Object[]{this};
            GatewayConflictHelper helper = new GatewayConflictHelper(){

                @Override
                public void disallowEvent() {
                    disallow[0] = true;
                }

                @Override
                public void changeEventValue(Object v) {
                    newValue[0] = v;
                }
            };
            TimestampedEntryEventImpl timestampedEvent = (TimestampedEntryEventImpl)event.getTimestampedEvent(tagDsid, stampDsid, tagTime, stampTime);
            if (!timestampedEvent.hasOldValue() && this.isRemoved()) {
                timestampedEvent.setOldValue(this.getValue(timestampedEvent.getRegion()));
            }
            Throwable thr = null;
            try {
                resolver.onEvent(timestampedEvent, helper);
            }
            catch (CancelException cancelled) {
                throw cancelled;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.error(LocalizedMessage.create(LocalizedStrings.LocalRegion_EXCEPTION_OCCURRED_IN_CONFLICTRESOLVER), t);
                thr = t;
            }
            if (isDebugEnabled) {
                logger.debug("done invoking resolver {}", thr);
            }
            if (thr == null) {
                if (disallow[0]) {
                    if (isDebugEnabled) {
                        logger.debug("conflict resolver rejected the event for {}", event.getKey());
                    }
                    throw new ConcurrentCacheModificationException("WAN conflict resolver rejected the operation");
                }
                tag.setAllowedByResolver(true);
                if (newValue[0] != this) {
                    if (isDebugEnabled) {
                        logger.debug("conflict resolver changed the value of the event for {}", event.getKey());
                    }
                    event.setNewValue(newValue[0]);
                }
                if (isDebugEnabled) {
                    logger.debug("change was allowed by conflict resolver: {}", tag);
                }
                return true;
            }
        }
        if (isDebugEnabled) {
            logger.debug("performing normal WAN conflict check");
        }
        if (tagTime > stampTime || tagTime == stampTime && tagDsid >= stampDsid) {
            if (isDebugEnabled) {
                logger.debug("allowing event");
            }
            return true;
        }
        if (isDebugEnabled) {
            logger.debug("disallowing event for " + event.getKey());
        }
        throw new ConcurrentCacheModificationException("conflicting WAN event detected");
    }

    static boolean isCompressible(RegionEntryContext context, Object value2) {
        return value2 != null && context != null && context.getCompressor() != null && !Token.isInvalidOrRemoved(value2);
    }

    @Override
    public VersionStamp getVersionStamp() {
        return null;
    }

    @Override
    public boolean isValueNull() {
        return null == this.getValueAsToken();
    }

    @Override
    public boolean isInvalid() {
        return Token.isInvalid(this.getValueAsToken());
    }

    @Override
    public boolean isDestroyed() {
        return Token.isDestroyed(this.getValueAsToken());
    }

    @Override
    public void setValueToNull() {
        this._setValue(null);
    }

    @Override
    public boolean isInvalidOrRemoved() {
        return Token.isInvalidOrRemoved(this.getValueAsToken());
    }

    @Override
    public Object _getValueUse(RegionEntryContext context, boolean decompress) {
        if (decompress) {
            return AbstractRegionEntry.decompress(context, this._getValue());
        }
        return this._getValue();
    }

    @Override
    public void returnToPool() {
    }

    public static class HashRegionEntryCreator
    implements CustomEntryConcurrentHashMap.HashEntryCreator<Object, Object> {
        @Override
        public CustomEntryConcurrentHashMap.HashEntry<Object, Object> newEntry(Object key2, int hash, CustomEntryConcurrentHashMap.HashEntry<Object, Object> next2, Object value2) {
            AbstractRegionEntry entry = (AbstractRegionEntry)value2;
            int entryHash = entry.getEntryHash();
            if ((hash == 0 || entryHash != 0) && entryHash != hash) {
                Assert.fail("unexpected mismatch of hash, expected=" + hash + ", actual=" + entryHash + " for " + entry);
            }
            entry.setEntryHash(hash);
            entry.setNextEntry(next2);
            return entry;
        }

        @Override
        public int keyHashCode(Object key2, boolean compareValues) {
            return CustomEntryConcurrentHashMap.keyHash(key2, compareValues);
        }
    }
}

