/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.GridAdvisor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class BridgeServerAdvisor
extends GridAdvisor {
    private BridgeServerAdvisor(DistributionAdvisee server) {
        super(server);
    }

    public static BridgeServerAdvisor createBridgeServerAdvisor(DistributionAdvisee server) {
        BridgeServerAdvisor advisor = new BridgeServerAdvisor(server);
        advisor.initialize();
        return advisor;
    }

    public String toString() {
        return "BridgeServerAdvisor for " + this.getAdvisee().getFullPath();
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new BridgeServerProfile(memberId, version);
    }

    public static class BridgeServerProfile
    extends GridAdvisor.GridProfile {
        private String[] groups;
        private int maxConnections;
        private ServerLoad initialLoad;
        private long loadPollInterval;

        public BridgeServerProfile() {
        }

        public BridgeServerProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public BridgeServerProfile(BridgeServerProfile toCopy) {
            super(toCopy);
            this.groups = toCopy.groups;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public void setGroups(String[] groups) {
            this.groups = groups;
        }

        public ServerLoad getInitialLoad() {
            return this.initialLoad;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public void setInitialLoad(ServerLoad initialLoad) {
            this.initialLoad = initialLoad;
        }

        public long getLoadPollInterval() {
            return this.loadPollInterval;
        }

        public void setLoadPollInterval(long v) {
            this.loadPollInterval = v;
        }

        @Override
        public void processIncoming(DistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            this.tellLocalControllers(removeProfile, exchangeProfiles, replyProfiles);
            this.tellLocalBridgeServers(removeProfile, exchangeProfiles, replyProfiles);
        }

        @Override
        public int getDSFID() {
            return -91;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeStringArray(this.groups, out);
            out.writeInt(this.maxConnections);
            InternalDataSerializer.invokeToData(this.initialLoad, out);
            out.writeLong(this.getLoadPollInterval());
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.groups = DataSerializer.readStringArray(in);
            this.maxConnections = in.readInt();
            this.initialLoad = new ServerLoad();
            InternalDataSerializer.invokeFromData(this.initialLoad, in);
            this.setLoadPollInterval(in.readLong());
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("BridgeServerProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            if (this.groups != null) {
                sb.append("; groups=" + Arrays.asList(this.groups));
                sb.append("; maxConnections=" + this.maxConnections);
                sb.append("; initialLoad=" + this.initialLoad);
                sb.append("; loadPollInterval=" + this.getLoadPollInterval());
            }
        }
    }
}

