/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ServerLocator;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.GridAdvisor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class ControllerAdvisor
extends GridAdvisor {
    private ControllerAdvisor(DistributionAdvisee server) {
        super(server);
    }

    public static ControllerAdvisor createControllerAdvisor(DistributionAdvisee server) {
        ControllerAdvisor advisor = new ControllerAdvisor(server);
        advisor.initialize();
        return advisor;
    }

    @Override
    public final void handshake() {
        DistributionAdvisor sqlfAdvisor;
        DistributionAdvisee sqlfAdvisee;
        super.handshake();
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        GridAdvisor.GridProfile profile = (GridAdvisor.GridProfile)this.createProfile();
        if (cache != null && (sqlfAdvisee = cache.getSqlfAdvisee()) != null && (sqlfAdvisor = sqlfAdvisee.getDistributionAdvisor()) != null) {
            sqlfAdvisor.putProfile(profile);
        }
    }

    @Override
    protected void profileCreated(DistributionAdvisor.Profile profile) {
        super.profileCreated(profile);
        ((ServerLocator)this.getAdvisee()).profileCreated(profile);
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        super.profileRemoved(profile);
        ((ServerLocator)this.getAdvisee()).profileRemoved(profile);
    }

    @Override
    protected void profileUpdated(DistributionAdvisor.Profile profile) {
        super.profileUpdated(profile);
        ((ServerLocator)this.getAdvisee()).profileUpdated(profile);
    }

    @Override
    protected void profilesChanged() {
        if (this.pollIsInitialized()) {
            super.profilesChanged();
            ServerLocator sl = (ServerLocator)this.getAdvisee();
            sl.setLocatorCount(this.getControllerCount());
            sl.setServerCount(this.getBridgeServerCount());
        }
    }

    public String toString() {
        return "ControllerAdvisor for " + this.getAdvisee().getFullPath();
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new ControllerProfile(memberId, version);
    }

    public static class ControllerProfile
    extends GridAdvisor.GridProfile {
        public ControllerProfile() {
        }

        public ControllerProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public ControllerProfile(ControllerProfile toCopy) {
            super(toCopy);
        }

        @Override
        public void processIncoming(DistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            this.tellLocalControllers(removeProfile, exchangeProfiles, replyProfiles);
            this.tellLocalBridgeServers(removeProfile, exchangeProfiles, replyProfiles);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public int getDSFID() {
            return -90;
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("ControllerProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
        }
    }
}

