/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisee;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EventStateHelper;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.ProfileExchangeProcessor;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class CreateRegionProcessor
implements ProfileExchangeProcessor {
    private static final Logger logger = LogService.getLogger();
    protected CacheDistributionAdvisee newRegion;

    public CreateRegionProcessor(CacheDistributionAdvisee newRegion) {
        this.newRegion = newRegion;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void initializeRegion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 3[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Set getRecipients() {
        DistributionAdvisee parent = this.newRegion.getParentAdvisee();
        Set recps = null;
        if (parent == null) {
            InternalDistributedSystem system = this.newRegion.getSystem();
            recps = system.getDistributionManager().getOtherDistributionManagerIds();
        } else {
            recps = this.getAdvice();
        }
        return recps;
    }

    @Override
    public CacheDistributionAdvisor.InitialImageAdvice getInitialImageAdvice(CacheDistributionAdvisor.InitialImageAdvice previousAdvice) {
        return this.newRegion.getCacheDistributionAdvisor().adviseInitialImage(previousAdvice);
    }

    private Set getAdvice() {
        if (this.newRegion instanceof BucketRegion) {
            return ((BucketRegion)this.newRegion).getBucketAdvisor().adviseProfileExchange();
        }
        DistributionAdvisee rgn = this.newRegion.getParentAdvisee();
        DistributionAdvisor advisor = rgn.getDistributionAdvisor();
        return advisor.adviseGeneric();
    }

    protected CreateRegionMessage getCreateRegionMessage(Set recps, ReplyProcessor21 proc, boolean useMcast) {
        CreateRegionMessage msg = new CreateRegionMessage();
        msg.regionPath = this.newRegion.getFullPath();
        msg.profile = (CacheDistributionAdvisor.CacheProfile)this.newRegion.getProfile();
        msg.processorId = proc.getProcessorId();
        msg.concurrencyChecksEnabled = this.newRegion.getAttributes().getConcurrencyChecksEnabled();
        msg.setMulticast(useMcast);
        msg.setRecipients(recps);
        return msg;
    }

    @Override
    public void setOnline(InternalDistributedMember target) {
    }

    public static final class CreateRegionReplyMessage
    extends ReplyMessage {
        protected CacheDistributionAdvisor.CacheProfile profile;
        protected ArrayList bucketProfiles;
        protected Object eventState;
        protected PersistentMemberID destroyedId;
        protected boolean skippedCompatibilityChecks;
        long seqKeyForWan = -1L;

        @Override
        public int getDSFID() {
            return 74;
        }

        @Override
        public boolean sendViaJGroups() {
            return true;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            int size2;
            super.fromData(in);
            if (in.readBoolean()) {
                this.profile = (CacheDistributionAdvisor.CacheProfile)DataSerializer.readObject(in);
            }
            if ((size2 = in.readInt()) == 0) {
                this.bucketProfiles = null;
            } else {
                this.bucketProfiles = new ArrayList(size2);
                for (int i = 0; i < size2; ++i) {
                    RegionAdvisor.BucketProfileAndId bp = new RegionAdvisor.BucketProfileAndId();
                    InternalDataSerializer.invokeFromData(bp, in);
                    this.bucketProfiles.add(bp);
                }
            }
            if (in.readBoolean()) {
                this.eventState = EventStateHelper.fromData(in, false);
            }
            if (in.readBoolean()) {
                this.destroyedId = new PersistentMemberID();
                InternalDataSerializer.invokeFromData(this.destroyedId, in);
            }
            this.skippedCompatibilityChecks = in.readBoolean();
            this.seqKeyForWan = in.readLong();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.profile != null);
            if (this.profile != null) {
                DataSerializer.writeObject(this.profile, out);
            }
            if (this.bucketProfiles == null) {
                out.writeInt(0);
            } else {
                int size2 = this.bucketProfiles.size();
                out.writeInt(size2);
                for (int i = 0; i < size2; ++i) {
                    RegionAdvisor.BucketProfileAndId bp = (RegionAdvisor.BucketProfileAndId)this.bucketProfiles.get(i);
                    InternalDataSerializer.invokeToData(bp, out);
                }
            }
            if (this.eventState != null) {
                out.writeBoolean(true);
                EventStateHelper.toData(out, (Map)this.eventState, false);
            } else {
                out.writeBoolean(false);
            }
            if (this.destroyedId != null) {
                out.writeBoolean(true);
                InternalDataSerializer.invokeToData(this.destroyedId, out);
            } else {
                out.writeBoolean(false);
            }
            out.writeBoolean(this.skippedCompatibilityChecks);
            out.writeLong(this.seqKeyForWan);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("CreateRegionReplyMessage");
            buff.append("(sender=").append(this.getSender());
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append("; profile=");
            buff.append(this.profile);
            if (this.bucketProfiles != null) {
                buff.append("; bucketProfiles=");
                buff.append(this.bucketProfiles);
            }
            if (this.eventState != null) {
                buff.append("; eventState=<not null>");
            }
            buff.append("; skippedCompatibilityChecks=");
            buff.append(this.skippedCompatibilityChecks);
            buff.append("; seqKeyForWan=");
            buff.append(this.seqKeyForWan);
            if (this.getException() != null) {
                buff.append("; with exception {").append(this.getException().getMessage()).append("}");
            }
            buff.append(")");
            return buff.toString();
        }
    }

    public static final class CreateRegionMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        public boolean concurrencyChecksEnabled;
        protected String regionPath;
        protected CacheDistributionAdvisor.CacheProfile profile;
        protected int processorId;
        private transient boolean incompatible = false;
        private transient ReplyException replyException;
        private transient CacheDistributionAdvisor.CacheProfile replyProfile;
        private transient ArrayList replyBucketProfiles;
        private transient Object eventState;
        protected transient boolean severeAlertCompatible;
        private transient boolean skippedCompatibilityChecks;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        public boolean isSevereAlertCompatible() {
            return this.severeAlertCompatible;
        }

        @Override
        public boolean sendViaJGroups() {
            return true;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void process(DistributionManager dm) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void handleCacheDistributionAdvisee(CacheDistributionAdvisee cda, boolean isRealRegion) {
            if (cda == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("<lclRgn is null> {}", this);
                }
                return;
            }
            String errorMsg = null;
            if (isRealRegion) {
                errorMsg = this.checkCompatibility(cda, this.profile);
            }
            if (errorMsg != null) {
                this.incompatible = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("{} <replyProfile not set because errorMsg={}", this, errorMsg);
                }
                this.replyException = new ReplyException(new IllegalStateException(errorMsg));
            } else {
                if (isRealRegion && CreateRegionMessage.isLocalAccessor(cda) && this.profile.isPersistent) {
                    DistributedRegion dr;
                    if (cda instanceof DistributedRegion && !(dr = (DistributedRegion)cda).getDataPolicy().withPersistence()) {
                        dr.setGeneratedVersionTag(false);
                    }
                    assert (cda instanceof LocalRegion);
                    LocalRegion lr = (LocalRegion)((Object)cda);
                    lr.enableConcurrencyChecks();
                }
                cda.getDistributionAdvisor().putProfile(this.profile);
                if (isRealRegion) {
                    this.replyProfile = (CacheDistributionAdvisor.CacheProfile)cda.getProfile();
                    if (cda instanceof PartitionedRegion) {
                        PartitionedRegion pr2 = (PartitionedRegion)cda;
                        this.replyBucketProfiles = pr2.getRegionAdvisor().getBucketRegionProfiles();
                    } else if (((LocalRegion)((Object)cda)).isUsedForPartitionedRegionBucket()) {
                        this.eventState = ((LocalRegion)((Object)cda)).getEventState();
                    }
                }
            }
        }

        protected String checkCompatibility(CacheDistributionAdvisee rgn, CacheDistributionAdvisor.CacheProfile profile) {
            PartitionAttributes pa;
            Set<String> myAsyncEventQueueIds;
            Set<String> otherAsynEventQueueIds;
            Set<String> myGatewaySenderIds;
            Set<String> otherGatewaySenderIds;
            Scope otherScope = rgn.getAttributes().getScope();
            String result = null;
            InternalDistributedMember myId = rgn.getDistributionManager().getId();
            boolean myGatewayEnabled = profile.isGatewayEnabled;
            boolean otherGatewayEnabled = rgn.getAttributes().getEnableGateway();
            if (myGatewayEnabled != otherGatewayEnabled) {
                result = LocalizedStrings.CreateRegionProcessor_CANNOT_CREATE_REGION_0_GATEWAYENABLED_1_BECAUSE_ANOTHER_CACHE_HAS_SAME_REGION_GATEWAYENABLED_2.toLocalizedString(this.regionPath, myGatewayEnabled, myId, otherGatewayEnabled);
            }
            boolean otherCCEnabled = rgn.getAttributes().getConcurrencyChecksEnabled();
            boolean skipCheckForAccessor = this.skipCheckForAccessor(rgn, profile);
            boolean skipConcurrencyChecks = this.skipChecksForInternalRegion(rgn);
            boolean initializing = this.skipDuringInitialization(rgn);
            if (initializing) {
                this.skippedCompatibilityChecks = true;
            }
            if (!initializing && !skipCheckForAccessor && rgn.getAttributes().getDataPolicy().withPersistence() != profile.dataPolicy.withPersistence()) {
                if (!rgn.getAttributes().getDataPolicy().withPersistence()) {
                    result = LocalizedStrings.CreateRegionProcessor_CANNOT_CREATE_REGION_0_WITH_PERSISTANCE_TRUE_PERSISTENT_MEMBERS_B4_NON_PERSISTENT.toLocalizedString(this.regionPath, myId);
                    skipConcurrencyChecks = true;
                } else {
                    skipConcurrencyChecks = true;
                }
            }
            if (!(initializing || skipCheckForAccessor || skipConcurrencyChecks || this.concurrencyChecksEnabled == otherCCEnabled)) {
                result = LocalizedStrings.CreateRegionProcessor_CANNOT_CREATE_REGION_0_CCENABLED_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_REGION_CCENABLED_2.toLocalizedString(this.regionPath, this.concurrencyChecksEnabled, myId, otherCCEnabled);
            }
            if (!(otherGatewaySenderIds = ((LocalRegion)((Object)rgn)).getGatewaySenderIds()).equals(myGatewaySenderIds = profile.gatewaySenderIds) && !rgn.getFullPath().contains("__DynamicRegions")) {
                result = LocalizedStrings.CreateRegionProcessor_CANNOT_CREATE_REGION_0_WITH_1_GATEWAY_SENDER_IDS_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_REGION_WITH_2_GATEWAY_SENDER_IDS.toLocalizedString(this.regionPath, otherGatewaySenderIds, myGatewaySenderIds);
            }
            if (!(otherAsynEventQueueIds = ((LocalRegion)((Object)rgn)).getAsyncEventQueueIds()).equals(myAsyncEventQueueIds = profile.asyncEventQueueIds)) {
                result = LocalizedStrings.CreateRegionProcessor_CANNOT_CREATE_REGION_0_WITH_1_ASYNC_EVENT_IDS_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_REGION_WITH_2_ASYNC_EVENT_IDS.toLocalizedString(this.regionPath, otherAsynEventQueueIds, myAsyncEventQueueIds);
            }
            if ((pa = rgn.getAttributes().getPartitionAttributes()) == null && profile.isPartitioned) {
                result = LocalizedStrings.CreateRegionProcessor_CANNOT_CREATE_PARTITIONEDREGION_0_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_REGION_DEFINED_AS_A_NON_PARTITIONEDREGION.toLocalizedString(this.regionPath, myId);
            } else if (pa != null && !profile.isPartitioned) {
                result = LocalizedStrings.CreateRegionProcessor_CANNOT_CREATE_THE_NON_PARTITIONEDREGION_0_BECAUSE_ANOTHER_CACHE_HAS_A_PARTITIONED_REGION_DEFINED_WITH_THE_SAME_NAME.toLocalizedString(this.regionPath, myId);
            } else if (profile.scope.isDistributed() && otherScope.isDistributed() && profile.scope != otherScope) {
                result = LocalizedStrings.CreateRegionProcessor_CANNOT_CREATE_REGION_0_WITH_1_SCOPE_BECAUSE_ANOTHER_CACHE_HAS_SAME_REGION_WITH_2_SCOPE.toLocalizedString(this.regionPath, profile.scope, myId, otherScope);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CreateRegionProcessor.checkCompatibility: this={}; other={}; result={}", rgn, profile, result);
            }
            return result;
        }

        private boolean skipDuringInitialization(CacheDistributionAdvisee rgn) {
            LocalRegion lr;
            boolean skip = false;
            if (rgn instanceof LocalRegion && !(lr = (LocalRegion)((Object)rgn)).isInitialized()) {
                Set recipients = new CreateRegionProcessor(rgn).getRecipients();
                recipients.remove(this.getSender());
                if (!recipients.isEmpty()) {
                    skip = true;
                }
            }
            return skip;
        }

        private boolean skipChecksForInternalRegion(CacheDistributionAdvisee rgn) {
            boolean skip = false;
            if (rgn instanceof LocalRegion) {
                LocalRegion lr = (LocalRegion)((Object)rgn);
                skip = lr.isInternalRegion();
            }
            return skip;
        }

        private boolean skipCheckForAccessor(CacheDistributionAdvisee rgn, CacheDistributionAdvisor.CacheProfile profile) {
            boolean skip = false;
            if (rgn instanceof DistributedRegion) {
                DistributedRegion dr = (DistributedRegion)rgn;
                skip = !dr.getGenerateVersionTag();
            }
            return skip || CreateRegionMessage.isLocalOrRemoteAccessor(rgn, profile);
        }

        protected static boolean isLocalOrRemoteAccessor(CacheDistributionAdvisee region, CacheDistributionAdvisor.CacheProfile profile) {
            return CreateRegionMessage.isLocalAccessor(region) || CreateRegionMessage.isRemoteAccessor(profile);
        }

        protected static boolean isLocalAccessor(CacheDistributionAdvisee region) {
            if (!region.getAttributes().getDataPolicy().withStorage()) {
                return true;
            }
            return region.getAttributes().getPartitionAttributes() != null && region.getAttributes().getPartitionAttributes().getLocalMaxMemory() == 0;
        }

        protected static boolean isRemoteAccessor(CacheDistributionAdvisor.CacheProfile profile) {
            if (!profile.dataPolicy.withStorage()) {
                return true;
            }
            if (profile.isPartitioned) {
                RegionAdvisor.PartitionProfile prProfile = (RegionAdvisor.PartitionProfile)profile;
                if (prProfile.localMaxMemory == 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void reset() {
            super.reset();
            this.regionPath = null;
            this.profile = null;
            this.processorId = -1;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.regionPath = DataSerializer.readString(in);
            this.profile = (CacheDistributionAdvisor.CacheProfile)DataSerializer.readObject(in);
            this.processorId = in.readInt();
            this.concurrencyChecksEnabled = in.readBoolean();
        }

        @Override
        public int getDSFID() {
            return -89;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.regionPath, out);
            DataSerializer.writeObject(this.profile, out);
            out.writeInt(this.processorId);
            out.writeBoolean(this.concurrencyChecksEnabled);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("CreateRegionMessage (region='");
            buff.append(this.regionPath);
            buff.append("'; processorId=");
            buff.append(this.processorId);
            buff.append("; concurrencyChecksEnabled=").append(this.concurrencyChecksEnabled);
            buff.append("; profile=");
            buff.append(this.profile);
            buff.append(")");
            return buff.toString();
        }
    }

    class CreateRegionReplyProcessor
    extends ReplyProcessor21 {
        private Object eventStateLock;
        private boolean eventStateRecorded;
        private boolean allMembersSkippedChecks;

        CreateRegionReplyProcessor(Set members) {
            super((InternalDistributedSystem)CreateRegionProcessor.this.newRegion.getCache().getDistributedSystem(), (Collection)members);
            this.eventStateLock = new Object();
            this.eventStateRecorded = false;
            this.allMembersSkippedChecks = true;
        }

        public boolean needRetry() {
            return this.allMembersSkippedChecks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            Assert.assertTrue(msg instanceof CreateRegionReplyMessage, "CreateRegionProcessor is unable to process message of type " + msg.getClass());
            CreateRegionReplyMessage reply = (CreateRegionReplyMessage)msg;
            LocalRegion lr = (LocalRegion)((Object)CreateRegionProcessor.this.newRegion);
            if (logger.isDebugEnabled()) {
                logger.debug("CreateRegionProcessor processing {}", msg);
            }
            try {
                DistributedRegion dr;
                if (reply.profile != null) {
                    FilterProfile localFP;
                    FilterProfile remoteFP;
                    Object ra;
                    if (CreateRegionProcessor.this.newRegion instanceof DistributedRegion && !(dr = (DistributedRegion)CreateRegionProcessor.this.newRegion).getDataPolicy().withPersistence() && reply.profile.isPersistent) {
                        dr.setGeneratedVersionTag(false);
                    }
                    if (CreateRegionMessage.isLocalAccessor(CreateRegionProcessor.this.newRegion) && reply.profile.isPersistent) {
                        lr.enableConcurrencyChecks();
                    }
                    CacheDistributionAdvisor cda = CreateRegionProcessor.this.newRegion.getCacheDistributionAdvisor();
                    cda.putProfile(reply.profile);
                    if (reply.bucketProfiles != null) {
                        ra = (RegionAdvisor)cda;
                        ((RegionAdvisor)ra).putBucketRegionProfiles(reply.bucketProfiles);
                    }
                    if (reply.eventState != null && lr.hasEventTracker()) {
                        ra = this.eventStateLock;
                        synchronized (ra) {
                            if (!this.eventStateRecorded) {
                                this.eventStateRecorded = true;
                                Object eventState = null;
                                eventState = reply.eventState;
                                lr.recordEventState(reply.getSender(), (Map)eventState);
                            }
                        }
                    }
                    reply.eventState = null;
                    if (lr.isUsedForPartitionedRegionBucket()) {
                        ((BucketRegion)lr).updateEventSeqNum(reply.seqKeyForWan);
                    }
                    if ((remoteFP = reply.profile.filterProfile) != null && (localFP = ((LocalRegion)((Object)CreateRegionProcessor.this.newRegion)).filterProfile) != null) {
                        List messages = localFP.getQueuedFilterProfileMsgs(reply.getSender());
                        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
                        try {
                            remoteFP.processQueuedFilterProfileMsgs(messages);
                        }
                        finally {
                            LocalRegion.setThreadInitLevelRequirement(oldLevel);
                            localFP.removeQueuedFilterProfileMsgs(reply.getSender());
                        }
                    }
                }
                if (reply.destroyedId != null && CreateRegionProcessor.this.newRegion instanceof DistributedRegion) {
                    dr = (DistributedRegion)CreateRegionProcessor.this.newRegion;
                    dr.getPersistenceAdvisor().removeMember(reply.destroyedId);
                }
                if (!reply.skippedCompatibilityChecks) {
                    this.allMembersSkippedChecks = false;
                }
            }
            finally {
                if (logger.isDebugEnabled()) {
                    logger.debug("CreateRegionProcessor invoking super.process()");
                }
                super.process(msg);
            }
        }

        @Override
        protected boolean logMultipleExceptions() {
            return false;
        }
    }
}

