/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.DeltaSerializationException;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.SerializedCacheValue;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.query.IndexMaintenanceException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.internal.IndexUpdater;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexUtils;
import com.gemstone.gemfire.cache.util.TimestampedEntryEvent;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.DSFIDFactory;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.BytesAndBitsForCompactor;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.cache.RemotePutMessage;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TimestampedEntryEventImpl;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PutMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class EntryEventImpl
implements EntryEvent,
InternalCacheEvent,
DataSerializableFixedID,
EntryOperation {
    private static final Logger logger = LogService.getLogger();
    public transient LocalRegion region;
    private transient RegionEntry re;
    protected KeyInfo keyInfo;
    protected EventID eventID;
    private Object newValue = null;
    private byte[] cachedSerializedNewValue = null;
    protected Object oldValue = null;
    protected com.gemstone.gemfire.internal.cache.delta.Delta delta = null;
    protected short eventFlags = 0;
    protected TXId txId = null;
    protected Operation op;
    private transient EnumListenerEvent eventType;
    private transient DistributedPutAllOperation putAllOp;
    private transient DistributedRemoveAllOperation removeAllOp;
    protected DistributedMember distributedMember;
    transient DistributionMessage causedByMessage;
    protected ClientProxyMembershipID context = null;
    private transient Object contextObj = null;
    private byte[] deltaBytes = null;
    private FilterRoutingInfo.FilterInfo filterInfo;
    protected byte[] newValueBytes;
    private byte[] oldValueBytes;
    protected VersionTag versionTag;
    private transient boolean isPendingSecondaryExpireDestroy = false;
    public static final Object SUSPECT_TOKEN = new Object();
    private static final boolean EVENT_OLD_VALUE = !Boolean.getBoolean("gemfire.disable-event-old-value");
    private transient int newValueBucketSize;
    protected Long tailKey = -1L;
    private Thread invokeCallbacksThread;

    public EntryEventImpl() {
    }

    public static EntryEventImpl createVersionTagHolder() {
        return new EntryEventImpl();
    }

    public static EntryEventImpl createVersionTagHolder(VersionTag tag) {
        EntryEventImpl result = new EntryEventImpl();
        result.setVersionTag(tag);
        return result;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.eventID = (EventID)DataSerializer.readObject(in);
        Object key2 = DataSerializer.readObject(in);
        Object value2 = DataSerializer.readObject(in);
        this.keyInfo = new KeyInfo(key2, value2, null);
        this.op = Operation.fromOrdinal(in.readByte());
        this.eventFlags = in.readShort();
        this.keyInfo.setCallbackArg(DataSerializer.readObject(in));
        this.txId = (TXId)DataSerializer.readObject(in);
        if (in.readBoolean()) {
            this.delta = (com.gemstone.gemfire.internal.cache.delta.Delta)DataSerializer.readObject(in);
        } else if (in.readBoolean()) {
            this.newValueBytes = DataSerializer.readByteArray(in);
            this.cachedSerializedNewValue = this.newValueBytes;
            this.newValue = CachedDeserializableFactory.create(this.newValueBytes);
        } else {
            this.newValue = DataSerializer.readObject(in);
        }
        if (in.readBoolean()) {
            this.oldValueBytes = DataSerializer.readByteArray(in);
            this.oldValue = CachedDeserializableFactory.create(this.oldValueBytes);
        } else {
            this.oldValue = DataSerializer.readObject(in);
        }
        this.distributedMember = DSFIDFactory.readInternalDistributedMember(in);
        this.context = ClientProxyMembershipID.readCanonicalized(in);
        this.tailKey = DataSerializer.readLong(in);
    }

    public EntryEventImpl(LocalRegion region, Operation op, Object key2, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember) {
        this(region, op, key2, newValue, callbackArgument, originRemote, distributedMember, true, true);
    }

    public EntryEventImpl(LocalRegion region, Operation op, Object key2, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks) {
        this(region, op, key2, newValue, callbackArgument, originRemote, distributedMember, generateCallbacks, true);
    }

    public EntryEventImpl(LocalRegion region, Operation op, Object key2, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean fromRILocalDestroy) {
        this.region = region;
        this.op = op;
        this.keyInfo = this.region.getKeyInfo(key2);
        this.setOriginRemote(originRemote);
        this.setGenerateCallbacks(generateCallbacks);
        this.distributedMember = distributedMember;
        this.setFromRILocalDestroy(fromRILocalDestroy);
    }

    public EntryEventImpl(LocalRegion region, Operation op, Object key2, Object newVal, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean initializeId) {
        this.region = region;
        this.op = op;
        this.keyInfo = this.region.getKeyInfo(key2, newVal, callbackArgument);
        if (newVal instanceof com.gemstone.gemfire.internal.cache.delta.Delta) {
            this.delta = (com.gemstone.gemfire.internal.cache.delta.Delta)newVal;
        } else if (!Token.isInvalid(newVal)) {
            this.basicSetNewValue(newVal);
        }
        this.txId = this.region.getTXId();
        if (newVal == Token.LOCAL_INVALID) {
            this.setLocalInvalid(true);
        }
        this.setOriginRemote(originRemote);
        this.setGenerateCallbacks(generateCallbacks);
        this.distributedMember = distributedMember;
    }

    public EntryEventImpl(LocalRegion region, Operation op, Object key2, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, EventID eventID) {
        this(region, op, key2, newValue, callbackArgument, originRemote, distributedMember, generateCallbacks, true);
        Assert.assertTrue(eventID != null || !(region instanceof PartitionedRegion));
        this.setEventId(eventID);
    }

    public EntryEventImpl(EntryEventImpl other) {
        this.region = other.region;
        this.eventID = other.eventID;
        this.basicSetNewValue(other.basicGetNewValue());
        this.newValueBytes = other.newValueBytes;
        this.cachedSerializedNewValue = other.cachedSerializedNewValue;
        this.re = other.re;
        this.delta = other.delta;
        this.basicSetOldValue(other.basicGetOldValue(), true);
        this.oldValueBytes = other.oldValueBytes;
        this.eventFlags = other.eventFlags;
        this.setEventFlag((short)128, false);
        this.txId = other.txId;
        this.op = other.op;
        this.distributedMember = other.distributedMember;
        this.filterInfo = other.filterInfo;
        if (other.getRawCallbackArgument() instanceof GatewayEventCallbackArgument) {
            this.keyInfo = new KeyInfo(other.keyInfo);
            this.keyInfo.setCallbackArg(new GatewayEventCallbackArgument((GatewayEventCallbackArgument)other.getRawCallbackArgument()));
        } else if (other.getRawCallbackArgument() instanceof GatewaySenderEventCallbackArgument) {
            this.keyInfo = new KeyInfo(other.keyInfo);
            this.keyInfo.setCallbackArg(new GatewaySenderEventCallbackArgument((GatewaySenderEventCallbackArgument)other.getRawCallbackArgument()));
        } else {
            this.keyInfo = new KeyInfo(other.keyInfo);
        }
        this.context = other.context;
        this.deltaBytes = other.deltaBytes;
        this.tailKey = other.tailKey;
        this.versionTag = other.versionTag;
        this.setPossibleDuplicate(other.isPossibleDuplicate());
    }

    public EntryEventImpl(Object key2) {
        this.keyInfo = new KeyInfo(key2, null, null);
    }

    public EntryEventImpl(EventID id) {
        this.eventID = id;
    }

    static EntryEventImpl createPutAllEvent(DistributedPutAllOperation putAllOp, LocalRegion region, Operation entryOp, Object entryKey, Object entryNewValue) {
        EntryEventImpl e;
        if (putAllOp != null) {
            EntryEventImpl event = putAllOp.getBaseEvent();
            if (event.isBridgeEvent()) {
                e = new EntryEventImpl(region, entryOp, entryKey, entryNewValue, event.getRawCallbackArgument(), false, event.distributedMember, event.isGenerateCallbacks());
                e.setContext(event.getContext());
            } else {
                e = new EntryEventImpl(region, entryOp, entryKey, entryNewValue, event.getCallbackArgument(), false, region.getMyId(), event.isGenerateCallbacks());
            }
        } else {
            e = new EntryEventImpl(region, entryOp, entryKey, entryNewValue, null, false, region.getMyId(), true);
        }
        e.putAllOp = putAllOp;
        return e;
    }

    static EntryEventImpl createRemoveAllEvent(DistributedRemoveAllOperation op, LocalRegion region, Object entryKey) {
        EntryEventImpl e;
        Operation entryOp = Operation.REMOVEALL_DESTROY;
        if (op != null) {
            EntryEventImpl event = op.getBaseEvent();
            if (event.isBridgeEvent()) {
                e = new EntryEventImpl(region, entryOp, entryKey, null, event.getRawCallbackArgument(), false, event.distributedMember, event.isGenerateCallbacks());
                e.setContext(event.getContext());
            } else {
                e = new EntryEventImpl(region, entryOp, entryKey, null, event.getCallbackArgument(), false, region.getMyId(), event.isGenerateCallbacks());
            }
        } else {
            e = new EntryEventImpl(region, entryOp, entryKey, null, null, false, region.getMyId(), true);
        }
        e.removeAllOp = op;
        return e;
    }

    public boolean isBulkOpInProgress() {
        return this.getPutAllOperation() != null || this.getRemoveAllOperation() != null;
    }

    public DistributedPutAllOperation getPutAllOperation() {
        return this.putAllOp;
    }

    public DistributedPutAllOperation setPutAllOperation(DistributedPutAllOperation nv) {
        DistributedPutAllOperation result = this.putAllOp;
        if (nv != null && nv.getBaseEvent() != null) {
            this.setCallbackArgument(nv.getBaseEvent().getCallbackArgument());
        }
        this.putAllOp = nv;
        return result;
    }

    public DistributedRemoveAllOperation getRemoveAllOperation() {
        return this.removeAllOp;
    }

    public DistributedRemoveAllOperation setRemoveAllOperation(DistributedRemoveAllOperation nv) {
        DistributedRemoveAllOperation result = this.removeAllOp;
        if (nv != null && nv.getBaseEvent() != null) {
            this.setCallbackArgument(nv.getBaseEvent().getCallbackArgument());
        }
        this.removeAllOp = nv;
        return result;
    }

    private final boolean testEventFlag(short mask) {
        return EventFlags.isSet(this.eventFlags, mask);
    }

    private final void setEventFlag(short mask, boolean on) {
        this.eventFlags = EventFlags.set(this.eventFlags, mask, on);
    }

    @Override
    public DistributedMember getDistributedMember() {
        return this.distributedMember;
    }

    public void setOriginRemote(boolean b) {
        this.setEventFlag((short)1, b);
    }

    public void setLocalInvalid(boolean b) {
        this.setEventFlag((short)2, b);
    }

    void setGenerateCallbacks(boolean b) {
        this.setEventFlag((short)4, b);
    }

    public void setInvokePRCallbacks(boolean b) {
        this.setEventFlag((short)16, b);
    }

    public boolean getInvokePRCallbacks() {
        return this.testEventFlag((short)16);
    }

    public boolean getInhibitDistribution() {
        return this.testEventFlag((short)4096);
    }

    public void setInhibitDistribution(boolean b) {
        this.setEventFlag((short)4096, b);
    }

    public boolean getIsRedestroyedEntry() {
        return this.testEventFlag((short)8192);
    }

    public void setIsRedestroyedEntry(boolean b) {
        this.setEventFlag((short)8192, b);
    }

    public void isConcurrencyConflict(boolean b) {
        this.setEventFlag((short)32, b);
    }

    public boolean isConcurrencyConflict() {
        return this.testEventFlag((short)32);
    }

    public void setCausedByMessage(DistributionMessage msg) {
        this.causedByMessage = msg;
    }

    public PartitionMessage getPartitionMessage() {
        if (this.causedByMessage != null && this.causedByMessage instanceof PartitionMessage) {
            return (PartitionMessage)this.causedByMessage;
        }
        return null;
    }

    public RemoteOperationMessage getRemoteOperationMessage() {
        if (this.causedByMessage != null && this.causedByMessage instanceof RemoteOperationMessage) {
            return (RemoteOperationMessage)this.causedByMessage;
        }
        return null;
    }

    @Override
    public boolean isLocalLoad() {
        return this.op.isLocalLoad();
    }

    @Override
    public boolean isNetSearch() {
        return this.op.isNetSearch();
    }

    @Override
    public boolean isNetLoad() {
        return this.op.isNetLoad();
    }

    @Override
    public boolean isDistributed() {
        return this.op.isDistributed();
    }

    @Override
    public boolean isExpiration() {
        return this.op.isExpiration();
    }

    public boolean isEviction() {
        return this.op.isEviction();
    }

    public final boolean isPendingSecondaryExpireDestroy() {
        return this.isPendingSecondaryExpireDestroy;
    }

    public final void setPendingSecondaryExpireDestroy(boolean value2) {
        this.isPendingSecondaryExpireDestroy = value2;
    }

    @Override
    public boolean isOriginRemote() {
        return this.testEventFlag((short)1);
    }

    public boolean isFromWANAndVersioned() {
        return this.versionTag != null && this.versionTag.isGatewayTag();
    }

    public boolean isFromBridgeAndVersioned() {
        return this.context != null && this.versionTag != null;
    }

    @Override
    public boolean isGenerateCallbacks() {
        return this.testEventFlag((short)4);
    }

    public void setNewEventId(DistributedSystem sys) {
        Assert.assertTrue(this.eventID == null, "Double setting event id");
        EventID newID = new EventID(sys);
        if (this.eventID != null && logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
            logger.trace(LogMarker.BRIDGE_SERVER, "Replacing event ID with {} in event {}", newID, this);
        }
        this.eventID = newID;
    }

    public void reserveNewEventId(DistributedSystem sys, int count) {
        Assert.assertTrue(this.eventID == null, "Double setting event id");
        this.eventID = new EventID(sys);
        if (count > 1) {
            this.eventID.reserveSequenceId(count - 1);
        }
    }

    public void setEventId(EventID id) {
        this.eventID = id;
    }

    @Override
    public final EventID getEventId() {
        return this.eventID;
    }

    @Override
    public boolean isBridgeEvent() {
        return this.hasClientOrigin();
    }

    @Override
    public boolean hasClientOrigin() {
        return this.getContext() != null;
    }

    public void setContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.context = contx;
    }

    @Override
    public ClientProxyMembershipID getContext() {
        return this.context;
    }

    boolean isLocalInvalid() {
        return this.testEventFlag((short)2);
    }

    public Object getKey() {
        return this.keyInfo.getKey();
    }

    public Object getOldValue() {
        try {
            if (this.isOriginRemote() && this.region.isProxy()) {
                return null;
            }
            Object ov = this.basicGetOldValue();
            if (ov == null) {
                return null;
            }
            if (ov == Token.NOT_AVAILABLE) {
                return AbstractRegion.handleNotAvailable(ov);
            }
            boolean doCopyOnRead = this.getRegion().isCopyOnRead();
            if (ov != null) {
                if (ov instanceof CachedDeserializable) {
                    CachedDeserializable cd2 = (CachedDeserializable)ov;
                    if (doCopyOnRead) {
                        return cd2.getDeserializedWritableCopy(this.region, this.re);
                    }
                    return cd2.getDeserializedValue(this.region, this.re);
                }
                if (doCopyOnRead) {
                    return CopyHelper.copy(ov);
                }
                return ov;
            }
            return null;
        }
        catch (IllegalArgumentException i) {
            IllegalArgumentException iae = new IllegalArgumentException(LocalizedStrings.DONT_RELEASE.toLocalizedString("Error while deserializing value for key=" + this.getKey()));
            iae.initCause(i);
            throw iae;
        }
    }

    public Object getRawNewValue() {
        if (this.delta != null) {
            return this.delta;
        }
        return this.basicGetNewValue();
    }

    private void basicSetNewValue(Object v) {
        if (v == this.newValue) {
            return;
        }
        this.newValue = v;
        this.cachedSerializedNewValue = null;
    }

    protected Object basicGetNewValue() {
        Object result = this.newValue;
        return result;
    }

    private void basicSetOldValue(Object v, boolean incRefCount) {
        if (v == this.oldValue) {
            return;
        }
        this.oldValue = v;
    }

    private Object basicGetOldValue() {
        Object result = this.oldValue;
        return result;
    }

    public Object getRawOldValue() {
        return this.basicGetOldValue();
    }

    public Object getNewValueForSize() {
        this.applyDelta(false);
        return this.basicGetNewValue();
    }

    protected boolean isRegionCopyOnRead() {
        return this.getRegion().isCopyOnRead();
    }

    public Object getNewValue() {
        boolean doCopyOnRead = this.getRegion().isCopyOnRead();
        try {
            if (this.applyDelta(true)) {
                Object applied = this.basicGetNewValue();
                if (applied == this.oldValue && doCopyOnRead) {
                    applied = CopyHelper.copy(applied);
                }
                return applied;
            }
        }
        catch (EntryNotFoundException ex) {
            throw new AssertionError((Object)"too early to call getNewValue");
        }
        Object nv = this.basicGetNewValue();
        if (nv != null) {
            if (nv == Token.NOT_AVAILABLE) {
                return AbstractRegion.handleNotAvailable(nv);
            }
            if (nv instanceof CachedDeserializable) {
                CachedDeserializable cd2 = (CachedDeserializable)nv;
                Object v = null;
                v = doCopyOnRead ? cd2.getDeserializedWritableCopy(this.region, this.re) : cd2.getDeserializedValue(this.region, this.re);
                assert (!(v instanceof CachedDeserializable)) : "for key " + this.getKey() + " found nested CachedDeserializable";
                return v;
            }
            if (doCopyOnRead) {
                return CopyHelper.copy(nv);
            }
            return nv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyDelta(boolean throwOnNullOldValue) throws EntryNotFoundException {
        if (this.newValue != null || this.delta == null) {
            return false;
        }
        if (this.oldValue == null) {
            if (throwOnNullOldValue) {
                throw new EntryNotFoundException("Cannot apply a delta without an existing value");
            }
            return false;
        }
        LocalRegion originalRegion = this.region;
        try {
            if (originalRegion instanceof BucketRegion) {
                this.region = ((BucketRegion)this.region).getPartitionedRegion();
            }
            this.basicSetNewValue(this.delta.apply(this));
        }
        finally {
            this.region = originalRegion;
        }
        return true;
    }

    public void setNewValue(Object obj) {
        if (obj instanceof com.gemstone.gemfire.internal.cache.delta.Delta) {
            this.delta = (com.gemstone.gemfire.internal.cache.delta.Delta)obj;
            this.basicSetNewValue(null);
        } else {
            this.basicSetNewValue(obj);
        }
    }

    @Override
    public TransactionId getTransactionId() {
        return this.txId;
    }

    public void setTransactionId(TransactionId txId) {
        this.txId = (TXId)txId;
    }

    @Override
    public boolean isLoad() {
        return this.op.isLoad();
    }

    public void setRegion(LocalRegion r) {
        this.region = r;
    }

    public final LocalRegion getRegion() {
        return this.region;
    }

    @Override
    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation op) {
        this.op = op;
        PartitionMessage prm = this.getPartitionMessage();
        if (prm != null) {
            prm.setOperation(this.op);
        }
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.keyInfo.getCallbackArg();
        while (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        if (result == Token.NOT_AVAILABLE) {
            result = AbstractRegion.handleNotAvailable(result);
        }
        return result;
    }

    @Override
    public boolean isCallbackArgumentAvailable() {
        return this.getRawCallbackArgument() != Token.NOT_AVAILABLE;
    }

    public Object getRawCallbackArgument() {
        return this.keyInfo.getCallbackArg();
    }

    public void setRawCallbackArgument(Object newCallbackArgument) {
        this.keyInfo.setCallbackArg(newCallbackArgument);
    }

    public void setCallbackArgument(Object newCallbackArgument) {
        if (this.keyInfo.getCallbackArg() instanceof WrappedCallbackArgument) {
            ((WrappedCallbackArgument)this.keyInfo.getCallbackArg()).setOriginalCallbackArgument(newCallbackArgument);
        } else {
            this.keyInfo.setCallbackArg(newCallbackArgument);
        }
    }

    public SerializedCacheValue<?> getSerializedNewValue() {
        Object tmp = this.basicGetNewValue();
        if (tmp instanceof CachedDeserializable) {
            byte[] bytes = this.newValueBytes;
            if (bytes == null) {
                bytes = this.cachedSerializedNewValue;
            }
            return new SerializedCacheValueImpl(this.getRegion(), this.re, (CachedDeserializable)tmp, bytes);
        }
        return null;
    }

    public void makeSerializedNewValue() {
        this.makeSerializedNewValue(false);
    }

    private void makeSerializedNewValue(boolean isSynced) {
        Object obj = this.newValue;
        if (isSynced) {
            this.setSerializationDeferred(false);
        } else if (obj == null && this.delta != null) {
            this.setSerializationDeferred(true);
            return;
        }
        this.basicSetNewValue(EntryEventImpl.getCachedDeserializable(obj, this));
    }

    public static Object getCachedDeserializable(Object obj) {
        return EntryEventImpl.getCachedDeserializable(obj, null);
    }

    public static Object getCachedDeserializable(Object obj, EntryEventImpl ev) {
        CachedDeserializable cd2;
        if (obj instanceof byte[] || obj == null || obj instanceof CachedDeserializable || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj) || obj instanceof Delta || obj instanceof com.gemstone.gemfire.internal.cache.delta.Delta) {
            return obj;
        }
        if (obj instanceof byte[][]) {
            int objSize = 12;
            for (byte[] bytes : (byte[][])obj) {
                if (bytes != null) {
                    objSize += CachedDeserializableFactory.getByteSize(bytes);
                    continue;
                }
                objSize += 8;
            }
            cd2 = CachedDeserializableFactory.create(obj, objSize);
        } else {
            byte[] b = EntryEventImpl.serialize(obj);
            cd2 = CachedDeserializableFactory.create(b);
            if (ev != null) {
                ev.newValueBytes = b;
                ev.cachedSerializedNewValue = b;
            }
        }
        return cd2;
    }

    public void setCachedSerializedNewValue(byte[] v) {
        this.cachedSerializedNewValue = v;
    }

    public byte[] getCachedSerializedNewValue() {
        return this.cachedSerializedNewValue;
    }

    public void setSerializedNewValue(byte[] serializedValue) {
        this.newValueBytes = serializedValue;
        this.basicSetNewValue(CachedDeserializableFactory.create(serializedValue));
        this.cachedSerializedNewValue = serializedValue;
    }

    public void setSerializedOldValue(byte[] serializedOldValue) {
        this.oldValueBytes = serializedOldValue;
        this.basicSetOldValue(CachedDeserializableFactory.create(serializedOldValue), true);
    }

    void putExistingEntry(LocalRegion owner, RegionEntry entry) throws RegionClearedException {
        this.putExistingEntry(owner, entry, false, null);
    }

    void putExistingEntry(LocalRegion owner, RegionEntry reentry, boolean requireOldValue, Object oldValueForDelta) throws RegionClearedException {
        this.makeUpdate();
        if (this.oldValue == null && !reentry.isInvalidOrRemoved()) {
            if (requireOldValue || EVENT_OLD_VALUE || this.region instanceof HARegion) {
                Object ov = reentry._getValueUse(owner, true);
                if (ov == null) {
                    ov = Token.NOT_AVAILABLE;
                }
                this.basicSetOldValue(ov, false);
            } else {
                this.basicSetOldValue(Token.NOT_AVAILABLE, true);
            }
        }
        if (this.oldValue == Token.NOT_AVAILABLE) {
            FilterProfile fp = this.region.getFilterProfile();
            if (this.op.guaranteesOldValue() || fp != null && fp.entryRequiresOldValue(this.getKey())) {
                this.setOldValueForQueryProcessing();
            }
        }
        this.setNewValueInRegion(owner, reentry, oldValueForDelta);
    }

    void makeUpdate() {
        this.setOperation(this.op.getCorrespondingUpdateOp());
    }

    void makeCreate() {
        this.setOperation(this.op.getCorrespondingCreateOp());
    }

    void putNewEntry(LocalRegion owner, RegionEntry reentry) throws RegionClearedException {
        if (!this.op.guaranteesOldValue()) {
            this.basicSetOldValue(null, true);
        }
        this.makeCreate();
        this.setNewValueInRegion(owner, reentry, null);
    }

    void setRegionEntry(RegionEntry re) {
        this.re = re;
    }

    RegionEntry getRegionEntry() {
        return this.re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewValueInRegion(LocalRegion owner, RegionEntry reentry, Object oldValueForDelta) throws RegionClearedException {
        IndexUpdater indexUpdater;
        IndexManager idxManager;
        boolean isTombstone;
        boolean wasTombstone = reentry.isTombstone();
        if (this.applyDelta(this.op.isCreate()) && this.isSerializationDeferred()) {
            this.makeSerializedNewValue(true);
        }
        if (this.deltaBytes != null && this.newValue == null) {
            this.processDeltaBytes(oldValueForDelta);
        }
        if (owner != null) {
            owner.generateAndSetVersionTag(this, reentry);
        } else {
            this.region.generateAndSetVersionTag(this, reentry);
        }
        Object v = this.newValue;
        if (v == null) {
            v = this.isLocalInvalid() ? Token.LOCAL_INVALID : Token.INVALID;
        } else {
            this.region.regionInvalid = false;
        }
        reentry.setValueResultOfSearch(this.op.isNetSearch());
        if (v instanceof Delta && this.region.isUsedForPartitionedRegionBucket()) {
            Object ov = this.basicGetOldValue();
            int vSize = ov instanceof CachedDeserializable && !GemFireCacheImpl.DELTAS_RECALCULATE_SIZE ? ((CachedDeserializable)ov).getValueSizeInBytes() : CachedDeserializableFactory.calcMemSize(v, this.region.getObjectSizer(), false);
            v = CachedDeserializableFactory.create(v, vSize);
            this.basicSetNewValue(v);
        }
        v = AbstractRegionMap.prepareValueForCache(this.region, v, this);
        this.setNewValueBucketSize(owner, v);
        boolean bl = isTombstone = v == Token.TOMBSTONE;
        if ((this.op.isUpdate() && !reentry.isInvalid() || this.op.isInvalidate()) && (idxManager = IndexUtils.getIndexManager(this.region, false)) != null) {
            try {
                idxManager.updateIndexes(reentry, 3, this.op.isUpdate() ? 1 : 0);
            }
            catch (QueryException e) {
                throw new IndexMaintenanceException(e);
            }
        }
        if ((indexUpdater = this.region.getIndexUpdater()) != null) {
            boolean success = false;
            LocalRegion indexRegion = owner != null ? owner : this.region;
            try {
                indexUpdater.onEvent(indexRegion, this, reentry);
                reentry.setValueWithTombstoneCheck(v, this);
                success = true;
            }
            finally {
                indexUpdater.postEvent(indexRegion, this, reentry, success);
            }
        } else {
            reentry.setValueWithTombstoneCheck(v, this);
        }
        if (logger.isTraceEnabled()) {
            if (v instanceof CachedDeserializable) {
                logger.trace("EntryEventImpl.setNewValueInRegion: put CachedDeserializable({},{})", this.getKey(), ((CachedDeserializable)v).getStringForm());
            } else {
                logger.trace("EntryEventImpl.setNewValueInRegion: put({},{})", this.getKey(), StringUtils.forceToString(v));
            }
        }
        if (!isTombstone && wasTombstone) {
            owner.unscheduleTombstone(reentry);
        }
    }

    public int getNewValueBucketSize() {
        return this.newValueBucketSize;
    }

    private void setNewValueBucketSize(LocalRegion lr, Object v) {
        if (lr == null) {
            lr = this.region;
        }
        this.newValueBucketSize = lr.calculateValueSize(v);
    }

    private void processDeltaBytes(Object oldValueInVM) {
        if (!this.region.hasSeenEvent(this)) {
            if (oldValueInVM == null || Token.isInvalidOrRemoved(oldValueInVM)) {
                this.region.getCachePerfStats().incDeltaFailedUpdates();
                throw new InvalidDeltaException("Old value not found for key " + this.keyInfo.getKey());
            }
            FilterProfile fp = this.region.getFilterProfile();
            boolean copy = this.region.getCompressor() == null && (this.region.isCopyOnRead() || this.region.getCloningEnabled() || fp != null && fp.getCqCount() > 0);
            Object value2 = oldValueInVM;
            boolean wasCD = false;
            if (value2 instanceof CachedDeserializable) {
                wasCD = true;
                value2 = copy ? ((CachedDeserializable)value2).getDeserializedWritableCopy(this.region, this.re) : ((CachedDeserializable)value2).getDeserializedValue(this.region, this.re);
            } else if (copy) {
                value2 = CopyHelper.copy(value2);
            }
            boolean deltaBytesApplied = false;
            try {
                long start = CachePerfStats.getStatTime();
                ((Delta)value2).fromDelta(new DataInputStream(new ByteArrayInputStream(this.getDeltaBytes())));
                this.region.getCachePerfStats().endDeltaUpdate(start);
                deltaBytesApplied = true;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                throw new DeltaSerializationException("Exception while deserializing delta bytes.", t);
            }
            finally {
                if (!deltaBytesApplied) {
                    this.region.getCachePerfStats().incDeltaFailedUpdates();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Delta has been applied for key {}", this.getKey());
            }
            if (wasCD) {
                CachedDeserializable old = (CachedDeserializable)oldValueInVM;
                int valueSize = GemFireCacheImpl.DELTAS_RECALCULATE_SIZE ? CachedDeserializableFactory.calcMemSize(value2, this.region.getObjectSizer(), false) : old.getValueSizeInBytes();
                value2 = CachedDeserializableFactory.create(value2, valueSize);
            }
            this.setNewValue(value2);
            if (this.causedByMessage != null && this.causedByMessage instanceof PutMessage) {
                ((PutMessage)this.causedByMessage).setDeltaValObj(value2);
            }
        } else {
            this.region.getCachePerfStats().incDeltaFailedUpdates();
            throw new InvalidDeltaException("Cache encountered replay of event containing delta bytes for key " + this.keyInfo.getKey());
        }
    }

    void setTXEntryOldValue(Object oldVal, boolean mustBeAvailable) {
        if (Token.isInvalidOrRemoved(oldVal) || oldVal == null) {
            this.basicSetOldValue(null, true);
        } else if (mustBeAvailable) {
            this.basicSetOldValue(oldVal, true);
        } else if (EVENT_OLD_VALUE) {
            this.basicSetOldValue(oldVal, true);
        } else {
            this.basicSetOldValue(Token.NOT_AVAILABLE, true);
        }
    }

    void putValueTXEntry(TXEntryState tx) {
        Object v = this.basicGetNewValue();
        if (v == null) {
            if (this.deltaBytes != null) {
                this.processDeltaBytes(tx.getNearSidePendingValue());
                v = this.basicGetNewValue();
            } else if (this.delta != null) {
                v = this.delta;
            } else {
                Object object = v = this.isLocalInvalid() ? Token.LOCAL_INVALID : Token.INVALID;
            }
        }
        if (this.op != Operation.LOCAL_INVALIDATE && this.op != Operation.LOCAL_DESTROY) {
            tx.setPendingValue(v);
        }
        tx.setCallbackArgument(this.getCallbackArgument());
    }

    public boolean setOldValueFromRegion() {
        try {
            RegionEntry re = this.region.getRegionEntry(this.getKey());
            if (re == null) {
                return false;
            }
            Object v = re._getValueUse(this.region, true);
            return this.setOldValue(v);
        }
        catch (EntryNotFoundException ex) {
            return false;
        }
    }

    boolean oldValueIsDestroyedToken() {
        return this.oldValue == Token.DESTROYED || this.oldValue == Token.TOMBSTONE;
    }

    void setOldValueDestroyedToken() {
        this.basicSetOldValue(Token.DESTROYED, true);
    }

    public boolean setOldValue(Object v) {
        return this.setOldValue(v, false);
    }

    public boolean setOldValue(Object v, boolean force) {
        if (v == null || Token.isRemoved(v)) {
            return false;
        }
        if (Token.isInvalid(v)) {
            this.basicSetOldValue(null, true);
        } else if (force || this.region instanceof HARegion) {
            this.basicSetOldValue(v, true);
        } else if (EVENT_OLD_VALUE) {
            this.basicSetOldValue(v, true);
        } else {
            this.basicSetOldValue(Token.NOT_AVAILABLE, true);
        }
        return true;
    }

    public void setConcurrentMapOldValue(Object v) {
        if (Token.isRemoved(v)) {
            return;
        }
        if (Token.isInvalid(v)) {
            this.basicSetOldValue(null, true);
        } else {
            this.basicSetOldValue(v, true);
        }
    }

    public boolean hasNewValue() {
        Object tmp = this.newValue;
        if (tmp == null && this.delta != null) {
            return true;
        }
        return tmp != null && tmp != Token.NOT_AVAILABLE;
    }

    public final boolean hasOldValue() {
        return this.oldValue != null && this.basicGetOldValue() != Token.NOT_AVAILABLE;
    }

    public boolean hasDelta() {
        return this.delta != null;
    }

    @Override
    public boolean isOldValueAvailable() {
        if (this.isOriginRemote() && this.region.isProxy()) {
            return false;
        }
        return this.basicGetOldValue() != Token.NOT_AVAILABLE;
    }

    public void oldValueNotAvailable() {
        this.basicSetOldValue(Token.NOT_AVAILABLE, true);
    }

    public static Object deserialize(byte[] bytes) {
        return EntryEventImpl.deserialize(bytes, null, null);
    }

    public static Object deserialize(byte[] bytes, Version version, ByteArrayDataInput in) {
        if (bytes == null) {
            return null;
        }
        try {
            return BlobHelper.deserializeBlob(bytes, version, in);
        }
        catch (IOException e) {
            throw new SerializationException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_DESERIALIZING.toLocalizedString(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(LocalizedStrings.EntryEventImpl_A_CLASSNOTFOUNDEXCEPTION_WAS_THROWN_WHILE_TRYING_TO_DESERIALIZE_CACHED_VALUE.toLocalizedString(), e);
        }
    }

    public static byte[] serialize(Object obj) {
        return EntryEventImpl.serialize(obj, null);
    }

    public static byte[] serialize(Object obj, Version version) {
        if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
            throw new IllegalArgumentException(LocalizedStrings.EntryEventImpl_MUST_NOT_SERIALIZE_0_IN_THIS_CONTEXT.toLocalizedString(obj));
        }
        try {
            return BlobHelper.serializeToBlob(obj, version);
        }
        catch (IOException e) {
            throw new SerializationException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString(), e);
        }
    }

    public static void fillSerializedValue(BytesAndBitsForCompactor wrapper, Object obj, byte userBits) {
        if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
            throw new IllegalArgumentException(LocalizedStrings.EntryEvents_MUST_NOT_SERIALIZE_0_IN_THIS_CONTEXT.toLocalizedString(obj));
        }
        try {
            HeapDataOutputStream hdos = null;
            hdos = wrapper.getBytes().length < 32 ? new HeapDataOutputStream(Version.CURRENT) : new HeapDataOutputStream(wrapper.getBytes());
            DataSerializer.writeObject(obj, hdos);
            hdos.sendTo(wrapper, userBits);
        }
        catch (IOException e) {
            IllegalArgumentException e2 = new IllegalArgumentException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString());
            e2.initCause(e);
            throw e2;
        }
    }

    String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getShortClassName());
        buf.append("[");
        buf.append("op=");
        buf.append(this.getOperation());
        buf.append(";key=");
        buf.append(this.getKey());
        buf.append(";oldValue=");
        buf.append(this.basicGetOldValue());
        buf.append(";newValue=");
        buf.append(this.basicGetNewValue());
        buf.append(";callbackArg=");
        buf.append(this.getRawCallbackArgument());
        buf.append(";originRemote=");
        buf.append(this.isOriginRemote());
        buf.append(";originMember=");
        buf.append(this.getDistributedMember());
        if (this.isPossibleDuplicate()) {
            buf.append(";posDup");
        }
        if (this.callbacksInvoked()) {
            buf.append(";callbacksInvoked");
        }
        if (this.versionTag != null) {
            buf.append(";version=").append(this.versionTag);
        }
        if (this.getContext() != null) {
            buf.append(";context=");
            buf.append(this.getContext());
        }
        if (this.eventID != null) {
            buf.append(";id=");
            buf.append(this.eventID);
        }
        if (this.deltaBytes != null) {
            buf.append(";[" + this.deltaBytes.length + " deltaBytes]");
        }
        if (this.filterInfo != null) {
            buf.append(";routing=");
            buf.append(this.filterInfo);
        }
        if (this.isFromServer()) {
            buf.append(";isFromServer");
        }
        if (this.isConcurrencyConflict()) {
            buf.append(";isInConflict");
        }
        if (this.getInhibitDistribution()) {
            buf.append(";inhibitDistribution");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int getDSFID() {
        return 105;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.eventID, out);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeObject(this.keyInfo.getValue(), out);
        out.writeByte(this.op.ordinal);
        out.writeShort(this.eventFlags & 0xFFFFC03F);
        DataSerializer.writeObject(this.getRawCallbackArgument(), out);
        DataSerializer.writeObject(this.txId, out);
        boolean isDelta = this.delta != null;
        out.writeBoolean(isDelta);
        if (isDelta) {
            DataSerializer.writeObject(this.delta, out);
        } else {
            Object nv = this.basicGetNewValue();
            boolean newValueSerialized = nv instanceof CachedDeserializable;
            out.writeBoolean(newValueSerialized);
            if (newValueSerialized) {
                if (this.newValueBytes != null) {
                    DataSerializer.writeByteArray(this.newValueBytes, out);
                } else if (this.cachedSerializedNewValue != null) {
                    DataSerializer.writeByteArray(this.cachedSerializedNewValue, out);
                } else {
                    CachedDeserializable cd2 = (CachedDeserializable)nv;
                    DataSerializer.writeObjectAsByteArray(cd2.getValue(), out);
                }
            } else {
                DataSerializer.writeObject(nv, out);
            }
        }
        Object ov = this.basicGetOldValue();
        boolean oldValueSerialized = ov instanceof CachedDeserializable;
        out.writeBoolean(oldValueSerialized);
        if (oldValueSerialized) {
            if (this.oldValueBytes != null) {
                DataSerializer.writeByteArray(this.oldValueBytes, out);
            } else {
                CachedDeserializable cd3 = (CachedDeserializable)ov;
                DataSerializer.writeObjectAsByteArray(cd3.getValue(), out);
            }
        } else {
            DataSerializer.writeObject(ov, out);
        }
        InternalDataSerializer.invokeToData((InternalDistributedMember)this.distributedMember, out);
        DataSerializer.writeObject(this.getContext(), out);
        DataSerializer.writeLong(this.tailKey, out);
    }

    public SerializedCacheValue<?> getSerializedOldValue() {
        Object tmp = this.basicGetOldValue();
        if (tmp instanceof CachedDeserializable) {
            return new SerializedCacheValueImpl(this.region, this.re, (CachedDeserializable)tmp, this.oldValueBytes);
        }
        return null;
    }

    public int getNewValSizeForPR() {
        int newSize = 0;
        this.applyDelta(false);
        Object v = this.basicGetNewValue();
        if (v != null) {
            try {
                newSize = CachedDeserializableFactory.calcSerializedSize(v) + CachedDeserializableFactory.overhead();
            }
            catch (IllegalArgumentException iae) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.EntryEventImpl_DATASTORE_FAILED_TO_CALCULATE_SIZE_OF_NEW_VALUE), (Throwable)iae);
                newSize = 0;
            }
        }
        return newSize;
    }

    public int getOldValSize() {
        int oldSize = 0;
        if (this.hasOldValue()) {
            try {
                oldSize = CachedDeserializableFactory.calcMemSize(this.basicGetOldValue());
            }
            catch (IllegalArgumentException iae) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.EntryEventImpl_DATASTORE_FAILED_TO_CALCULATE_SIZE_OF_OLD_VALUE), (Throwable)iae);
                oldSize = 0;
            }
        }
        return oldSize;
    }

    @Override
    public EnumListenerEvent getEventType() {
        return this.eventType;
    }

    @Override
    public void setEventType(EnumListenerEvent eventType) {
        this.eventType = eventType;
    }

    public void callbacksInvoked(boolean dispatched) {
        this.setEventFlag((short)128, dispatched);
    }

    public boolean callbacksInvoked() {
        return this.testEventFlag((short)128);
    }

    public void inhibitCacheListenerNotification(boolean inhibit) {
        this.setEventFlag((short)64, inhibit);
    }

    public boolean inhibitCacheListenerNotification() {
        return this.testEventFlag((short)64);
    }

    void invokeCallbacks(LocalRegion rgn, boolean skipListeners, boolean notifyGateways) {
        if (!this.callbacksInvoked()) {
            this.callbacksInvoked(true);
            if (this.op.isUpdate()) {
                rgn.invokePutCallbacks(EnumListenerEvent.AFTER_UPDATE, this, !skipListeners, notifyGateways);
            } else if (this.op.isCreate()) {
                rgn.invokePutCallbacks(EnumListenerEvent.AFTER_CREATE, this, !skipListeners, notifyGateways);
            } else if (this.op.isDestroy()) {
                rgn.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, this, !skipListeners, notifyGateways);
            } else if (this.op.isInvalidate()) {
                rgn.invokeInvalidateCallbacks(EnumListenerEvent.AFTER_INVALIDATE, this, !skipListeners);
            }
        }
    }

    private void setFromRILocalDestroy(boolean on) {
        this.setEventFlag((short)2048, on);
    }

    public boolean isFromRILocalDestroy() {
        return this.testEventFlag((short)2048);
    }

    public boolean isFromServer() {
        return this.testEventFlag((short)1024);
    }

    public void setFromServer(boolean v) {
        this.setEventFlag((short)1024, v);
    }

    public boolean isPossibleDuplicate() {
        return this.testEventFlag((short)8);
    }

    public void setPossibleDuplicate(boolean possibleDuplicate) {
        this.setEventFlag((short)8, possibleDuplicate);
    }

    public boolean inhibitAllNotifications() {
        return this.testEventFlag((short)16384);
    }

    public void setInhibitAllNotifications(boolean inhibit) {
        this.setEventFlag((short)16384, inhibit);
    }

    @Override
    public void setLocalFilterInfo(FilterRoutingInfo.FilterInfo info) {
        this.filterInfo = info;
    }

    @Override
    public FilterRoutingInfo.FilterInfo getLocalFilterInfo() {
        return this.filterInfo;
    }

    public LocalRegion getLocalRegion() {
        return this.region;
    }

    public byte[] getDeltaBytes() {
        return this.deltaBytes;
    }

    public void setDeltaBytes(byte[] deltaBytes) {
        this.deltaBytes = deltaBytes;
    }

    public boolean isCreate() {
        return this.testEventFlag((short)256);
    }

    public EntryEventImpl setCreate(boolean isCreate) {
        this.setEventFlag((short)256, isCreate);
        return this;
    }

    public final void setContextObject(Object ctx) {
        this.contextObj = ctx;
    }

    public final Object getContextObject() {
        return this.contextObj;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public void setOldValueForQueryProcessing() {
        Object v;
        RegionEntry reentry = this.region.entries.getEntry(this.getKey());
        if (reentry != null && !((v = reentry.getValueOffHeapOrDiskWithoutFaultIn(this.region)) instanceof Token)) {
            this.basicSetOldValue(v, false);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public void setVersionTag(VersionTag versionTag) {
        this.versionTag = versionTag;
    }

    @Override
    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    public long getEventTime(long suggestedTime) {
        long result = suggestedTime;
        if (this.versionTag != null) {
            if (suggestedTime != 0L) {
                this.versionTag.setVersionTimeStamp(suggestedTime);
            } else {
                result = this.versionTag.getVersionTimeStamp();
            }
        }
        if (result <= 0L) {
            LocalRegion region = this.getLocalRegion();
            result = region != null ? region.cacheTimeMillis() : System.currentTimeMillis();
        }
        return result;
    }

    public void setTailKey(Long tailKey) {
        this.tailKey = tailKey;
    }

    public Long getTailKey() {
        return this.tailKey;
    }

    public void setCallbacksInvokedByCurrentThread() {
        this.invokeCallbacksThread = Thread.currentThread();
    }

    public boolean getCallbacksInvokedByCurrentThread() {
        if (this.invokeCallbacksThread == null) {
            return false;
        }
        return Thread.currentThread().equals(this.invokeCallbacksThread);
    }

    public boolean isOnPdxTypeRegion() {
        return "/PdxTypes".equals(this.region.getFullPath());
    }

    public boolean noVersionReceivedFromServer() {
        return this.versionTag == null && this.region.concurrencyChecksEnabled && this.region.getServerProxy() != null && !this.op.isLocal() && !this.isOriginRemote();
    }

    public TimestampedEntryEvent getTimestampedEvent(int newDSID, int oldDSID, long newTimestamp, long oldTimestamp) {
        return new TimestampedEntryEventImpl(this, newDSID, oldDSID, newTimestamp, oldTimestamp);
    }

    private void setSerializationDeferred(boolean serializationDeferred) {
        this.setEventFlag((short)512, serializationDeferred);
    }

    private boolean isSerializationDeferred() {
        return this.testEventFlag((short)512);
    }

    public boolean isSingleHop() {
        return this.causedByMessage != null && this.causedByMessage instanceof RemoteOperationMessage;
    }

    public boolean isSingleHopPutOp() {
        return this.causedByMessage != null && this.causedByMessage instanceof RemotePutMessage;
    }

    public static class SerializedCacheValueImpl
    implements SerializedCacheValue,
    CachedDeserializable,
    InternalDataSerializer.Sendable {
        private final CachedDeserializable cd;
        private final Region r;
        private final RegionEntry re;
        private final byte[] serializedValue;

        SerializedCacheValueImpl(Region r, RegionEntry re, CachedDeserializable cd2, byte[] serializedBytes) {
            this.r = r;
            this.re = re;
            this.cd = cd2;
            this.serializedValue = serializedBytes;
        }

        @Override
        public byte[] getSerializedValue() {
            if (this.serializedValue != null) {
                return this.serializedValue;
            }
            return this.cd.getSerializedValue();
        }

        public Object getDeserializedValue() {
            return this.getDeserializedValue(this.r, this.re);
        }

        @Override
        public Object getDeserializedForReading() {
            return this.cd.getDeserializedForReading();
        }

        @Override
        public Object getDeserializedWritableCopy(Region rgn, RegionEntry entry) {
            return this.cd.getDeserializedWritableCopy(rgn, entry);
        }

        @Override
        public Object getDeserializedValue(Region rgn, RegionEntry reentry) {
            return this.cd.getDeserializedValue(rgn, reentry);
        }

        @Override
        public Object getValue() {
            if (this.serializedValue != null) {
                return this.serializedValue;
            }
            return this.cd.getValue();
        }

        @Override
        public void writeValueAsByteArray(DataOutput out) throws IOException {
            if (this.serializedValue != null) {
                DataSerializer.writeByteArray(this.serializedValue, out);
            } else {
                this.cd.writeValueAsByteArray(out);
            }
        }

        @Override
        public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
            if (this.serializedValue != null) {
                wrapper.setData(this.serializedValue, userBits, this.serializedValue.length, false);
            } else {
                this.cd.fillSerializedValue(wrapper, userBits);
            }
        }

        @Override
        public int getValueSizeInBytes() {
            return this.cd.getValueSizeInBytes();
        }

        @Override
        public int getSizeInBytes() {
            return this.cd.getSizeInBytes();
        }

        @Override
        public String getStringForm() {
            return this.cd.getStringForm();
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            DataSerializer.writeObject(this.cd, out);
        }
    }

    private static abstract class EventFlags {
        private static final short FLAG_ORIGIN_REMOTE = 1;
        private static final short FLAG_LOCAL_INVALID = 2;
        private static final short FLAG_GENERATE_CALLBACKS = 4;
        private static final short FLAG_POSSIBLE_DUPLICATE = 8;
        private static final short FLAG_INVOKE_PR_CALLBACKS = 16;
        private static final short FLAG_CONCURRENCY_CONFLICT = 32;
        private static final short FLAG_INHIBIT_LISTENER_NOTIFICATION = 64;
        private static final short FLAG_CALLBACKS_INVOKED = 128;
        private static final short FLAG_ISCREATE = 256;
        private static final short FLAG_SERIALIZATION_DEFERRED = 512;
        private static final short FLAG_FROM_SERVER = 1024;
        private static final short FLAG_FROM_RI_LOCAL_DESTROY = 2048;
        private static final short FLAG_INHIBIT_DISTRIBUTION = 4096;
        private static final short FLAG_REDESTROYED_TOMBSTONE = 8192;
        private static final short FLAG_INHIBIT_ALL_NOTIFICATIONS = 16384;
        private static final short FLAG_TRANSIENT_MASK = -16321;

        private EventFlags() {
        }

        protected static final boolean isSet(short flags, short mask) {
            return (flags & mask) != 0;
        }

        protected static final short set(short flags, short mask, boolean on) {
            return (short)(on ? flags | mask : flags & ~mask);
        }
    }
}

