/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.ValidatingDiskRegion;
import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ExportDiskRegion
extends ValidatingDiskRegion {
    private Map<Object, DiskEntry.RecoveredEntry> currentOplogEntries = new HashMap<Object, DiskEntry.RecoveredEntry>();
    private ExportWriter writer;

    public ExportDiskRegion(DiskStoreImpl ds, DiskRegionView drv, ExportWriter writer) {
        super(ds, drv);
        this.writer = writer;
    }

    @Override
    public DiskEntry initializeRecoveredEntry(Object key2, DiskEntry.RecoveredEntry re) {
        if (re.getValue() == null) {
            Assert.fail("Value should not have been null for key " + key2);
        }
        this.currentOplogEntries.put(key2, re);
        return super.initializeRecoveredEntry(key2, re);
    }

    @Override
    public DiskEntry updateRecoveredEntry(Object key2, DiskEntry.RecoveredEntry re) {
        this.currentOplogEntries.put(key2, re);
        return super.updateRecoveredEntry(key2, re);
    }

    @Override
    public void destroyRecoveredEntry(Object key2) {
        this.currentOplogEntries.remove(key2);
        super.destroyRecoveredEntry(key2);
    }

    @Override
    public void oplogRecovered(long oplogId) {
        try {
            this.writer.writeBatch(this.currentOplogEntries);
        }
        catch (IOException e) {
            throw new DiskAccessException("Error during export", (Throwable)e, this.getDiskStore());
        }
        this.currentOplogEntries.clear();
    }

    public static interface ExportWriter {
        public void writeBatch(Map<Object, DiskEntry.RecoveredEntry> var1) throws IOException;
    }
}

