/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GatewayEventCallbackArgument
extends WrappedCallbackArgument
implements DataSerializableFixedID {
    private String _originatingGatewayHubId;
    private THashSet _recipientGateways;

    public GatewayEventCallbackArgument() {
    }

    public GatewayEventCallbackArgument(Object originalCallbackArg) {
        super(originalCallbackArg);
    }

    public GatewayEventCallbackArgument(Object originalCallbackArg, String originatingGatewayHubId, List originalRecipientGateways, boolean serializeCBArg) {
        super(originalCallbackArg, serializeCBArg);
        this._originatingGatewayHubId = originatingGatewayHubId;
        this.initializeRecipientGateways(originalRecipientGateways);
    }

    public GatewayEventCallbackArgument(GatewayEventCallbackArgument geca) {
        super(geca.getOriginalCallbackArg());
        this._originatingGatewayHubId = geca._originatingGatewayHubId;
        if (geca._recipientGateways != null) {
            this._recipientGateways = (THashSet)geca._recipientGateways.clone();
        }
    }

    public void addRecipientGateway(String gatewayId) {
        this._recipientGateways.add(gatewayId);
    }

    public String getOriginatingGatewayHubId() {
        return this._originatingGatewayHubId;
    }

    public void setOriginatingGatewayHubId(String originatingGatewayHubId) {
        this._originatingGatewayHubId = originatingGatewayHubId;
    }

    public Set getRecipientGateways() {
        return this._recipientGateways;
    }

    public void initializeRecipientGateways(List originalRecipientGateways) {
        this._recipientGateways = new THashSet(2);
        Iterator i = originalRecipientGateways.iterator();
        while (i.hasNext()) {
            this._recipientGateways.add(i.next());
        }
    }

    @Override
    public int getDSFID() {
        return -56;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this._originatingGatewayHubId, out);
        if (this._recipientGateways != null) {
            out.writeInt(this._recipientGateways.size());
            for (String gateway : this._recipientGateways) {
                DataSerializer.writeString(gateway, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this._originatingGatewayHubId = DataSerializer.readString(in);
        this._recipientGateways = new THashSet(2);
        int numberOfRecipientGateways = in.readInt();
        for (int i = 0; i < numberOfRecipientGateways; ++i) {
            this._recipientGateways.add(DataSerializer.readString(in));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GatewayEventCallbackArgument [").append("originalCallbackArg=").append(this.getOriginalCallbackArg()).append(";originatingGatewayHubId=").append(this._originatingGatewayHubId).append(";recipientGateways=").append(this._recipientGateways).append("]");
        return buffer.toString();
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

