/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.GatewayEventDispatcher;
import com.gemstone.gemfire.internal.cache.GatewayImpl;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;

class GatewayEventCallbackDispatcher
implements GatewayEventDispatcher {
    private static final Logger logger = LogService.getLogger();
    protected final GatewayImpl.GatewayEventProcessor eventProcessor;
    private volatile List eventListeners = Collections.EMPTY_LIST;
    private final Object eventLock = new Object();

    protected GatewayEventCallbackDispatcher(GatewayImpl.GatewayEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
        this.initializeEventListeners();
    }

    @Override
    public boolean dispatchBatch(List events, boolean removeFromQueueOnException) {
        GatewayStats statistics = this.eventProcessor.getGateway().getStatistics();
        boolean success = false;
        try {
            long start = statistics.startTime();
            success = this.dispatchBatch(events);
            statistics.endBatch(start, events.size());
        }
        catch (GatewayException e) {
        }
        catch (CancelException e) {
            this.eventProcessor.setIsStopped(true);
            throw e;
        }
        catch (Exception e) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayEventCallbackDispatcher_STOPPING_THE_PROCESSOR_BECAUSE_THE_FOLLOWING_EXCEPTION_OCCURRED_WHILE_PROCESSING_A_BATCH), (Throwable)e);
            this.eventProcessor.setIsStopped(true);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerGatewayEventListener(GatewayEventListener listener) {
        Object object = this.eventLock;
        synchronized (object) {
            List oldListeners = this.eventListeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<GatewayEventListener> newListeners = new ArrayList<GatewayEventListener>(oldListeners);
                newListeners.add(listener);
                this.eventListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterGatewayEventListener(GatewayEventListener listener) {
        Object object = this.eventLock;
        synchronized (object) {
            ArrayList newListeners;
            List oldListeners = this.eventListeners;
            if (oldListeners.contains(listener) && (newListeners = new ArrayList(oldListeners)).remove(listener)) {
                this.eventListeners = newListeners;
            }
        }
    }

    protected void initializeEventListeners() {
        Iterator i = this.eventProcessor.getGateway().getListeners().iterator();
        while (i.hasNext()) {
            this.registerGatewayEventListener((GatewayEventListener)i.next());
        }
    }

    protected boolean dispatchBatch(List events) throws GatewayException {
        if (events.isEmpty()) {
            return true;
        }
        int batchId = this.eventProcessor.getBatchId();
        boolean successAll = true;
        try {
            for (GatewayEventListener listener : this.eventListeners) {
                boolean successOne = listener.processEvents(events);
                if (successOne) continue;
                successAll = false;
            }
        }
        catch (Exception e) {
            StringId alias = LocalizedStrings.GatewayEventCallbackDispatcher__0___EXCEPTION_DURING_PROCESSING_BATCH__1_;
            Object[] aliasArgs = new Object[]{this, batchId};
            String exMsg = alias.toLocalizedString(aliasArgs);
            GatewayException ge = new GatewayException(exMsg, e);
            logger.warn(LocalizedMessage.create(alias, aliasArgs), (Throwable)ge);
            throw ge;
        }
        return successAll;
    }
}

