/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.SerializedCacheValue;
import com.gemstone.gemfire.cache.util.GatewayEvent;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache.wan.GatewayQueueEvent;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;

public final class GatewayEventImpl
implements GatewayEvent,
GatewayQueueEvent,
DataSerializableFixedID,
Conflatable,
Sizeable {
    private static final long serialVersionUID = -5690172020872255422L;
    private static final Object TOKEN_UN_INITIALIZED = new Object();
    private static final short VERSION = 17;
    protected EnumListenerEvent _operation;
    protected EntryEventImpl _entryEvent;
    protected int _action;
    protected int _numberOfParts;
    protected EventID _id;
    private LocalRegion _region;
    protected String _regionName;
    private Object _key = TOKEN_UN_INITIALIZED;
    protected byte[] _value;
    protected byte _valueIsObject;
    protected GatewayEventCallbackArgument _callbackArgument;
    protected boolean _possibleDuplicate;
    protected long _creationTime;
    private int bucketId;
    private Long shadowKey = new Long(1L);
    private static final int CREATE_ACTION = 0;
    private static final int UPDATE_ACTION = 1;
    private static final int DESTROY_ACTION = 2;

    public GatewayEventImpl() {
    }

    public GatewayEventImpl(EnumListenerEvent operation, CacheEvent event) throws IOException {
        this(operation, event, true);
    }

    public GatewayEventImpl(EnumListenerEvent operation, CacheEvent event, boolean initialize, int bucketId) throws IOException {
        this(operation, event, true);
        this.bucketId = bucketId;
    }

    public GatewayEventImpl(EnumListenerEvent operation, CacheEvent event, boolean initialize) throws IOException {
        EntryEventImpl entryEvent;
        this._operation = operation;
        this._entryEvent = entryEvent = (EntryEventImpl)event;
        this._region = this._entryEvent.getRegion();
        this._regionName = this._region.getFullPath();
        this.initializeId();
        this._possibleDuplicate = false;
        this._creationTime = this._region.cacheTimeMillis();
        if (initialize) {
            this.initialize();
        }
    }

    public int getAction() {
        return this._action;
    }

    @Override
    public Operation getOperation() {
        Operation operation = null;
        switch (this._action) {
            case 0: {
                operation = Operation.CREATE;
                break;
            }
            case 1: {
                operation = Operation.UPDATE;
                break;
            }
            case 2: {
                operation = Operation.DESTROY;
            }
        }
        return operation;
    }

    public String getRegionName() {
        return this._regionName;
    }

    @Override
    public Object getKey() {
        return this._key == TOKEN_UN_INITIALIZED ? null : this._key;
    }

    public byte[] getValue() {
        return this._value;
    }

    public byte getValueIsObject() {
        return this._valueIsObject;
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.getGatewayCallbackArgument();
        while (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        return result;
    }

    public GatewayEventCallbackArgument getGatewayCallbackArgument() {
        return this._callbackArgument;
    }

    public int getNumberOfParts() {
        return this._numberOfParts;
    }

    public Object getDeserializedValueForLogging() {
        Object deserializedObject = this._value;
        try {
            deserializedObject = this._valueIsObject == 0 ? this._value : (Object)EntryEventImpl.deserialize(this._value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedObject;
    }

    @Override
    public Object getDeserializedValue() {
        if (this._valueIsObject == 0) {
            return this._value;
        }
        return EntryEventImpl.deserialize(this._value);
    }

    @Override
    public byte[] getSerializedValue() {
        return this._value;
    }

    @Override
    public void setPossibleDuplicate(boolean possibleDuplicate) {
        this._possibleDuplicate = possibleDuplicate;
    }

    @Override
    public boolean getPossibleDuplicate() {
        return this._possibleDuplicate;
    }

    @Override
    public long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public int getDSFID() {
        return -136;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (this._key == TOKEN_UN_INITIALIZED) {
            this.initialize();
        }
        out.writeShort(17);
        out.writeInt(this._action);
        out.writeInt(this._numberOfParts);
        DataSerializer.writeObject(this._id, out);
        DataSerializer.writeString(this._regionName, out);
        out.writeByte(this._valueIsObject);
        DataSerializer.writeObject(this._key, out);
        DataSerializer.writeByteArray(this._value, out);
        DataSerializer.writeObject(this._callbackArgument, out);
        out.writeBoolean(this._possibleDuplicate);
        out.writeLong(this._creationTime);
        out.writeInt(this.bucketId);
        out.writeLong(this.shadowKey);
    }

    public void fromData66(DataInput in) throws IOException, ClassNotFoundException {
        int version = 17;
        this._action = in.readInt();
        this._numberOfParts = in.readInt();
        if (in instanceof InputStream && InternalDataSerializer.getVersionForDataStream(in) == Version.CURRENT) {
            in = new VersionedDataInputStream((InputStream)((Object)in), Version.GFE_66);
        }
        this._id = (EventID)DataSerializer.readObject(in);
        this._regionName = DataSerializer.readString(in);
        this._valueIsObject = in.readByte();
        this._key = DataSerializer.readObject(in);
        this._value = DataSerializer.readByteArray(in);
        this._callbackArgument = (GatewayEventCallbackArgument)DataSerializer.readObject(in);
        this._possibleDuplicate = in.readBoolean();
        this._creationTime = in.readLong();
        this.bucketId = 1;
        this.shadowKey = new Long(1L);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version != 17) {
            // empty if block
        }
        this._action = in.readInt();
        this._numberOfParts = in.readInt();
        if (version < 17 && in instanceof InputStream && InternalDataSerializer.getVersionForDataStream(in) == Version.CURRENT) {
            in = new VersionedDataInputStream((InputStream)((Object)in), Version.GFE_701);
        }
        this._id = (EventID)DataSerializer.readObject(in);
        this._regionName = DataSerializer.readString(in);
        this._valueIsObject = in.readByte();
        this._key = DataSerializer.readObject(in);
        this._value = DataSerializer.readByteArray(in);
        this._callbackArgument = (GatewayEventCallbackArgument)DataSerializer.readObject(in);
        this._possibleDuplicate = in.readBoolean();
        this._creationTime = in.readLong();
        this.bucketId = in.readInt();
        this.shadowKey = in.readLong();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GatewayEventImpl[").append("id=").append(this._id).append(";action=").append(this._action).append(";operation=").append(this.getOperation()).append(";region=").append(this._regionName).append(";key=").append(this._key).append(";value=").append(this.getDeserializedValueForLogging()).append(";valueIsObject=").append(this._valueIsObject).append(";numberOfParts=").append(this._numberOfParts).append(";callbackArgument=").append(this._callbackArgument).append(";possibleDuplicate=").append(this._possibleDuplicate).append(";creationTime=").append(this._creationTime).append(":bucketId=").append(this.bucketId).append(":shadowKey=").append(this.shadowKey);
        buffer.append("]");
        return buffer.toString();
    }

    protected Object deserializeForLogging(byte[] serializedBytes) {
        Object deserializedObject = serializedBytes;
        try {
            deserializedObject = this._valueIsObject == 0 ? serializedBytes : (Object)EntryEventImpl.deserialize(serializedBytes);
        }
        catch (Exception e) {
            throw new InternalGemFireError(e);
        }
        return deserializedObject;
    }

    @Override
    public boolean shouldBeConflated() {
        return this.isUpdate() || this.getRegion() != null && !this.getRegion().getAttributes().getDataPolicy().withStorage() && this.isCreate();
    }

    @Override
    public String getRegionToConflate() {
        return this._regionName;
    }

    @Override
    public Object getKeyToConflate() {
        return this._key;
    }

    @Override
    public Object getValueToConflate() {
        return this._value;
    }

    @Override
    public void setLatestValue(Object value2) {
        this._value = (byte[])value2;
    }

    protected boolean isUpdate() {
        return this._operation == null ? this._action == 1 : this._operation == EnumListenerEvent.AFTER_UPDATE;
    }

    protected boolean isCreate() {
        return this._operation == null ? this._action == 0 : this._operation == EnumListenerEvent.AFTER_CREATE;
    }

    protected boolean isDestroy() {
        return this._operation == null ? this._action == 2 : this._operation == EnumListenerEvent.AFTER_DESTROY;
    }

    private void initializeId() {
        this._id = this._entryEvent.getEventId();
        if (this._id == null) {
            throw new IllegalStateException(LocalizedStrings.GatewayEventImpl_NO_EVENT_ID_IS_AVAILABLE_FOR_THIS_GATEWAY_EVENT.toLocalizedString());
        }
    }

    protected void initialize() throws IOException {
        if (this._key != TOKEN_UN_INITIALIZED) {
            return;
        }
        this._key = this._entryEvent.getKey();
        this._valueIsObject = 1;
        SerializedCacheValue<?> serializedNewValue = this._entryEvent.getSerializedNewValue();
        if (serializedNewValue == null) {
            if (this._entryEvent.getCachedSerializedNewValue() != null) {
                this._value = this._entryEvent.getCachedSerializedNewValue();
            } else {
                Object newValue = this._entryEvent.getRawNewValue();
                if (newValue instanceof byte[]) {
                    this._value = (byte[])newValue;
                    this._valueIsObject = 0;
                } else {
                    this._value = CacheServerHelper.serialize(newValue);
                    this._entryEvent.setCachedSerializedNewValue(this._value);
                }
            }
        } else {
            this._value = serializedNewValue.getSerializedValue();
        }
        this._callbackArgument = (GatewayEventCallbackArgument)this._entryEvent.getRawCallbackArgument();
        this.initializeAction(this._operation);
        this._entryEvent = null;
    }

    protected void initializeAction(EnumListenerEvent operation) {
        if (operation == EnumListenerEvent.AFTER_CREATE) {
            this._action = 0;
            this._numberOfParts = this._callbackArgument == null ? 7 : 8;
        } else if (operation == EnumListenerEvent.AFTER_UPDATE) {
            this._action = 1;
            this._numberOfParts = this._callbackArgument == null ? 7 : 8;
        } else if (operation == EnumListenerEvent.AFTER_DESTROY) {
            this._action = 2;
            this._numberOfParts = this._callbackArgument == null ? 6 : 7;
        }
    }

    @Override
    public EventID getEventId() {
        return this._id;
    }

    @Override
    public int getSizeInBytes() {
        int size2 = 0;
        size2 += 8;
        size2 += 28;
        size2 += 10;
        size2 += 64;
        if (this._value != null) {
            size2 += CachedDeserializableFactory.calcMemSize(this._value);
        }
        size2 += 202;
        size2 += 8 + this.sizeOf(this.getCallbackArgument());
        return size2 += 8;
    }

    private int sizeOf(Object obj) {
        int size2 = 0;
        if (obj == null) {
            return size2;
        }
        size2 = obj instanceof String ? ObjectSizer.DEFAULT.sizeof(obj) : (obj instanceof Integer ? 4 : (obj instanceof Long ? 8 : CachedDeserializableFactory.calcMemSize(obj) - 8));
        return size2;
    }

    public EntryEvent<Object, Object> getEntryEvent() {
        return this._entryEvent;
    }

    public long getVersionTimeStamp() {
        throw new UnsupportedOperationException("versioning is not enabled with this WAN implementation");
    }

    @Override
    public Region<?, ?> getRegion() {
        return this._region != null ? this._region : CacheFactory.getAnyInstance().getRegion(this._regionName);
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setShadowKey(Long tailKey) {
        this.shadowKey = tailKey;
    }

    public Long getShadowKey() {
        return this.shadowKey;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

