/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.GatewayConfigurationException;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ServerProxy;
import com.gemstone.gemfire.cache.client.internal.pooling.ConnectionDestroyedException;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.GatewayEventDispatcher;
import com.gemstone.gemfire.internal.cache.GatewayEventImpl;
import com.gemstone.gemfire.internal.cache.GatewayImpl;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import com.gemstone.gemfire.internal.cache.tier.BatchException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

class GatewayEventRemoteDispatcher
implements GatewayEventDispatcher {
    private static final Logger logger = LogService.getLogger();
    private final GatewayImpl.GatewayEventProcessor eventProcessor;
    private volatile Connection connection;
    private final Set<String> notFoundRegions;
    private final Object notFoundRegionsSync;
    private static final int ARTIFICIAL_DELAY = Integer.getInteger("gemfire.artificialGatewayDelay", -1);
    private int failedConnectCount;

    protected GatewayEventRemoteDispatcher(GatewayImpl.GatewayEventProcessor eventProcessor) {
        block2: {
            this.notFoundRegions = new HashSet<String>();
            this.notFoundRegionsSync = new Object();
            this.failedConnectCount = 0;
            this.eventProcessor = eventProcessor;
            try {
                this.initializeConnection();
            }
            catch (GatewayException e) {
                if (!(e.getCause() instanceof GemFireSecurityException) && !(e instanceof GatewayConfigurationException)) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchBatch(List events, boolean removeFromQueueOnException) {
        boolean success;
        block25: {
            GatewayStats statistics = this.eventProcessor.getGateway().getStatistics();
            success = false;
            try {
                long start = statistics.startTime();
                if (ARTIFICIAL_DELAY > 0) {
                    try {
                        Thread.sleep(ARTIFICIAL_DELAY);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.dispatchBatch(events);
                statistics.endBatch(start, events.size());
                success = true;
            }
            catch (GatewayException e) {
                Throwable t = e.getCause();
                if (this.eventProcessor.getGateway().getProxy().isDestroyed()) break block25;
                if (t instanceof IOException || t instanceof ServerConnectivityException || t instanceof ConnectionDestroyedException) {
                    this.eventProcessor.logBatchDebug("Because of IOException, failed to dispatch the following ", events);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        if (!this.eventProcessor.getIsStopped()) {
                            logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_AN_INTERRUPTEDEXCEPTION_OCCURRED_BUT_THE_PROCESSOR_IS_NOT_STOPPED), (Throwable)e);
                        }
                        break block25;
                    }
                }
                if (t instanceof BatchException) {
                    BatchException be = (BatchException)t;
                    this.eventProcessor.incrementBatchId();
                    if (removeFromQueueOnException) {
                        boolean logWarning = true;
                        if (be.getCause() instanceof RegionDestroyedException) {
                            RegionDestroyedException rde = (RegionDestroyedException)be.getCause();
                            Object object = this.notFoundRegionsSync;
                            synchronized (object) {
                                if (this.notFoundRegions.contains(rde.getRegionFullPath())) {
                                    logWarning = false;
                                } else {
                                    this.notFoundRegions.add(rde.getRegionFullPath());
                                }
                            }
                        }
                        if (logWarning) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_A_BATCHEXCEPTION_OCCURRED_PROCESSING_EVENT__0, be.getIndex()), (Throwable)be);
                        }
                        try {
                            this.eventProcessor.eventQueueRemove(be.getIndex());
                            GatewayEventImpl ge = (GatewayEventImpl)this.eventProcessor.eventQueueTake();
                            statistics.setQueueSize(this.eventProcessor.eventQueueSize());
                            if (logWarning) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_THE_EVENT_BEING_PROCESSED_WHEN_THE_BATCHEXCEPTION_OCCURRED_WAS__0, ge));
                            }
                        }
                        catch (CacheException ce) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_THE_FOLLOWING_CACHEEXCEPTION_OCCURRED_WHILE_REMOVING__0__EVENTS, be.getIndex()), (Throwable)ce);
                        }
                        catch (InterruptedException ie) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_INTERRUPTED_WHILE_REMOVING_0_EVENTS, be.getIndex()), (Throwable)ie);
                        }
                    }
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_A_BATCHEXCEPTION_OCCURRED_DURING_FAILOVER_PROCESSING_EVENT__0__THIS_MESSAGE_WILL_CONTINUE_TO_BE_PROCESSED, be.getIndex()), (Throwable)be);
                }
                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_STOPPING_THE_PROCESSOR_BECAUSE_THE_FOLLOWING_EXCEPTION_OCCURRED_WHILE_PROCESSING_A_BATCH), (Throwable)e);
                this.eventProcessor.setIsStopped(true);
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Stopping the processor because cancellation occurred while processing a batch");
                }
                this.eventProcessor.setIsStopped(true);
                throw e;
            }
            catch (Exception e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_STOPPING_THE_PROCESSOR_BECAUSE_THE_FOLLOWING_EXCEPTION_OCCURRED_WHILE_PROCESSING_A_BATCH), (Throwable)e);
                this.eventProcessor.setIsStopped(true);
            }
        }
        return success;
    }

    private void dispatchBatch(List events) throws GatewayException {
        if (events.isEmpty()) {
            return;
        }
        Exception ex = null;
        Connection connection = this.getConnection();
        int batchId = this.eventProcessor.getBatchId();
        try {
            ServerProxy sp = new ServerProxy(this.eventProcessor.getGateway().getProxy());
            sp.dispatchBatch(connection, events, batchId, this.eventProcessor.getGateway().getEarlyAck());
            return;
        }
        catch (ServerOperationException e) {
            Throwable t = e.getCause();
            ex = t instanceof BatchException ? (BatchException)t : e;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            ex = t instanceof IOException ? (IOException)t : e;
        }
        if (!(ex instanceof BatchException)) {
            this.destroyConnection();
        }
        GatewayException ge = new GatewayException(LocalizedStrings.GatewayEventRemoteDispatcher_0_EXCEPTION_DURING_PROCESSING_BATCH_1_ON_CONNECTION_2.toLocalizedString(this, batchId, connection), ex);
        throw ge;
    }

    Connection getConnection() throws GatewayException {
        if (this.connection == null) {
            this.initializeConnection();
            this.eventProcessor.resetBatchId();
        }
        return this.connection;
    }

    void destroyConnection() {
        Connection con = this.connection;
        if (con != null) {
            if (!con.isDestroyed()) {
                con.destroy();
                this.eventProcessor.getGateway().getProxy().returnConnection(con);
            }
            this.connection = null;
        }
    }

    private void initializeConnection() throws GatewayException, GemFireSecurityException {
        Connection connection;
        try {
            connection = this.eventProcessor.getGateway().getProxy().acquireConnection();
        }
        catch (ServerConnectivityException e) {
            ++this.failedConnectCount;
            Throwable ex = null;
            if (e.getCause() instanceof GemFireSecurityException) {
                ex = e.getCause();
                if (this.failedConnectCount == 1) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_0_COULD_NOT_CONNECT_1, new Object[]{this.eventProcessor.getGateway(), ex.getMessage()}));
                }
                throw (GemFireSecurityException)ex;
            }
            if (e.getCause() instanceof GatewayConfigurationException) {
                ex = e.getCause();
                if (this.failedConnectCount == 1) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_0_COULD_NOT_CONNECT_1, new Object[]{this.eventProcessor.getGateway(), ex.getMessage()}));
                }
                throw (GatewayConfigurationException)ex;
            }
            List<ServerLocation> servers = this.eventProcessor.getGateway().getProxy().getCurrentServers();
            String ioMsg = null;
            if (servers.size() == 0) {
                ioMsg = LocalizedStrings.GatewayEventRemoteDispatcher_THERE_ARE_NO_ACTIVE_SERVERS.toLocalizedString();
            } else {
                StringBuilder buffer = new StringBuilder();
                Iterator<ServerLocation> i = servers.iterator();
                while (i.hasNext()) {
                    String endpointName = String.valueOf(i.next());
                    if (buffer.length() > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(endpointName);
                }
                ioMsg = LocalizedStrings.GatewayEventRemoteDispatcher_NO_AVAILABLE_CONNECTION_WAS_FOUND_BUT_THE_FOLLOWING_ACTIVE_SERVERS_EXIST_0.toLocalizedString(buffer.toString());
            }
            ex = new IOException(ioMsg);
            if (this.failedConnectCount == 1) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher__0___COULD_NOT_CONNECT, this.eventProcessor.getGateway()));
            }
            throw new GatewayException(LocalizedStrings.GatewayEventRemoteDispatcher__0___COULD_NOT_CONNECT.toLocalizedString(this.eventProcessor.getGateway()), ex);
        }
        if (this.failedConnectCount > 0) {
            Object[] logArgs = new Object[]{this.eventProcessor.getGateway(), connection, this.failedConnectCount};
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_0_USING_1_AFTER_2_FAILED_CONNECT_ATTEMPTS, logArgs));
            this.failedConnectCount = 0;
        } else {
            Object[] logArgs = new Object[]{this.eventProcessor.getGateway(), connection};
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayEventRemoteDispatcher_0_USING_1, logArgs));
        }
        this.connection = connection;
    }
}

