/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.internal.cache.GatewayStatus;
import java.io.Serializable;
import java.util.List;

public class GatewayHubStatus
implements Serializable {
    private static final long serialVersionUID = -4925249622141335103L;
    protected String _id;
    protected int _port;
    protected boolean _isPrimary;
    protected GatewayStatus[] _gatewayStatuses;

    public GatewayHubStatus(GatewayHub hub) {
        this.setId(hub.getId());
        this.setPort(hub.getPort());
        this.setIsPrimary(hub.isPrimary());
        this.initializeGatewayStatuses(hub);
    }

    public String getId() {
        return this._id;
    }

    protected void setId(String id) {
        this._id = id;
    }

    public int getPort() {
        return this._port;
    }

    protected void setPort(int port) {
        this._port = port;
    }

    public boolean getIsPrimary() {
        return this._isPrimary;
    }

    protected void setIsPrimary(boolean isPrimary) {
        this._isPrimary = isPrimary;
    }

    public GatewayStatus[] getGatewayStatuses() {
        return this._gatewayStatuses;
    }

    protected void initializeGatewayStatuses(GatewayHub hub) {
        List<Gateway> gateways = hub.getGateways();
        this._gatewayStatuses = new GatewayStatus[gateways.size()];
        int i = 0;
        for (Gateway gateway : gateways) {
            this._gatewayStatuses[i] = new GatewayStatus(gateway);
            ++i;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GatewayHubStatus[").append("id=").append(this._id).append("; port=").append(this._port).append("; isPrimary=").append(this._isPrimary);
        if (this._gatewayStatuses == null) {
            buffer.append("; gatewayStatus = null");
        } else {
            buffer.append("; gatewayStatuses (" + this._gatewayStatuses.length + ") = [");
            for (int i = 0; i < this._gatewayStatuses.length; ++i) {
                buffer.append(this._gatewayStatuses[i].toString());
                if (i == this._gatewayStatuses.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append("]");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

