/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.GatewayConfigurationException;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.EndpointManagerImpl;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.GatewayCancelledException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.AbstractGateway;
import com.gemstone.gemfire.internal.cache.DiskWriteAttributesImpl;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackDispatcher;
import com.gemstone.gemfire.internal.cache.GatewayEventDispatcher;
import com.gemstone.gemfire.internal.cache.GatewayEventFilter;
import com.gemstone.gemfire.internal.cache.GatewayEventImpl;
import com.gemstone.gemfire.internal.cache.GatewayEventRemoteDispatcher;
import com.gemstone.gemfire.internal.cache.GatewayHubImpl;
import com.gemstone.gemfire.internal.cache.GatewayParallelImpl;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.SingleWriteSingleReadRegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class GatewayImpl
extends AbstractGateway {
    private static final Logger logger = LogService.getLogger();
    protected static final int TOKEN_TIMEOUT = Integer.getInteger("Gateway.TOKEN_TIMEOUT", 15000);
    public static final int QUEUE_OPLOG_SIZE = Integer.getInteger("gemfire.GatewayQueueOpLogSize", 0x6400000);
    private static final long GATEWAY_TIMEOUT = Integer.getInteger("gemfire.GATEWAY_TIMEOUT", 30).intValue();
    private volatile List _endpoints;
    private volatile List _listeners;
    private volatile GatewayQueueAttributes _queueAttributes;
    private volatile boolean _primary;
    private final Object _primaryLock = new Object();
    protected final Stopper stopper = new Stopper();
    protected volatile PoolImpl _proxy;
    private int _socketBufferSize;
    private int _socketReadTimeout;
    private volatile GatewayEventProcessor _eventProcessor;
    private GatewayEventFilter filter = DefaultGatewayEventFilter.getInstance();
    private final boolean _usedInParallel;
    protected static final int MAXIMUM_SHUTDOWN_PEEKS = Integer.getInteger("Gateway.MAXIMUM_SHUTDOWN_PEEKS", 20);
    protected static final int QUEUE_SIZE_THRESHOLD = Integer.getInteger("Gateway.QUEUE_SIZE_THRESHOLD", 5000);
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private static final AtomicBoolean SOCKET_READ_TIMEOUT_PROPERTY_CHECKED = new AtomicBoolean(false);
    private boolean failoverCompleted = false;
    private final Object failoverCompletedLock = new Object();

    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    GatewayImpl(GatewayHubImpl hub, String id) {
        this(hub, id, false, null);
    }

    GatewayImpl(GatewayHubImpl hub, String id, boolean usedInParallel, GatewayStats allStatistics) {
        super(hub, id, id, allStatistics);
        this._usedInParallel = usedInParallel;
        this._endpoints = Collections.EMPTY_LIST;
        this._listeners = Collections.EMPTY_LIST;
        this._isRunning = false;
        this._queueAttributes = new GatewayQueueAttributes();
        if (hub.getSqlFabricStartedHub()) {
            String dirPath = this._queueAttributes.getEnablePersistence() ? DiskWriteAttributesImpl.generatePersistentDirName(null) : DiskWriteAttributesImpl.generateOverFlowDirName(null);
            this._queueAttributes.setOverflowDirectory(dirPath);
        }
        this._primary = false;
        this._socketBufferSize = 32768;
        this._socketReadTimeout = 0;
    }

    public GatewayEventFilter getEventFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEndpoint(String id, String host, int port) throws GatewayException {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            if (this.alreadyDefinesEndpoint(id, host, port)) {
                throw new GatewayException(LocalizedStrings.GatewayImpl_GATEWAY_0_ALREADY_DEFINES_AN_ENDPOINT_EITHER_WITH_ID_1_OR_HOST_2_AND_PORT_3.toLocalizedString(this._id, id, host, port));
            }
            String[] otherGateway = new String[1];
            if (!this._usedInParallel && this.otherGatewayDefinesEndpoint(host, port, otherGateway)) {
                throw new GatewayException(LocalizedStrings.GatewayImpl_GATEWAY_0_CANNOT_DEFINE_ENDPOINT_HOST_1_AND_PORT_2_BECAUSE_IT_IS_ALREADY_DEFINED_BY_GATEWAY_3.toLocalizedString(this._id, host, port, otherGateway[0]));
            }
            if (this.isConnectingToOwnHub(host, port)) {
                throw new GatewayException(LocalizedStrings.GatewayImpl_GATEWAY_0_CANNOT_DEFINE_AN_ENDPOINT_TO_ITS_OWN_HUB_HOST_1_AND_PORT_2.toLocalizedString(this._id, host, port));
            }
            if (this.hasListeners()) {
                throw new GatewayException(LocalizedStrings.GatewayImpl_GATEWAY_0_CANNOT_DEFINE_AN_ENDPOINT_BECAUSE_AT_LEAST_ONE_LISTENER_IS_ALREADY_DEFINED_BOTH_LISTENERS_AND_ENDPOINTS_CANNOT_BE_DEFINED_FOR_THE_SAME_GATEWAY.toLocalizedString(this._id));
            }
            ArrayList<EndpointImpl> newEndpoints = new ArrayList<EndpointImpl>(this._endpoints);
            newEndpoints.add(new EndpointImpl(id, host, port));
            this._endpoints = Collections.unmodifiableList(newEndpoints);
        }
    }

    @Override
    public List getEndpoints() {
        return this._endpoints;
    }

    @Override
    public boolean hasEndpoints() {
        return this.getEndpoints().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(GatewayEventListener listener) throws GatewayException {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            if (this.hasEndpoints()) {
                throw new GatewayException(LocalizedStrings.GatewayImpl_GATEWAY_0_CANNOT_DEFINE_A_LISTENER_BECAUSE_AT_LEAST_ONE_ENDPOINT_IS_ALREADY_DEFINED_BOTH_LISTENERS_AND_ENDPOINTS_CANNOT_BE_DEFINED_FOR_THE_SAME_GATEWAY.toLocalizedString(this._id));
            }
            ArrayList<GatewayEventListener> newListeners = new ArrayList<GatewayEventListener>(this._listeners);
            newListeners.add(listener);
            this._listeners = Collections.unmodifiableList(newListeners);
        }
    }

    public List getListeners() {
        return this._listeners;
    }

    @Override
    public boolean hasListeners() {
        return this.getListeners().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            this._socketBufferSize = socketBufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSocketBufferSize() {
        Object object = this.controlLock;
        synchronized (object) {
            return this._socketBufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSocketReadTimeout(int socketReadTimeout) {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            if (socketReadTimeout != 0 && socketReadTimeout < 30000) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Gateway_CONFIGURED_SOCKET_READ_TIMEOUT_TOO_LOW, new Object[]{"Gateway " + this._id, socketReadTimeout, 30000}));
                this._socketReadTimeout = 30000;
            } else {
                this._socketReadTimeout = socketReadTimeout;
            }
            if (SOCKET_READ_TIMEOUT_PROPERTY_CHECKED.compareAndSet(false, true) && System.getProperty("gemfire.cache.gateway.default-socket-read-timeout") != null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Gateway_OBSOLETE_SYSTEM_POPERTY, new Object[]{"gemfire.cache.gateway.default-socket-read-timeout", "Gateway socket read timeout"}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSocketReadTimeout() {
        Object object = this.controlLock;
        synchronized (object) {
            return this._socketReadTimeout;
        }
    }

    @Override
    protected void setPrimary(boolean primary) {
        this._primary = primary;
    }

    protected boolean getPrimary() {
        return this._primary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGatewayEventFilter(GatewayEventFilter filter) {
        Object object = this.controlLock;
        synchronized (object) {
            this.filter = filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueueAttributes(GatewayQueueAttributes queueAttributes) {
        Object object = this.controlLock;
        synchronized (object) {
            this.checkRunning();
            if (this._eventProcessor != null && ((SingleWriteSingleReadRegionQueue)this._eventProcessor._eventQueue).isPersistent() && !queueAttributes.getEnablePersistence()) {
                this._eventProcessor.destroyQueuePersistenceFiles();
            }
            this._queueAttributes = queueAttributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayQueueAttributes getQueueAttributes() {
        Object object = this.controlLock;
        synchronized (object) {
            return this._queueAttributes;
        }
    }

    public GatewayQueueAttributes getQueueAttributesNoSync() {
        return this._queueAttributes;
    }

    public RegionQueue getRegionQueueTestOnly() {
        return this._eventProcessor._eventQueue;
    }

    @Override
    public int getConcurrencyLevel() {
        return 1;
    }

    private boolean otherGatewayDefinesEndpoint(String host, int port, String[] otherGateway) {
        boolean otherGatewayDefined = false;
        block0: for (Gateway gateway : this.getGatewayHub().getGateways()) {
            if (this.getId().equals(gateway.getId())) continue;
            for (Gateway.Endpoint endpoint : gateway.getEndpoints()) {
                if (!endpoint.getHost().equals(host) || endpoint.getPort() != port) continue;
                otherGatewayDefined = true;
                otherGateway[0] = gateway.getId();
                continue block0;
            }
        }
        return otherGatewayDefined;
    }

    private boolean alreadyDefinesEndpoint(String id, String host, int port) {
        boolean alreadyDefined = false;
        for (Gateway.Endpoint endpoint : this._endpoints) {
            if (!endpoint.getId().equals(id) && (!endpoint.getHost().equals(host) || endpoint.getPort() != port)) continue;
            alreadyDefined = true;
            break;
        }
        return alreadyDefined;
    }

    private boolean isConnectingToOwnHub(String host, int port) {
        boolean isConnectingToOwnHub = false;
        if (port == this._hub.getPort()) {
            try {
                String localHostName = SocketCreator.getLocalHost().getCanonicalHostName();
                String requestedHostName = InetAddress.getByName(host).getCanonicalHostName();
                if (localHostName.equals(requestedHostName) || requestedHostName.startsWith("localhost")) {
                    isConnectingToOwnHub = true;
                }
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        return isConnectingToOwnHub;
    }

    protected Cache getCache() {
        return this._cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PoolImpl getProxy() {
        Object object = this.controlLock;
        synchronized (object) {
            return this._proxy;
        }
    }

    @Override
    public void start() throws IOException {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(GatewayParallelImpl gpi) throws IOException {
        Object object = this.controlLock;
        synchronized (object) {
            if (this._isRunning) {
                return;
            }
            if (this.getStatistics().isClosed()) {
                this.setStatistics(new GatewayStats(this._cache.getDistributedSystem(), this.getGatewayHubId(), this.getId(), gpi == null ? null : gpi.getStatistics()));
            }
            if (this.hasEndpoints()) {
                Properties properties = new Properties();
                StringBuffer buffer = new StringBuffer();
                Iterator i = this.getEndpoints().iterator();
                while (i.hasNext()) {
                    Gateway.Endpoint endpoint = (Gateway.Endpoint)i.next();
                    buffer.append(endpoint.getId()).append('=').append(endpoint.getHost()).append(':').append(endpoint.getPort());
                    if (!i.hasNext()) continue;
                    buffer.append(',');
                }
                properties.setProperty("endpoints", buffer.toString());
                properties.setProperty("socketBufferSize", String.valueOf(this._socketBufferSize));
                properties.setProperty("connectionsPerServer", "0");
                properties.setProperty("readTimeout", String.valueOf(this._socketReadTimeout));
                this._proxy = this.createPool(properties);
                EndpointManagerImpl emi = (EndpointManagerImpl)this._proxy.getEndpointManager();
                emi.setGatewayStats(this.getStatistics());
            }
            try {
                GatewayEventProcessor ev = this.initializeEventProcessor();
                this.setRunning(true);
                ev.start();
                ((GemFireCacheImpl)this.getCache()).getPdxRegistry().gatewayStarted(this);
            }
            catch (GemFireSecurityException e) {
                this.setRunning(false);
                throw e;
            }
            catch (GatewayConfigurationException e) {
                this.setRunning(false);
                throw e;
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_STARTED__0, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.controlLock;
        synchronized (object) {
            if (!this._isRunning) {
                return;
            }
            this._eventProcessor.pauseDispatching();
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_PAUSED__0, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.controlLock;
        synchronized (object) {
            if (!this._isRunning) {
                return;
            }
            this._eventProcessor.resumeDispatching();
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_RESUMED__0, this));
        }
    }

    @Override
    public boolean isPaused() {
        boolean isPaused = false;
        GatewayEventProcessor ev = this._eventProcessor;
        if (ev != null) {
            isPaused = ev.getIsPaused();
        }
        return isPaused;
    }

    public PoolImpl createPool(Properties props) {
        String name = "GatewayPool-" + GatewayImpl.getGatewayPoolId();
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        try {
            pf.init(props, false, true);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("Couldn't find any Endpoint")) {
                throw e;
            }
            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_UnknownHost), (Throwable)e);
        }
        PoolImpl result = (PoolImpl)pf.create(name);
        return result;
    }

    private static int getGatewayPoolId() {
        return ID_COUNTER.incrementAndGet();
    }

    public static void loadEmergencyClasses() {
        PoolImpl.loadEmergencyClasses();
    }

    @Override
    public void emergencyClose() {
        this._isRunning = false;
        PoolImpl bpi = this._proxy;
        if (bpi != null) {
            bpi.emergencyClose();
        }
    }

    private void stompProxyDead() {
        Runnable stomper = new Runnable(){

            @Override
            public void run() {
                PoolImpl bpi = GatewayImpl.this._proxy;
                if (bpi != null) {
                    try {
                        bpi.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        LoggingThreadGroup tg = LoggingThreadGroup.createThreadGroup("Proxy Stomper Group", logger);
        Thread t = new Thread(tg, stomper, "Gateway Proxy Stomper");
        t.setDaemon(true);
        t.start();
        try {
            t.join(GATEWAY_TIMEOUT * 1000L);
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_GATEWAY_0_IS_NOT_CLOSING_CLEANLY_FORCING_CANCELLATION, this));
            t.interrupt();
            this._proxy.emergencyClose();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.controlLock;
        synchronized (object) {
            if (!this._isRunning) {
                return;
            }
            this.setRunning(false);
            this.setFailoverComplete(false);
            GatewayEventProcessor ev = this._eventProcessor;
            if (ev != null) {
                try {
                    ev.resumeDispatching();
                    ev.stopProcessing();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.stompProxyDead();
            Iterator i = this._listeners.iterator();
            while (i.hasNext()) {
                ((GatewayEventListener)i.next()).close();
            }
            if (this._statistics != null) {
                this._statistics.close();
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_STOPPED__0, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueueSize() {
        Object object = this.controlLock;
        synchronized (object) {
            GatewayEventProcessor ev = this._eventProcessor;
            if (ev == null) {
                return 0;
            }
            return ev._eventQueue.size();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._primary ? "Primary" : "Secondary");
        sb.append(" Gateway to ");
        sb.append(this._id);
        if (this.hasEndpoints()) {
            if (!this.isConnectedNoSync()) {
                sb.append(" not");
            }
            sb.append(" connected to ");
            sb.append(this._endpoints);
        } else if (this.hasListeners()) {
            sb.append(" with listeners ");
            sb.append(this._listeners);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.controlLock;
        synchronized (object) {
            return this.isConnectedNoSync();
        }
    }

    private boolean isConnectedNoSync() {
        if (!this._isRunning) {
            return false;
        }
        GatewayEventProcessor ev = this._eventProcessor;
        if (ev == null) {
            return false;
        }
        if (!ev.isAlive()) {
            return false;
        }
        if (!this._isRunning) {
            return false;
        }
        PoolImpl bpi = this._proxy;
        if (bpi == null) {
            return false;
        }
        return !bpi.isDestroyed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunning(boolean running) {
        Object object = this.controlLock;
        synchronized (object) {
            this._isRunning = running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void distribute(EnumListenerEvent operation, EntryEventImpl event) {
        if (!this.isRunning()) {
            return;
        }
        if (event.getSerializedNewValue() == null && event.getCachedSerializedNewValue() == null) {
            try {
                Object newValue = event.getRawNewValue();
                if (!(newValue instanceof byte[])) {
                    byte[] value2 = CacheServerHelper.serialize(newValue);
                    event.setSerializedNewValue(value2);
                }
            }
            catch (IOException e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_AN_EXCEPTION_OCCURRED_WHILE_QUEUEING_1_TO_PERFORM_OPERATION_2_FOR_3, new Object[]{this, this.getId(), operation, event}), (Throwable)e);
            }
        }
        Object object = this.controlLock;
        synchronized (object) {
            if (!this.isRunning() || !this.filter.enqueueEvent(event)) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: About to queue operation {} for {}: {}", this, operation, this.getId(), event);
            }
            try {
                GatewayEventProcessor ev = this._eventProcessor;
                if (ev == null) {
                    this.stopper.checkCancelInProgress(null);
                    ((InternalDistributedSystem)this._cache.getDistributedSystem()).getCancelCriterion().checkCancelInProgress(null);
                    if (ev == null) {
                        throw new GatewayCancelledException("Event processor thread is gone");
                    }
                }
                if (ev != null) {
                    ev.enqueueEvent(operation, event);
                }
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_AN_EXCEPTION_OCCURRED_WHILE_QUEUEING_1_TO_PERFORM_OPERATION_2_FOR_3, new Object[]{this, this.getId(), operation, event}), (Throwable)e);
            }
        }
    }

    private GatewayEventProcessor initializeEventProcessor() {
        GatewayEventProcessor ev;
        this._eventProcessor = ev = new GatewayEventProcessor(this);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Created event processor {}", this, ev);
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitToBecomePrimary() throws InterruptedException {
        if (this.getPrimary()) {
            return;
        }
        Object object = this._primaryLock;
        synchronized (object) {
            while (!this.getPrimary()) {
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0__WAITING_TO_BECOME_PRIMARY_GATEWAY, this));
                this._primaryLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForFailoverCompletion() {
        Object object = this.failoverCompletedLock;
        synchronized (object) {
            if (this.failoverCompleted) {
                return;
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0__WAITING_FOR_FAILOVER_COMPLETION, this));
            try {
                while (!this.failoverCompleted) {
                    this.failoverCompletedLock.wait();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this._cache.getCancelCriterion().checkCancelInProgress(ex);
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_DID_NOT_WAIT_FOR_FAILOVER_COMPLETION_DUE_TO_INTERRUPTION, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeFailover() {
        Object object = this.failoverCompletedLock;
        synchronized (object) {
            this.setFailoverComplete(true);
            this.failoverCompletedLock.notifyAll();
        }
    }

    private void setFailoverComplete(boolean failoverCompleted) {
        this.failoverCompleted = failoverCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void becomePrimary() {
        logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0__BECOMING_PRIMARY_GATEWAY, this));
        Object object = this._primaryLock;
        synchronized (object) {
            this.setPrimary(true);
            this._primaryLock.notify();
        }
    }

    private static class ConflationKey {
        private String regionName;
        private Object key;
        private Operation operation;

        private ConflationKey(String regionName, Object key2, Operation operation) {
            this.regionName = regionName;
            this.key = key2;
            this.operation = operation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.regionName.hashCode();
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.operation.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConflationKey that = (ConflationKey)obj;
            if (!this.regionName.equals(that.regionName)) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return this.operation.equals(that.operation);
        }
    }

    public static class DefaultGatewayEventFilter
    implements GatewayEventFilter {
        private static final DefaultGatewayEventFilter singleton = new DefaultGatewayEventFilter();

        private DefaultGatewayEventFilter() {
        }

        public static GatewayEventFilter getInstance() {
            return singleton;
        }

        @Override
        public boolean enqueueEvent(EntryEventImpl event) {
            return true;
        }
    }

    private static class EventWrapper {
        private static final int EVENT_TIMEOUT = Integer.getInteger("Gateway.EVENT_TIMEOUT", 300000);
        public final long timeout;
        public final GatewayEventImpl event;

        public EventWrapper(GatewayEventImpl e) {
            this.event = e;
            this.timeout = System.currentTimeMillis() + (long)EVENT_TIMEOUT;
        }
    }

    protected class SecondaryGatewayListener
    extends CacheListenerAdapter {
        private final GatewayEventProcessor _eventProcessor;

        protected SecondaryGatewayListener(GatewayEventProcessor eventProcessor) {
            this._eventProcessor = eventProcessor;
        }

        @Override
        public void afterCreate(EntryEvent event) {
            if (GatewayImpl.this.getPrimary()) {
                return;
            }
            GatewayEventImpl gatewayEvent = (GatewayEventImpl)event.getNewValue();
            this._eventProcessor.handlePrimaryEvent(gatewayEvent);
        }

        @Override
        public void afterDestroy(EntryEvent event) {
            if (GatewayImpl.this.getPrimary()) {
                return;
            }
            if (event.getOldValue() instanceof GatewayEventImpl) {
                GatewayEventImpl gatewayEvent = (GatewayEventImpl)event.getOldValue();
                this._eventProcessor.handlePrimaryDestroy(gatewayEvent);
            }
        }
    }

    protected class GatewayEventProcessor
    extends Thread {
        protected final GatewayImpl _gateway;
        protected final RegionQueue _eventQueue;
        protected final GatewayEventDispatcher _eventDispatcher;
        private final Object unprocessedEventsLock;
        private Map unprocessedEvents;
        private Map unprocessedTokens;
        protected boolean _eventQueueSizeWarning;
        protected int _batchId;
        protected volatile boolean _isStopped;
        protected volatile boolean _isPaused;
        protected final Object _pausedLock;
        private static final int REAP_THRESHOLD = 1000;
        private int uncheckedCount;
        private ExecutorService _executor;

        protected GatewayEventProcessor(GatewayImpl gateway) {
            super((ThreadGroup)LoggingThreadGroup.createThreadGroup("Gateway Event Processor from " + gateway.getGatewayHubId() + " to " + gateway.getId(), logger), "Gateway Event Processor from " + gateway.getGatewayHubId() + " to " + gateway.getId());
            this.unprocessedEventsLock = new Object();
            this._eventQueueSizeWarning = false;
            this._batchId = 0;
            this._isStopped = false;
            this._isPaused = false;
            this._pausedLock = new Object();
            this.uncheckedCount = 0;
            this._gateway = gateway;
            this.unprocessedEvents = new LinkedHashMap();
            this.unprocessedTokens = new LinkedHashMap();
            this._eventQueue = this.initializeMessageQueue();
            this._eventDispatcher = this.initializeEventDispatcher();
            this.setDaemon(true);
        }

        protected void stopProcessing() {
            if (this.isAlive()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}:Notifying the dispatcher to terminate", this);
                }
                if (this.getGateway().getPrimary()) {
                    int numberOfPeeks = 0;
                    try {
                        try {
                            while (this._eventQueue.peek() != null && numberOfPeeks != MAXIMUM_SHUTDOWN_PEEKS) {
                                ++numberOfPeeks;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        catch (InterruptedException e) {
                        }
                    }
                    catch (CacheException cacheException) {
                        // empty catch block
                    }
                }
                this.setIsStopped(true);
                if (this.isAlive()) {
                    this.interrupt();
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}:Joining with the dispatcher thread upto limit of 5 seconds", this);
                    }
                    try {
                        this.join(5000L);
                        if (this.isAlive()) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_DISPATCHER_STILL_ALIVE_EVEN_AFTER_JOIN_OF_5_SECONDS, this));
                            if (this._eventDispatcher instanceof GatewayEventRemoteDispatcher) {
                                GatewayEventRemoteDispatcher g = (GatewayEventRemoteDispatcher)this._eventDispatcher;
                                g.destroyConnection();
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_INTERRUPTEDEXCEPTION_IN_JOINING_WITH_DISPATCHER_THREAD, this));
                    }
                }
            }
            this.closeProcessor();
            if (logger.isDebugEnabled()) {
                logger.debug("Stopped dispatching: {}", this);
            }
        }

        protected void pauseDispatching() {
            if (this._isPaused) {
                return;
            }
            this._isPaused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resumeDispatching() {
            if (!this._isPaused) {
                return;
            }
            this._isPaused = false;
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Resuming processing", this);
            }
            Object object = this._pausedLock;
            synchronized (object) {
                this._pausedLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void closeProcessor() {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing dispatcher");
            }
            try {
                try {
                    if (this._eventQueue.peek() != null) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_DESTROYING_GATEWAYEVENTDISPATCHER_WITH_ACTIVELY_QUEUED_DATA));
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            catch (CacheException ignore) {
            }
            finally {
                try {
                    this._eventQueue.getRegion().close();
                }
                catch (RegionDestroyedException e) {}
                if (logger.isDebugEnabled()) {
                    logger.debug("Closed dispatcher");
                }
            }
        }

        private void destroyQueuePersistenceFiles() {
            ((SingleWriteSingleReadRegionQueue)this._eventQueue).destroyPersistentFiles(this.getGateway().getCache());
        }

        protected boolean isStopped() {
            return this._isStopped;
        }

        protected void setIsStopped(boolean isStopped) {
            this._isStopped = isStopped;
        }

        protected boolean getIsStopped() {
            return this._isStopped;
        }

        protected boolean getIsPaused() {
            return this._isPaused;
        }

        protected void incrementBatchId() {
            if (this._batchId + 1 == Integer.MAX_VALUE) {
                this._batchId = -1;
            }
            ++this._batchId;
        }

        protected void resetBatchId() {
            this._batchId = 0;
        }

        protected int getBatchId() {
            return this._batchId;
        }

        protected void eventQueueRemove(int numberOfEventsToRemove) throws CacheException {
            this._eventQueue.remove(numberOfEventsToRemove);
        }

        protected Object eventQueueTake() throws CacheException, InterruptedException {
            return this._eventQueue.take();
        }

        protected int eventQueueSize() {
            return this._eventQueue.size();
        }

        protected GatewayImpl getGateway() {
            return this._gateway;
        }

        protected RegionQueue initializeMessageQueue() {
            SingleWriteSingleReadRegionQueue queue = null;
            StringBuffer regionNameBuffer = new StringBuffer();
            regionNameBuffer.append(this.getGateway().getGatewayHubId()).append('_').append(this.getGateway().getId()).append("_EVENT_QUEUE");
            String regionName = regionNameBuffer.toString();
            SecondaryGatewayListener listener = null;
            if (!this.getGateway().getPrimary()) {
                listener = new SecondaryGatewayListener(this);
                this.initializeListenerExecutor();
            }
            queue = new SingleWriteSingleReadRegionQueue(this.getGateway().getCache(), regionName, this.getGateway().getQueueAttributes(), listener, this.getGateway().getStatistics());
            if (logger.isDebugEnabled()) {
                logger.debug("Created queue: {}", queue);
            }
            return queue;
        }

        protected GatewayEventDispatcher initializeEventDispatcher() {
            GatewayEventDispatcher dispatcher = null;
            dispatcher = this.getGateway().hasEndpoints() ? new GatewayEventRemoteDispatcher(this) : new GatewayEventCallbackDispatcher(this);
            return dispatcher;
        }

        private boolean stopped() {
            if (this._isStopped) {
                return true;
            }
            return GatewayImpl.this.stopper.cancelInProgress() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForPrimary() {
            try {
                this.getGateway().waitToBecomePrimary();
            }
            catch (InterruptedException e) {
                if (!this.stopped()) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_AN_INTERRUPTEDEXCEPTION_OCCURRED_THE_THREAD_WILL_EXIT), (Throwable)e);
                }
                this.shutdownListenerExecutor();
                return false;
            }
            try {
                this.shutdownListenerExecutor();
                DistributedSystem.setThreadsSocketPolicy(true);
                if (!this.stopped()) {
                    this.handleFailover();
                }
            }
            catch (RegionDestroyedException e) {
                if (!this.stopped() && logger.isDebugEnabled()) {
                    logger.debug("Terminating due to {}", (Throwable)e);
                }
                boolean bl = false;
                return bl;
            }
            catch (CancelException e) {
                if (!this.stopped() && logger.isDebugEnabled()) {
                    logger.debug("Terminating due to {}", (Throwable)e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                GatewayImpl.this.completeFailover();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            boolean isDebugEnabled = logger.isDebugEnabled();
            GatewayQueueAttributes gqa = this.getGateway().getQueueAttributes();
            int batchSize = gqa.getBatchSize();
            int batchTimeInterval = gqa.getBatchTimeInterval();
            int alertThreshold = gqa.getAlertThreshold();
            GatewayStats statistics = this.getGateway().getStatistics();
            List events = null;
            block10: while (!this.stopped()) {
                try {
                    if (this._isPaused) {
                        this.waitForResumption();
                    }
                    if (isDebugEnabled) {
                        logger.debug("Attempting to peek a batch of {} events", batchSize);
                    }
                    while (!this.stopped()) {
                        if (this._isPaused) {
                            this.waitForResumption();
                        }
                        boolean interrupted = Thread.interrupted();
                        try {
                            events = this._eventQueue.peek(batchSize, batchTimeInterval);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            GatewayImpl.this.getCancelCriterion().checkCancelInProgress(e);
                            continue;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        if (events.isEmpty()) continue;
                        List conflatedEvents = this.conflate(events);
                        this.logBatchDebug("During normal processing, dispatching the following ", events);
                        boolean success = this._eventDispatcher.dispatchBatch(conflatedEvents, true);
                        if (isDebugEnabled) {
                            logger.debug("During normal processing, {}successfully dispatched {} events (batch #{}) queue size={}", success ? "" : "un", conflatedEvents.size(), this.getBatchId(), this.eventQueueSize());
                        }
                        if (this.stopped()) continue block10;
                        if (success) {
                            this.eventQueueRemove(events.size());
                            int queueSize = this.eventQueueSize();
                            statistics.setQueueSize(queueSize);
                            if (alertThreshold > 0) {
                                Iterator it = conflatedEvents.iterator();
                                long currentTime = System.currentTimeMillis();
                                while (it.hasNext()) {
                                    GatewayEventImpl ge;
                                    Object o = it.next();
                                    if (o == null || !(o instanceof GatewayEventImpl) || (ge = (GatewayEventImpl)o).getCreationTime() + (long)alertThreshold >= currentTime) continue;
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_QUEUE_ALERT_OPERATION_0_REGION_1_KEY_2_VALUE_3_TIME_4, new Object[]{ge.getOperation(), ge.getRegionName(), ge.getKey(), ge.getDeserializedValueForLogging(), currentTime - ge.getCreationTime()}));
                                    statistics.incEventsExceedingAlertThreshold();
                                }
                            }
                            if (this._eventQueueSizeWarning && queueSize <= QUEUE_SIZE_THRESHOLD) {
                                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_THE_EVENT_QUEUE_SIZE_HAS_DROPPED_BELOW_THE_THRESHOLD_0, QUEUE_SIZE_THRESHOLD));
                                this._eventQueueSizeWarning = false;
                            }
                            this.incrementBatchId();
                        } else {
                            statistics.incBatchesRedistributed();
                            Iterator it = events.iterator();
                            while (it.hasNext() && !this._isStopped) {
                                Object o = it.next();
                                if (o == null || !(o instanceof GatewayEventImpl)) continue;
                                GatewayEventImpl ge = (GatewayEventImpl)o;
                                ge.setPossibleDuplicate(true);
                            }
                        }
                        if (!isDebugEnabled) continue;
                        logger.debug("Finished processing events (batch #{})", this.getBatchId());
                    }
                }
                catch (RegionDestroyedException e) {
                    if (this.stopped()) {
                        return;
                    }
                    logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_TERMINATED_DUE_TO_REGIONDESTROYEDEXCEPTION));
                    this.setIsStopped(true);
                }
                catch (CancelException e) {
                    this.setIsStopped(true);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable e) {
                    SystemFailure.checkFailure();
                    if (this.stopped()) {
                        return;
                    }
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_AN_EXCEPTION_OCCURRED_THE_DISPATCHER_WILL_CONTINUE), e);
                }
            }
        }

        private List conflate(List events) {
            ArrayList<GatewayEventImpl> conflatedEvents = null;
            if (this.getGateway().getQueueAttributes().getBatchConflation() && events.size() > 1) {
                LinkedHashMap<ConflationKey, GatewayEventImpl> conflatedEventsMap = new LinkedHashMap<ConflationKey, GatewayEventImpl>();
                conflatedEvents = new ArrayList<GatewayEventImpl>();
                for (GatewayEventImpl event : events) {
                    ConflationKey key2;
                    if (event.shouldBeConflated()) {
                        key2 = new ConflationKey(event.getRegionToConflate(), event.getKeyToConflate(), event.getOperation());
                        conflatedEventsMap.remove(key2);
                        conflatedEventsMap.put(key2, event);
                        continue;
                    }
                    key2 = new ConflationKey(event.getRegionToConflate(), event.getKeyToConflate(), event.getOperation());
                    conflatedEventsMap.put(key2, event);
                }
                for (GatewayEventImpl gei : conflatedEventsMap.values()) {
                    conflatedEvents.add(gei);
                }
                GatewayImpl.this.getStatistics().incEventsConflatedFromBatches(events.size() - conflatedEvents.size());
                this.logConflatedBatchDebug(events, conflatedEvents);
            } else {
                conflatedEvents = events;
            }
            return conflatedEvents;
        }

        private void logConflatedBatchDebug(List events, List conflatedEvents) {
            if (logger.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Conflated batch ").append(this.getBatchId()).append("\n\tFrom the original ").append(events.size()).append(" events:");
                Iterator i = events.iterator();
                while (i.hasNext()) {
                    builder.append("\n\t\t").append(i.next());
                }
                builder.append("\n\tTo the conflated ").append(conflatedEvents.size()).append(" events: ");
                i = conflatedEvents.iterator();
                while (i.hasNext()) {
                    builder.append("\n\t\t").append(i.next());
                }
                logger.debug(builder.toString());
            }
        }

        @Override
        public void run() {
            try {
                if (!this.getGateway().getPrimary()) {
                    if (!this.waitForPrimary()) {
                        return;
                    }
                } else {
                    GatewayImpl.this.completeFailover();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Beginning to process the message queue");
                }
                if (!this.getGateway().getPrimary()) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_ABOUT_TO_PROCESS_THE_MESSAGE_QUEUE_BUT_NOT_THE_PRIMARY));
                }
                try {
                    Thread.sleep(new Random().nextInt(1000));
                }
                catch (InterruptedException e) {
                    return;
                }
                this.processQueue();
            }
            catch (CancelException e) {
                if (!this._isStopped) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_A_CANCELLATION_OCCURRED_STOPPING_THE_DISPATCHER));
                    this.setIsStopped(true);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_MESSAGE_DISPATCH_FAILED_DUE_TO_UNEXPECTED_EXCEPTION), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleFailover() {
            Object object = this.unprocessedEventsLock;
            synchronized (object) {
                GatewayEventImpl ge;
                Object o;
                Iterator it;
                this._eventQueue.removeCacheListener();
                this.unprocessedTokens = null;
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_GATEWAY_FAILOVER_INITIATED_PROCESSING_0_UNPROCESSED_EVENTS, this.unprocessedEvents.size()));
                GatewayStats statistics = this.getGateway().getStatistics();
                statistics.setQueueSize(this.eventQueueSize());
                if (!this.unprocessedEvents.isEmpty()) {
                    this.reapOld(statistics, true);
                    it = this._eventQueue.getRegion().values().iterator();
                    while (!(!it.hasNext() || this.stopped() || (o = it.next()) != null && o instanceof GatewayEventImpl && this.unprocessedEvents.remove((ge = (GatewayEventImpl)o).getEventId()) != null && this.unprocessedEvents.isEmpty())) {
                    }
                    logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_GATEWAY_FAILOVER_INITIATED_ADDING_0_UNPROCESSED_EVENTS, this.unprocessedEvents.size()));
                    it = this.unprocessedEvents.values().iterator();
                    while (it.hasNext() && !this.stopped()) {
                        EventWrapper ew = (EventWrapper)it.next();
                        GatewayEventImpl gatewayEvent = ew.event;
                        try {
                            gatewayEvent.initialize();
                        }
                        catch (IOException e) {
                            logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_FAILED_TO_BE_INITIALIZED_0, gatewayEvent), (Throwable)e);
                        }
                        GatewayEventCallbackArgument geca = gatewayEvent.getGatewayCallbackArgument();
                        if (geca.getOriginatingGatewayHubId() == null) {
                            geca.setOriginatingGatewayHubId(this.getGateway().getGatewayHubId());
                            geca.initializeRecipientGateways(this.getGateway().getGatewayHub().getGatewayIds());
                        }
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug("{}: Queueing unprocessed event: {}", this.getGateway(), gatewayEvent);
                            }
                            this.queuePrimaryEvent(gatewayEvent);
                        }
                        catch (IOException ex) {
                            if (this.stopped()) continue;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_DROPPED_DURING_FAILOVER_0, gatewayEvent), (Throwable)ex);
                        }
                        catch (CacheException ex) {
                            if (this.stopped()) continue;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_DROPPED_DURING_FAILOVER_0, gatewayEvent), (Throwable)ex);
                        }
                    }
                    statistics.clearUnprocessedMaps();
                }
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0__MARKING__1__EVENTS_AS_POSSIBLE_DUPLICATES, new Object[]{this.getGateway(), this._eventQueue.size()}));
                it = this._eventQueue.getRegion().values().iterator();
                while (it.hasNext() && !this.stopped()) {
                    o = it.next();
                    if (o == null || !(o instanceof GatewayEventImpl)) continue;
                    ge = (GatewayEventImpl)o;
                    ge.setPossibleDuplicate(true);
                }
                this.unprocessedEvents = null;
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_GATEWAY_FAILOVER_COMPLETED));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void enqueueEvent(EnumListenerEvent operation, EntryEvent event) throws IOException, CacheException {
            GatewayEventImpl gatewayEvent = null;
            boolean isPrimary = this.getGateway().getPrimary();
            if (!isPrimary) {
                Object object = this.unprocessedEventsLock;
                synchronized (object) {
                    if (this.getGateway().getPrimary()) {
                        isPrimary = true;
                    } else {
                        gatewayEvent = new GatewayEventImpl(operation, event, false);
                        this.handleSecondaryEvent(gatewayEvent);
                    }
                }
            }
            if (isPrimary) {
                GatewayImpl.this.waitForFailoverCompletion();
                gatewayEvent = new GatewayEventImpl(operation, event);
                this.queuePrimaryEvent(gatewayEvent);
            }
        }

        private void queuePrimaryEvent(GatewayEventImpl gatewayEvent) throws IOException, CacheException {
            boolean isDebugEnabled = logger.isDebugEnabled();
            GatewayStats statistics = this.getGateway().getStatistics();
            if (isDebugEnabled) {
                logger.debug("{}: Queueing event ({}): {}", this.getGateway(), statistics.getEventsQueued() + 1, gatewayEvent);
            }
            long start = statistics.startTime();
            try {
                if (this.shouldEnqueue(gatewayEvent)) {
                    this._eventQueue.put(gatewayEvent);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                GatewayImpl.this.getCancelCriterion().checkCancelInProgress(e);
            }
            statistics.endPut(start);
            if (isDebugEnabled) {
                logger.debug("{}: Queued event ({}): ", this.getGateway(), statistics.getEventsQueued(), gatewayEvent);
            }
            int queueSize = this.eventQueueSize();
            statistics.setQueueSize(queueSize);
            if (!this._eventQueueSizeWarning && queueSize >= QUEUE_SIZE_THRESHOLD) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_THE_EVENT_QUEUE_SIZE_HAS_REACHED_THE_THRESHOLD_1, new Object[]{this.getGateway(), QUEUE_SIZE_THRESHOLD}));
                this._eventQueueSizeWarning = true;
            }
        }

        private boolean shouldEnqueue(GatewayEventImpl gatewayEvent) {
            LocalRegion region = (LocalRegion)gatewayEvent.getRegion();
            return GatewayImpl.this.hasEndpoints() || !region.isUsedForMetaRegion();
        }

        protected void handleSecondaryEvent(GatewayEventImpl gatewayEvent) {
            this.basicHandleSecondaryEvent(gatewayEvent);
        }

        protected void handlePrimaryEvent(final GatewayEventImpl gatewayEvent) {
            ExecutorService my_executor = this._executor;
            if (my_executor == null) {
                return;
            }
            my_executor.execute(new Runnable(){

                @Override
                public void run() {
                    GatewayEventProcessor.this.basicHandlePrimaryEvent(gatewayEvent);
                }
            });
        }

        protected void handlePrimaryDestroy(final GatewayEventImpl gatewayEvent) {
            ExecutorService my_executor = this._executor;
            if (my_executor == null) {
                return;
            }
            my_executor.execute(new Runnable(){

                @Override
                public void run() {
                    GatewayEventProcessor.this.basicHandlePrimaryDestroy(gatewayEvent);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void basicHandlePrimaryDestroy(GatewayEventImpl gatewayEvent) {
            if (GatewayImpl.this.getPrimary()) {
                return;
            }
            GatewayStats statistics = this.getGateway().getStatistics();
            Object object = this.unprocessedEventsLock;
            synchronized (object) {
                if (this.unprocessedEvents == null) {
                    return;
                }
                Object v = this.unprocessedEvents.remove(gatewayEvent.getEventId());
                if (v != null) {
                    statistics.incUnprocessedEventsRemovedByPrimary();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void basicHandlePrimaryEvent(GatewayEventImpl gatewayEvent) {
            if (GatewayImpl.this.getPrimary()) {
                return;
            }
            GatewayStats statistics = this.getGateway().getStatistics();
            Object object = this.unprocessedEventsLock;
            synchronized (object) {
                if (this.unprocessedEvents == null) {
                    return;
                }
                Object v = this.unprocessedEvents.remove(gatewayEvent.getEventId());
                if (v == null) {
                    if (logger.isTraceEnabled()) {
                        try {
                            gatewayEvent.initialize();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        logger.trace("{}: fromPrimary event {}:{}->{} added to unprocessed token map.", GatewayImpl.this, gatewayEvent.getEventId(), gatewayEvent.getKey(), this.deserialize(gatewayEvent.getValue()));
                    }
                    Long mapValue = System.currentTimeMillis() + (long)TOKEN_TIMEOUT;
                    Long oldv = this.unprocessedTokens.put(gatewayEvent.getEventId(), mapValue);
                    if (oldv == null) {
                        statistics.incUnprocessedTokensAddedByPrimary();
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        try {
                            gatewayEvent.initialize();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        logger.trace("{}: Primary create/update event {}:{}->{} removed from unprocessed events map", GatewayImpl.this, gatewayEvent.getEventId(), gatewayEvent.getKey(), this.deserialize(gatewayEvent.getValue()));
                    }
                    statistics.incUnprocessedEventsRemovedByPrimary();
                }
                this.reapOld(statistics, false);
            }
        }

        private void basicHandleSecondaryEvent(GatewayEventImpl gatewayEvent) {
            GatewayStats statistics = this.getGateway().getStatistics();
            Assert.assertHoldsLock(this.unprocessedEventsLock, true);
            Assert.assertTrue(this.unprocessedEvents != null);
            Object v = this.unprocessedTokens.remove(gatewayEvent.getEventId());
            if (v == null) {
                if (logger.isTraceEnabled()) {
                    try {
                        gatewayEvent.initialize();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    logger.trace("{}: fromSecondary event {}:{}->{} added to unprocessed token map.", GatewayImpl.this, gatewayEvent.getEventId(), gatewayEvent.getKey(), this.deserialize(gatewayEvent.getValue()));
                }
                EventWrapper mapValue = new EventWrapper(gatewayEvent);
                EventWrapper oldv = this.unprocessedEvents.put(gatewayEvent.getEventId(), mapValue);
                if (oldv == null) {
                    statistics.incUnprocessedEventsAddedBySecondary();
                } else {
                    this.unprocessedEvents.put(gatewayEvent.getEventId(), oldv);
                    if (logger.isWarnEnabled()) {
                        try {
                            gatewayEvent.initialize();
                        }
                        catch (IOException e) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_FAILED_TO_BE_INITIALIZED_0, gatewayEvent), (Throwable)e);
                        }
                        logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_THE_UNPROCESSED_EVENTS_MAP_ALREADY_CONTAINED_AN_EVENT_FROM_THE_HUB_1_SO_IGNORING_NEW_EVENT_2, new Object[]{GatewayImpl.this, GatewayImpl.this.getGatewayHubId(), gatewayEvent}));
                    }
                }
            } else {
                if (logger.isTraceEnabled()) {
                    try {
                        gatewayEvent.initialize();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    logger.trace("{}: Secondary created event {}:{}->{} removed from unprocessed token map", GatewayImpl.this, gatewayEvent.getEventId(), gatewayEvent.getKey(), this.deserialize(gatewayEvent.getValue()));
                }
                statistics.incUnprocessedTokensRemovedBySecondary();
            }
            this.reapOld(statistics, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reapOld(GatewayStats statistics, boolean forceEventReap) {
            Object object = this.unprocessedEventsLock;
            synchronized (object) {
                if (this.uncheckedCount > 1000) {
                    Map.Entry me;
                    int count;
                    Iterator it;
                    this.uncheckedCount = 0;
                    long now = System.currentTimeMillis();
                    if (!forceEventReap && this.unprocessedTokens.size() > 1000) {
                        long meValue;
                        it = this.unprocessedTokens.entrySet().iterator();
                        count = 0;
                        while (it.hasNext() && (meValue = ((Long)(me = it.next()).getValue()).longValue()) <= now) {
                            it.remove();
                            ++count;
                        }
                        if (count > 0) {
                            statistics.incUnprocessedTokensRemovedByTimeout(count);
                        }
                    }
                    if (forceEventReap || this.unprocessedEvents.size() > 1000) {
                        it = this.unprocessedEvents.entrySet().iterator();
                        count = 0;
                        while (it.hasNext()) {
                            me = it.next();
                            EventWrapper ew = (EventWrapper)me.getValue();
                            if (ew.timeout > now) break;
                            it.remove();
                            ++count;
                        }
                        if (count > 0) {
                            statistics.incUnprocessedEventsRemovedByTimeout(count);
                        }
                    }
                } else {
                    ++this.uncheckedCount;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitForResumption() throws InterruptedException {
            Object object = this._pausedLock;
            synchronized (object) {
                if (!this._isPaused) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Pausing processing", this);
                }
                while (this._isPaused) {
                    this._pausedLock.wait();
                }
            }
        }

        protected void logBatchDebug(String message, List events) {
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(message);
                buffer.append(events.size()).append(" events");
                buffer.append(" (batch #" + this.getBatchId());
                buffer.append("):\n");
                for (GatewayEventImpl ge : events) {
                    buffer.append("\tEvent ").append(ge.getEventId()).append(":");
                    buffer.append(ge.getKey()).append("->");
                    buffer.append(ge.getDeserializedValueForLogging());
                    buffer.append("\n");
                }
                logger.debug(buffer.toString());
            }
        }

        protected Object deserialize(byte[] serializedBytes) {
            Object deserializedObject = serializedBytes;
            try {
                deserializedObject = EntryEventImpl.deserialize(serializedBytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return deserializedObject;
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            GatewayQueueAttributes gqa = this.getGateway().getQueueAttributesNoSync();
            buffer.append("GatewayEventProcessor[").append("gatewayId=").append(this.getGateway().getId()).append(";gatewayHubId=").append(this.getGateway().getGatewayHubId());
            if (gqa.getDiskStoreName() != null) {
                buffer.append(";diskStoreName=").append(gqa.getDiskStoreName());
            } else {
                buffer.append(";overflowDirectory=").append(gqa.getOverflowDirectory());
            }
            buffer.append(";batchSize=").append(gqa.getBatchSize()).append(";batchTimeInterval=").append(gqa.getBatchTimeInterval()).append(";batchConflation=").append(gqa.getBatchConflation()).append(";enablePersistence=").append(gqa.getEnablePersistence()).append("]");
            return buffer.toString();
        }

        private void initializeListenerExecutor() {
            final LoggingThreadGroup loggerGroup = LoggingThreadGroup.createThreadGroup("Gateway Listener Group", logger);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable command) {
                    Thread thread = new Thread(loggerGroup, command, "Queued Gateway Listener Thread");
                    thread.setDaemon(true);
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
            this._executor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, q, tf);
        }

        private void shutdownListenerExecutor() {
            if (this._executor != null) {
                this._executor.shutdown();
                this._executor = null;
            }
        }
    }

    protected static class EndpointImpl
    implements Gateway.Endpoint {
        protected String _myid;
        protected String _host;
        protected int _port;

        protected EndpointImpl(String id, String host, int port) {
            this._myid = id;
            this._host = host;
            this._port = port;
        }

        @Override
        public String getId() {
            return this._myid;
        }

        @Override
        public String getHost() {
            return this._host;
        }

        @Override
        public int getPort() {
            return this._port;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this._myid).append("=").append(this._host).append(":").append(this._port);
            return buffer.toString();
        }
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            String reason = GatewayImpl.this._hub.getCancelCriterion().cancelInProgress();
            if (reason != null) {
                return reason;
            }
            if (GatewayImpl.this._isRunning) {
                return null;
            }
            return "Gateway has been stopped";
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            RuntimeException result = GatewayImpl.this._hub.getCancelCriterion().generateCancelledException(e);
            if (result != null) {
                return result;
            }
            return new GatewayCancelledException("Gateway has been stopped");
        }
    }
}

