/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.internal.cache.AbstractGateway;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GatewayEventFilter;
import com.gemstone.gemfire.internal.cache.GatewayHubImpl;
import com.gemstone.gemfire.internal.cache.GatewayImpl;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class GatewayParallelImpl
extends AbstractGateway {
    private static final Logger logger = LogService.getLogger();
    private final List<Gateway> gateways = new ArrayList<Gateway>();
    private final Object controlLock = new Object();

    GatewayParallelImpl(GatewayHubImpl hub, String id, int concurrencyLevel) {
        super(hub, id, id + ".rollup", null);
        this.setOrderPolicy(Gateway.OrderPolicy.KEY);
        this.initializeGateways(concurrencyLevel);
    }

    @Override
    public void addEndpoint(String id, String host, int port) throws GatewayException {
        for (Gateway gateway : this.getGateways()) {
            gateway.addEndpoint(id, host, port);
        }
    }

    @Override
    public List getEndpoints() {
        List endpoints = null;
        endpoints = this.getGateways().isEmpty() ? Collections.emptyList() : this.getGateways().get(0).getEndpoints();
        return endpoints;
    }

    @Override
    public boolean hasEndpoints() {
        boolean hasEndpoints = false;
        if (!this.getGateways().isEmpty()) {
            hasEndpoints = this.getGateways().get(0).hasEndpoints();
        }
        return hasEndpoints;
    }

    @Override
    public void addListener(GatewayEventListener listener) throws GatewayException {
        for (Gateway gateway : this.getGateways()) {
            gateway.addListener(listener);
        }
    }

    @Override
    public List<GatewayEventListener> getListeners() {
        List<GatewayEventListener> listeners = null;
        listeners = this.getGateways().isEmpty() ? Collections.emptyList() : this.getGateways().get(0).getListeners();
        return listeners;
    }

    @Override
    public boolean hasListeners() {
        boolean hasListeners = false;
        if (!this.getGateways().isEmpty()) {
            hasListeners = this.getGateways().get(0).hasListeners();
        }
        return hasListeners;
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        for (Gateway gateway : this.getGateways()) {
            gateway.setSocketBufferSize(socketBufferSize);
        }
    }

    @Override
    public int getSocketBufferSize() {
        int socketBufferSize = 0;
        if (!this.getGateways().isEmpty()) {
            socketBufferSize = this.getGateways().get(0).getSocketBufferSize();
        }
        return socketBufferSize;
    }

    @Override
    public void setSocketReadTimeout(int socketReadTimeout) {
        for (Gateway gateway : this.getGateways()) {
            gateway.setSocketReadTimeout(socketReadTimeout);
        }
    }

    @Override
    public int getSocketReadTimeout() {
        int socketReadTimeout = 0;
        if (!this.getGateways().isEmpty()) {
            socketReadTimeout = this.getGateways().get(0).getSocketReadTimeout();
        }
        return socketReadTimeout;
    }

    public void setGatewayEventFilter(GatewayEventFilter filter) {
        for (Gateway gateway : this.getGateways()) {
            ((GatewayImpl)gateway).setGatewayEventFilter(filter);
        }
    }

    @Override
    public void setQueueAttributes(GatewayQueueAttributes queueAttributes) {
        for (Gateway gateway : this.getGateways()) {
            gateway.setQueueAttributes(queueAttributes);
        }
    }

    @Override
    public GatewayQueueAttributes getQueueAttributes() {
        GatewayQueueAttributes queueAttributes = null;
        if (!this.getGateways().isEmpty()) {
            queueAttributes = this.getGateways().get(0).getQueueAttributes();
        }
        return queueAttributes;
    }

    @Override
    public int getConcurrencyLevel() {
        return this.getGateways().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        Object object = this.controlLock;
        synchronized (object) {
            if (this._isRunning) {
                return;
            }
            if (this.getStatistics().isClosed()) {
                this.setStatistics(new GatewayStats(this._cache.getDistributedSystem(), this.getGatewayHubId(), this.getId() + ".rollup", null));
            }
            for (Gateway gateway : this.getGateways()) {
                ((GatewayImpl)gateway).start(this);
            }
            this._isRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.controlLock;
        synchronized (object) {
            if (!this._isRunning) {
                return;
            }
            for (Gateway gateway : this.getGateways()) {
                gateway.stop();
            }
            this._isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.controlLock;
        synchronized (object) {
            boolean isConnected = false;
            if (!this.getGateways().isEmpty()) {
                isConnected = this.getGateways().get(0).isConnected();
            }
            return isConnected;
        }
    }

    @Override
    public int getQueueSize() {
        int queueSize = 0;
        for (Gateway gateway : this.getGateways()) {
            queueSize += gateway.getQueueSize();
        }
        return queueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.controlLock;
        synchronized (object) {
            for (Gateway gateway : this.getGateways()) {
                gateway.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.controlLock;
        synchronized (object) {
            for (Gateway gateway : this.getGateways()) {
                gateway.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPaused() {
        Object object = this.controlLock;
        synchronized (object) {
            boolean isPaused = false;
            if (!this.getGateways().isEmpty()) {
                isPaused = this.getGateways().get(0).isPaused();
            }
            return isPaused;
        }
    }

    public String toString() {
        return "Parallel Gateway to " + this._id;
    }

    @Override
    protected void setPrimary(boolean primary) {
        for (Gateway gateway : this.getGateways()) {
            ((GatewayImpl)gateway).setPrimary(primary);
        }
    }

    @Override
    public void emergencyClose() {
        for (Gateway gateway : this.getGateways()) {
            ((GatewayImpl)gateway).emergencyClose();
        }
    }

    @Override
    protected void becomePrimary() {
        for (Gateway gateway : this.getGateways()) {
            ((GatewayImpl)gateway).becomePrimary();
        }
    }

    @Override
    protected void distribute(EnumListenerEvent operation, EntryEventImpl event) {
        if (event.isOnPdxTypeRegion()) {
            for (int i = 0; i < this.getGateways().size(); ++i) {
                this.distribute(operation, event, i);
            }
        } else {
            int index2 = Math.abs(this.getHashCode(event) % this.getGateways().size());
            this.distribute(operation, event, index2);
        }
    }

    private void distribute(EnumListenerEvent operation, EntryEventImpl event, int index2) {
        AbstractGateway gateway = (AbstractGateway)this.getGateways().get(index2);
        if (this.getOrderPolicy() == Gateway.OrderPolicy.KEY || this.getOrderPolicy() == Gateway.OrderPolicy.PARTITION) {
            EntryEventImpl clonedEvent = new EntryEventImpl(event);
            EventID originalEventId = clonedEvent.getEventId();
            long newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGateway(index2, originalEventId.getThreadID(), 0);
            EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Generated event id for event with key={}, index={}, original event id={}, threadId={}, new event id={}, newThreadId={}", this, event.getKey(), index2, originalEventId, originalEventId.getThreadID(), newEventId, newThreadId);
            }
            clonedEvent.setEventId(newEventId);
            gateway.distribute(operation, clonedEvent);
        } else {
            gateway.distribute(operation, event);
        }
    }

    private int getHashCode(EntryEventImpl event) {
        int eventHashCode = 0;
        switch (this.getOrderPolicy()) {
            case KEY: {
                eventHashCode = event.getKey().hashCode();
                if (!logger.isDebugEnabled()) break;
                logger.debug("{}: Generated key hashcode for event with key={}: {}", this, event.getKey(), eventHashCode);
                break;
            }
            case THREAD: {
                EventID eventId = event.getEventId();
                byte[] memberId = eventId.getMembershipID();
                long threadId = eventId.getThreadID();
                int memberIdHashCode = Arrays.hashCode(memberId);
                int threadIdHashCode = (int)(threadId ^ threadId >>> 32);
                eventHashCode = memberIdHashCode + threadIdHashCode;
                if (!logger.isDebugEnabled()) break;
                logger.debug("{}: Generated thread hashcode for event with key={}, memberId={}, threadId={}: {}", this, event.getKey(), Arrays.toString(memberId), threadId, eventHashCode);
                break;
            }
            case PARTITION: {
                int n = eventHashCode = PartitionRegionHelper.isPartitionedRegion(event.getRegion()) ? PartitionedRegionHelper.getHashKey(event) : event.getKey().hashCode();
                if (!logger.isDebugEnabled()) break;
                logger.debug("{}: Generated partition hashcode for event with key={}: {}", this, event.getKey(), eventHashCode);
            }
        }
        return eventHashCode;
    }

    public List<Gateway> getGateways() {
        return this.gateways;
    }

    private void initializeGateways(int concurrencyLevel) {
        for (int i = 0; i < concurrencyLevel; ++i) {
            GatewayImpl gateway = new GatewayImpl((GatewayHubImpl)this.getGatewayHub(), this.getId() + "." + i, true, this.getStatistics());
            this.getGateways().add(gateway);
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Gateway> i = this.getGateways().iterator();
        while (i.hasNext()) {
            Gateway gateway = i.next();
            builder.append(gateway.getId());
            if (!i.hasNext()) continue;
            builder.append(", ");
        }
        Object[] args = new Object[]{this.toString(), concurrencyLevel, builder.toString()};
        logger.info(LocalizedMessage.create(LocalizedStrings.GatewayParallel_0_CREATED_1_GATEWAYS_2, args));
    }
}

