/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GatewayStats {
    public static final String typeName = "GatewayStatistics";
    private static final StatisticsType _type;
    private static final String EVENTS_QUEUED = "eventsQueued";
    private static final String EVENTS_NOT_QUEUED_CONFLATED = "eventsNotQueuedConflated";
    private static final String EVENT_QUEUE_TIME = "eventQueueTime";
    private static final String EVENT_QUEUE_SIZE = "eventQueueSize";
    private static final String EVENTS_DISTRIBUTED = "eventsDistributed";
    private static final String EVENTS_EXCEEDING_ALERT_THRESHOLD = "eventsExceedingAlertThreshold";
    private static final String BATCH_DISTRIBUTION_TIME = "batchDistributionTime";
    private static final String BATCHES_DISTRIBUTED = "batchesDistributed";
    private static final String BATCHES_REDISTRIBUTED = "batchesRedistributed";
    private static final String UNPROCESSED_TOKENS_ADDED_BY_PRIMARY = "unprocessedTokensAddedByPrimary";
    private static final String UNPROCESSED_EVENTS_ADDED_BY_SECONDARY = "unprocessedEventsAddedBySecondary";
    private static final String UNPROCESSED_EVENTS_REMOVED_BY_PRIMARY = "unprocessedEventsRemovedByPrimary";
    private static final String UNPROCESSED_TOKENS_REMOVED_BY_SECONDARY = "unprocessedTokensRemovedBySecondary";
    private static final String UNPROCESSED_EVENTS_REMOVED_BY_TIMEOUT = "unprocessedEventsRemovedByTimeout";
    private static final String UNPROCESSED_TOKENS_REMOVED_BY_TIMEOUT = "unprocessedTokensRemovedByTimeout";
    private static final String UNPROCESSED_EVENT_MAP_SIZE = "unprocessedEventMapSize";
    private static final String UNPROCESSED_TOKEN_MAP_SIZE = "unprocessedTokenMapSize";
    private static final String CONFLATION_INDEXES_MAP_SIZE = "conflationIndexesSize";
    private static final String SENT_BYTES = "sentBytes";
    private static final String EVENTS_CONFLATED_FROM_BATCHES = "eventsConflatedFromBatches";
    private static final int _eventsQueuedId;
    private static final int _eventsNotQueuedConflatedId;
    private static final int _eventQueueTimeId;
    private static final int _eventQueueSizeId;
    private static final int _eventsDistributedId;
    private static final int _eventsExceedingAlertThresholdId;
    private static final int _batchDistributionTimeId;
    private static final int _batchesDistributedId;
    private static final int _batchesRedistributedId;
    private static final int _unprocessedTokensAddedByPrimaryId;
    private static final int _unprocessedEventsAddedBySecondaryId;
    private static final int _unprocessedEventsRemovedByPrimaryId;
    private static final int _unprocessedTokensRemovedBySecondaryId;
    private static final int _unprocessedEventsRemovedByTimeoutId;
    private static final int _unprocessedTokensRemovedByTimeoutId;
    private static final int _unprocessedEventMapSizeId;
    private static final int _unprocessedTokenMapSizeId;
    private static final int _conflationIndexesMapSizeId;
    private static final int _sentBytesId;
    private static final int _eventsConflatedFromBatchesId;
    private final Statistics _stats;
    private final GatewayStats _rollupStatistics;
    private Map<String, Integer> allQueueSizes = new ConcurrentHashMap<String, Integer>();

    public GatewayStats(StatisticsFactory f, String gatewayHubId, String gatewayId, GatewayStats rollupStatistics) {
        this._stats = f.createAtomicStatistics(_type, "gatewayStats-" + gatewayHubId + "-" + gatewayId);
        this._rollupStatistics = rollupStatistics;
    }

    public void close() {
        this._stats.close();
    }

    public boolean isClosed() {
        return this._stats.isClosed();
    }

    public int getEventsQueued() {
        return this._stats.getInt(_eventsQueuedId);
    }

    public int getEventsNotQueuedConflated() {
        return this._stats.getInt(_eventsNotQueuedConflatedId);
    }

    public int getEventsConflatedFromBatches() {
        return this._stats.getInt(_eventsConflatedFromBatchesId);
    }

    public int getEventQueueSize() {
        return this._stats.getInt(_eventQueueSizeId);
    }

    public int getEventsDistributed() {
        return this._stats.getInt(_eventsDistributedId);
    }

    public int getEventsExceedingAlertThreshold() {
        return this._stats.getInt(_eventsExceedingAlertThresholdId);
    }

    public void incEventsExceedingAlertThreshold() {
        this._stats.incInt(_eventsExceedingAlertThresholdId, 1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incEventsExceedingAlertThreshold();
        }
    }

    public long getBatchDistributionTime() {
        return this._stats.getLong(_batchDistributionTimeId);
    }

    public int getBatchesDistributed() {
        return this._stats.getInt(_batchesDistributedId);
    }

    public int getBatchesRedistributed() {
        return this._stats.getInt(_batchesRedistributedId);
    }

    public void incBatchesRedistributed() {
        this._stats.incInt(_batchesRedistributedId, 1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incBatchesRedistributed();
        }
    }

    public void setQueueSize(int size2) {
        this._stats.setInt(_eventQueueSizeId, size2);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.setQueueSize(this._stats.getTextId(), size2);
        }
    }

    private void setQueueSize(String gatewayStatsName, int size2) {
        this.allQueueSizes.put(gatewayStatsName, size2);
        int allQueuesSize = 0;
        for (Integer queueSize : this.allQueueSizes.values()) {
            allQueuesSize += queueSize.intValue();
        }
        this.setQueueSize(allQueuesSize);
    }

    public void incEventsNotQueuedConflated() {
        this._stats.incInt(_eventsNotQueuedConflatedId, 1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incEventsNotQueuedConflated();
        }
    }

    public void incEventsConflatedFromBatches(int numEvents) {
        this._stats.incInt(_eventsConflatedFromBatchesId, numEvents);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incEventsConflatedFromBatches(numEvents);
        }
    }

    public int getUnprocessedTokensAddedByPrimary() {
        return this._stats.getInt(_unprocessedTokensAddedByPrimaryId);
    }

    public int getUnprocessedEventsAddedBySecondary() {
        return this._stats.getInt(_unprocessedEventsAddedBySecondaryId);
    }

    public int getUnprocessedEventsRemovedByPrimary() {
        return this._stats.getInt(_unprocessedEventsRemovedByPrimaryId);
    }

    public int getUnprocessedTokensRemovedBySecondary() {
        return this._stats.getInt(_unprocessedTokensRemovedBySecondaryId);
    }

    public int getUnprocessedEventMapSize() {
        return this._stats.getInt(_unprocessedEventMapSizeId);
    }

    public int getUnprocessedTokenMapSize() {
        return this._stats.getInt(_unprocessedTokenMapSizeId);
    }

    public void incUnprocessedTokensAddedByPrimary() {
        this._stats.incInt(_unprocessedTokensAddedByPrimaryId, 1);
        this.incUnprocessedTokenMapSize();
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incUnprocessedTokensAddedByPrimary();
        }
    }

    public void incUnprocessedEventsAddedBySecondary() {
        this._stats.incInt(_unprocessedEventsAddedBySecondaryId, 1);
        this.incUnprocessedEventMapSize();
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incUnprocessedEventsAddedBySecondary();
        }
    }

    public void incUnprocessedEventsRemovedByPrimary() {
        this._stats.incInt(_unprocessedEventsRemovedByPrimaryId, 1);
        this.decUnprocessedEventMapSize();
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incUnprocessedEventsRemovedByPrimary();
        }
    }

    public void incUnprocessedTokensRemovedBySecondary() {
        this._stats.incInt(_unprocessedTokensRemovedBySecondaryId, 1);
        this.decUnprocessedTokenMapSize();
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incUnprocessedTokensRemovedBySecondary();
        }
    }

    public void incUnprocessedEventsRemovedByTimeout(int count) {
        this._stats.incInt(_unprocessedEventsRemovedByTimeoutId, count);
        this.decUnprocessedEventMapSize(count);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incUnprocessedEventsRemovedByTimeout(count);
        }
    }

    public void incUnprocessedTokensRemovedByTimeout(int count) {
        this._stats.incInt(_unprocessedTokensRemovedByTimeoutId, count);
        this.decUnprocessedTokenMapSize(count);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incUnprocessedTokensRemovedByTimeout(count);
        }
    }

    public void clearUnprocessedMaps() {
        this._stats.setInt(_unprocessedEventMapSizeId, 0);
        this._stats.setInt(_unprocessedTokenMapSizeId, 0);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.clearUnprocessedMaps();
        }
    }

    private void incUnprocessedEventMapSize() {
        this._stats.incInt(_unprocessedEventMapSizeId, 1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incUnprocessedEventMapSize();
        }
    }

    private void decUnprocessedEventMapSize() {
        this._stats.incInt(_unprocessedEventMapSizeId, -1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.decUnprocessedEventMapSize();
        }
    }

    private void decUnprocessedEventMapSize(int decCount) {
        this._stats.incInt(_unprocessedEventMapSizeId, -decCount);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.decUnprocessedEventMapSize(decCount);
        }
    }

    private void incUnprocessedTokenMapSize() {
        this._stats.incInt(_unprocessedTokenMapSizeId, 1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incUnprocessedTokenMapSize();
        }
    }

    private void decUnprocessedTokenMapSize() {
        this._stats.incInt(_unprocessedTokenMapSizeId, -1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.decUnprocessedTokenMapSize();
        }
    }

    private void decUnprocessedTokenMapSize(int decCount) {
        this._stats.incInt(_unprocessedTokenMapSizeId, -decCount);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.decUnprocessedTokenMapSize(decCount);
        }
    }

    public void incConflationIndexesMapSize() {
        this._stats.incInt(_conflationIndexesMapSizeId, 1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incConflationIndexesMapSize();
        }
    }

    public void decConflationIndexesMapSize() {
        this._stats.incInt(_conflationIndexesMapSizeId, -1);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.decConflationIndexesMapSize();
        }
    }

    public long startTime() {
        return DistributionStats.getStatTime();
    }

    public void endBatch(long start, int numberOfEvents) {
        long end = DistributionStats.getStatTime();
        this.endBatch(start, end, numberOfEvents);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.endBatch(start, end, numberOfEvents);
        }
    }

    private void endBatch(long start, long end, int numberOfEvents) {
        this._stats.incInt(_batchesDistributedId, 1);
        this._stats.incInt(_eventsDistributedId, numberOfEvents);
        long elapsed = end - start;
        this._stats.incLong(_batchDistributionTimeId, elapsed);
    }

    public void endPut(long start) {
        long end = DistributionStats.getStatTime();
        this.endPut(start, end);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.endPut(start, end);
        }
    }

    private void endPut(long start, long end) {
        this._stats.incInt(_eventsQueuedId, 1);
        long elapsed = end - start;
        this._stats.incLong(_eventQueueTimeId, elapsed);
    }

    public static int getEventQueueSizeId() {
        return _eventQueueSizeId;
    }

    public void incSentBytes(long v) {
        this._stats.incLong(_sentBytesId, v);
        if (this._rollupStatistics != null) {
            this._rollupStatistics.incSentBytes(v);
        }
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        _type = f.createType(typeName, typeName, new StatisticDescriptor[]{f.createIntCounter(EVENTS_QUEUED, "Number of events added to the event queue.", "operations"), f.createLongCounter(EVENT_QUEUE_TIME, "Total time spent queueing events.", "nanoseconds"), f.createIntGauge(EVENT_QUEUE_SIZE, "Size of the event queue.", "operations"), f.createIntCounter(EVENTS_NOT_QUEUED_CONFLATED, "Number of events received but not added to the event queue because the queue already contains an event with the event's key.", "operations"), f.createIntCounter(EVENTS_CONFLATED_FROM_BATCHES, "Number of events conflated from batches.", "operations"), f.createIntCounter(EVENTS_DISTRIBUTED, "Number of events removed from the event queue and sent.", "operations"), f.createIntCounter(EVENTS_EXCEEDING_ALERT_THRESHOLD, "Number of events exceeding the alert threshold.", "operations"), f.createLongCounter(BATCH_DISTRIBUTION_TIME, "Total time spent distributing batches of events to other gateways.", "nanoseconds"), f.createIntCounter(BATCHES_DISTRIBUTED, "Number of batches of events removed from the event queue and sent.", "operations"), f.createIntCounter(BATCHES_REDISTRIBUTED, "Number of batches of events removed from the event queue and resent.", "operations"), f.createIntCounter(UNPROCESSED_TOKENS_ADDED_BY_PRIMARY, "Number of tokens added to the secondary's unprocessed token map by the primary (though a listener).", "tokens"), f.createIntCounter(UNPROCESSED_EVENTS_ADDED_BY_SECONDARY, "Number of events added to the secondary's unprocessed event map by the secondary.", "events"), f.createIntCounter(UNPROCESSED_EVENTS_REMOVED_BY_PRIMARY, "Number of events removed from the secondary's unprocessed event map by the primary (though a listener).", "events"), f.createIntCounter(UNPROCESSED_TOKENS_REMOVED_BY_SECONDARY, "Number of tokens removed from the secondary's unprocessed token map by the secondary.", "tokens"), f.createIntCounter(UNPROCESSED_EVENTS_REMOVED_BY_TIMEOUT, "Number of events removed from the secondary's unprocessed event map by a timeout.", "events"), f.createIntCounter(UNPROCESSED_TOKENS_REMOVED_BY_TIMEOUT, "Number of tokens removed from the secondary's unprocessed token map by a timeout.", "tokens"), f.createIntGauge(UNPROCESSED_EVENT_MAP_SIZE, "Current number of entries in the secondary's unprocessed event map.", "events"), f.createIntGauge(UNPROCESSED_TOKEN_MAP_SIZE, "Current number of entries in the secondary's unprocessed token map.", "tokens"), f.createIntGauge(CONFLATION_INDEXES_MAP_SIZE, "Current number of entries in the conflation indexes map.", "events"), f.createLongCounter(SENT_BYTES, "Total number of bytes sent to the remote site.", "bytes")});
        _eventsQueuedId = _type.nameToId(EVENTS_QUEUED);
        _eventsNotQueuedConflatedId = _type.nameToId(EVENTS_NOT_QUEUED_CONFLATED);
        _eventQueueTimeId = _type.nameToId(EVENT_QUEUE_TIME);
        _eventQueueSizeId = _type.nameToId(EVENT_QUEUE_SIZE);
        _eventsDistributedId = _type.nameToId(EVENTS_DISTRIBUTED);
        _eventsExceedingAlertThresholdId = _type.nameToId(EVENTS_EXCEEDING_ALERT_THRESHOLD);
        _batchDistributionTimeId = _type.nameToId(BATCH_DISTRIBUTION_TIME);
        _batchesDistributedId = _type.nameToId(BATCHES_DISTRIBUTED);
        _batchesRedistributedId = _type.nameToId(BATCHES_REDISTRIBUTED);
        _unprocessedTokensAddedByPrimaryId = _type.nameToId(UNPROCESSED_TOKENS_ADDED_BY_PRIMARY);
        _unprocessedEventsAddedBySecondaryId = _type.nameToId(UNPROCESSED_EVENTS_ADDED_BY_SECONDARY);
        _unprocessedEventsRemovedByPrimaryId = _type.nameToId(UNPROCESSED_EVENTS_REMOVED_BY_PRIMARY);
        _unprocessedTokensRemovedBySecondaryId = _type.nameToId(UNPROCESSED_TOKENS_REMOVED_BY_SECONDARY);
        _unprocessedEventsRemovedByTimeoutId = _type.nameToId(UNPROCESSED_EVENTS_REMOVED_BY_TIMEOUT);
        _unprocessedTokensRemovedByTimeoutId = _type.nameToId(UNPROCESSED_TOKENS_REMOVED_BY_TIMEOUT);
        _unprocessedEventMapSizeId = _type.nameToId(UNPROCESSED_EVENT_MAP_SIZE);
        _unprocessedTokenMapSizeId = _type.nameToId(UNPROCESSED_TOKEN_MAP_SIZE);
        _conflationIndexesMapSizeId = _type.nameToId(CONFLATION_INDEXES_MAP_SIZE);
        _sentBytesId = _type.nameToId(SENT_BYTES);
        _eventsConflatedFromBatchesId = _type.nameToId(EVENTS_CONFLATED_FROM_BATCHES);
    }
}

