/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.ServerLocator;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BridgeServerAdvisor;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.ControllerAdvisor;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class GridAdvisor
extends DistributionAdvisor {
    private final Object cacheLock = new Object();
    private volatile List cachedBridgeServerProfiles;
    private volatile List cachedControllerProfiles;
    private volatile Set cachedBridgeServerAdvise;
    private volatile Set cachedControllerAdvise;
    private static final DistributionAdvisor.Filter CONTROLLER_FILTER = new DistributionAdvisor.Filter(){

        @Override
        public boolean include(DistributionAdvisor.Profile profile) {
            return profile instanceof ControllerAdvisor.ControllerProfile;
        }
    };
    private static final DistributionAdvisor.Filter BRIDGE_SERVER_FILTER = new DistributionAdvisor.Filter(){

        @Override
        public boolean include(DistributionAdvisor.Profile profile) {
            return profile instanceof BridgeServerAdvisor.BridgeServerProfile;
        }
    };

    protected GridAdvisor(DistributionAdvisee server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set adviseControllers() {
        Set<InternalDistributedMember> result = this.cachedControllerAdvise;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                result = this.cachedControllerAdvise;
                if (result == null) {
                    this.cachedControllerAdvise = result = Collections.unmodifiableSet(this.adviseFilter(CONTROLLER_FILTER));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set adviseBridgeServers() {
        Set<InternalDistributedMember> result = this.cachedBridgeServerAdvise;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                result = this.cachedBridgeServerAdvise;
                if (result == null) {
                    this.cachedBridgeServerAdvise = result = Collections.unmodifiableSet(this.adviseFilter(BRIDGE_SERVER_FILTER));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List fetchBridgeServers() {
        List result = null;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (result == null) {
                    this.cachedBridgeServerProfiles = result = this.fetchProfiles(BRIDGE_SERVER_FILTER);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List fetchControllers() {
        List result = this.cachedControllerProfiles;
        if (result == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                result = this.cachedControllerProfiles;
                if (result == null) {
                    this.cachedControllerProfiles = result = this.fetchProfiles(CONTROLLER_FILTER);
                }
            }
        }
        return result;
    }

    public int getBridgeServerCount() {
        List l = this.cachedBridgeServerProfiles;
        if (l == null) {
            l = this.fetchProfiles(BRIDGE_SERVER_FILTER);
        }
        return l.size();
    }

    public int getControllerCount() {
        List l = this.cachedControllerProfiles;
        if (l == null) {
            l = this.fetchProfiles(CONTROLLER_FILTER);
        }
        return l.size();
    }

    @Override
    public boolean useAdminMembersForDefault() {
        return true;
    }

    @Override
    protected boolean isCurrentMember(DistributionAdvisor.Profile p) {
        return true;
    }

    @Override
    protected void profileCreated(DistributionAdvisor.Profile profile) {
        this.profilesChanged();
    }

    @Override
    protected void profileUpdated(DistributionAdvisor.Profile profile) {
        this.profilesChanged();
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        this.profilesChanged();
    }

    protected void profilesChanged() {
        if (this.pollIsInitialized()) {
            this.cachedBridgeServerProfiles = null;
            this.cachedControllerProfiles = null;
            this.cachedBridgeServerAdvise = null;
            this.cachedControllerAdvise = null;
        }
    }

    public void handshake() {
        if (this.initializationGate()) {
            ArrayList<DistributionAdvisor.Profile> otherProfiles = new ArrayList<DistributionAdvisor.Profile>();
            GridProfile profile = (GridProfile)this.createProfile();
            profile.tellLocalBridgeServers(false, true, otherProfiles);
            profile.tellLocalControllers(false, true, otherProfiles);
            for (DistributionAdvisor.Profile otherProfile : otherProfiles) {
                if (otherProfile.equals(profile)) continue;
                this.putProfile(otherProfile);
            }
        }
        this.profilesChanged();
    }

    @Override
    public void close() {
        try {
            new UpdateAttributesProcessor(this.getAdvisee(), true).distribute();
            GridProfile profile = (GridProfile)this.createProfile();
            profile.tellLocalBridgeServers(true, false, null);
            profile.tellLocalControllers(true, false, null);
            super.close();
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
        this.profilesChanged();
    }

    @Override
    public Set adviseProfileRemove() {
        Set results = super.adviseProfileRemove();
        results.remove(this.getDistributionManager().getId());
        return results;
    }

    public static final class GridProfileId
    implements DistributionAdvisor.ProfileId {
        private final GridProfile gp;

        public GridProfileId(GridProfile gp) {
            this.gp = gp;
        }

        public final InternalDistributedMember getMemberId() {
            return this.gp.getDistributedMember();
        }

        public final String getHost() {
            return this.gp.getHost();
        }

        public final int getPort() {
            return this.gp.getPort();
        }

        public String toString() {
            return "GridProfile[host=" + this.gp.getHost() + ",port=" + this.gp.getPort() + ']';
        }

        public int hashCode() {
            String thisHost = this.gp.getHost();
            int thisPort = this.gp.getPort();
            return thisHost != null ? thisHost.hashCode() ^ thisPort : thisPort;
        }

        public boolean equals(Object obj) {
            if (obj instanceof GridProfileId) {
                GridProfileId other = (GridProfileId)obj;
                if (this.gp.getPort() == other.gp.getPort()) {
                    String thisHost = this.gp.getHost();
                    String otherHost = other.gp.getHost();
                    if (thisHost != null) {
                        return thisHost.equals(otherHost);
                    }
                    return otherHost == null;
                }
            }
            return false;
        }
    }

    public static abstract class GridProfile
    extends DistributionAdvisor.Profile {
        private String host;
        private int port;
        private DistributionAdvisor.ProfileId id;

        public GridProfile() {
        }

        public GridProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public GridProfile(GridProfile toCopy) {
            super(toCopy.getDistributedMember(), toCopy.version);
            this.host = toCopy.host;
            this.port = toCopy.port;
            this.finishInit();
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final void setPort(int port) {
            this.port = port;
        }

        public final String getHost() {
            return this.host;
        }

        public final int getPort() {
            return this.port;
        }

        @Override
        public final DistributionAdvisor.ProfileId getId() {
            if (this.id == null) {
                throw new IllegalStateException("profile id not yet initialized");
            }
            return this.id;
        }

        protected final void tellLocalControllers(boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            List<Locator> locators = Locator.getLocators();
            for (int i = 0; i < locators.size(); ++i) {
                InternalLocator l = (InternalLocator)locators.get(i);
                ServerLocator advisee = l.getServerLocatorAdvisee();
                if (advisee != null && advisee.getProfile().equals(this)) continue;
                if (this.port > 0) {
                    this.handleDistributionAdvisee(advisee, removeProfile, exchangeProfiles, replyProfiles);
                    continue;
                }
                if (!exchangeProfiles || advisee == null) continue;
                replyProfiles.add(advisee.getProfile());
            }
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed()) {
                this.handleDistributionAdvisee(cache.getSqlfAdvisee(), removeProfile, false, replyProfiles);
            }
        }

        protected final void tellLocalBridgeServers(boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed()) {
                List bridgeServers = cache.getBridgeServersAndGatewayReceiver();
                for (int i = 0; i < bridgeServers.size(); ++i) {
                    BridgeServerImpl bsi = (BridgeServerImpl)bridgeServers.get(i);
                    if (!bsi.isRunning() || bsi.getProfile().equals(this)) continue;
                    if (this.port > 0) {
                        this.handleDistributionAdvisee(bsi, removeProfile, exchangeProfiles, replyProfiles);
                        continue;
                    }
                    if (!exchangeProfiles) continue;
                    replyProfiles.add(bsi.getProfile());
                }
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.host, out);
            DataSerializer.writePrimitiveInt(this.port, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.host = DataSerializer.readString(in);
            this.port = DataSerializer.readPrimitiveInt(in);
            this.finishInit();
        }

        public void finishInit() {
            this.id = new GridProfileId(this);
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; host=" + this.host);
            sb.append("; port=" + this.port);
        }
    }
}

