/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.DeltaSerializationException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.internal.SystemMemberCacheEventProcessor;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.FailedSynchronizationException;
import com.gemstone.gemfire.cache.InterestRegistrationEvent;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionMembershipListener;
import com.gemstone.gemfire.cache.RegionReinitializedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.StatisticsDisabledException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.SubscriptionNotEnabledException;
import com.gemstone.gemfire.cache.client.internal.BridgePoolImpl;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexMaintenanceException;
import com.gemstone.gemfire.cache.query.MultiIndexCreationException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.IndexUpdater;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassLoadUtil;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalStatisticsDisabledException;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.BridgeRegionEventImpl;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.BucketRegionQueue;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.CacheStatisticsImpl;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.CustomEntryExpiryTask;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskInitFile;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.DiskStoreFactoryImpl;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EntriesSet;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EntryExpiryTask;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.EventTracker;
import com.gemstone.gemfire.internal.cache.ExpirationScheduler;
import com.gemstone.gemfire.internal.cache.ExpiryTask;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.FindVersionTagOperation;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.GatewayHubImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.ImageState;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.InterestEvent;
import com.gemstone.gemfire.internal.cache.InterestFilter;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.InternalDataView;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LoaderHelperFactory;
import com.gemstone.gemfire.internal.cache.LoaderHelperImpl;
import com.gemstone.gemfire.internal.cache.LocalRegionDataView;
import com.gemstone.gemfire.internal.cache.NetSearchExpirationCalculator;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.RegionExpiryTask;
import com.gemstone.gemfire.internal.cache.RegionIdleExpiryTask;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.RegionMapFactory;
import com.gemstone.gemfire.internal.cache.RegionTTLExpiryTask;
import com.gemstone.gemfire.internal.cache.SearchLoadAndWriteProcessor;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXRegionState;
import com.gemstone.gemfire.internal.cache.TXRmtEvent;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TXStateProxyImpl;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.internal.cache.UnsharedImageState;
import com.gemstone.gemfire.internal.cache.UserSpecifiedRegionAttributes;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.control.MemoryEventType;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionResultSender;
import com.gemstone.gemfire.internal.cache.execute.LocalResultCollector;
import com.gemstone.gemfire.internal.cache.execute.RegionFunctionContextImpl;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.lru.LRUEntry;
import com.gemstone.gemfire.internal.cache.partitioned.RedundancyAlreadyMetException;
import com.gemstone.gemfire.internal.cache.persistence.DiskExceptionHandler;
import com.gemstone.gemfire.internal.cache.persistence.DiskRecoveryStore;
import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.persistence.query.IndexMap;
import com.gemstone.gemfire.internal.cache.persistence.query.mock.IndexMapImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientHealthMonitor;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientTombstoneMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionHolder;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.sequencelog.EntryLogger;
import com.gemstone.gemfire.internal.util.concurrent.FutureResult;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCountDownLatch;
import com.gemstone.gemfire.internal.util.concurrent.StoppableReadWriteLock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.logging.log4j.Logger;

public class LocalRegion
extends AbstractRegion
implements LoaderHelperFactory,
ResourceListener<MemoryEvent>,
DiskExceptionHandler,
DiskRecoveryStore {
    private static final Logger logger = LogService.getLogger();
    public static final int AFTER_INITIAL_IMAGE = 0;
    public static final int BEFORE_INITIAL_IMAGE = 1;
    public static final int ANY_INIT = 2;
    private static final ThreadLocal initializationThread = new ThreadLocal();
    protected static final ThreadLocal isConversion = new ThreadLocal();
    private Object regionUserAttribute;
    protected Map entryUserAttributes;
    private final String regionName;
    protected final LocalRegion parentRegion;
    private volatile boolean reinitialized_old = false;
    protected volatile boolean isDestroyed = false;
    protected volatile boolean isDestroyedForParallelWAN = false;
    private volatile boolean reinitialized_new = false;
    private Semaphore destroyLock;
    private RegionTTLExpiryTask regionTTLExpiryTask = null;
    private RegionIdleExpiryTask regionIdleExpiryTask = null;
    private final Object regionExpiryLock = new Object();
    private int txRefCount;
    private final ConcurrentHashMap<RegionEntry, EntryExpiryTask> entryExpiryTasks = new ConcurrentHashMap();
    volatile boolean regionInvalid = false;
    public final RegionMap entries;
    private final boolean supportsTX;
    protected EventTracker eventTracker;
    private RegionVersionVector versionVector;
    private static final Pattern[] QUERY_PATTERNS = new Pattern[]{Pattern.compile("^\\(*select .*", 98), Pattern.compile("^import .*", 98)};
    public static final String EXPIRY_MS_PROPERTY = "gemfire.EXPIRY_UNITS_MS";
    final boolean EXPIRY_UNITS_MS = Boolean.getBoolean("gemfire.EXPIRY_UNITS_MS");
    private volatile boolean entriesInitialized;
    protected volatile ConcurrentMap subregions;
    private final Object subregionsLock = new Object();
    protected final StoppableCountDownLatch initializationLatchBeforeGetInitialImage;
    protected final StoppableCountDownLatch initializationLatchAfterGetInitialImage;
    private final StoppableCountDownLatch afterRegionCreateEventLatch;
    private volatile boolean initialized = false;
    private final DiskRegion diskRegion;
    private volatile StoppableReadWriteLock txExpirationLock;
    protected final ConcurrentMap getFutures = new ConcurrentHashMap();
    public static boolean ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
    private final boolean isUsedForPartitionedRegionAdmin;
    private final boolean isUsedForPartitionedRegionBucket;
    private final boolean isUsedForMetaRegion;
    private final boolean isMetaRegionWithTransactions;
    private final boolean isUsedForSerialGatewaySenderQueue;
    private final boolean isUsedForParallelGatewaySenderQueue;
    private final SerialGatewaySenderImpl serialGatewaySender;
    protected final LoaderHelperFactory loaderHelperFactory;
    private final CachePerfStats cachePerfStats;
    private final boolean hasOwnStats;
    private final ImageState imageState;
    private int riCnt = 0;
    private volatile HashMap destroyedSubregionSerialNumbers;
    public final AtomicBoolean heapThresholdReached = new AtomicBoolean(false);
    public final Lock clientMetaDataLock = new ReentrantLock();
    private int hubType = 0;
    protected final CancelCriterion stopper = this.createStopper();
    private final TestCallable testCallable;
    private static final ThreadLocal<LocalRegion> initializingRegion = new ThreadLocal();
    private boolean keyRequiresRegionContext;
    protected final ServerRegionProxy srp;
    private final InternalDataView sharedDataView;
    private final String fullPath;
    private final boolean DO_EXPENSIVE_VALIDATIONS = Boolean.getBoolean("gemfire.DO_EXPENSIVE_VALIDATIONS");
    protected AtomicInteger tombstoneCount = new AtomicInteger();
    private boolean concurrencyMessageIssued;
    private static final byte SNAPSHOT_VERSION = 1;
    private static final byte SNAPSHOT_VALUE_OBJ = 23;
    private static final byte SNAPSHOT_VALUE_INVALID = 24;
    private static final byte SNAPSHOT_VALUE_LOCAL_INVALID = 25;
    public static final float DEFAULT_HEAPLRU_EVICTION_HEAP_PERCENTAGE = 80.0f;
    private final DiskStoreImpl dsi;
    protected static final TXEntryState NOOP_INVALIDATE = new TXEntryState();
    FilterProfile filterProfile;
    private static final DistributionAdvisor.ProfileVisitor<Void> netLoaderVisitor = new DistributionAdvisor.ProfileVisitor<Void>(){

        @Override
        public boolean visit(DistributionAdvisor advisor, DistributionAdvisor.Profile profile, int profileIndex, int numProfiles, Void aggregate) {
            assert (profile instanceof CacheDistributionAdvisor.CacheProfile);
            CacheDistributionAdvisor.CacheProfile prof = (CacheDistributionAdvisor.CacheProfile)profile;
            if (prof.regionInitialized && !prof.memberUnInitialized) {
                return !prof.hasCacheLoader;
            }
            return true;
        }
    };
    private static final DistributionAdvisor.ProfileVisitor<Void> netWriterVisitor = new DistributionAdvisor.ProfileVisitor<Void>(){

        @Override
        public boolean visit(DistributionAdvisor advisor, DistributionAdvisor.Profile profile, int profileIndex, int numProfiles, Void aggregate) {
            assert (profile instanceof CacheDistributionAdvisor.CacheProfile);
            CacheDistributionAdvisor.CacheProfile prof = (CacheDistributionAdvisor.CacheProfile)profile;
            if (!prof.inRecovery && !prof.memberUnInitialized) {
                return !prof.hasCacheWriter;
            }
            return true;
        }
    };

    protected CancelCriterion createStopper() {
        return new Stopper();
    }

    public static LocalRegion getInitializingRegion() {
        return initializingRegion.get();
    }

    public final boolean keyRequiresRegionContext() {
        return this.keyRequiresRegionContext;
    }

    public final void setKeyRequiresRegionContext(boolean v) {
        this.keyRequiresRegionContext = v;
    }

    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    private static String calcFullPath(String regionName, LocalRegion parentRegion) {
        StringBuilder buf = null;
        if (parentRegion == null) {
            buf = new StringBuilder(regionName.length() + 1);
        } else {
            String parentFull = parentRegion.getFullPath();
            buf = new StringBuilder(parentFull.length() + regionName.length() + 1);
            buf.append(parentFull);
        }
        buf.append("/").append(regionName);
        return buf.toString();
    }

    protected LocalRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, InternalRegionArguments internalRegionArgs) throws DiskAccessException {
        super(cache, attrs, regionName, internalRegionArgs);
        Assert.assertTrue(regionName != null, "regionName must not be null");
        this.sharedDataView = this.buildDataView();
        this.regionName = regionName;
        this.parentRegion = parentRegion;
        this.fullPath = LocalRegion.calcFullPath(regionName, parentRegion);
        String myName = this.getFullPath();
        if (internalRegionArgs.getPartitionedRegion() != null) {
            myName = internalRegionArgs.getPartitionedRegion().getFullPath();
        }
        this.initializationLatchBeforeGetInitialImage = new StoppableCountDownLatch(this.stopper, 1);
        this.initializationLatchAfterGetInitialImage = new StoppableCountDownLatch(this.stopper, 1);
        this.afterRegionCreateEventLatch = new StoppableCountDownLatch(this.stopper, 1);
        if (internalRegionArgs.getUserAttribute() != null) {
            this.setUserAttribute(internalRegionArgs.getUserAttribute());
        }
        this.setKeyRequiresRegionContext(internalRegionArgs.keyRequiresRegionContext());
        initializingRegion.set(this);
        if (internalRegionArgs.getCachePerfStatsHolder() != null) {
            this.hasOwnStats = false;
            this.cachePerfStats = internalRegionArgs.getCachePerfStatsHolder().getCachePerfStats();
        } else if (attrs.getPartitionAttributes() != null || this.isInternalRegion() || internalRegionArgs.isUsedForMetaRegion()) {
            this.hasOwnStats = false;
            this.cachePerfStats = cache.getCachePerfStats();
        } else {
            this.hasOwnStats = true;
            this.cachePerfStats = new RegionPerfStats(cache, cache.getCachePerfStats(), regionName);
        }
        this.dsi = this.findDiskStore(attrs, internalRegionArgs);
        this.diskRegion = this.createDiskRegion(internalRegionArgs);
        this.entries = this.createRegionMap(internalRegionArgs);
        this.entriesInitialized = true;
        this.subregions = new ConcurrentHashMap();
        if (parentRegion == null) {
            this.initRoot();
        }
        this.loaderHelperFactory = internalRegionArgs.getLoaderHelperFactory() != null ? internalRegionArgs.getLoaderHelperFactory() : this;
        this.isUsedForPartitionedRegionAdmin = internalRegionArgs.isUsedForPartitionedRegionAdmin();
        this.isUsedForPartitionedRegionBucket = internalRegionArgs.isUsedForPartitionedRegionBucket();
        this.isUsedForMetaRegion = internalRegionArgs.isUsedForMetaRegion();
        this.isMetaRegionWithTransactions = internalRegionArgs.isMetaRegionWithTransactions();
        this.isUsedForSerialGatewaySenderQueue = internalRegionArgs.isUsedForSerialGatewaySenderQueue();
        this.isUsedForParallelGatewaySenderQueue = internalRegionArgs.isUsedForParallelGatewaySenderQueue();
        this.serialGatewaySender = internalRegionArgs.getSerialGatewaySender();
        if (!(this.isUsedForMetaRegion || this.isUsedForPartitionedRegionAdmin || this.isUsedForPartitionedRegionBucket || this.isUsedForSerialGatewaySenderQueue || this.isUsedForParallelGatewaySenderQueue)) {
            this.filterProfile = new FilterProfile(this);
        }
        this.srp = this.getPoolName() != null || LocalRegion.isBridgeLoader(this.getCacheLoader()) || LocalRegion.isBridgeWriter(this.getCacheWriter()) ? new ServerRegionProxy(this) : null;
        this.imageState = new UnsharedImageState(this.srp != null, this.getDataPolicy().withReplication() || this.getDataPolicy().isPreloaded(), this.getAttributes().getDataPolicy().withPersistence(), this.stopper);
        this.createEventTracker();
        this.supportsTX = !this.isSecret() && !this.isUsedForPartitionedRegionAdmin() && !this.isUsedForMetaRegion() || this.isMetaRegionWithTransactions();
        this.testCallable = internalRegionArgs.getTestCallable();
    }

    private RegionMap createRegionMap(InternalRegionArguments internalRegionArgs) {
        RegionMap result = null;
        if (this.diskRegion != null) {
            result = this.diskRegion.useExistingRegionMap(this);
        }
        if (result == null) {
            RegionMap.Attributes ma = new RegionMap.Attributes();
            ma.statisticsEnabled = this.statisticsEnabled;
            ma.loadFactor = this.loadFactor;
            ma.initialCapacity = this.initialCapacity;
            ma.concurrencyLevel = this.concurrencyLevel;
            result = RegionMapFactory.createVM(this, ma, internalRegionArgs);
        }
        return result;
    }

    protected InternalDataView buildDataView() {
        return new LocalRegionDataView();
    }

    void createEventTracker() {
    }

    protected EventTracker getEventTracker() {
        return this.eventTracker;
    }

    public RegionVersionVector getVersionVector() {
        return this.versionVector;
    }

    public Object getSizeGuard() {
        if (!this.concurrencyChecksEnabled) {
            return new Object();
        }
        return this.fullPath;
    }

    protected void createVersionVector() {
        this.versionVector = RegionVersionVector.create(this.getVersionMember(), this);
        if (this.dataPolicy.withPersistence()) {
            RegionVersionVector diskVector = this.diskRegion.getRegionVersionVector();
            this.versionVector.recordVersions(diskVector.getCloneForTransmission());
        } else if (!this.dataPolicy.withStorage()) {
            this.versionVector.turnOffRecordingForEmptyRegion();
        }
        if (this.srp != null) {
            this.versionVector.setIsClientVector();
        }
        this.cache.getDistributionManager().addMembershipListener(this.versionVector);
    }

    @Override
    protected void updateEntryExpiryPossible() {
        super.updateEntryExpiryPossible();
        if (!this.isEntryExpiryPossible()) {
            this.cancelAllEntryExpiryTasks();
        }
    }

    public final IndexUpdater getIndexUpdater() {
        return this.entries.getIndexUpdater();
    }

    final boolean isCacheClosing() {
        return this.cache.isClosed();
    }

    public RegionEntry getRegionEntry(Object key2) {
        return this.entries.getEntry(key2);
    }

    public VersionTag getVersionTag(Object key2) {
        Region.Entry entry = this.getEntry(key2, true);
        VersionTag tag = null;
        if (entry != null && entry instanceof EntrySnapshot) {
            tag = ((EntrySnapshot)entry).getVersionTag();
        } else if (entry != null && entry instanceof NonTXEntry) {
            tag = ((NonTXEntry)entry).getRegionEntry().getVersionStamp().asVersionTag();
        }
        return tag;
    }

    private void destroyEntriesAndClearDestroyedKeysSet() {
        ImageState is = this.getImageState();
        Iterator iter = is.getDestroyedEntries();
        while (iter.hasNext()) {
            Object key2 = iter.next();
            this.entries.removeIfDestroyed(key2);
        }
    }

    public final ServerRegionProxy getServerProxy() {
        return this.srp;
    }

    public final boolean hasServerProxy() {
        return this.srp != null;
    }

    protected boolean isExpirationAllowed(ExpiryTask expiry) {
        return true;
    }

    void performExpiryTimeout(ExpiryTask p_task) throws CacheException {
        if (p_task != null) {
            p_task.basicPerformTimeout(false);
        }
    }

    private void initRoot() {
        this.destroyLock = new Semaphore(1);
    }

    public void handleMarker() {
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.MARKER, null, false, (DistributedMember)this.getMyId(), false);
        this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_LIVE, event);
    }

    public AttributesMutator getAttributesMutator() {
        this.checkReadiness();
        return this;
    }

    public Region createSubregion(String subregionName, RegionAttributes regionAttributes) throws RegionExistsException, TimeoutException {
        try {
            return this.createSubregion(subregionName, regionAttributes, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false));
        }
        catch (IOException e) {
            InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_EXCEPTION.toLocalizedString());
            assErr.initCause(e);
            throw assErr;
        }
        catch (ClassNotFoundException e) {
            InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_EXCEPTION.toLocalizedString());
            assErr.initCause(e);
            throw assErr;
        }
    }

    @Override
    protected InternalDistributedMember getMyId() {
        return this.cache.getMyId();
    }

    public VersionSource getVersionMember() {
        if (this.dataPolicy.withPersistence()) {
            return this.getDiskStore().getDiskStoreID();
        }
        return this.cache.getMyId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region createSubregion(String subregionName, RegionAttributes attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException, IOException, ClassNotFoundException {
        this.checkReadiness();
        LocalRegion newRegion = null;
        RegionAttributes regionAttributes = attrs;
        InputStream snapshotInputStream = internalRegionArgs.getSnapshotInputStream();
        boolean getDestroyLock = internalRegionArgs.getDestroyLockFlag();
        InternalDistributedMember imageTarget = internalRegionArgs.getImageTarget();
        try {
            if (getDestroyLock) {
                this.acquireDestroyLock();
            }
            LocalRegion existing = null;
            try {
                if (this.isDestroyed()) {
                    if (this.reinitialized_old) {
                        throw new RegionReinitializedException(this.toString(), this.getFullPath());
                    }
                    throw new RegionDestroyedException(this.toString(), this.getFullPath());
                }
                LocalRegion.validateRegionName(subregionName);
                this.validateSubregionAttributes(regionAttributes);
                Object object = this.subregionsLock;
                synchronized (object) {
                    existing = (LocalRegion)this.subregions.get(subregionName);
                    if (existing == null) {
                        if (regionAttributes.getScope().isDistributed() && internalRegionArgs.isUsedForPartitionedRegionBucket()) {
                            PartitionedRegion pr2 = internalRegionArgs.getPartitionedRegion();
                            internalRegionArgs.setIndexUpdater(pr2.getIndexUpdater());
                            internalRegionArgs.setUserAttribute(pr2.getUserAttribute());
                            internalRegionArgs.setKeyRequiresRegionContext(pr2.keyRequiresRegionContext());
                            newRegion = pr2.isShadowPR() ? new BucketRegionQueue(subregionName, regionAttributes, this, this.cache, internalRegionArgs) : new BucketRegion(subregionName, regionAttributes, this, this.cache, internalRegionArgs);
                        } else {
                            boolean local2;
                            newRegion = regionAttributes.getPartitionAttributes() != null ? new PartitionedRegion(subregionName, regionAttributes, this, this.cache, internalRegionArgs) : ((local2 = regionAttributes.getScope().isLocal()) ? new LocalRegion(subregionName, regionAttributes, this, this.cache, internalRegionArgs) : new DistributedRegion(subregionName, regionAttributes, this, this.cache, internalRegionArgs));
                        }
                        LocalRegion o = this.subregions.putIfAbsent(subregionName, newRegion);
                        Assert.assertTrue(o == null);
                        Assert.assertTrue(!newRegion.isInitialized());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Subregion created: {}", newRegion.getFullPath());
                        }
                        if (snapshotInputStream != null || imageTarget != null || internalRegionArgs.getRecreateFlag()) {
                            this.cache.regionReinitialized(newRegion);
                        }
                    }
                }
            }
            finally {
                if (getDestroyLock) {
                    this.releaseDestroyLock();
                }
            }
            if (existing != null) {
                existing.waitOnInitialization();
                throw new RegionExistsException(existing);
            }
            boolean success = false;
            try {
                newRegion.checkReadiness();
                this.cache.setRegionByPath(newRegion.getFullPath(), newRegion);
                if (regionAttributes instanceof UserSpecifiedRegionAttributes) {
                    internalRegionArgs.setIndexes(((UserSpecifiedRegionAttributes)regionAttributes).getIndexes());
                }
                newRegion.initialize(snapshotInputStream, imageTarget, internalRegionArgs);
                if (!newRegion.isInternalRegion() && !newRegion.isDestroyed) {
                    this.cache.getResourceManager().addResourceListener(newRegion);
                    InternalDistributedSystem system = this.cache.getDistributedSystem();
                    system.handleResourceEvent(ResourceEvent.REGION_CREATE, newRegion);
                }
                success = true;
            }
            catch (CancelException e) {
                throw e;
            }
            catch (RedundancyAlreadyMetException e) {
                throw e;
            }
            catch (RuntimeException validationException) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_INITIALIZATION_FAILED_FOR_REGION_0, this.getFullPath()), (Throwable)validationException);
                throw validationException;
            }
            finally {
                if (!success) {
                    this.cache.setRegionByPath(newRegion.getFullPath(), null);
                    this.initializationFailed(newRegion);
                    this.cache.getResourceManager(false).removeResourceListener(newRegion);
                }
            }
            newRegion.postCreateRegion();
        }
        finally {
            if (newRegion != null && !newRegion.isInitialized() && logger.isDebugEnabled()) {
                logger.debug("Region initialize latch is closed, Error must have occurred");
            }
        }
        return newRegion;
    }

    public final void create(Object key2, Object value2, Object aCallbackArgument) throws TimeoutException, EntryExistsException, CacheWriterException {
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = this.newCreateEntryEvent(key2, value2, aCallbackArgument);
        this.validatedCreate(event, startPut);
    }

    public final void validatedCreate(EntryEventImpl event, long startPut) throws TimeoutException, EntryExistsException, CacheWriterException {
        if (event.getEventId() == null && this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        if (this.getDataPolicy() == DataPolicy.NORMAL) {
            event.setLocalInvalid(true);
        }
        this.discoverJTA();
        if (!this.basicPut(event, true, false, null, true)) {
            throw new EntryExistsException(event.getKey().toString(), event.getOldValue());
        }
        if (!this.getDataView().isDeferredStats()) {
            this.getCachePerfStats().endPut(startPut, false);
        }
    }

    public final EntryEventImpl newCreateEntryEvent(Object key2, Object value2, Object aCallbackArgument) {
        this.validateArguments(key2, value2, aCallbackArgument);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        return new EntryEventImpl(this, Operation.CREATE, key2, value2, aCallbackArgument, false, this.getMyId()).setCreate(true);
    }

    @Override
    public boolean generateEventID() {
        return !this.isUsedForPartitionedRegionAdmin() && !this.isUsedForPartitionedRegionBucket();
    }

    public final Object destroy(Object key2, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        EntryEventImpl event = this.newDestroyEntryEvent(key2, aCallbackArgument);
        return this.validatedDestroy(key2, event);
    }

    public Object validatedDestroy(Object key2, EntryEventImpl event) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        if (event.getEventId() == null && this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        this.basicDestroy(event, true, null);
        return LocalRegion.handleNotAvailable(event.getOldValue());
    }

    public final EntryEventImpl newDestroyEntryEvent(Object key2, Object aCallbackArgument) {
        this.validateKey(key2);
        this.validateCallbackArg(aCallbackArgument);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        return new EntryEventImpl(this, Operation.DESTROY, key2, null, aCallbackArgument, false, this.getMyId());
    }

    @Override
    public void destroyRegion(Object aCallbackArgument) throws CacheWriterException, TimeoutException {
        this.getDataView().checkSupportsRegionDestroy();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_DESTROY, aCallbackArgument, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.basicDestroyRegion(event, true);
    }

    public InternalDataView getDataView() {
        TXStateInterface tx = this.getTXState();
        if (tx == null) {
            return this.sharedDataView;
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getDeserializedValue(KeyInfo keyInfo, boolean updateStats, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones) {
        if (this.diskRegion != null) {
            this.diskRegion.setClearCountReference();
        }
        try {
            Object value2;
            RegionEntry re;
            block20: {
                re = this.entries.getEntry(keyInfo.getKey());
                if (re == null) {
                    Object var8_8 = null;
                    return var8_8;
                }
                if (clientEvent != null && re.getVersionStamp() != null) {
                    boolean disabled = this.entries.disableLruUpdateCallback();
                    try {
                        RegionEntry regionEntry = re;
                        synchronized (regionEntry) {
                            clientEvent.setVersionTag(re.getVersionStamp().asVersionTag());
                            value2 = this.getDeserialized(re, updateStats, disableCopyOnRead, preferCD);
                            break block20;
                        }
                    }
                    finally {
                        if (disabled) {
                            this.entries.enableLruUpdateCallback();
                        }
                        try {
                            this.entries.lruUpdateCallback();
                        }
                        catch (DiskAccessException dae) {
                            this.handleDiskAccessException(dae);
                            throw dae;
                        }
                    }
                }
                value2 = this.getDeserialized(re, updateStats, disableCopyOnRead, preferCD);
            }
            if (logger.isTraceEnabled() && !(this instanceof HARegion)) {
                logger.trace("getDeserializedValue for {} returning version: {} returnTombstones: {} value: {}", keyInfo.getKey(), re.getVersionStamp() == null ? "null" : re.getVersionStamp().asVersionTag(), returnTombstones, value2);
            }
            Object object = value2;
            return object;
        }
        finally {
            if (this.diskRegion != null) {
                this.diskRegion.removeClearCountReference();
            }
        }
    }

    protected final Object getDeserialized(RegionEntry re, boolean updateStats, boolean disableCopyOnRead, boolean preferCD) {
        try {
            Object v = null;
            try {
                v = re.getValue(this);
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae);
                throw dae;
            }
            if (v == null) {
                return null;
            }
            if (v instanceof CachedDeserializable) {
                if (!preferCD) {
                    v = this.isCopyOnRead() ? (disableCopyOnRead ? ((CachedDeserializable)v).getDeserializedForReading() : ((CachedDeserializable)v).getDeserializedWritableCopy(this, re)) : ((CachedDeserializable)v).getDeserializedValue(this, re);
                }
            } else if (!disableCopyOnRead) {
                v = this.conditionalCopy(v);
            }
            if (updateStats) {
                this.updateStatsForGet(re, v != null && !Token.isInvalid(v));
            }
            return v;
        }
        catch (IllegalArgumentException i) {
            IllegalArgumentException iae = new IllegalArgumentException(LocalizedStrings.DONT_RELEASE.toLocalizedString("Error while deserializing value for key=" + re.getKey()));
            iae.initCause(i);
            throw iae;
        }
    }

    @Override
    public Object get(Object key2, Object aCallbackArgument, boolean generateCallbacks, EntryEventImpl clientEvent) throws TimeoutException, CacheLoaderException {
        Object result = this.get(key2, aCallbackArgument, generateCallbacks, false, false, null, clientEvent, false);
        if (Token.isInvalid(result)) {
            result = null;
        }
        return result;
    }

    public Object get(Object key2, Object aCallbackArgument, boolean generateCallbacks, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws TimeoutException, CacheLoaderException {
        return this.get(key2, aCallbackArgument, generateCallbacks, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key2, Object aCallbackArgument, boolean generateCallbacks, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones, boolean opScopeIsLocal) throws TimeoutException, CacheLoaderException {
        this.validateKey(key2);
        this.validateCallbackArg(aCallbackArgument);
        this.checkReadiness();
        this.checkForNoAccess();
        this.discoverJTA();
        CachePerfStats stats = this.getCachePerfStats();
        long start = stats.startGet();
        boolean isMiss = true;
        try {
            Object value2 = this.getDataView().getDeserializedValue(this.getKeyInfo(key2), this, true, disableCopyOnRead, preferCD, clientEvent, returnTombstones);
            boolean isCreate = value2 == null;
            boolean bl = isMiss = value2 == null || Token.isInvalid(value2) || !returnTombstones && value2 == Token.TOMBSTONE;
            if (isMiss) {
                if (!opScopeIsLocal && (this.getScope().isDistributed() || this.hasServerProxy() || this.basicGetLoader() != null)) {
                    value2 = this.getDataView().findObject(this.getKeyInfo(key2, aCallbackArgument), this, isCreate, generateCallbacks, value2, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
                    if (!returnTombstones && value2 == Token.TOMBSTONE) {
                        value2 = null;
                    }
                } else {
                    if (isCreate) {
                        this.recordMiss(null, key2);
                    }
                    value2 = null;
                }
            }
            Object object = value2;
            return object;
        }
        finally {
            stats.endGet(start, isMiss);
        }
    }

    public final void recordMiss(RegionEntry re, Object key2) {
        RegionEntry e = re == null && !this.isTX() ? this.basicGetEntry(key2) : re;
        this.updateStatsForGet(e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object nonTxnFindObject(KeyInfo keyInfo, boolean p_isCreate, boolean generateCallbacks, Object p_localValue, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones) throws TimeoutException, CacheLoaderException {
        FutureResult thisFuture;
        Object result;
        boolean isCreate;
        Object localValue;
        block15: {
            VersionTag tag;
            Object e3;
            localValue = p_localValue;
            isCreate = p_isCreate;
            Object[] valueAndVersion = null;
            result = null;
            thisFuture = new FutureResult(this.stopper);
            Future otherFuture = this.getFutures.putIfAbsent(keyInfo.getKey(), thisFuture);
            if (otherFuture != null) {
                try {
                    valueAndVersion = (Object[])otherFuture.get();
                    if (valueAndVersion != null) {
                        result = valueAndVersion[0];
                        if (clientEvent != null) {
                            clientEvent.setVersionTag((VersionTag)valueAndVersion[1]);
                        }
                        if (!preferCD && result instanceof CachedDeserializable) {
                            CachedDeserializable cd2 = (CachedDeserializable)result;
                            result = !disableCopyOnRead && this.isCopyOnRead() ? cd2.getDeserializedWritableCopy(null, null) : cd2.getDeserializedForReading();
                        } else if (!disableCopyOnRead) {
                            result = this.conditionalCopy(result);
                        }
                        RegionEntry re = null;
                        if (isCreate) {
                            re = this.basicGetEntry(keyInfo.getKey());
                            this.updateStatsForGet(re, true);
                        }
                        return result;
                    }
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return null;
                }
                catch (ExecutionException e3) {
                    InternalGemFireError err = new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_EXCEPTION.toLocalizedString());
                    err.initCause(err);
                    throw err;
                }
            }
            try {
                localValue = this.getDeserializedValue(keyInfo, isCreate, disableCopyOnRead, preferCD, clientEvent, false);
                if (localValue == null || Token.isInvalid(localValue)) break block15;
                e3 = result = localValue;
                tag = clientEvent == null ? null : clientEvent.getVersionTag();
            }
            catch (Throwable throwable) {
                VersionTag tag2 = clientEvent == null ? null : clientEvent.getVersionTag();
                thisFuture.set(new Object[]{result, tag2});
                this.getFutures.remove(keyInfo.getKey());
                throw throwable;
            }
            thisFuture.set(new Object[]{result, tag});
            this.getFutures.remove(keyInfo.getKey());
            return e3;
        }
        isCreate = localValue == null;
        result = this.findObjectInSystem(keyInfo, isCreate, null, generateCallbacks, localValue, disableCopyOnRead, preferCD, null, clientEvent, returnTombstones);
        if (result == null && localValue != null && (localValue != Token.TOMBSTONE || returnTombstones)) {
            result = localValue;
        }
        VersionTag tag = clientEvent == null ? null : clientEvent.getVersionTag();
        thisFuture.set(new Object[]{result, tag});
        this.getFutures.remove(keyInfo.getKey());
        if (!disableCopyOnRead) {
            result = this.conditionalCopy(result);
        }
        return result;
    }

    protected boolean isCopyOnRead() {
        return this.compressor == null && this.cache.isCopyOnRead() && !this.isUsedForPartitionedRegionAdmin && !this.isUsedForMetaRegion && !this.isSecret();
    }

    protected Object conditionalCopy(Object o) {
        if (this.isCopyOnRead() && !Token.isInvalid(o)) {
            return CopyHelper.copy(o);
        }
        return o;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public Region getParentRegion() {
        return this.parentRegion;
    }

    public Region getSubregion(String path) {
        this.checkReadiness();
        return this.getSubregion(path, false);
    }

    @Override
    public void invalidateRegion(Object aCallbackArgument) throws TimeoutException {
        this.getDataView().checkSupportsRegionInvalidate();
        this.validateCallbackArg(aCallbackArgument);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_INVALIDATE, aCallbackArgument, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.basicInvalidateRegion(event);
    }

    public Object put(Object key2, Object value2, Object aCallbackArgument) throws TimeoutException, CacheWriterException {
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = this.newUpdateEntryEvent(key2, value2, aCallbackArgument);
        return this.validatedPut(event, startPut);
    }

    public final Object validatedPut(EntryEventImpl event, long startPut) throws TimeoutException, CacheWriterException {
        if (event.getEventId() == null && this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        Object oldValue = null;
        boolean forceUpdateForDelta = event.hasDelta();
        if (this.basicPut(event, false, forceUpdateForDelta, null, false)) {
            oldValue = event.getOldValue();
            if (!this.getDataView().isDeferredStats()) {
                this.getCachePerfStats().endPut(startPut, false);
            }
        }
        return LocalRegion.handleNotAvailable(oldValue);
    }

    public final EntryEventImpl newUpdateEntryEvent(Object key2, Object value2, Object aCallbackArgument) {
        this.validateArguments(key2, value2, aCallbackArgument);
        if (value2 == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_VALUE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.discoverJTA();
        EntryEventImpl event = new EntryEventImpl(this, Operation.UPDATE, key2, value2, aCallbackArgument, false, this.getMyId());
        this.extractDeltaIntoEvent(value2, event);
        return event;
    }

    private void extractDeltaIntoEvent(Object value2, EntryEventImpl event) {
        block13: {
            try {
                boolean extractDelta = false;
                if (!this.getSystem().getConfig().getDeltaPropagation() || !(value2 instanceof Delta)) break block13;
                if (!this.hasServerProxy()) {
                    if (this instanceof PartitionedRegion) {
                        InternalDistributedMember ids;
                        extractDelta = ((PartitionedRegion)this).getRedundantCopies() > 0 ? true : ((ids = (InternalDistributedMember)PartitionRegionHelper.getPrimaryMemberForKey(this, event.getKey())) != null ? (this.getSystem().getMemberId().equals(ids.getId()) ? this.hasAdjunctRecipientsNeedingDelta(event) : true) : true);
                    } else if (this instanceof DistributedRegion && !((DistributedRegion)this).scope.isDistributedNoAck() && ((DistributedRegion)this).getCacheDistributionAdvisor().adviseCacheOp().size() > 0) {
                        extractDelta = true;
                    }
                    if (!extractDelta && ClientHealthMonitor.getInstance() != null) {
                        extractDelta = ClientHealthMonitor.getInstance().hasDeltaClients();
                    }
                } else if (HandShake.isDeltaEnabledOnServer()) {
                    extractDelta = true;
                }
                if (!extractDelta || !((Delta)value2).hasDelta()) break block13;
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                long start = DistributionStats.getStatTime();
                try {
                    ((Delta)value2).toDelta(hdos);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new DeltaSerializationException(LocalizedStrings.DistributionManager_CAUGHT_EXCEPTION_WHILE_SENDING_DELTA.toLocalizedString(), e);
                }
                event.setDeltaBytes(hdos.toByteArray());
                this.getCachePerfStats().endDeltaPrepared(start);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new InternalGemFireException(e);
            }
        }
    }

    private boolean hasAdjunctRecipientsNeedingDelta(EntryEventImpl event) {
        PartitionedRegion pr2 = (PartitionedRegion)this;
        BucketRegion br = null;
        FilterRoutingInfo filterRouting = null;
        Set twoMessages = Collections.EMPTY_SET;
        Set adjunctRecipients = Collections.EMPTY_SET;
        Set cacheservers = null;
        int bId = event.getKeyInfo().getBucketId();
        try {
            br = pr2.dataStore.getInitializedBucketForId(event.getKey(), bId);
        }
        catch (ForceReattemptException fre) {
            return true;
        }
        Set recipients = br.getCacheDistributionAdvisor().adviseUpdate(event);
        twoMessages = br.getBucketAdvisor().adviseRequiresTwoMessages();
        CacheDistributionAdvisor cda = pr2.getCacheDistributionAdvisor();
        filterRouting = cda.adviseFilterRouting(event, recipients);
        adjunctRecipients = br.getAdjunctReceivers(event, recipients, twoMessages, filterRouting);
        cacheservers = cda.adviseCacheServers();
        return !Collections.disjoint(adjunctRecipients, cacheservers);
    }

    public Region.Entry getEntry(Object key2) {
        this.validateKey(key2);
        this.checkReadiness();
        this.checkForNoAccess();
        this.discoverJTA();
        return this.getDataView().getEntry(this.getKeyInfo(key2), this, false);
    }

    public Region.Entry getEntry(Object key2, boolean allowTombstones) {
        return this.getDataView().getEntry(this.getKeyInfo(key2), this, allowTombstones);
    }

    public Region.Entry accessEntry(Object key2, boolean updateStats) {
        this.validateKey(key2);
        this.checkReadiness();
        this.checkForNoAccess();
        if (updateStats) {
            return this.getDataView().accessEntry(this.getKeyInfo(key2), this);
        }
        return this.getDataView().getEntry(this.getKeyInfo(key2), this, false);
    }

    protected Region.Entry nonTXGetEntry(KeyInfo keyInfo, boolean access, boolean allowTombstones) {
        boolean miss;
        Object key2 = keyInfo.getKey();
        RegionEntry re = this.entries.getEntry(key2);
        boolean bl = miss = re == null || re.isDestroyedOrRemoved();
        if (access) {
            this.updateStatsForGet(re, !miss);
        }
        if (re == null) {
            return null;
        }
        if (re.isTombstone() ? !allowTombstones : miss) {
            return null;
        }
        NonTXEntry ren = new NonTXEntry(re);
        return ren;
    }

    protected boolean isClosed() {
        return this.cache.isClosed();
    }

    @Override
    public boolean isDestroyed() {
        if (this.isClosed()) {
            return true;
        }
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (this.isDestroyed) {
            if (isTraceEnabled) {
                logger.trace("isDestroyed: true, this.isDestroyed: {}", this.getFullPath());
            }
            return true;
        }
        if (isTraceEnabled) {
            logger.trace("isDestroyed: false : {}", this.getFullPath());
        }
        return false;
    }

    protected Set basicSubregions(boolean recursive) {
        return new SubregionsSet(recursive);
    }

    public Set subregions(boolean recursive) {
        this.checkReadiness();
        return new SubregionsSet(recursive);
    }

    public Set entries(boolean recursive) {
        this.checkReadiness();
        this.checkForNoAccess();
        return this.basicEntries(recursive);
    }

    public Set basicEntries(boolean recursive) {
        return new EntriesSet(this, recursive, IteratorType.ENTRIES, false);
    }

    public Set testHookKeys() {
        this.checkReadiness();
        this.checkForNoAccess();
        return new EntriesSet(this, false, IteratorType.KEYS, false, false, false);
    }

    public Set keys() {
        this.checkReadiness();
        this.checkForNoAccess();
        return new EntriesSet(this, false, IteratorType.KEYS, false);
    }

    public Set keySet(boolean allowTombstones) {
        this.checkReadiness();
        this.checkForNoAccess();
        return new EntriesSet(this, false, IteratorType.KEYS, allowTombstones);
    }

    @Override
    public Collection values() {
        this.checkReadiness();
        this.checkForNoAccess();
        return new EntriesSet(this, false, IteratorType.VALUES, false);
    }

    @Override
    public Object getUserAttribute() {
        return this.regionUserAttribute;
    }

    @Override
    public void setUserAttribute(Object value2) {
        this.checkReadiness();
        this.regionUserAttribute = value2;
    }

    @Override
    public boolean containsKey(Object key2) {
        this.checkReadiness();
        this.checkForNoAccess();
        return this.getDataView().containsKey(this.getKeyInfo(key2), this);
    }

    public boolean containsTombstone(Object key2) {
        this.checkReadiness();
        this.checkForNoAccess();
        if (!this.concurrencyChecksEnabled) {
            return false;
        }
        try {
            Region.Entry entry = this.getDataView().getEntry(this.getKeyInfo(key2), this, true);
            if (entry == null) {
                return false;
            }
            return entry.getValue() == Token.TOMBSTONE;
        }
        catch (EntryDestroyedException e) {
            return true;
        }
    }

    protected boolean nonTXContainsKey(KeyInfo keyInfo) {
        RegionEntry re;
        boolean contains = this.getRegionMap().containsKey(keyInfo.getKey());
        if (contains && this.imageState.isClient() && ((re = this.entries.getEntry(keyInfo.getKey())) == null || re.isDestroyedOrRemoved())) {
            contains = false;
        }
        return contains;
    }

    @Override
    public boolean containsValueForKey(Object key2) {
        this.discoverJTA();
        return this.getDataView().containsValueForKey(this.getKeyInfo(key2), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean nonTXContainsValueForKey(KeyInfo keyInfo) {
        this.checkReadiness();
        this.checkForNoAccess();
        if (this.diskRegion != null) {
            this.diskRegion.setClearCountReference();
        }
        try {
            boolean result;
            RegionEntry entry = this.entries.getEntry(keyInfo.getKey());
            boolean bl = result = entry != null;
            if (result) {
                Object val = entry.getTransformedValue();
                result = !Token.isInvalidOrRemoved(val);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            if (this.diskRegion != null) {
                this.diskRegion.removeClearCountReference();
            }
        }
    }

    public RegionAttributes getAttributes() {
        return this;
    }

    @Override
    public String getName() {
        return this.regionName;
    }

    public String getDisplayName() {
        if (this.isUsedForPartitionedRegionBucket()) {
            return this.getPartitionedRegion().getName();
        }
        return this.regionName;
    }

    public int entryCount() {
        return this.getDataView().entryCount(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRegionSize() {
        Object object = this.getSizeGuard();
        synchronized (object) {
            int result = this.getRegionMap().size();
            if (this.imageState.isClient() && !this.concurrencyChecksEnabled) {
                return result - this.imageState.getDestroyedEntriesCount();
            }
            return result - this.tombstoneCount.get();
        }
    }

    public DiskRegion getDiskRegion() {
        return this.diskRegion;
    }

    @Override
    public DiskRegionView getDiskRegionView() {
        return this.getDiskRegion();
    }

    public void evictValue(Object key2) {
        if (this.getDiskRegion() != null) {
            this.entries.evictValue(key2);
        }
    }

    public void checkLRU() {
        if (this.entriesInitialized) {
            try {
                this.entries.lruUpdateCallback();
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae);
                throw dae;
            }
        }
    }

    protected boolean isOverflowEnabled() {
        EvictionAttributes ea = this.getAttributes().getEvictionAttributes();
        return ea != null && ea.getAction().isOverflowToDisk();
    }

    @Override
    public void writeToDisk() {
        if (this.diskRegion == null) {
            DataPolicy dp = this.getDataPolicy();
            if (dp.isEmpty()) {
                throw new IllegalStateException(LocalizedStrings.LocalRegion_CANNOT_WRITE_A_REGION_WITH_DATAPOLICY_0_TO_DISK.toLocalizedString(dp));
            }
            if (!dp.withPersistence() && !this.isOverflowEnabled()) {
                throw new IllegalStateException(LocalizedStrings.LocalRegion_CANNOT_WRITE_A_REGION_THAT_IS_NOT_CONFIGURED_TO_ACCESS_DISKS.toLocalizedString());
            }
        } else {
            this.diskRegion.asynchForceFlush();
        }
    }

    public void forceFlush() {
        if (this.diskRegion != null) {
            this.diskRegion.flushForTesting();
        }
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        Scope theScope = this.getAttributes().getScope();
        Assert.assertTrue(theScope == Scope.LOCAL);
        throw new IllegalStateException(LocalizedStrings.LocalRegion_ONLY_SUPPORTED_FOR_GLOBAL_SCOPE_NOT_LOCAL.toLocalizedString());
    }

    @Override
    public Lock getDistributedLock(Object key2) throws IllegalStateException {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        Scope theScope = this.getAttributes().getScope();
        Assert.assertTrue(theScope == Scope.LOCAL);
        throw new IllegalStateException(LocalizedStrings.LocalRegion_ONLY_SUPPORTED_FOR_GLOBAL_SCOPE_NOT_LOCAL.toLocalizedString());
    }

    @Override
    public void invalidate(Object key2, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.validatedInvalidate(key2, aCallbackArgument);
    }

    protected void validatedInvalidate(Object key2, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        EntryEventImpl event = new EntryEventImpl(this, Operation.INVALIDATE, key2, null, aCallbackArgument, false, this.getMyId());
        if (this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        this.basicInvalidate(event);
    }

    @Override
    public void localDestroy(Object key2, Object aCallbackArgument) throws EntryNotFoundException {
        this.validateKey(key2);
        this.checkReadiness();
        this.checkForNoAccess();
        EntryEventImpl event = new EntryEventImpl(this, Operation.LOCAL_DESTROY, key2, null, aCallbackArgument, false, this.getMyId());
        if (this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        try {
            this.basicDestroy(event, false, null);
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.LocalRegion_CACHE_WRITER_SHOULD_NOT_HAVE_BEEN_CALLED_FOR_LOCALDESTROY.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.LocalRegion_NO_DISTRIBUTED_LOCK_SHOULD_HAVE_BEEN_ATTEMPTED_FOR_LOCALDESTROY.toLocalizedString(), e);
        }
    }

    @Override
    public void localDestroyRegion(Object aCallbackArgument) {
        this.getDataView().checkSupportsRegionDestroy();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_DESTROY, aCallbackArgument, false, (DistributedMember)this.getMyId(), this.generateEventID());
        try {
            this.basicDestroyRegion(event, false);
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.LocalRegion_CACHEWRITEREXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.LocalRegion_TIMEOUTEXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
        }
    }

    @Override
    public void close() {
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_CLOSE, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        try {
            this.basicDestroyRegion(event, false, true, true);
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.LocalRegion_CACHEWRITEREXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.LocalRegion_TIMEOUTEXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
        }
    }

    @Override
    public void localInvalidate(Object key2, Object callbackArgument) throws EntryNotFoundException {
        this.validateKey(key2);
        this.checkReadiness();
        this.checkForNoAccess();
        EntryEventImpl event = new EntryEventImpl(this, Operation.LOCAL_INVALIDATE, key2, null, callbackArgument, false, this.getMyId());
        if (this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        event.setLocalInvalid(true);
        this.basicInvalidate(event);
    }

    @Override
    public void localInvalidateRegion(Object aCallbackArgument) {
        this.getDataView().checkSupportsRegionInvalidate();
        this.checkReadiness();
        this.checkForNoAccess();
        RegionEventImpl event = new RegionEventImpl(this, Operation.REGION_LOCAL_INVALIDATE, aCallbackArgument, false, this.getMyId());
        this.basicInvalidateRegion(event);
    }

    public static LocalRegion getRegionFromPath(DistributedSystem system, String path) {
        GemFireCacheImpl c = GemFireCacheImpl.getInstance();
        if (c == null) {
            return null;
        }
        return (LocalRegion)c.getRegion(path);
    }

    protected void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        this.initializeSqlfHubDefinitionFlag(this.cache.getHighestOrderHubTypeAssociatedWith(this));
        if (!this.isInternalRegion() && !this.isDestroyed) {
            this.cache.getResourceManager().addResourceListener(this);
        }
        if (this.concurrencyChecksEnabled && this.versionVector == null) {
            this.createVersionVector();
        }
        if (this.scope.isLocal()) {
            this.createOQLIndexes(internalRegionArgs);
            if (this.diskRegion != null) {
                try {
                    this.diskRegion.initializeOwner(this);
                    this.diskRegion.finishInitializeOwner(this, InitialImageOperation.GIIStatus.NO_GII);
                    PersistentMemberID oldId = this.diskRegion.getMyInitializingID();
                    if (oldId == null) {
                        oldId = this.diskRegion.getMyPersistentID();
                    }
                    if (oldId == null) {
                        PersistentMemberID newId = this.diskRegion.generatePersistentID();
                        this.diskRegion.setInitializing(newId);
                        this.diskRegion.setInitialized();
                    }
                }
                catch (DiskAccessException dae) {
                    this.releaseAfterRegionCreateEventLatch();
                    this.handleDiskAccessException(dae, true);
                    throw dae;
                }
            }
        }
        this.releaseBeforeGetInitialImageLatch();
        if (snapshotInputStream != null && this.scope.isLocal()) {
            try {
                this.loadSnapshotDuringInitialization(snapshotInputStream);
            }
            catch (DiskAccessException dae) {
                this.releaseAfterRegionCreateEventLatch();
                this.handleDiskAccessException(dae);
                throw dae;
            }
        }
        this.releaseAfterGetInitialImageLatch();
        if (logger.isDebugEnabled()) {
            logger.debug("Calling addExpiryTasks for {}", this);
        }
        try {
            this.addIdleExpiryTask();
            this.addTTLExpiryTask();
            if (this.isEntryExpiryPossible()) {
                this.rescheduleEntryExpiryTasks();
            }
            this.initialized();
        }
        catch (RegionDestroyedException e) {
            Assert.assertTrue(this.isDestroyed());
        }
    }

    protected void createOQLIndexes(InternalRegionArguments internalRegionArgs) {
        this.createOQLIndexes(internalRegionArgs, false);
    }

    /*
     * Exception decompiling
     */
    protected void createOQLIndexes(InternalRegionArguments internalRegionArgs, boolean recoverFromDisk) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void populateOQLIndexes(Set<Index> indexes) {
        logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_INDEX_LOADING));
        try {
            this.indexManager.populateIndexes(indexes);
        }
        catch (MultiIndexCreationException ex) {
            logger.info("Failed to update index on region {}: {}", this.getFullPath(), ex.getMessage());
        }
    }

    protected void initialized() {
    }

    protected void releaseLatches() {
        this.releaseBeforeGetInitialImageLatch();
        this.releaseAfterGetInitialImageLatch();
        this.releaseAfterRegionCreateEventLatch();
    }

    protected void releaseBeforeGetInitialImageLatch() {
        if (logger.isDebugEnabled()) {
            logger.debug("Releasing Initialization Latch (before initial image) for {}", this.getFullPath());
        }
        LocalRegion.releaseLatch(this.initializationLatchBeforeGetInitialImage);
    }

    protected final void releaseAfterGetInitialImageLatch() {
        if (logger.isDebugEnabled()) {
            logger.debug("Releasing Initialization Latch (after initial image) for {}", this.getFullPath());
        }
        LocalRegion.releaseLatch(this.initializationLatchAfterGetInitialImage);
    }

    private void releaseAfterRegionCreateEventLatch() {
        LocalRegion.releaseLatch(this.afterRegionCreateEventLatch);
    }

    private void waitForRegionCreateEvent() {
        StoppableCountDownLatch l = this.afterRegionCreateEventLatch;
        if (l != null && l.getCount() == 0L) {
            return;
        }
        this.waitOnInitialization(l);
    }

    private static void releaseLatch(StoppableCountDownLatch latch) {
        if (latch == null) {
            return;
        }
        latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveDestroyRegion(Set eventSet, RegionEventImpl p_event, boolean cacheWrite) throws CacheWriterException, TimeoutException {
        boolean isClose;
        RegionEventImpl event;
        block48: {
            event = p_event;
            isClose = event.getOperation().isClose();
            if (eventSet != null && cacheWrite) {
                try {
                    this.cacheWriteBeforeRegionDestroy(event);
                }
                catch (CancelException e) {
                    if (this.cache.forcedDisconnect()) break block48;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_PROBLEM_IN_CACHEWRITEBEFOREREGIONDESTROY), (Throwable)e);
                }
            }
        }
        if (this.eventTracker != null) {
            this.eventTracker.stop();
        }
        if (logger.isTraceEnabled(LogMarker.RVV) && this.getVersionVector() != null) {
            logger.trace(LogMarker.RVV, "version vector for {} is {}", this.getName(), this.getVersionVector().fullToString());
        }
        this.cancelTTLExpiryTask();
        this.cancelIdleExpiryTask();
        this.cancelAllEntryExpiryTasks();
        if (!this.isInternalRegion()) {
            this.getCachePerfStats().incRegions(-1);
        }
        this.cache.getResourceManager(false).removeResourceListener(this);
        if (this.getMembershipAttributes().hasRequiredRoles() && !this.isInternalRegion()) {
            this.getCachePerfStats().incReliableRegions(-1);
        }
        if (eventSet != null) {
            eventSet.add(event);
        }
        try {
            block51: {
                Collection values = this.subregions.values();
                Iterator itr = values.iterator();
                while (itr.hasNext()) {
                    block50: {
                        LocalRegion rgn;
                        Object element = itr.next();
                        try {
                            LocalRegion.setThreadInitLevelRequirement(1);
                            try {
                                rgn = this.toRegion(element);
                            }
                            finally {
                                LocalRegion.setThreadInitLevelRequirement(0);
                            }
                        }
                        catch (CancelException e) {
                            rgn = (LocalRegion)element;
                        }
                        catch (RegionDestroyedException rde) {
                            continue;
                        }
                        if (rgn.isDestroyed) continue;
                        if (eventSet != null) {
                            event = (RegionEventImpl)event.clone();
                            event.region = rgn;
                        }
                        try {
                            rgn.recursiveDestroyRegion(eventSet, event, cacheWrite);
                            if (!rgn.isInternalRegion()) {
                                InternalDistributedSystem system = rgn.cache.getDistributedSystem();
                                system.handleResourceEvent(ResourceEvent.REGION_REMOVE, rgn);
                            }
                        }
                        catch (CancelException e) {
                            if (this.cache.forcedDisconnect()) break block50;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_RECURSION_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, rgn.getFullPath()), (Throwable)e);
                        }
                    }
                    itr.remove();
                }
                try {
                    if (this.indexManager == null) break block51;
                    try {
                        if (this instanceof BucketRegion) {
                            this.indexManager.removeBucketIndexes(this.getPartitionedRegion());
                        }
                        this.indexManager.destroy();
                    }
                    catch (QueryException e) {
                        throw new IndexMaintenanceException(e);
                    }
                }
                catch (CancelException e) {
                    if (this.cache.forcedDisconnect()) break block51;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_BASICDESTROYREGION_INDEX_REMOVAL_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
                }
            }
            if (event.isReinitializing()) {
                this.reinitialized_old = true;
            }
            this.cache.setRegionByPath(this.getFullPath(), null);
            if (this.eventTracker != null) {
                this.eventTracker.stop();
            }
            if (this.diskRegion != null) {
                this.diskRegion.prepareForClose(this);
            }
            this.isDestroyed = true;
            this.cache.getResourceManager(false).removeResourceListener(this);
            this.entries.clear(null);
        }
        catch (Throwable throwable) {
            if (event.isReinitializing()) {
                this.reinitialized_old = true;
            }
            this.cache.setRegionByPath(this.getFullPath(), null);
            if (this.eventTracker != null) {
                this.eventTracker.stop();
            }
            if (this.diskRegion != null) {
                this.diskRegion.prepareForClose(this);
            }
            this.isDestroyed = true;
            this.cache.getResourceManager(false).removeResourceListener(this);
            this.entries.clear(null);
            if (logger.isDebugEnabled()) {
                logger.debug("recursiveDestroyRegion: Region Destroyed: {}", this.getFullPath());
            }
            try {
                this.postDestroyRegion(!isClose, event);
            }
            catch (CancelException e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_POSTDESTROYREGION_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
            }
            if (this.getServerProxy() == null) {
                this.closeCqs();
            }
            this.detachPool();
            if (eventSet != null) {
                this.closeCallbacksExceptListener();
            } else {
                this.closeAllCallbacks();
            }
            if (this.concurrencyChecksEnabled && this.dataPolicy.withReplication() && !this.cache.isClosed()) {
                this.cache.getTombstoneService().unscheduleTombstones(this);
            }
            if (this.hasOwnStats) {
                this.cachePerfStats.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("recursiveDestroyRegion: Region Destroyed: {}", this.getFullPath());
        }
        try {
            this.postDestroyRegion(!isClose, event);
        }
        catch (CancelException e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_POSTDESTROYREGION_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
        }
        if (this.getServerProxy() == null) {
            this.closeCqs();
        }
        this.detachPool();
        if (eventSet != null) {
            this.closeCallbacksExceptListener();
        } else {
            this.closeAllCallbacks();
        }
        if (this.concurrencyChecksEnabled && this.dataPolicy.withReplication() && !this.cache.isClosed()) {
            this.cache.getTombstoneService().unscheduleTombstones(this);
        }
        if (this.hasOwnStats) {
            this.cachePerfStats.close();
        }
    }

    @Override
    public void checkReadiness() {
        this.checkRegionDestroyed(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findObjectInSystem(KeyInfo keyInfo, boolean isCreate, TXStateInterface tx, boolean generateCallbacks, Object localValue, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws CacheLoaderException, TimeoutException {
        RegionEntry re;
        Object value2;
        Object key2;
        block20: {
            CacheLoader loader;
            key2 = keyInfo.getKey();
            Object aCallbackArgument = keyInfo.getCallbackArg();
            value2 = null;
            boolean fromServer = false;
            EntryEventImpl holder = null;
            ServerRegionProxy mySRP = this.getServerProxy();
            if (mySRP != null) {
                holder = EntryEventImpl.createVersionTagHolder();
                value2 = mySRP.get(key2, aCallbackArgument, holder);
                boolean bl = fromServer = value2 != null;
            }
            if (!fromServer && (loader = this.basicGetLoader()) != null) {
                LoaderHelper loaderHelper = this.loaderHelperFactory.createLoaderHelper(key2, aCallbackArgument, false, true, null);
                CachePerfStats stats = this.getCachePerfStats();
                long statStart = stats.startLoad();
                try {
                    value2 = loader.load(loaderHelper);
                }
                finally {
                    stats.endLoad(statStart);
                }
            }
            re = null;
            if (value2 != null && !this.isHeapThresholdReachedForLoad()) {
                long startPut = CachePerfStats.getStatTime();
                this.validateKey(key2);
                Operation op = isCreate ? Operation.LOCAL_LOAD_CREATE : Operation.LOCAL_LOAD_UPDATE;
                EntryEventImpl event = new EntryEventImpl(this, op, key2, value2, aCallbackArgument, false, this.getMyId(), generateCallbacks);
                if (fromServer) {
                    if (this.alreadyInvalid(key2, event)) {
                        return null;
                    }
                    event.setFromServer(fromServer);
                    event.setVersionTag(holder.getVersionTag());
                    if (clientEvent != null) {
                        clientEvent.setVersionTag(holder.getVersionTag());
                    }
                }
                if (!fromServer) {
                    event.setNewEventId(this.cache.getDistributedSystem());
                }
                try {
                    try {
                        re = this.basicPutEntry(event, 0L);
                        if (!fromServer && clientEvent != null) {
                            clientEvent.setVersionTag(event.getVersionTag());
                            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
                        }
                        if (fromServer && event.getNewValue() == Token.TOMBSTONE) {
                            return null;
                        }
                    }
                    catch (ConcurrentCacheModificationException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("caught concurrent modification attempt when applying {}", event);
                        }
                        this.notifyBridgeClients(event);
                    }
                    if (!this.getDataView().isDeferredStats()) {
                        this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
                    }
                }
                catch (CacheWriterException cwe) {
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug("findObjectInSystem: writer exception putting entry {}", event, cwe);
                }
            }
        }
        if (isCreate) {
            this.recordMiss(re, key2);
        }
        return value2;
    }

    protected boolean isHeapThresholdReachedForLoad() {
        return this.heapThresholdReached.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean alreadyInvalid(Object key2, EntryEventImpl event) {
        RegionEntry entry;
        Object newValue = event.getRawNewValue();
        if ((newValue == null || Token.isInvalid(newValue)) && (entry = this.entries.getEntry(key2)) != null) {
            RegionEntry regionEntry = entry;
            synchronized (regionEntry) {
                if (entry.isInvalid()) {
                    VersionStamp stamp = entry.getVersionStamp();
                    if (stamp == null || event.getVersionTag() == null) {
                        return true;
                    }
                    if (stamp.getEntryVersion() >= event.getVersionTag().getEntryVersion()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cacheWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        boolean result = false;
        CacheWriter writer = this.basicGetWriter();
        if (writer != null && event.getOperation() != Operation.REMOVE && !event.inhibitAllNotifications()) {
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                writer.beforeDestroy(event);
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
            result = true;
        }
        this.serverDestroy(event, expectedOldValue);
        return result;
    }

    protected boolean bridgeWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        if (this.hasServerProxy()) {
            this.serverDestroy(event, expectedOldValue);
            return true;
        }
        return false;
    }

    protected void serverRegionDestroy(RegionEventImpl regionEvent) {
        ServerRegionProxy mySRP;
        if (regionEvent.getOperation().isDistributed() && (mySRP = this.getServerProxy()) != null) {
            EventID eventId = regionEvent.getEventId();
            Object callbackArg = regionEvent.getRawCallbackArgument();
            mySRP.destroyRegion(eventId, callbackArg);
        }
    }

    protected void serverRegionClear(RegionEventImpl regionEvent) {
        ServerRegionProxy mySRP;
        if (regionEvent.getOperation().isDistributed() && (mySRP = this.getServerProxy()) != null) {
            EventID eventId = regionEvent.getEventId();
            Object callbackArg = regionEvent.getRawCallbackArgument();
            mySRP.clear(eventId, callbackArg);
        }
    }

    protected void serverRegionInvalidate(RegionEventImpl regionEvent) {
        ServerRegionProxy mySRP;
        if (!regionEvent.getOperation().isDistributed() || (mySRP = this.getServerProxy()) != null) {
            // empty if block
        }
    }

    protected void serverInvalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        ServerRegionProxy mySRP;
        if (event.getOperation().isDistributed() && (mySRP = this.getServerProxy()) != null) {
            mySRP.invalidate(event);
        }
    }

    protected void serverPut(EntryEventImpl event, boolean requireOldValue, Object expectedOldValue) {
        ServerRegionProxy mySRP;
        if (event.getOperation().isDistributed() && !event.isFromServer() && (mySRP = this.getServerProxy()) != null) {
            if (event.isBulkOpInProgress()) {
                return;
            }
            Operation op = event.getOperation();
            Object key2 = event.getKey();
            Object value2 = event.getRawNewValue();
            Object callbackArg = event.getRawCallbackArgument();
            boolean isCreate = event.isCreate();
            Object result = mySRP.put(key2, value2, event.getDeltaBytes(), event, op, requireOldValue, expectedOldValue, callbackArg, isCreate);
            this.getCancelCriterion().checkCancelInProgress(null);
            if (op.guaranteesOldValue()) {
                if (op != Operation.REPLACE || requireOldValue) {
                    event.setConcurrentMapOldValue(result);
                }
                if (op == Operation.PUT_IF_ABSENT) {
                    if (result != null) {
                        throw new EntryNotFoundException("entry existed for putIfAbsent");
                    }
                } else if (op == Operation.REPLACE) {
                    if (requireOldValue && result == null) {
                        throw new EntryNotFoundException("entry not found for replace");
                    }
                    if (!requireOldValue && !((Boolean)result).booleanValue()) {
                        throw new EntryNotFoundException("entry found with wrong value");
                    }
                }
            }
        }
    }

    protected void serverDestroy(EntryEventImpl event, Object expectedOldValue) {
        ServerRegionProxy mySRP;
        if (event.getOperation().isDistributed() && (mySRP = this.getServerProxy()) != null) {
            Object key2 = event.getKey();
            Object callbackArg = event.getRawCallbackArgument();
            Object result = mySRP.destroy(key2, expectedOldValue, event.getOperation(), event, callbackArg);
            if (result instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cacheWriteBeforeRegionDestroy(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        boolean result = false;
        CacheWriter writer = this.basicGetWriter();
        if (writer != null) {
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                writer.beforeRegionDestroy(event);
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
            result = true;
        }
        this.serverRegionDestroy(event);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cacheWriteBeforeRegionClear(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        boolean result = false;
        CacheWriter writer = this.basicGetWriter();
        if (writer != null) {
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                writer.beforeRegionClear(event);
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
            result = true;
        }
        this.serverRegionClear(event);
        return result;
    }

    void cacheWriteBeforeInvalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        if (!event.getOperation().isLocal() && !event.isOriginRemote()) {
            this.serverInvalidate(event, invokeCallbacks, forceNewEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheWriteBeforePut(EntryEventImpl event, Set netWriteRecipients, CacheWriter localWriter, boolean requireOldValue, Object expectedOldValue) throws CacheWriterException, TimeoutException {
        Assert.assertTrue(netWriteRecipients == null);
        Operation op = event.getOperation();
        if (op != Operation.PUT_IF_ABSENT && op != Operation.REPLACE && localWriter != null && !event.inhibitAllNotifications()) {
            long start = this.getCachePerfStats().startCacheWriterCall();
            boolean newEntry = event.getOperation().isCreate();
            try {
                if (!newEntry) {
                    localWriter.beforeUpdate(event);
                } else {
                    localWriter.beforeCreate(event);
                }
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
        }
        this.serverPut(event, requireOldValue, expectedOldValue);
    }

    protected void validateArguments(Object key2, Object value2, Object aCallbackArgument) {
        this.validateKey(key2);
        this.validateValue(value2);
        this.validateCallbackArg(aCallbackArgument);
    }

    protected void validateKey(Object key2) {
        if (key2 == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_KEY_CANNOT_BE_NULL.toLocalizedString());
        }
        if (this.keyConstraint != null && !this.keyConstraint.isInstance(key2)) {
            throw new ClassCastException(LocalizedStrings.LocalRegion_KEY_0_DOES_NOT_SATISFY_KEYCONSTRAINT_1.toLocalizedString(key2.getClass().getName(), this.keyConstraint.getName()));
        }
    }

    protected void validateCallbackArg(Object aCallbackArgument) {
    }

    protected void validateValue(Object p_value) {
        Object value2 = p_value;
        if (this.valueConstraint != null && value2 != null) {
            if (value2 instanceof CachedDeserializable) {
                if (this.DO_EXPENSIVE_VALIDATIONS) {
                    value2 = ((CachedDeserializable)value2).getDeserializedValue(null, null);
                } else {
                    return;
                }
            }
            if (!this.valueConstraint.isInstance(value2)) {
                throw new ClassCastException(LocalizedStrings.LocalRegion_VALUE_0_DOES_NOT_SATISFY_VALUECONSTRAINT_1.toLocalizedString(value2.getClass().getName(), this.valueConstraint.getName()));
            }
        }
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.cachePerfStats;
    }

    public CachePerfStats getRegionPerfStats() {
        return this.cachePerfStats;
    }

    public void incTombstoneCount(int delta) {
        this.tombstoneCount.addAndGet(delta);
        this.cachePerfStats.incTombstoneCount(delta);
        this.cachePerfStats.incEntryCount(-delta);
        if (this.getDiskRegion() != null) {
            this.getDiskRegion().incNumEntriesInVM(-delta);
        }
        DiskEntry.Helper.incrementBucketStats(this, -delta, 0, 0);
    }

    public int getTombstoneCount() {
        return this.tombstoneCount.get();
    }

    public void scheduleTombstone(RegionEntry entry, VersionTag destroyedVersion) {
        if (destroyedVersion == null) {
            throw new NullPointerException("destroyed version tag cannot be null");
        }
        this.incTombstoneCount(1);
        if (logger.isTraceEnabled(LogMarker.TOMBSTONE_COUNT)) {
            logger.trace(LogMarker.TOMBSTONE_COUNT, "scheduling tombstone for {} version={} count is {} entryMap size is {}", entry.getKey(), entry.getVersionStamp().asVersionTag(), this.tombstoneCount.get(), this.entries.size());
        }
        this.getGemFireCache().getTombstoneService().scheduleTombstone(this, entry, destroyedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescheduleTombstone(RegionEntry entry, VersionTag version) {
        Object sync;
        Object object = sync = TombstoneService.DEBUG_TOMBSTONE_COUNT ? TombstoneService.debugSync : new Object();
        synchronized (object) {
            this.unscheduleTombstone(entry, false);
            this.scheduleTombstone(entry, version);
        }
    }

    public void unscheduleTombstone(RegionEntry entry) {
        this.unscheduleTombstone(entry, true);
    }

    private void unscheduleTombstone(RegionEntry entry, boolean validate) {
        this.incTombstoneCount(-1);
        if (logger.isTraceEnabled(LogMarker.TOMBSTONE)) {
            logger.trace(LogMarker.TOMBSTONE, "unscheduling tombstone for {} count is {} entryMap size is {}", entry.getKey(), this.tombstoneCount.get(), this.entries.size());
        }
        this.getRegionMap().unscheduleTombstone(entry);
        if (logger.isTraceEnabled(LogMarker.TOMBSTONE_COUNT) && validate && this.entries instanceof AbstractRegionMap) {
            ((AbstractRegionMap)this.entries).verifyTombstoneCount(this.tombstoneCount);
        }
    }

    public void expireTombstones(Map<VersionSource, Long> regionGCVersions, EventID eventID, FilterRoutingInfo.FilterInfo clientRouting) {
        Set<Object> keys = null;
        if (!this.concurrencyChecksEnabled) {
            return;
        }
        if (!this.versionVector.containsTombstoneGCVersions(regionGCVersions) && (keys = this.cache.getTombstoneService().gcTombstones(this, regionGCVersions)) == null) {
            return;
        }
        if (eventID != null) {
            this.notifyClientsOfTombstoneGC(regionGCVersions, keys, eventID, clientRouting);
        }
    }

    public void expireTombstoneKeys(Set<Object> tombstoneKeys) {
        if (this.concurrencyChecksEnabled) {
            this.cache.getTombstoneService().gcTombstoneKeys(this, tombstoneKeys);
        }
    }

    protected void notifyClientsOfTombstoneGC(Map<VersionSource, Long> regionGCVersions, Set<Object> keysRemoved, EventID eventID, FilterRoutingInfo.FilterInfo routing) {
        FilterProfile fp;
        if (CacheClientNotifier.getInstance() != null && ((fp = this.getFilterProfile()) != null || routing != null)) {
            RegionEventImpl regionEvent = new RegionEventImpl(this, Operation.REGION_DESTROY, null, true, this.getMyId());
            regionEvent.setEventID(eventID);
            FilterRoutingInfo.FilterInfo clientRouting = routing;
            if (clientRouting == null) {
                clientRouting = fp.getLocalFilterRouting(regionEvent);
            }
            regionEvent.setLocalFilterInfo(clientRouting);
            ClientTombstoneMessage clientMessage = ClientTombstoneMessage.gc(this, regionGCVersions, eventID);
            CacheClientNotifier.notifyClients(regionEvent, clientMessage);
        }
    }

    protected boolean shouldGenerateVersionTag(RegionEntry entry, EntryEventImpl event) {
        if (this.getDataPolicy().withPersistence()) {
            return true;
        }
        return this.concurrencyChecksEnabled && (entry.getVersionStamp().hasValidVersion() || this.dataPolicy.withReplication());
    }

    protected void enableConcurrencyChecks() {
        this.concurrencyChecksEnabled = true;
        if (this.dataPolicy.withStorage()) {
            RegionEntryFactory versionedEntryFactory = this.entries.getEntryFactory().makeVersioned();
            Assert.assertTrue(this.entries.size() == 0, "RegionMap should be empty but was of size:" + this.entries.size());
            this.entries.setEntryFactory(versionedEntryFactory);
            this.createVersionVector();
        }
    }

    protected void validateSubregionAttributes(RegionAttributes attrs) {
        if (attrs == null) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_REGION_ATTRIBUTES_MUST_NOT_BE_NULL.toLocalizedString());
        }
        if (this.scope == Scope.LOCAL && attrs.getScope() != Scope.LOCAL) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_A_REGION_WITH_SCOPELOCAL_CAN_ONLY_HAVE_SUBREGIONS_WITH_SCOPELOCAL.toLocalizedString());
        }
    }

    public Object getValueInVM(Object key2) throws EntryNotFoundException {
        return this.basicGetValueInVM(key2, true);
    }

    public Object getValueInVM(EntryEventImpl event) throws EntryNotFoundException {
        return this.basicGetValueInVM(event.getKey(), true);
    }

    private Object basicGetValueInVM(Object key2, boolean rememberRead) throws EntryNotFoundException {
        return this.getDataView().getValueInVM(this.getKeyInfo(key2), this, rememberRead);
    }

    protected Object nonTXbasicGetValueInVM(KeyInfo keyInfo) {
        RegionEntry re = this.entries.getEntry(keyInfo.getKey());
        if (re == null) {
            throw new EntryNotFoundException(keyInfo.getKey().toString());
        }
        Object v = re.getValueInVM(this);
        if (Token.isRemoved(v)) {
            throw new EntryNotFoundException(keyInfo.getKey().toString());
        }
        if (v == Token.NOT_AVAILABLE) {
            return null;
        }
        return v;
    }

    public Set testHookTXKeys() {
        if (!this.isTX()) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_TX_NOT_IN_PROGRESS.toLocalizedString());
        }
        TXStateProxyImpl tx = (TXStateProxyImpl)this.getTXState();
        if (!tx.isRealDealLocal()) {
            return Collections.EMPTY_SET;
        }
        TXRegionState txr = this.txReadRegion();
        if (txr == null) {
            return Collections.EMPTY_SET;
        }
        return txr.getEntryKeys();
    }

    public Object getValueOnDisk(Object key2) throws EntryNotFoundException {
        RegionEntry re = this.entries.getEntry(key2);
        if (re == null) {
            throw new EntryNotFoundException(key2.toString());
        }
        return re.getValueOnDisk(this);
    }

    public Object getValueInVMOrDiskWithoutFaultIn(Object key2) throws EntryNotFoundException {
        RegionEntry re = this.entries.getEntry(key2);
        if (re == null) {
            throw new EntryNotFoundException(key2.toString());
        }
        return re.getValueInVMOrDiskWithoutFaultIn(this);
    }

    public Object getSerializedValueOnDisk(Object key2) throws EntryNotFoundException {
        RegionEntry re = this.entries.getEntry(key2);
        if (re == null) {
            throw new EntryNotFoundException(key2.toString());
        }
        Object result = re.getSerializedValueOnDisk(this);
        if (Token.isInvalid(result)) {
            result = null;
        } else if (Token.isRemoved(result)) {
            throw new EntryNotFoundException(key2.toString());
        }
        return result;
    }

    public Object getValueOnDiskOrBuffer(Object key2) throws EntryNotFoundException {
        RegionEntry re = this.entries.getEntry(key2);
        if (re == null) {
            throw new EntryNotFoundException(key2.toString());
        }
        return re.getValueOnDiskOrBuffer(this);
    }

    public Object getNoLRU(Object k, boolean adamant, boolean allowTombstone, boolean serializedFormOkay) {
        Object o = null;
        try {
            o = this.getValueInVM(k);
            if (o == null) {
                o = this.getValueOnDiskOrBuffer(k);
                if (o == null) {
                    o = this.getValueInVM(k);
                    if (o == null) {
                        if (adamant) {
                            o = this.get(k);
                        }
                    } else if (!serializedFormOkay && o instanceof CachedDeserializable) {
                        o = ((CachedDeserializable)o).getDeserializedValue(this, this.getRegionEntry(k));
                    }
                }
            } else if (!serializedFormOkay && o instanceof CachedDeserializable) {
                o = ((CachedDeserializable)o).getDeserializedValue(this, this.getRegionEntry(k));
            }
        }
        catch (EntryNotFoundException ok) {
            // empty catch block
        }
        if (o == Token.TOMBSTONE && !allowTombstone) {
            o = null;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
        if (this.isProxy()) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_REGIONS_WITH_DATAPOLICY_0_DO_NOT_SUPPORT_SAVESNAPSHOT.toLocalizedString(this.getDataPolicy()));
        }
        this.checkForNoAccess();
        try (DataOutputStream out = new DataOutputStream(outputStream);){
            out.writeByte(1);
            for (Region.Entry entry : this.entries(false)) {
                try {
                    Object key2 = entry.getKey();
                    Object value2 = entry.getValue();
                    if (value2 == Token.TOMBSTONE) continue;
                    DataSerializer.writeObject(key2, out);
                    if (value2 == null) {
                        NonTXEntry lre = (NonTXEntry)entry;
                        RegionEntry re = lre.getRegionEntry();
                        value2 = re.getValue(this);
                        if (value2 == Token.INVALID) {
                            out.writeByte(24);
                            continue;
                        }
                        if (value2 == Token.LOCAL_INVALID) {
                            out.writeByte(25);
                            continue;
                        }
                        out.writeByte(23);
                        DataSerializer.writeObject(value2, out);
                        continue;
                    }
                    out.writeByte(23);
                    DataSerializer.writeObject(value2, out);
                }
                catch (EntryDestroyedException e) {}
            }
            DataSerializer.writeObject(null, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSnapshot4ConvertTo65(InputStream inputStream) throws CacheWriterException, TimeoutException, ClassNotFoundException, IOException {
        isConversion.set(true);
        try {
            this.loadSnapshot(inputStream);
        }
        finally {
            isConversion.remove();
        }
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws CacheWriterException, TimeoutException, ClassNotFoundException, IOException {
        if (this.isProxy()) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_REGIONS_WITH_DATAPOLICY_0_DO_NOT_SUPPORT_LOADSNAPSHOT.toLocalizedString(this.getDataPolicy()));
        }
        if (inputStream == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_INPUTSTREAM_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOAD_SNAPSHOT, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.reinitialize(inputStream, event);
    }

    public void registerInterest(Object key2) {
        this.registerInterest(key2, false);
    }

    public void registerInterest(Object key2, boolean isDurable) {
        this.registerInterest(key2, isDurable, true);
    }

    public void registerInterest(Object key2, boolean isDurable, boolean receiveValues) {
        this.registerInterest(key2, InterestResultPolicy.DEFAULT, isDurable, receiveValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRegisterInterest() {
        this.getImageState().writeLockRI();
        try {
            this.cache.registerInterestStarted();
            ++this.riCnt;
        }
        finally {
            this.getImageState().writeUnlockRI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRegisterInterest() {
        if (Boolean.getBoolean("gemfire.testing.slow-interest-recovery")) {
            if (logger.isDebugEnabled()) {
                logger.debug("slowing interest recovery...");
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("done slowing interest recovery");
            }
        }
        boolean gotLock = false;
        try {
            this.getImageState().writeLockRI();
            gotLock = true;
            --this.riCnt;
            Assert.assertTrue(this.riCnt >= 0, "register interest count can not be < 0 ");
            if (this.riCnt == 0) {
                this.destroyEntriesAndClearDestroyedKeysSet();
            }
        }
        finally {
            this.cache.registerInterestCompleted();
            if (gotLock) {
                this.getImageState().writeUnlockRI();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleInterest(Object key2, int interestType2, InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        block39: {
            ServerRegionProxy proxy = this.getServerProxy();
            if (proxy == null) {
                throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_REGISTRATION_REQUIRES_A_POOL.toLocalizedString());
            }
            if (isDurable && !proxy.getPool().isDurableClient()) {
                throw new IllegalStateException(LocalizedStrings.LocalRegion_DURABLE_FLAG_ONLY_APPLICABLE_FOR_DURABLE_CLIENTS.toLocalizedString());
            }
            if (!proxy.getPool().getSubscriptionEnabled()) {
                if (proxy.getPool() instanceof BridgePoolImpl) {
                    String msg = "Interest registration requires establishCallbackConnection to be set to true.";
                    throw new BridgeWriterException(msg);
                }
                String msg = "Interest registration requires a pool whose queue is enabled.";
                throw new SubscriptionNotEnabledException(msg);
            }
            if (this.getAttributes().getDataPolicy().withReplication() && !this.getAttributes().getScope().isLocal()) {
                throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_REGISTRATION_NOT_SUPPORTED_ON_REPLICATED_REGIONS.toLocalizedString());
            }
            if (key2 == null) {
                throw new IllegalArgumentException(LocalizedStrings.LocalRegion_INTEREST_KEY_MUST_NOT_BE_NULL.toLocalizedString());
            }
            this.startRegisterInterest();
            try {
                List serverKeys;
                this.clearKeysOfInterest(key2, interestType2, pol);
                if (PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG) {
                    BridgeObserver bo = BridgeObserverHolder.getInstance();
                    bo.beforeInterestRegistration();
                }
                byte regionDataPolicy = this.getAttributes().getDataPolicy().ordinal;
                switch (interestType2) {
                    case 2: {
                        serverKeys = proxy.registerInterest(key2, interestType2, pol, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                        break;
                    }
                    case 0: {
                        if (key2 instanceof String && key2.equals("ALL_KEYS")) {
                            serverKeys = proxy.registerInterest(".*", 1, pol, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                            break;
                        }
                        if (key2 instanceof List) {
                            serverKeys = proxy.registerInterestList((List)key2, pol, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                            break;
                        }
                        serverKeys = proxy.registerInterest(key2, 0, pol, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                        break;
                    }
                    case 3: {
                        serverKeys = proxy.registerInterest(key2, 3, pol, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                        break;
                    }
                    case 1: {
                        String regex = (String)key2;
                        Pattern.compile(regex);
                        serverKeys = proxy.registerInterest(regex, 1, pol, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                        break;
                    }
                    default: {
                        throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNKNOWN_INTEREST_TYPE.toLocalizedString());
                    }
                }
                boolean finishedRefresh = false;
                try {
                    this.refreshEntriesFromServerKeys(null, serverKeys, pol);
                    finishedRefresh = true;
                    if (finishedRefresh) break block39;
                }
                catch (Throwable throwable) {
                    if (!finishedRefresh) {
                        switch (interestType2) {
                            case 2: {
                                proxy.unregisterInterest(key2, interestType2, false, false);
                                break;
                            }
                            case 0: {
                                if (key2 instanceof String && key2.equals("ALL_KEYS")) {
                                    proxy.unregisterInterest(".*", 1, false, false);
                                    break;
                                }
                                if (key2 instanceof List) {
                                    proxy.unregisterInterestList((List)key2, false, false);
                                    break;
                                }
                                proxy.unregisterInterest(key2, 0, false, false);
                                break;
                            }
                            case 3: {
                                proxy.unregisterInterest(key2, 3, false, false);
                                break;
                            }
                            case 1: {
                                proxy.unregisterInterest(key2, 1, false, false);
                                break;
                            }
                            default: {
                                throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNKNOWN_INTEREST_TYPE.toLocalizedString());
                            }
                        }
                    }
                    throw throwable;
                }
                switch (interestType2) {
                    case 2: {
                        proxy.unregisterInterest(key2, interestType2, false, false);
                        break;
                    }
                    case 0: {
                        if (key2 instanceof String && key2.equals("ALL_KEYS")) {
                            proxy.unregisterInterest(".*", 1, false, false);
                        } else if (key2 instanceof List) {
                            proxy.unregisterInterestList((List)key2, false, false);
                        } else {
                            proxy.unregisterInterest(key2, 0, false, false);
                        }
                        break;
                    }
                    case 3: {
                        proxy.unregisterInterest(key2, 3, false, false);
                        break;
                    }
                    case 1: {
                        proxy.unregisterInterest(key2, 1, false, false);
                        break;
                    }
                    default: {
                        throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNKNOWN_INTEREST_TYPE.toLocalizedString());
                    }
                }
            }
            finally {
                this.finishRegisterInterest();
            }
        }
    }

    public void registerInterest(Object key2, InterestResultPolicy policy) {
        this.registerInterest(key2, policy, false);
    }

    public void registerInterest(Object key2, InterestResultPolicy policy, boolean isDurable) {
        this.registerInterest(key2, policy, isDurable, true);
    }

    public void registerInterest(Object key2, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        this.processSingleInterest(key2, 0, policy, isDurable, !receiveValues);
    }

    @Override
    public void registerInterestRegex(String regex) {
        this.registerInterestRegex(regex, false);
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable) {
        this.registerInterestRegex(regex, InterestResultPolicy.DEFAULT, isDurable, true);
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable, boolean receiveValues) {
        this.registerInterestRegex(regex, InterestResultPolicy.DEFAULT, isDurable, receiveValues);
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy) {
        this.registerInterestRegex(regex, policy, false);
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable) {
        this.registerInterestRegex(regex, policy, isDurable, true);
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        this.processSingleInterest(regex, 1, policy, isDurable, !receiveValues);
    }

    public void registerInterestFilter(String className) {
        this.registerInterestFilter(className, false);
    }

    public void registerInterestFilter(String className, boolean isDurable) {
        this.registerInterestFilter(className, isDurable, true);
    }

    public void registerInterestFilter(String className, boolean isDurable, boolean receiveValues) {
        this.processSingleInterest(className, 2, InterestResultPolicy.DEFAULT, isDurable, !receiveValues);
    }

    public void registerInterestOQL(String query) {
        this.registerInterestOQL(query, false);
    }

    public void registerInterestOQL(String query, boolean isDurable) {
        this.registerInterestOQL(query, isDurable, true);
    }

    public void registerInterestOQL(String query, boolean isDurable, boolean receiveValues) {
        this.processSingleInterest(query, 3, InterestResultPolicy.DEFAULT, isDurable, !receiveValues);
    }

    public void unregisterInterest(Object key2) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            if (key2 instanceof String && key2.equals("ALL_KEYS")) {
                proxy.unregisterInterest(".*", 1, false, false);
            } else if (key2 instanceof List) {
                proxy.unregisterInterestList((List)key2, false, false);
            } else {
                proxy.unregisterInterest(key2, 0, false, false);
            }
        } else {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
        }
    }

    @Override
    public void unregisterInterestRegex(String regex) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy == null) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
        }
        proxy.unregisterInterest(regex, 1, false, false);
    }

    public void unregisterInterestFilter(String className) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy == null) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
        }
        proxy.unregisterInterest(className, 2, false, false);
    }

    public void unregisterInterestOQL(String query) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy == null) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
        }
        proxy.unregisterInterest(query, 3, false, false);
    }

    public List getInterestList() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.getInterestList(0);
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
    }

    public Set getKeysWithInterest(int interestType2, Object interestArg, boolean allowTombstones) {
        HashSet<Object> ret = null;
        if (interestType2 == 1) {
            if (interestArg == null || ".*".equals(interestArg)) {
                ret = new HashSet<Object>(this.keySet(allowTombstones));
            } else {
                ret = new HashSet();
                if (!(interestArg instanceof String)) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_REGULAR_EXPRESSION_ARGUMENT_WAS_NOT_A_STRING.toLocalizedString());
                }
                Pattern keyPattern = Pattern.compile((String)interestArg);
                for (Object entryKey : this.keySet(allowTombstones)) {
                    if (!(entryKey instanceof String) || !keyPattern.matcher((String)entryKey).matches()) continue;
                    ret.add(entryKey);
                }
            }
        } else if (interestType2 == 0) {
            if (interestArg instanceof List) {
                ret = new HashSet();
                List keyList = (List)interestArg;
                for (Object entryKey : keyList) {
                    if (!this.containsKey(entryKey) && (!allowTombstones || !this.containsTombstone(entryKey))) continue;
                    ret.add(entryKey);
                }
            } else {
                ret = new HashSet();
                if (this.containsKey(interestArg) || allowTombstones && this.containsTombstone(interestArg)) {
                    ret.add(interestArg);
                }
            }
        } else {
            if (interestType2 == 2) {
                throw new UnsupportedOperationException(LocalizedStrings.AbstractRegion_INTERESTTYPEFILTER_CLASS_NOT_YET_SUPPORTED.toLocalizedString());
            }
            if (interestType2 == 3) {
                throw new UnsupportedOperationException(LocalizedStrings.AbstractRegion_INTERESTTYPEOQL_QUERY_NOT_YET_SUPPORTED.toLocalizedString());
            }
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_UNSUPPORTED_INTEREST_TYPE_0.toLocalizedString(interestType2));
        }
        return ret;
    }

    public List getInterestListRegex() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.getInterestList(1);
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_LIST_RETRIEVAL_REQUIRES_A_POOL.toLocalizedString());
    }

    public List getInterestListFilters() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.getInterestList(2);
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_LIST_RETRIEVAL_REQUIRES_A_POOL.toLocalizedString());
    }

    public List getInterestListOQL() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.getInterestList(3);
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_LIST_RETRIEVAL_REQUIRES_A_POOL.toLocalizedString());
    }

    public Set keySetOnServer() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.keySet();
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_SERVER_KEYSET_REQUIRES_A_POOL.toLocalizedString());
    }

    @Override
    public boolean containsKeyOnServer(Object key2) {
        this.checkReadiness();
        this.checkForNoAccess();
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.containsKey(key2);
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_SERVER_KEYSET_REQUIRES_A_POOL.toLocalizedString());
    }

    protected void localDestroyNoCallbacks(Object key2) {
        if (logger.isDebugEnabled()) {
            logger.debug("localDestroyNoCallbacks key={}", key2);
        }
        this.checkReadiness();
        this.validateKey(key2);
        EntryEventImpl event = new EntryEventImpl(this, Operation.LOCAL_DESTROY, key2, false, this.getMyId(), false, true);
        try {
            this.basicDestroy(event, false, null);
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.LocalRegion_CACHE_WRITER_SHOULD_NOT_HAVE_BEEN_CALLED_FOR_LOCALDESTROY.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.LocalRegion_NO_DISTRIBUTED_LOCK_SHOULD_HAVE_BEEN_ATTEMPTED_FOR_LOCALDESTROY.toLocalizedString(), e);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
    }

    private void clearViaList(List keys) {
        for (Region.Entry entry : this.entries(false)) {
            try {
                Object entryKey = entry.getKey();
                boolean match = false;
                for (Object k : keys) {
                    if (!entryKey.equals(k)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                this.localDestroyNoCallbacks(entryKey);
            }
            catch (EntryDestroyedException ignore) {}
        }
    }

    private void clearViaRegEx(String key2) {
        Pattern keyPattern = Pattern.compile(key2);
        for (Region.Entry entry : this.entries(false)) {
            try {
                Object entryKey = entry.getKey();
                if (!(entryKey instanceof String) || !keyPattern.matcher((String)entryKey).matches()) continue;
                this.localDestroyNoCallbacks(entryKey);
            }
            catch (EntryDestroyedException ignore) {}
        }
    }

    private void clearViaFilterClass(String key2) {
        InterestFilter filter;
        try {
            Class filterClass = ClassLoadUtil.classFromName(key2);
            filter = (InterestFilter)filterClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(LocalizedStrings.LocalRegion_CLASS_0_NOT_FOUND_IN_CLASSPATH.toLocalizedString(key2), cnfe);
        }
        catch (Exception e) {
            throw new RuntimeException(LocalizedStrings.LocalRegion_CLASS_0_COULD_NOT_BE_INSTANTIATED.toLocalizedString(key2), e);
        }
        for (Region.Entry entry : this.entries(false)) {
            try {
                InterestEvent e;
                Object entryKey = entry.getKey();
                if (!(entryKey instanceof String) || !filter.notifyOnRegister(e = new InterestEvent(entryKey, entry.getValue(), true))) continue;
                this.localDestroyNoCallbacks(entryKey);
            }
            catch (EntryDestroyedException ignore) {}
        }
    }

    private void clearViaQuery(String query) {
        throw new InternalGemFireError(LocalizedStrings.LocalRegion_NOT_YET_SUPPORTED.toLocalizedString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshEntriesFromServerKeys(Connection con, List serverKeys, InterestResultPolicy pol) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (logger.isDebugEnabled()) {
            this.logKeys(serverKeys, pol);
        }
        if (pol == InterestResultPolicy.NONE) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("refreshEntries region={}", this.getFullPath());
        }
        for (ArrayList keysList : serverKeys) {
            Endpoint endpoint;
            if (keysList == null) continue;
            if (EntryLogger.isEnabled() && con != null && (endpoint = con.getEndpoint()) != null) {
                EntryLogger.setSource(endpoint.getMemberId(), "RIGII");
            }
            try {
                ArrayList list = new ArrayList(keysList);
                if (pol != InterestResultPolicy.KEYS_VALUES) {
                    for (Object currentKey : keysList) {
                        if (currentKey != null && !this.getImageState().hasDestroyedEntry(currentKey)) continue;
                        list.remove(currentKey);
                    }
                }
                if (pol == InterestResultPolicy.KEYS) {
                    if (this.isProxy()) continue;
                    for (Object currentKey : list) {
                        this.entries.initialImagePut(currentKey, 0L, Token.LOCAL_INVALID, false, false, null, null, false);
                    }
                    continue;
                }
                if (list.isEmpty()) continue;
                Assert.assertTrue(pol == InterestResultPolicy.KEYS_VALUES);
                VersionedObjectList values = (VersionedObjectList)list.get(0);
                if (logger.isDebugEnabled()) {
                    logger.debug("processing interest response: {}", values.size());
                }
                VersionedObjectList.Iterator listIt = values.iterator();
                while (listIt.hasNext()) {
                    VersionedObjectList.Entry entry = listIt.next();
                    Object currentKey = entry.getKey();
                    if (currentKey == null || this.getImageState().hasDestroyedEntry(currentKey)) continue;
                    this.localDestroyNoCallbacks(currentKey);
                    Object val = entry.getObject();
                    boolean isBytes = entry.isBytes();
                    boolean isKeyOnServer = !entry.isKeyNotOnServer();
                    boolean isTombstone = this.concurrencyChecksEnabled && entry.isKeyNotOnServer() && entry.getVersionTag() != null;
                    VersionTag tag = entry.getVersionTag();
                    if (val instanceof Throwable) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_CAUGHT_THE_FOLLOWING_EXCEPTION_FOR_KEY_0_WHILE_PERFORMING_A_REMOTE_GETALL, currentKey), (Throwable)val);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("refreshEntries key={} value={}", currentKey, entry);
                    }
                    if (val instanceof byte[] && !isBytes) {
                        val = CachedDeserializableFactory.create((byte[])val);
                    }
                    if (isTombstone) {
                        assert (val == null) : "server returned a value for a destroyed entry";
                        val = Token.TOMBSTONE;
                    }
                    if (val != null || isTombstone) {
                        if (this.isProxy()) continue;
                        this.entries.initialImagePut(currentKey, 0L, val, false, false, tag, null, false);
                        continue;
                    }
                    RegionEntry re = this.entries.getEntry(currentKey);
                    if (!this.isProxy() && isKeyOnServer) {
                        this.entries.initialImagePut(currentKey, 0L, Token.LOCAL_INVALID, false, false, tag, null, false);
                        continue;
                    }
                    if (re == null) continue;
                    RegionEntry regionEntry = re;
                    synchronized (regionEntry) {
                        if (re.isDestroyedOrRemovedButNotTombstone()) {
                            this.entries.removeEntry(currentKey, re, false);
                        }
                    }
                }
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae);
                throw dae;
            }
            finally {
                EntryLogger.clearSource();
            }
        }
    }

    private void logKeys(List serverKeys, InterestResultPolicy pol) {
        int totalKeys = 0;
        StringBuffer buffer = new StringBuffer();
        for (ArrayList keysList : serverKeys) {
            if (keysList == null) continue;
            int numThisChunk = keysList.size();
            totalKeys += numThisChunk;
            for (Object key2 : keysList) {
                if (key2 == null) continue;
                if (key2 instanceof VersionedObjectList) {
                    Set keys = ((VersionedObjectList)key2).keySet();
                    for (Object k : keys) {
                        buffer.append("  " + k).append("\n");
                    }
                    continue;
                }
                buffer.append("  " + key2).append("\n");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} refreshEntriesFromServerKeys count={} policy={}\n{}", this, totalKeys, pol, buffer);
        }
    }

    public void clearKeysOfInterest(Object key2, int interestType2, InterestResultPolicy pol) {
        switch (interestType2) {
            case 2: {
                this.clearViaFilterClass((String)key2);
                break;
            }
            case 0: {
                if (key2 instanceof String && key2.equals("ALL_KEYS")) {
                    this.clearViaRegEx(".*");
                    break;
                }
                if (key2 instanceof List) {
                    this.clearViaList((List)key2);
                    break;
                }
                this.localDestroyNoCallbacks(key2);
                break;
            }
            case 3: {
                this.clearViaQuery((String)key2);
                break;
            }
            case 1: {
                this.clearViaRegEx((String)key2);
                break;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNKNOWN_INTEREST_TYPE.toLocalizedString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitialize(InputStream inputStream, RegionEventImpl event) throws TimeoutException, IOException, ClassNotFoundException {
        this.acquireDestroyLock();
        try {
            this.reinitialize_destroy(event);
            this.recreate(inputStream, null);
        }
        finally {
            this.releaseDestroyLock();
        }
    }

    void reinitializeFromImageTarget(InternalDistributedMember imageTarget) throws TimeoutException, IOException, ClassNotFoundException {
        Assert.assertTrue(imageTarget != null);
        this.recreate(null, imageTarget);
    }

    boolean reinitialized_new() {
        return this.reinitialized_new;
    }

    void reinitialize_destroy(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        boolean cacheWrite = !event.originRemote;
        this.cache.regionReinitializing(this.getFullPath());
        this.basicDestroyRegion(event, cacheWrite, false, true);
    }

    private void recreate(InputStream inputStream, InternalDistributedMember imageTarget) throws TimeoutException, IOException, ClassNotFoundException {
        String thePath = this.getFullPath();
        Region newRegion = null;
        try {
            LocalRegion parent = this.parentRegion;
            boolean getDestroyLock = false;
            if (this.dsi != null && this.dsi.getName().equals("DEFAULT") && this.diskStoreName == null && !this.useDefaultDiskStore()) {
                this.diskStoreName = this.dsi.getName();
            }
            LocalRegion attrs = this;
            InternalRegionArguments iargs = new InternalRegionArguments().setDestroyLockFlag(getDestroyLock).setSnapshotInputStream(inputStream).setImageTarget(imageTarget).setRecreateFlag(true);
            if (this instanceof BucketRegion) {
                BucketRegion me = (BucketRegion)this;
                iargs.setPartitionedRegionBucketRedundancy(me.getRedundancyLevel());
            }
            newRegion = parent == null ? this.cache.createVMRegion(this.regionName, attrs, iargs) : parent.createSubregion(this.regionName, attrs, iargs);
        }
        catch (RegionExistsException e) {
            InternalGemFireError error = new InternalGemFireError(LocalizedStrings.LocalRegion_GOT_REGIONEXISTSEXCEPTION_IN_REINITIALIZE_WHEN_HOLDING_DESTROY_LOCK.toLocalizedString());
            error.initCause(e);
            throw error;
        }
        finally {
            if (newRegion == null) {
                this.cache.unregisterReinitializingRegion(thePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSnapshotDuringInitialization(InputStream inputStream) throws IOException, ClassNotFoundException {
        try (DataInputStream in = new DataInputStream(inputStream);){
            Object key2;
            RegionMap map = this.getRegionMap();
            byte snapshotVersion = in.readByte();
            if (snapshotVersion != 1) {
                throw new IllegalArgumentException(LocalizedStrings.LocalRegion_UNSUPPORTED_SNAPSHOT_VERSION_0_ONLY_VERSION_1_IS_SUPPORTED.toLocalizedString(snapshotVersion, (byte)1));
            }
            while ((key2 = DataSerializer.readObject(in)) != null) {
                Object value2;
                byte b = in.readByte();
                if (b == 23) {
                    value2 = DataSerializer.readObject(in);
                } else if (b == 24) {
                    value2 = Token.LOCAL_INVALID;
                } else if (b == 25) {
                    value2 = Token.LOCAL_INVALID;
                } else {
                    throw new IllegalArgumentException(LocalizedStrings.LocalRegion_UNEXPECTED_SNAPSHOT_CODE_0_THIS_SNAPSHOT_WAS_PROBABLY_WRITTEN_BY_AN_EARLIER_INCOMPATIBLE_RELEASE.toLocalizedString(new Byte(b)));
                }
                VersionTag tag = null;
                if (this.concurrencyChecksEnabled) {
                    tag = VersionTag.create(this.getVersionMember());
                }
                map.initialImagePut(key2, this.cacheTimeMillis(), value2, false, false, tag, null, false);
            }
        }
        this.reinitialized_new = true;
    }

    Object getEntryValue(RegionEntry entry) {
        if (entry == null) {
            return null;
        }
        try {
            return entry.getValue(this);
        }
        catch (DiskAccessException dae) {
            this.handleDiskAccessException(dae);
            throw dae;
        }
    }

    Region getSubregion(String path, boolean destroyedRegionOk) {
        if (destroyedRegionOk) {
            this.checkCacheClosed();
        } else if (this.isDestroyed()) {
            return null;
        }
        if (path == null) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_PATH_SHOULD_NOT_BE_NULL.toLocalizedString());
        }
        if (path.length() == 0) {
            this.waitOnInitialization();
            return this;
        }
        if (path.charAt(0) == '/') {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_PATH_SHOULD_NOT_START_WITH_A_SLASH.toLocalizedString());
        }
        LocalRegion r = this;
        String n = path;
        while (n.length() != 0) {
            int sep_idx = n.indexOf(47);
            boolean last = sep_idx < 0;
            String next2 = last ? n : n.substring(0, sep_idx);
            if ((r = r.basicGetSubregion(next2)) == null) {
                return null;
            }
            if (r.isDestroyed() && !destroyedRegionOk) {
                return null;
            }
            if (!last) {
                n = n.substring(sep_idx + 1);
            }
            if (!last) continue;
        }
        r.waitOnInitialization();
        if (r.isDestroyed()) {
            if (!destroyedRegionOk) {
                return null;
            }
            return r;
        }
        return r;
    }

    public static int setThreadInitLevelRequirement(int level) {
        int oldLevel = LocalRegion.threadInitLevelRequirement();
        if (level == 0) {
            initializationThread.set(null);
        } else {
            initializationThread.set(level);
        }
        return oldLevel;
    }

    public static int threadInitLevelRequirement() {
        Integer initLevel = (Integer)initializationThread.get();
        if (initLevel == null) {
            return 0;
        }
        return initLevel;
    }

    public boolean checkForInitialization() {
        if (this.initialized) {
            return true;
        }
        switch (LocalRegion.threadInitLevelRequirement()) {
            case 0: {
                return this.checkForInitialization(this.initializationLatchAfterGetInitialImage);
            }
            case 1: {
                return this.checkForInitialization(this.initializationLatchBeforeGetInitialImage);
            }
            case 2: {
                return true;
            }
        }
        throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_THREADINITLEVELREQUIREMENT.toLocalizedString());
    }

    private boolean checkForInitialization(StoppableCountDownLatch latch) {
        return latch.getCount() == 0L;
    }

    public void waitOnInitialization() {
        if (this.initialized) {
            return;
        }
        switch (LocalRegion.threadInitLevelRequirement()) {
            case 0: {
                this.waitOnInitialization(this.initializationLatchAfterGetInitialImage);
                break;
            }
            case 1: {
                this.waitOnInitialization(this.initializationLatchBeforeGetInitialImage);
                break;
            }
            case 2: {
                return;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_THREADINITLEVELREQUIREMENT.toLocalizedString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitOnInitialization(StoppableCountDownLatch latch) {
        if (latch == null) {
            return;
        }
        while (true) {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.cache.getCancelCriterion().checkCancelInProgress(e);
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void waitForData() {
        if (this.initialized) {
            return;
        }
        this.waitOnInitialization(this.initializationLatchAfterGetInitialImage);
    }

    @Override
    public RegionEntry basicGetEntry(Object key2) {
        RegionEntry re = this.entries.getEntry(key2);
        if (re != null && re.isRemoved()) {
            re = null;
        }
        return re;
    }

    void basicInvalidate(EntryEventImpl event) throws EntryNotFoundException {
        this.basicInvalidate(event, this.isInitialized());
    }

    @Override
    public DiskEntry initializeRecoveredEntry(Object key2, DiskEntry.RecoveredEntry value2) {
        Assert.assertTrue(this.diskRegion != null);
        RegionEntry re = this.entries.initRecoveredEntry(key2, value2);
        if (re == null) {
            throw new InternalGemFireError(LocalizedStrings.LocalRegion_ENTRY_ALREADY_EXISTED_0.toLocalizedString(key2));
        }
        return (DiskEntry)re;
    }

    @Override
    public DiskEntry updateRecoveredEntry(Object key2, DiskEntry.RecoveredEntry value2) {
        Assert.assertTrue(this.diskRegion != null);
        RegionEntry re = this.entries.updateRecoveredEntry(key2, value2);
        return (DiskEntry)re;
    }

    @Override
    public void copyRecoveredEntries(RegionMap rm2) {
        this.entries.copyRecoveredEntries(rm2);
    }

    @Override
    public void recordRecoveredGCVersion(VersionSource member, long gcVersion) {
        this.versionVector.recordGCVersion(member, gcVersion);
        DiskRegion dr = this.getDiskRegion();
        if (dr != null) {
            dr.recordRecoveredGCVersion(member, gcVersion);
        }
    }

    @Override
    public void recordRecoveredVersonHolder(VersionSource member, RegionVersionHolder versionHolder, boolean latestOplog) {
        if (this.concurrencyChecksEnabled) {
            this.versionVector.initRecoveredVersion(member, versionHolder, latestOplog);
            DiskRegion dr = this.getDiskRegion();
            if (dr != null) {
                dr.recordRecoveredVersonHolder(member, versionHolder, latestOplog);
            }
        }
    }

    @Override
    public void recordRecoveredVersionTag(VersionTag tag) {
        if (this.concurrencyChecksEnabled) {
            this.versionVector.recordVersion(tag.getMemberID(), tag.getRegionVersion());
            DiskRegion dr = this.getDiskRegion();
            if (dr != null) {
                dr.recordRecoveredVersionTag(tag);
            }
        }
    }

    @Override
    public void setRVVTrusted(boolean rvvTrusted) {
        DiskRegion dr;
        if (this.concurrencyChecksEnabled && (dr = this.getDiskRegion()) != null) {
            dr.setRVVTrusted(rvvTrusted);
        }
    }

    public Iterator<RegionEntry> getBestIterator(boolean includeValues) {
        if (this instanceof DistributedRegion) {
            return ((DistributedRegion)this).getBestIterator(includeValues);
        }
        return this.entries.regionEntries().iterator();
    }

    void repairRVV() {
        RegionVersionVector rvv = this.getVersionVector();
        if (rvv == null) {
            return;
        }
        Iterator<RegionEntry> it = this.getBestIterator(false);
        boolean count = false;
        VersionSource myId = this.getVersionMember();
        while (it.hasNext()) {
            RegionEntry mapEntry = it.next();
            VersionStamp stamp = mapEntry.getVersionStamp();
            Object id = stamp.getMemberID();
            if (id == null) {
                id = myId;
            }
            rvv.recordVersion(id, stamp.getRegionVersion());
        }
    }

    private void basicInvalidate(EntryEventImpl event, boolean invokeCallbacks) throws EntryNotFoundException {
        this.basicInvalidate(event, invokeCallbacks, false);
    }

    void basicInvalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws EntryNotFoundException {
        if (!event.isOriginRemote() && !event.isDistributed() && this.getScope().isDistributed() && this.getDataPolicy().withReplication() && invokeCallbacks) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_CANNOT_DO_A_LOCAL_INVALIDATE_ON_A_REPLICATED_REGION.toLocalizedString());
        }
        if (this.hasSeenEvent(event)) {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "LR.basicInvalidate: this cache has already seen this event {}", event);
            }
            if (this.concurrencyChecksEnabled && event.getVersionTag() != null && !event.getVersionTag().isRecorded()) {
                this.getVersionVector().recordVersion((InternalDistributedMember)event.getDistributedMember(), event.getVersionTag());
            }
            return;
        }
        this.discoverJTA();
        this.getDataView().invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
    }

    void basicInvalidatePart2(RegionEntry re, EntryEventImpl event, boolean conflictwithClear, boolean invokeCallbacks) {
        this.updateStatsForInvalidate();
        if (invokeCallbacks) {
            try {
                re.dispatchListenerEvents(event);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.stopper.checkCancelInProgress(null);
                return;
            }
        } else {
            event.callbacksInvoked(true);
        }
    }

    private void updateStatsForInvalidate() {
        this.getCachePerfStats().incInvalidates();
    }

    void basicInvalidatePart3(RegionEntry re, EntryEventImpl event, boolean invokeCallbacks) {
    }

    public void invokeInvalidateCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent) {
        event.setEventType(eventType);
        this.notifyBridgeClients(event);
        if (callDispatchListenerEvent) {
            this.dispatchListenerEvent(eventType, event);
        }
    }

    final void txApplyInvalidate(Object key2, Object newValue, boolean didDestroy, TransactionId rmtOrigin, TXRmtEvent event, boolean localOp, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        this.entries.txApplyInvalidate(key2, newValue, didDestroy, rmtOrigin, event, localOp, eventId, aCallbackArgument, pendingCallbacks, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
    }

    final void txApplyInvalidatePart2(RegionEntry re, Object key2, boolean didDestroy, boolean didInvalidate, boolean clearConflict) {
        if (this.testCallable != null) {
            this.testCallable.call(this, Operation.INVALIDATE, re);
        }
        if (didInvalidate) {
            this.updateStatsForInvalidate();
        }
        if (didDestroy && this.entryUserAttributes != null) {
            this.entryUserAttributes.remove(key2);
        }
    }

    protected final boolean basicPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) throws TimeoutException, CacheWriterException {
        return this.getDataView().putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, 0L, false);
    }

    final void txApplyPut(Operation putOp, Object key2, Object newValue, boolean didDestroy, TransactionId rmtOrigin, TXRmtEvent event, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        long startPut = CachePerfStats.getStatTime();
        this.entries.txApplyPut(putOp, key2, newValue, didDestroy, rmtOrigin, event, eventId, aCallbackArgument, pendingCallbacks, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
        this.updateStatsForPut(startPut);
        this.checkReadiness();
    }

    private void updateStatsForPut(long startPut) {
        this.getCachePerfStats().endPut(startPut, false);
    }

    final void txApplyPutPart2(RegionEntry re, Object key2, Object newValue, long lastModified, boolean isCreate, boolean didDestroy, boolean clearConflict) {
        if (this.testCallable != null) {
            Operation op = isCreate ? Operation.CREATE : Operation.UPDATE;
            this.testCallable.call(this, op, re);
        }
        if (isCreate) {
            this.updateStatsForCreate();
        }
        if (!this.isProxy() && !clearConflict && this.indexManager != null) {
            try {
                this.indexManager.updateIndexes(re, isCreate ? 1 : 2, isCreate ? 0 : 2);
            }
            catch (QueryException e) {
                throw new IndexMaintenanceException(e);
            }
        }
        if (didDestroy && this.entryUserAttributes != null) {
            this.entryUserAttributes.remove(key2);
        }
        if (this.statisticsEnabled && !clearConflict) {
            this.addExpiryTaskIfAbsent(re);
        }
        this.setLastModifiedTime(lastModified);
    }

    public boolean basicBridgeCreate(Object key2, byte[] value2, boolean isObject, Object p_callbackArg, ClientProxyMembershipID client, boolean fromClient, EntryEventImpl clientEvent, boolean throwEntryExists) throws TimeoutException, EntryExistsException, CacheWriterException {
        EventID eventId = clientEvent.getEventId();
        Object callbackArg = p_callbackArg;
        long startPut = CachePerfStats.getStatTime();
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.CREATE, key2, (Object)value2, callbackArg, false, client.getDistributedMember(), true, eventId);
        event.setContext(client);
        event.setVersionTag(clientEvent.getVersionTag());
        event.setPossibleDuplicate(clientEvent.isPossibleDuplicate());
        if (this.getDataPolicy() == DataPolicy.NORMAL) {
            event.setLocalInvalid(true);
        }
        if (value2 != null) {
            if (isObject) {
                event.setSerializedNewValue(value2);
            } else {
                event.setNewValue(value2);
            }
        }
        boolean ifNew = true;
        boolean ifOld = false;
        long lastModified = 0L;
        boolean overwriteDestroyed = false;
        boolean success = this.basicUpdate(event, ifNew, ifOld, lastModified, overwriteDestroyed);
        clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
        if (success) {
            clientEvent.setVersionTag(event.getVersionTag());
            this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
        } else {
            this.stopper.checkCancelInProgress(null);
            if (throwEntryExists) {
                throw new EntryExistsException("" + key2, event.getOldValue());
            }
        }
        return success;
    }

    public boolean basicBridgePut(Object key2, Object value2, byte[] deltaBytes, boolean isObject, Object p_callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent, boolean isSqlFabricSystem) throws TimeoutException, CacheWriterException {
        EventID eventID = clientEvent.getEventId();
        Object callbackArg = p_callbackArg;
        long startPut = CachePerfStats.getStatTime();
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.UPDATE, key2, null, callbackArg, false, memberId.getDistributedMember(), true, eventID);
        event.setContext(memberId);
        event.setDeltaBytes(deltaBytes);
        event.setVersionTag(clientEvent.getVersionTag());
        event.setPossibleDuplicate(clientEvent.isPossibleDuplicate());
        if (isObject && value2 instanceof byte[]) {
            if (isSqlFabricSystem) {
                event.setNewValue(EntryEventImpl.deserialize((byte[])value2));
            } else {
                event.setSerializedNewValue((byte[])value2);
            }
        } else {
            event.setNewValue(value2);
        }
        boolean ifNew = false;
        boolean ifOld = isSqlFabricSystem;
        long lastModified = 0L;
        boolean overwriteDestroyed = false;
        boolean success = false;
        try {
            success = this.basicUpdate(event, ifNew, ifOld, lastModified, overwriteDestroyed);
        }
        catch (ConcurrentCacheModificationException ex) {
            event.isConcurrencyConflict(true);
        }
        clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
        if (success) {
            clientEvent.setVersionTag(event.getVersionTag());
            this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
        } else {
            this.stopper.checkCancelInProgress(null);
        }
        return success;
    }

    private void concurrencyConfigurationCheck(VersionTag tag) {
        if (!this.concurrencyMessageIssued && tag != null != this.concurrencyChecksEnabled) {
            this.concurrencyMessageIssued = true;
            logger.info(LocalizedMessage.create(LocalizedStrings.LocalRegion_SERVER_HAS_CONCURRENCY_CHECKS_ENABLED_0_BUT_CLIENT_HAS_1_FOR_REGION_2, new Object[]{!this.concurrencyChecksEnabled, this.concurrencyChecksEnabled, this}));
        }
    }

    public void basicBridgeClientUpdate(DistributedMember serverId, Object key2, Object value2, byte[] deltaBytes, boolean isObject, Object callbackArgument, boolean isCreate, boolean processedMarker, EntryEventImpl event, EventID eventID) throws TimeoutException, CacheWriterException {
        if (this.isCacheContentProxy()) {
            return;
        }
        this.concurrencyConfigurationCheck(event.getVersionTag());
        long startPut = CachePerfStats.getStatTime();
        if (this.generateEventID() && !this.cache.getCacheServers().isEmpty()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        } else {
            event.setEventId(eventID);
        }
        event.setDeltaBytes(deltaBytes);
        if (value2 != null) {
            if (isObject && value2 instanceof byte[]) {
                event.setSerializedNewValue((byte[])value2);
            } else {
                event.setNewValue(value2);
            }
        }
        if (processedMarker) {
            boolean ifNew = false;
            boolean ifOld = false;
            long lastModified = 0L;
            boolean overwriteDestroyed = true;
            if (this.basicUpdate(event, ifNew, ifOld, lastModified, overwriteDestroyed)) {
                this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
            }
        } else if (this.isInitialized()) {
            this.invokePutCallbacks(isCreate ? EnumListenerEvent.AFTER_CREATE : EnumListenerEvent.AFTER_UPDATE, event, true, true);
        }
    }

    public void basicBridgeClientInvalidate(DistributedMember serverId, Object key2, Object callbackArgument, boolean processedMarker, EventID eventID, VersionTag versionTag) throws EntryNotFoundException {
        if (!this.isCacheContentProxy()) {
            this.concurrencyConfigurationCheck(versionTag);
            EntryEventImpl event = new EntryEventImpl(this, Operation.INVALIDATE, key2, null, callbackArgument, true, serverId);
            event.setVersionTag(versionTag);
            event.setFromServer(true);
            if (this.generateEventID() && !this.cache.getCacheServers().isEmpty()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            } else {
                event.setEventId(eventID);
            }
            if (processedMarker) {
                boolean forceNewEntry = this.concurrencyChecksEnabled;
                this.basicInvalidate(event, true, forceNewEntry);
                if (event.isConcurrencyConflict()) {
                    throw new ConcurrentCacheModificationException();
                }
            } else if (this.isInitialized()) {
                this.invokeInvalidateCallbacks(EnumListenerEvent.AFTER_INVALIDATE, event, true);
            }
        }
    }

    public void basicBridgeClientDestroy(DistributedMember serverId, Object key2, Object callbackArgument, boolean processedMarker, EventID eventID, VersionTag versionTag) throws EntryNotFoundException {
        if (!this.isCacheContentProxy()) {
            this.concurrencyConfigurationCheck(versionTag);
            EntryEventImpl event = new EntryEventImpl(this, Operation.DESTROY, key2, null, callbackArgument, true, serverId);
            event.setFromServer(true);
            event.setVersionTag(versionTag);
            if (this.generateEventID() && !this.cache.getCacheServers().isEmpty()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            } else {
                event.setEventId(eventID);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("basicBridgeClientDestroy(processedMarker={})", processedMarker);
            }
            if (processedMarker) {
                this.basicDestroy(event, false, null);
                if (event.isConcurrencyConflict()) {
                    throw new ConcurrentCacheModificationException();
                }
            } else if (this.isInitialized()) {
                this.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, event, true, true);
            }
        }
    }

    public void basicBridgeClientClear(Object callbackArgument, boolean processedMarker) {
        this.checkReadiness();
        this.checkForNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_CLEAR, callbackArgument, true, (DistributedMember)this.getMyId(), this.generateEventID());
        if (processedMarker) {
            this.basicLocalClear(event);
        } else if (this.isInitialized()) {
            this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_CLEAR, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeDestroy(Object key2, Object p_callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Object callbackArg = p_callbackArg;
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.DESTROY, key2, null, callbackArg, false, memberId.getDistributedMember(), true, clientEvent.getEventId());
        event.setContext(memberId);
        event.setVersionTag(clientEvent.getVersionTag());
        try {
            this.basicDestroy(event, true, null);
        }
        catch (ConcurrentCacheModificationException ex) {
            event.isConcurrencyConflict(true);
        }
        finally {
            clientEvent.setVersionTag(event.getVersionTag());
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
            clientEvent.setIsRedestroyedEntry(event.getIsRedestroyedEntry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeInvalidate(Object key2, Object p_callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Object callbackArg = p_callbackArg;
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.INVALIDATE, key2, null, callbackArg, false, memberId.getDistributedMember(), true, clientEvent.getEventId());
        event.setContext(memberId);
        event.setVersionTag(clientEvent.getVersionTag());
        try {
            this.basicInvalidate(event);
        }
        finally {
            clientEvent.setVersionTag(event.getVersionTag());
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeUpdateVersionStamp(Object key2, Object p_callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) {
        EntryEventImpl event = new EntryEventImpl(this, Operation.UPDATE_VERSION_STAMP, key2, null, null, false, memberId.getDistributedMember(), false, clientEvent.getEventId());
        event.setContext(memberId);
        event.setVersionTag(clientEvent.getVersionTag());
        try {
            this.basicUpdateEntryVersion(event);
        }
        finally {
            clientEvent.setVersionTag(event.getVersionTag());
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
        }
    }

    void basicUpdateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        if (this.hasSeenEvent(event)) {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "LR.basicDestroy: this cache has already seen this event {}", event);
            }
            if (this.concurrencyChecksEnabled && event.getVersionTag() != null && !event.getVersionTag().isRecorded()) {
                this.getVersionVector().recordVersion((InternalDistributedMember)event.getDistributedMember(), event.getVersionTag());
            }
            return;
        }
        this.getDataView().updateEntryVersion(event);
    }

    final boolean basicUpdate(EntryEventImpl event, boolean ifNew, boolean ifOld, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        if (this.keyConstraint != null && !this.keyConstraint.isInstance(event.getKey())) {
            throw new ClassCastException(LocalizedStrings.LocalRegion_KEY_0_DOES_NOT_SATISFY_KEYCONSTRAINT_1.toLocalizedString(event.getKey().getClass().getName(), this.keyConstraint.getName()));
        }
        this.validateValue(event.basicGetNewValue());
        return this.getDataView().putEntry(event, ifNew, ifOld, null, false, lastModified, overwriteDestroyed);
    }

    boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        if (!InternalResourceManager.isLowMemoryExceptionDisabled()) {
            this.checkIfAboveThreshold(event);
        }
        Operation originalOp = event.getOperation();
        RegionEntry oldEntry = null;
        try {
            oldEntry = this.entries.basicPut(event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue, overwriteDestroyed);
        }
        catch (ConcurrentCacheModificationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("caught concurrent modification attempt when applying {}", event);
            }
            this.notifyBridgeClients(event);
            return false;
        }
        ServerRegionProxy mySRP = this.getServerProxy();
        if (mySRP != null && this.dataPolicy == DataPolicy.EMPTY) {
            if (originalOp == Operation.PUT_IF_ABSENT) {
                return event.getOldValue() == null;
            }
            if (originalOp == Operation.REPLACE && !requireOldValue) {
                return true;
            }
        }
        return oldEntry != null;
    }

    public void checkIfAboveThreshold(EntryEventImpl evi) throws LowMemoryException {
        boolean alreadyCheckedThreshold;
        if (evi == null) {
            this.checkIfAboveThreshold("UNKNOWN");
            return;
        }
        boolean bl = alreadyCheckedThreshold = this.hasServerProxy() && evi.getOperation().isPutAll();
        if (!alreadyCheckedThreshold && !evi.isOriginRemote()) {
            this.checkIfAboveThreshold(evi.getKey());
        }
    }

    private void checkIfAboveThreshold(Object key2) throws LowMemoryException {
        if (this.heapThresholdReached.get()) {
            Set<DistributedMember> htrm = this.getHeapThresholdReachedMembers();
            InternalResourceManager.getInternalResourceManager(this.cache).triggerMemoryEvent();
            Object[] prms = new Object[]{this.getFullPath(), key2, htrm};
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_IN_0_FOR_PUT_1_MEMBER_2.toLocalizedString(prms), htrm);
        }
    }

    protected RegionEntry basicPutEntry(EntryEventImpl event, long lastModified) throws TimeoutException, CacheWriterException {
        this.discoverJTA();
        TXStateInterface tx = this.getTXState();
        boolean ifNew = false;
        if (this.isTX()) {
            tx.txPutEntry(event, false, false, false, null);
            return null;
        }
        RegionEntry oldEntry = this.entries.basicPut(event, lastModified, false, false, null, false, false);
        return oldEntry;
    }

    protected long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
        boolean invokeCallbacks;
        boolean isNewKey = event.getOperation().isCreate();
        boolean bl = invokeCallbacks = !entry.isTombstone();
        if (isNewKey) {
            this.updateStatsForCreate();
        }
        boolean lruRecentUse = event.isNetSearch() || event.isLoad();
        long lastModifiedTime = event.getEventTime(lastModified);
        this.updateStatsForPut(entry, lastModifiedTime, lruRecentUse);
        if (!this.isProxy() && !clearConflict && this.indexManager != null) {
            try {
                if (!entry.isInvalid()) {
                    this.indexManager.updateIndexes(entry, isNewKey ? 1 : 2, isNewKey ? 0 : 2);
                }
            }
            catch (QueryException e) {
                throw new IndexMaintenanceException(e);
            }
        }
        if (invokeCallbacks) {
            boolean doCallback = false;
            if (isInitialized) {
                if (event.isGenerateCallbacks()) {
                    doCallback = true;
                }
            } else if (this.isUsedForPartitionedRegionBucket) {
                doCallback = true;
            }
            if (doCallback) {
                this.notifyGatewayHubs(event.getOperation().isUpdate() ? EnumListenerEvent.AFTER_UPDATE : EnumListenerEvent.AFTER_CREATE, event);
                if (!event.isBulkOpInProgress()) {
                    try {
                        entry.dispatchListenerEvents(event);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.stopper.checkCancelInProgress(null);
                    }
                }
            }
        }
        return lastModifiedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateLocalFilterRouting(InternalCacheEvent event) {
        boolean isEntryEvent = event.getOperation().isEntry();
        EntryEventImpl entryEvent = isEntryEvent ? (EntryEventImpl)event : null;
        FilterProfile fp = this.getFilterProfile();
        FilterRoutingInfo.FilterInfo routing = event.getLocalFilterInfo();
        boolean lockForCQ = false;
        RegionEntry re = null;
        if (fp != null && routing == null) {
            if (isEntryEvent && entryEvent.getRegionEntry() != null) {
                re = entryEvent.getRegionEntry();
                if (!entryEvent.isConcurrencyConflict()) {
                    Assert.assertTrue(re != null);
                    lockForCQ = true;
                }
            }
            if (isEntryEvent && logger.isDebugEnabled()) {
                logger.debug("getting local client routing.");
            }
            if (lockForCQ) {
                RegionEntry regionEntry = re;
                synchronized (regionEntry) {
                    routing = fp.getLocalFilterRouting(event);
                }
            } else {
                routing = fp.getLocalFilterRouting(event);
            }
            event.setLocalFilterInfo(routing);
        }
        if (routing != null && event.getOperation().isEntry() && ((EntryEventImpl)event).isConcurrencyConflict()) {
            if (logger.isDebugEnabled()) {
                logger.debug("clearing CQ routing for event that's in conflict");
            }
            routing.clearCQRouting();
        }
    }

    protected void notifyTimestampsToGateways(EntryEventImpl event) {
        EntryEventImpl updateTimeStampEvent = EntryEventImpl.createVersionTagHolder(event.getVersionTag());
        updateTimeStampEvent.setOperation(Operation.UPDATE_VERSION_STAMP);
        updateTimeStampEvent.setKeyInfo(event.getKeyInfo());
        updateTimeStampEvent.setGenerateCallbacks(false);
        updateTimeStampEvent.distributedMember = event.getDistributedMember();
        updateTimeStampEvent.setNewEventId(this.getSystem());
        if (event.getRegion() instanceof BucketRegion) {
            BucketRegion br = (BucketRegion)event.getRegion();
            PartitionedRegion pr2 = br.getPartitionedRegion();
            updateTimeStampEvent.setRegion(pr2);
            if (pr2.isParallelWanEnabled()) {
                br.handleWANEvent(updateTimeStampEvent);
            }
            if (pr2.isInitialized()) {
                pr2.notifyGatewayHubs(EnumListenerEvent.TIMESTAMP_UPDATE, updateTimeStampEvent);
            }
        } else {
            updateTimeStampEvent.setRegion(event.getRegion());
            this.notifyGatewayHubs(EnumListenerEvent.TIMESTAMP_UPDATE, updateTimeStampEvent);
        }
    }

    private void updateStatsForCreate() {
        this.getCachePerfStats().incCreates();
    }

    public void basicPutPart3(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean invokeCallbacks, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
        if (invokeCallbacks && event.isBulkOpInProgress()) {
            event.getPutAllOperation().addEntry(event);
        }
    }

    public void invokePutCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent, boolean notifyGateways) {
        if (!event.isGenerateCallbacks()) {
            return;
        }
        Operation op = event.getOperation();
        if (op == Operation.PUT_IF_ABSENT) {
            event.setOperation(Operation.CREATE);
        } else if (op == Operation.REPLACE) {
            event.setOperation(Operation.UPDATE);
        }
        event.setEventType(eventType);
        this.notifyBridgeClients(event);
        if (notifyGateways) {
            this.notifyGatewayHubs(eventType, event);
        }
        if (callDispatchListenerEvent) {
            this.dispatchListenerEvent(eventType, event);
        }
    }

    protected void postUpdate(EntryEventImpl event, long lastModifiedTime) {
    }

    public Map<? extends DataSerializable, ? extends DataSerializable> getEventState() {
        if (this.eventTracker != null) {
            return this.eventTracker.getState();
        }
        return null;
    }

    protected void recordEventState(InternalDistributedMember provider, Map state) {
        if (this.eventTracker != null) {
            this.eventTracker.recordState(provider, state);
        }
    }

    public void generateAndSetVersionTag(InternalCacheEvent event, RegionEntry entry) {
        EntryEventImpl entryEvent;
        if (entry != null && event.getOperation().isEntry() && !(entryEvent = (EntryEventImpl)event).isOriginRemote() && this.shouldGenerateVersionTag(entry, entryEvent)) {
            boolean eventHasDelta = this.getSystem().getConfig().getDeltaPropagation() && !this.scope.isDistributedNoAck() && entryEvent.getDeltaBytes() != null;
            VersionTag v = entry.generateVersionTag(null, eventHasDelta, this, entryEvent);
            if (logger.isDebugEnabled()) {
                logger.debug("generated version tag {} for {}", v, entryEvent.getKey());
            }
        }
    }

    public void recordEvent(InternalCacheEvent event) {
        if (this.eventTracker != null) {
            this.eventTracker.recordEvent(event);
        }
    }

    public boolean hasSeenEvent(EntryEventImpl event) {
        boolean isDup = false;
        if (this.eventTracker != null) {
            if (this.isUsedForPartitionedRegionBucket()) {
                try {
                    this.eventTracker.waitOnInitialization();
                }
                catch (InterruptedException ie) {
                    this.stopper.checkCancelInProgress(ie);
                    Thread.currentThread().interrupt();
                }
            }
            if (isDup = this.eventTracker.hasSeenEvent(event)) {
                event.setPossibleDuplicate(true);
                if (this.concurrencyChecksEnabled && event.getVersionTag() == null) {
                    event.setVersionTag(this.findVersionTagForClientEvent(event.getEventId()));
                }
            } else if (event.isPossibleDuplicate() && event.getRegion().concurrencyChecksEnabled && event.getVersionTag() == null && event.getEventId() != null) {
                boolean isBulkOp = event.getOperation().isPutAll() || event.getOperation().isRemoveAll();
                VersionTag tag = FindVersionTagOperation.findVersionTag(event.getRegion(), event.getEventId(), isBulkOp);
                event.setVersionTag(tag);
            }
        }
        return isDup;
    }

    public VersionTag findVersionTagForClientEvent(EventID eventId) {
        if (this.eventTracker != null) {
            return this.eventTracker.findVersionTag(eventId);
        }
        return null;
    }

    public VersionTag findVersionTagForClientBulkOp(EventID eventId) {
        if (eventId == null) {
            return null;
        }
        if (this.eventTracker != null) {
            return this.eventTracker.findVersionTagForBulkOp(eventId);
        }
        return null;
    }

    public boolean hasSeenEvent(EventID eventID) {
        if (eventID == null) {
            return false;
        }
        boolean isDup = false;
        if (this.eventTracker != null) {
            if (this.isUsedForPartitionedRegionBucket()) {
                try {
                    this.eventTracker.waitOnInitialization();
                }
                catch (InterruptedException ie) {
                    this.stopper.checkCancelInProgress(ie);
                    Thread.currentThread().interrupt();
                }
            }
            isDup = this.eventTracker.hasSeenEvent(eventID, null);
        }
        return isDup;
    }

    public void syncBulkOp(Runnable r, EventID eventID) {
        if (this.eventTracker != null && !this.isTX()) {
            this.eventTracker.syncBulkOp(r, eventID);
        } else {
            r.run();
        }
    }

    public void recordBulkOpStart(ThreadIdentifier membershipID) {
        if (this.eventTracker != null && !this.isTX()) {
            this.eventTracker.recordBulkOpStart(membershipID);
        }
    }

    protected final void notifyBridgeClients(CacheEvent event) {
        int numBS = this.getCache().getCacheServers().size();
        if (event.getOperation().isLocal() || numBS == 0) {
            return;
        }
        if (event instanceof EntryEventImpl && ((EntryEventImpl)event).inhibitAllNotifications()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notification inhibited for key {}", event);
            }
            return;
        }
        if (this.shouldNotifyBridgeClients()) {
            EntryEventImpl e;
            if (numBS > 0 && logger.isDebugEnabled()) {
                logger.debug("{}: notifying {} bridge servers of event: {}", this.getName(), numBS, event);
            }
            Operation op = event.getOperation();
            if (event.getOperation().isEntry() && (e = (EntryEventImpl)event).getEventType() == null) {
                if (op.isCreate()) {
                    e.setEventType(EnumListenerEvent.AFTER_CREATE);
                } else if (op.isUpdate()) {
                    e.setEventType(EnumListenerEvent.AFTER_UPDATE);
                } else if (op.isDestroy()) {
                    e.setEventType(EnumListenerEvent.AFTER_DESTROY);
                } else if (op.isInvalidate()) {
                    e.setEventType(EnumListenerEvent.AFTER_INVALIDATE);
                } else {
                    throw new IllegalStateException("event is missing client notification eventType: " + e);
                }
            }
            InternalCacheEvent ice = (InternalCacheEvent)event;
            if (!this.isUsedForPartitionedRegionBucket()) {
                this.generateLocalFilterRouting(ice);
            }
            CacheClientNotifier.notifyClients((InternalCacheEvent)event);
        }
    }

    protected void notifyGatewayHubs(EnumListenerEvent operation, EntryEventImpl event) {
        if (event.isConcurrencyConflict()) {
            return;
        }
        if (event.inhibitAllNotifications()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notification inhibited for key {}", event);
            }
            return;
        }
        if (!event.getOperation().isLocal()) {
            if (this.shouldNotifyGatewayHub() && event.getOperation() != Operation.UPDATE_VERSION_STAMP) {
                for (GatewayHub hub : this.getCache().getGatewayHubs()) {
                    GatewayHubImpl hubImpl = (GatewayHubImpl)hub;
                    if (!this.shouldNotifyGatewayHub(hubImpl)) continue;
                    hubImpl.distribute(operation, event);
                }
            }
            Set<String> allGatewaySenderIds = null;
            this.checkSameSenderIdsAvailableOnAllNodes();
            allGatewaySenderIds = event.getOperation() == Operation.UPDATE_VERSION_STAMP ? this.getGatewaySenderIds() : this.getAllGatewaySenderIds();
            List<Integer> allRemoteDSIds = this.getRemoteDsIds(allGatewaySenderIds);
            if (allRemoteDSIds != null) {
                for (GatewaySender sender : this.getCache().getAllGatewaySenders()) {
                    if (this.isPdxTypesRegion() || !allGatewaySenderIds.contains(sender.getId())) continue;
                    if (!this.getDataPolicy().withStorage() && sender.isParallel()) {
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Notifying the GatewaySender : {}", sender.getId());
                    }
                    ((AbstractGatewaySender)sender).distribute(operation, event, allRemoteDSIds);
                }
            }
        }
    }

    public void checkSameSenderIdsAvailableOnAllNodes() {
    }

    void basicDestroyRegion(RegionEventImpl event, boolean cacheWrite) throws CacheWriterException, TimeoutException {
        this.basicDestroyRegion(event, cacheWrite, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicDestroyRegion(RegionEventImpl event, boolean cacheWrite, boolean lock, boolean callbackEvents) throws CacheWriterException, TimeoutException {
        block35: {
            this.preDestroyChecks();
            HashSet eventSet = null;
            TXStateProxy tx = this.cache.getTXMgr().internalSuspend();
            try {
                boolean acquiredLock;
                block34: {
                    acquiredLock = false;
                    if (lock) {
                        try {
                            this.acquireDestroyLock();
                            acquiredLock = true;
                        }
                        catch (CancelException e) {
                            if (!logger.isDebugEnabled()) break block34;
                            logger.debug("basicDestroyRegion: acquireDestroyLock failed due to cache closure, region = {}", this.getFullPath());
                        }
                    }
                }
                try {
                    this.checkRegionDestroyed(false);
                    boolean cancelledByCacheWriterException = false;
                    try {
                        if (this instanceof PartitionedRegion && !((PartitionedRegion)this).getParallelGatewaySenderIds().isEmpty()) {
                            ((PartitionedRegion)this).destroyParallelGatewaySenderRegion(event.getOperation(), cacheWrite, lock, callbackEvents);
                        }
                        if (this.parentRegion != null) {
                            this.parentRegion.updateStats();
                        }
                        try {
                            eventSet = callbackEvents ? new HashSet() : null;
                            this.destroyedSubregionSerialNumbers = this.collectSubregionSerialNumbers();
                            this.recursiveDestroyRegion(eventSet, event, cacheWrite);
                        }
                        catch (CancelException e) {
                            if (!this.cache.forcedDisconnect()) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_RECURSION_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
                            }
                        }
                        catch (CacheWriterException cwe) {
                            cancelledByCacheWriterException = true;
                            throw cwe;
                        }
                        Assert.assertTrue(this.isDestroyed);
                        if (!this.isInternalRegion()) {
                            InternalDistributedSystem system = this.cache.getDistributedSystem();
                            system.handleResourceEvent(ResourceEvent.REGION_REMOVE, this);
                        }
                        try {
                            LocalRegion parent = this.parentRegion;
                            if (parent == null) {
                                this.cache.removeRoot(this);
                                break block35;
                            }
                            parent.subregions.remove(this.regionName, this);
                        }
                        catch (CancelException e) {
                            if (!this.cache.forcedDisconnect()) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_BASICDESTROYREGION_PARENT_REMOVAL_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (!cancelledByCacheWriterException) {
                            event.setEventType(EnumListenerEvent.AFTER_REGION_DESTROY);
                            this.notifyBridgeClients(event);
                        }
                        if (eventSet != null && callbackEvents) {
                            try {
                                this.sendPendingRegionDestroyEvents(eventSet);
                            }
                            catch (CancelException e) {}
                        }
                    }
                }
                finally {
                    if (acquiredLock) {
                        try {
                            this.releaseDestroyLock();
                        }
                        catch (CancelException e) {}
                    }
                }
            }
            finally {
                this.cache.getTXMgr().resume(tx);
            }
        }
    }

    protected void preDestroyChecks() {
    }

    protected void distributeDestroyRegion(RegionEventImpl event, boolean notifyOfRegionDeparture) {
    }

    protected void postCreateRegion() {
        InternalResourceManager rm2;
        if (this.getEvictionAttributes().getAlgorithm().isLRUHeap() && !(rm2 = this.cache.getResourceManager()).hasEvictionThreshold()) {
            float chp = rm2.getCriticalHeapPercentage();
            if (chp > 0.0f) {
                if (chp >= 10.0f) {
                    chp -= 5.0f;
                }
                rm2.setEvictionHeapPercentage(chp);
            } else {
                rm2.setEvictionHeapPercentage(80.0f);
            }
        }
        if (!this.isInternalRegion()) {
            this.getCachePerfStats().incRegions(1);
            if (this.getMembershipAttributes().hasRequiredRoles()) {
                this.getCachePerfStats().incReliableRegions(1);
            }
        }
        if (this.hasListener()) {
            RegionEventImpl event = new RegionEventImpl(this, Operation.REGION_CREATE, null, false, this.getMyId());
            this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_CREATE, event);
        }
        this.releaseAfterRegionCreateEventLatch();
        SystemMemberCacheEventProcessor.send(this.getCache(), this, Operation.REGION_CREATE);
        initializingRegion.set(null);
    }

    public void notifyOfInitialMembers(CacheListener[] listeners, Set others) {
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof RegionMembershipListener)) continue;
                RegionMembershipListener rml = (RegionMembershipListener)listeners[i];
                try {
                    DistributedMember[] otherDms = new DistributedMember[others.size()];
                    others.toArray(otherDms);
                    rml.initialMembers(this, otherDms);
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.error(LocalizedMessage.create(LocalizedStrings.DistributedRegion_EXCEPTION_OCCURRED_IN_REGIONMEMBERSHIPLISTENER), t);
                }
            }
        }
    }

    protected void postDestroyRegion(boolean destroyDiskRegion, RegionEventImpl event) {
        if (this.diskRegion != null) {
            if (destroyDiskRegion) {
                this.diskRegion.endDestroy(this);
            } else {
                this.diskRegion.close(this);
            }
        }
        if (this.versionVector != null) {
            try {
                this.cache.getDistributionManager().removeMembershipListener(this.versionVector);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        if (!event.isOriginRemote()) {
            this.checkIfReplicatedAndLocalDestroy(event);
        }
        if (this.hasSeenEvent(event)) {
            assert (this.getJTAEnlistedTX() == null);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "LR.basicDestroy: this cache has already seen this event {}", event);
            }
            if (this.concurrencyChecksEnabled && event.getVersionTag() != null && !event.getVersionTag().isRecorded()) {
                this.getVersionVector().recordVersion((InternalDistributedMember)event.getDistributedMember(), event.getVersionTag());
            }
            this.notifyGatewayHubs(EnumListenerEvent.AFTER_DESTROY, event);
            return;
        }
        this.discoverJTA();
        this.getDataView().destroyExistingEntry(event, cacheWrite, expectedOldValue);
    }

    public final void discoverJTA() {
        if (!(this.isSecret() || this.isUsedForPartitionedRegionAdmin() || this.isUsedForMetaRegion())) {
            this.getJTAEnlistedTX();
        }
    }

    public final boolean isTX() {
        return this.getTXState() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean mapDestroy(EntryEventImpl event, boolean cacheWrite, boolean isEviction, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        boolean inGII = this.lockGII();
        try {
            boolean bl = this.mapDestroy(event, cacheWrite, isEviction, expectedOldValue, inGII, false);
            return bl;
        }
        finally {
            if (inGII) {
                this.unlockGII();
            }
        }
    }

    final boolean mapDestroy(EntryEventImpl event, boolean cacheWrite, boolean isEviction, Object expectedOldValue, boolean needTokensForGII, boolean removeRecoveredEntry) {
        boolean inRI = !needTokensForGII && !event.isFromRILocalDestroy() && this.lockRIReadLock();
        try {
            boolean result;
            boolean needRIDestroyToken = inRI && this.riCnt > 0;
            boolean inTokenMode = needTokensForGII || needRIDestroyToken;
            boolean bl = result = this.entries.destroy(event, inTokenMode, needRIDestroyToken, cacheWrite, isEviction, expectedOldValue, removeRecoveredEntry);
            return bl;
        }
        catch (ConcurrentCacheModificationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("caught concurrent modification attempt when applying {}", event);
            }
            if (event.getVersionTag() != null && !event.getVersionTag().isGatewayTag()) {
                this.notifyBridgeClients(event);
            }
            boolean bl = true;
            return bl;
        }
        catch (DiskAccessException dae) {
            this.handleDiskAccessException(dae);
            throw dae;
        }
        finally {
            if (inRI) {
                this.unlockRIReadLock();
            }
        }
    }

    static boolean causedByRDE(DiskAccessException dae) {
        boolean result = false;
        if (dae != null) {
            for (Throwable cause = dae.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RegionDestroyedException)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public final void handleDiskAccessException(DiskAccessException dae) {
        this.handleDiskAccessException(dae, false);
    }

    public final void handleDiskAccessException(DiskAccessException dae, boolean duringInitialization) {
        if (duringInitialization || LocalRegion.causedByRDE(dae)) {
            return;
        }
        StringId sid = LocalizedStrings.LocalRegion_A_DISKACCESSEXCEPTION_HAS_OCCURED_WHILE_WRITING_TO_THE_DISK_FOR_REGION_0_THE_CACHE_WILL_BE_CLOSED;
        logger.error(LocalizedMessage.create(sid, this.fullPath), (Throwable)dae);
        this.getDiskStore().handleDiskAccessException(dae);
    }

    void expireDestroy(EntryEventImpl event, boolean cacheWrite) {
        this.basicDestroy(event, cacheWrite, null);
    }

    void expireInvalidate(EntryEventImpl event) {
        this.basicInvalidate(event);
    }

    protected EntryEventImpl generateEvictDestroyEvent(Object key2) {
        EntryEventImpl event = new EntryEventImpl(this, Operation.EVICT_DESTROY, key2, null, null, false, this.getMyId());
        if (this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        return event;
    }

    boolean evictDestroy(LRUEntry entry) {
        this.checkReadiness();
        EntryEventImpl event = this.generateEvictDestroyEvent(entry.getKey());
        try {
            return this.mapDestroy(event, false, true, null);
        }
        catch (CacheWriterException error) {
            throw new Error(LocalizedStrings.LocalRegion_CACHE_WRITER_SHOULD_NOT_HAVE_BEEN_CALLED_FOR_EVICTDESTROY.toLocalizedString(), error);
        }
        catch (TimeoutException anotherError) {
            throw new Error(LocalizedStrings.LocalRegion_NO_DISTRIBUTED_LOCK_SHOULD_HAVE_BEEN_ATTEMPTED_FOR_EVICTDESTROY.toLocalizedString(), anotherError);
        }
        catch (EntryNotFoundException yetAnotherError) {
            throw new Error(LocalizedStrings.LocalRegion_ENTRYNOTFOUNDEXCEPTION_SHOULD_BE_MASKED_FOR_EVICTDESTROY.toLocalizedString(), yetAnotherError);
        }
    }

    protected void basicDestroyBeforeRemoval(RegionEntry entry, EntryEventImpl event) {
    }

    void basicDestroyPart2(RegionEntry re, EntryEventImpl event, boolean inTokenMode, boolean conflictWithClear, boolean duringRI, boolean invokeCallbacks) {
        if (!(this instanceof HARegion) && logger.isTraceEnabled()) {
            logger.trace("basicDestroyPart2(inTokenMode={},conflictWithClear={},duringRI={}) event={}", inTokenMode, conflictWithClear, duringRI, event);
        }
        VersionTag v = event.getVersionTag();
        if (inTokenMode && !this.concurrencyChecksEnabled && !event.isFromRILocalDestroy()) {
            if (re.isDestroyed()) {
                this.getImageState().addDestroyedEntry(event.getKey());
                if (!(this instanceof HARegion) && logger.isTraceEnabled()) {
                    logger.trace("basicDestroy: {}--> Token.DESTROYED", event.getKey());
                }
            }
        } else if (this.concurrencyChecksEnabled && !(this instanceof HARegion) && logger.isDebugEnabled()) {
            logger.debug("basicDestroyPart2: {}, version={}", event.getKey(), v);
        }
        this.notifyGatewayHubs(EnumListenerEvent.AFTER_DESTROY, event);
        if (invokeCallbacks && !event.isBulkOpInProgress()) {
            if (this.isInitialized() && (!inTokenMode || duringRI) || this.isUsedForPartitionedRegionBucket) {
                try {
                    re.dispatchListenerEvents(event);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.stopper.checkCancelInProgress(null);
                    return;
                }
            } else {
                event.callbacksInvoked(true);
            }
        }
    }

    void basicDestroyPart3(RegionEntry re, EntryEventImpl event, boolean inTokenMode, boolean duringRI, boolean invokeCallbacks, Object expectedOldValue) {
        if (invokeCallbacks && event.isBulkOpInProgress()) {
            event.getRemoveAllOperation().addEntry(event);
        }
        if (!inTokenMode || duringRI) {
            this.updateStatsForDestroy();
        }
        if (this.entryUserAttributes != null) {
            this.entryUserAttributes.remove(event.getKey());
        }
    }

    private void updateStatsForDestroy() {
        this.getCachePerfStats().incDestroys();
    }

    final void txClearRegion() {
        TXStateInterface tx = this.getJTAEnlistedTX();
        if (tx != null) {
            tx.rmRegion(this);
        }
    }

    public void invokeDestroyCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent, boolean notifyGateways) {
        if (event.getOperation() == Operation.REMOVE) {
            event.setOperation(Operation.DESTROY);
        }
        event.setEventType(eventType);
        this.notifyBridgeClients(event);
        if (notifyGateways) {
            this.notifyGatewayHubs(eventType, event);
        }
        if (callDispatchListenerEvent) {
            this.dispatchListenerEvent(eventType, event);
        }
    }

    public void invokeTXCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent) {
        Operation op = event.getOperation();
        if (logger.isDebugEnabled()) {
            logger.debug("invokeTXCallbacks for event {}", event);
        }
        if (op == Operation.REMOVE) {
            event.setOperation(Operation.DESTROY);
        } else if (op == Operation.PUT_IF_ABSENT) {
            event.setOperation(Operation.CREATE);
        } else if (op == Operation.REPLACE) {
            event.setOperation(Operation.UPDATE);
        }
        event.setEventType(eventType);
        this.notifyBridgeClients(event);
        this.notifyGatewayHubs(eventType, event);
        if (callDispatchListenerEvent && (event.getInvokePRCallbacks() || !(event.getRegion() instanceof PartitionedRegion) && !event.getRegion().isUsedForPartitionedRegionBucket())) {
            this.dispatchListenerEvent(eventType, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void txApplyDestroy(Object key2, TransactionId rmtOrigin, TXRmtEvent event, boolean needTokensForGII, Operation op, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, boolean isOriginRemote, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        boolean inRI = !needTokensForGII && this.lockRIReadLock();
        boolean needRIDestroyToken = inRI && this.riCnt > 0;
        boolean inTokenMode = needTokensForGII || needRIDestroyToken;
        try {
            this.entries.txApplyDestroy(key2, rmtOrigin, event, inTokenMode, needRIDestroyToken, op, eventId, aCallbackArgument, pendingCallbacks, filterRoutingInfo, bridgeContext, isOriginRemote, txEntryState, versionTag, tailKey);
        }
        finally {
            if (inRI) {
                this.unlockRIReadLock();
            }
        }
    }

    void txApplyDestroyPart2(RegionEntry re, Object key2, boolean inTokenMode, boolean clearConflict) {
        if (this.testCallable != null) {
            this.testCallable.call(this, Operation.DESTROY, re);
        }
        if (inTokenMode) {
            this.getImageState().addDestroyedEntry(key2);
        } else {
            this.updateStatsForDestroy();
        }
        if (this.entryUserAttributes != null) {
            this.entryUserAttributes.remove(key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicInvalidateRegion(RegionEventImpl event) {
        TXStateProxy tx = this.cache.getTXMgr().internalSuspend();
        try {
            this.regionInvalid = true;
            this.getImageState().setRegionInvalidated(true);
            this.invalidateAllEntries(event);
            Set allSubregions = this.subregions(true);
            for (LocalRegion rgn : allSubregions) {
                rgn.regionInvalid = true;
                try {
                    rgn.getImageState().setRegionInvalidated(true);
                    rgn.invalidateAllEntries(event);
                    if (!rgn.isInitialized() || !rgn.hasListener()) continue;
                    RegionEventImpl event2 = (RegionEventImpl)event.clone();
                    event2.region = rgn;
                    rgn.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_INVALIDATE, event2);
                }
                catch (RegionDestroyedException ignore) {}
            }
            if (!this.isInitialized()) {
                return;
            }
            event.setEventType(EnumListenerEvent.AFTER_REGION_INVALIDATE);
            this.notifyBridgeClients(event);
            boolean hasListener = this.hasListener();
            if (logger.isDebugEnabled()) {
                logger.debug("basicInvalidateRegion: hasListener = {}", hasListener);
            }
            if (hasListener) {
                this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_INVALIDATE, event);
            }
        }
        finally {
            this.cache.getTXMgr().resume(tx);
        }
    }

    boolean isExpiredWithRegardTo(Object key2, int ttl, int idleTime) {
        long expTime;
        if (!this.getAttributes().getStatisticsEnabled()) {
            return false;
        }
        try {
            expTime = new NetSearchExpirationCalculator(this, key2, ttl, idleTime).getExpirationTime();
        }
        catch (EntryNotFoundException ex) {
            return true;
        }
        if (expTime == 0L) {
            return false;
        }
        return expTime <= this.cacheTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchListenerEvent(EnumListenerEvent op, InternalCacheEvent event) {
        boolean isEntryEvent = event instanceof EntryEventImpl;
        if (isEntryEvent && ((EntryEventImpl)event).inhibitAllNotifications()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notification inhibited for key {}", event);
            }
            return;
        }
        if (this.shouldDispatchListenerEvent()) {
            RegionEntry re;
            if (logger.isTraceEnabled()) {
                logger.trace("dispatchListenerEvent event={}", event);
            }
            long start = this.getCachePerfStats().startCacheListenerCall();
            boolean origOriginRemote = false;
            boolean isOriginRemoteSet = false;
            try {
                if (isEntryEvent) {
                    if (((EntryEventImpl)event).isSingleHop()) {
                        origOriginRemote = event.isOriginRemote();
                        ((EntryEventImpl)event).setOriginRemote(true);
                        isOriginRemoteSet = true;
                    }
                    if ((re = ((EntryEventImpl)event).getRegionEntry()) != null) {
                        ((EntryEventImpl)event).getRegionEntry().setCacheListenerInvocationInProgress(true);
                    }
                }
                if (!GemFireCacheImpl.ASYNC_EVENT_LISTENERS) {
                    LocalRegion.dispatchEvent(this, event, op);
                } else {
                    try {
                        this.cache.getEventThreadPool().execute(new EventDispatcher(event, op));
                    }
                    catch (RejectedExecutionException rex) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_0_EVENT_NOT_DISPATCHED_DUE_TO_REJECTED_EXECUTION), (Throwable)rex);
                    }
                }
            }
            finally {
                this.getCachePerfStats().endCacheListenerCall(start);
                if (isOriginRemoteSet) {
                    ((EntryEventImpl)event).setOriginRemote(origOriginRemote);
                }
                if (isEntryEvent && (re = ((EntryEventImpl)event).getRegionEntry()) != null) {
                    re.setCacheListenerInvocationInProgress(false);
                }
            }
        }
    }

    public boolean isInitialized() {
        if (this.initialized) {
            return true;
        }
        StoppableCountDownLatch latch = this.initializationLatchAfterGetInitialImage;
        if (latch == null) {
            return true;
        }
        long count = latch.getCount();
        if (count == 0L) {
            this.initialized = true;
            return true;
        }
        return false;
    }

    public boolean isEventTrackerInitialized() {
        if (this.eventTracker != null) {
            return this.eventTracker.isInitialized();
        }
        return false;
    }

    public boolean hasEventTracker() {
        return this.eventTracker != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDestroyLock() {
        LocalRegion root = this.getRoot();
        boolean acquired = false;
        do {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                root.destroyLock.acquire();
                acquired = true;
            }
            catch (InterruptedException ie) {
                interrupted = true;
                this.cache.getCancelCriterion().checkCancelInProgress(ie);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (!acquired);
        if (logger.isDebugEnabled()) {
            logger.debug("Acquired Destroy Lock: {}", root);
        }
    }

    public void releaseDestroyLock() {
        LocalRegion root = this.getRoot();
        if (logger.isDebugEnabled()) {
            logger.debug("Releasing Destroy Lock: {}", root.getName());
        }
        root.destroyLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupFailedInitialization() {
        this.isDestroyed = true;
        this.cache.getResourceManager(false).removeResourceListener(this);
        this.entries.clear(null);
        this.destroyedSubregionSerialNumbers = this.collectSubregionSerialNumbers();
        try {
            if (this.eventTracker != null) {
                this.eventTracker.stop();
            }
            if (this.diskRegion != null) {
                try {
                    this.diskRegion.cleanupFailedInitialization(this);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.releaseLatches();
        }
    }

    LocalRegion getRoot() {
        LocalRegion r = this;
        while (r.parentRegion != null) {
            r = r.parentRegion;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializationFailed(LocalRegion subregion) {
        Object object = this.subregionsLock;
        synchronized (object) {
            this.subregions.remove(subregion.getName());
        }
        subregion.cleanupFailedInitialization();
    }

    long updateStatsForPut(RegionEntry entry, long p_lastModified, boolean lruRecentUse) {
        long lastModified = p_lastModified;
        if (lruRecentUse) {
            entry.setRecentlyUsed();
        }
        if (lastModified == 0L) {
            lastModified = this.cacheTimeMillis();
        }
        entry.updateStatsForPut(lastModified);
        IndexManager.setIndexBufferTime(lastModified, this.cacheTimeMillis());
        if (this.statisticsEnabled && !this.isProxy()) {
            this.addExpiryTaskIfAbsent(entry);
        }
        this.setLastModifiedTime(lastModified);
        return lastModified;
    }

    private LocalRegion basicGetSubregion(String name) {
        LocalRegion r = this.toRegion(this.subregions.get(name));
        if (r == null && LocalRegion.threadInitLevelRequirement() != 2) {
            String thePath = this.getFullPath() + "/" + name;
            if (logger.isDebugEnabled()) {
                logger.debug("Trying reinitializing region, fullPath={}", thePath);
            }
            r = this.cache.getReinitializingRegion(thePath);
            if (logger.isDebugEnabled()) {
                logger.debug("Reinitialized region is {}", r);
            }
        }
        return r;
    }

    private LocalRegion toRegion(Object element) {
        LocalRegion rgn = (LocalRegion)element;
        if (rgn != null) {
            rgn.waitOnInitialization();
        }
        return rgn;
    }

    public void updateStatsForGet(RegionEntry re, boolean hit) {
        if (!this.statisticsEnabled) {
            return;
        }
        long now = this.cacheTimeMillis();
        if (re != null) {
            re.updateStatsForGet(hit, now);
            if (this.isEntryIdleExpiryPossible()) {
                this.addExpiryTaskIfAbsent(re);
            }
        }
        this.setLastAccessedTime(now, hit);
    }

    private void sendPendingRegionDestroyEvents(HashSet set) {
        for (RegionEventImpl event : set) {
            event.region.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_DESTROY, event);
            if (this.cache.forcedDisconnect()) continue;
            SystemMemberCacheEventProcessor.send(this.getCache(), event.getRegion(), event.getOperation());
        }
    }

    protected void closeCallbacksExceptListener() {
        this.closeCacheCallback(this.getCacheLoader());
        this.closeCacheCallback(this.getCacheWriter());
        this.closeCacheCallback(this.getEvictionController());
    }

    private void closeAllCallbacks() {
        this.closeCallbacksExceptListener();
        CacheListener[] listeners = this.fetchCacheListenersField();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                this.closeCacheCallback(listeners[i]);
            }
        }
    }

    private void detachPool() {
        ServerRegionProxy mySRP = this.getServerProxy();
        if (mySRP != null) {
            GemFireCacheImpl gc2 = this.getCache();
            String poolname = this.getPoolName();
            PoolImpl dpool = (PoolImpl)PoolManager.find(this.getPoolName());
            if (poolname != null && dpool != null) {
                mySRP.detach(gc2.keepDurableSubscriptionsAlive() || dpool.getKeepAlive());
            } else {
                mySRP.detach(gc2.keepDurableSubscriptionsAlive());
            }
        }
    }

    private void closeCqs() {
        CqService cqService = CqService.getRunningCqService();
        if (cqService != null) {
            try {
                cqService.closeCqs(this.getFullPath());
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_EXCEPTION_OCCURRED_WHILE_CLOSING_CQS_ON_REGION_DESTORY), t);
            }
        }
    }

    void handleCacheClose(Operation op) {
        block7: {
            RegionEventImpl ev = new RegionEventImpl((Region)this, op, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
            if (!this.isDestroyed) {
                try {
                    this.basicDestroyRegion(ev, false, true, true);
                }
                catch (CancelException ignore) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("handleCacheClose: Encountered cache closure while closing region {}", this.getFullPath());
                    }
                }
                catch (RegionDestroyedException ignore) {
                }
                catch (CacheWriterException e) {
                    throw new Error(LocalizedStrings.LocalRegion_CACHEWRITEREXCEPTION_SHOULD_NOT_BE_THROWN_HERE.toLocalizedString(), e);
                }
                catch (TimeoutException e) {
                    InternalDistributedSystem ids = this.getCache().getDistributedSystem();
                    if (ids.isDisconnecting()) break block7;
                    throw new InternalGemFireError(LocalizedStrings.LocalRegion_TIMEOUTEXCEPTION_SHOULD_NOT_BE_THROWN_HERE.toLocalizedString(), e);
                }
            }
        }
    }

    void cleanUpOnIncompleteOp(EntryEventImpl event, RegionEntry re, boolean eventRecorded, boolean updateStats, boolean isReplace) {
        IndexUpdater iu = this.getIndexUpdater();
        if (!eventRecorded || iu == null || isReplace) {
            this.entries.removeEntry(event.getKey(), re, updateStats);
        } else {
            Operation oldOp = event.getOperation();
            event.setOperation(Operation.DESTROY);
            this.entries.removeEntry(event.getKey(), re, updateStats, event, this, iu);
            event.setOperation(oldOp);
        }
    }

    static void validateRegionName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_NULL.toLocalizedString());
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_EMPTY.toLocalizedString());
        }
        if (name.indexOf("/") >= 0) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_CONTAIN_THE_SEPARATOR_0.toLocalizedString("/"));
        }
    }

    private void checkCacheClosed() {
        if (this.cache.isClosed()) {
            throw this.cache.getCacheClosedException(null, null);
        }
    }

    private void checkRegionDestroyed(boolean checkCancel) {
        if (checkCancel) {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
        }
        if (this.isDestroyed) {
            RegionDestroyedException ex;
            if (this.reinitialized_old) {
                ex = new RegionReinitializedException(this.toString(), this.getFullPath());
            } else {
                if (this.cache.isCacheAtShutdownAll()) {
                    throw new CacheClosedException("Cache is being closed by ShutdownAll");
                }
                ex = new RegionDestroyedException(this.toString(), this.getFullPath());
            }
            if (checkCancel) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
            }
            throw ex;
        }
        if (this.isDestroyedForParallelWAN) {
            throw new RegionDestroyedException(LocalizedStrings.LocalRegion_REGION_IS_BEING_DESTROYED_WAITING_FOR_PARALLEL_QUEUE_TO_DRAIN.toLocalizedString(), this.getFullPath());
        }
    }

    @Override
    public void foreachRegionEntry(RegionEntryCallback callback) {
        Iterator<RegionEntry> it = this.entries.regionEntries().iterator();
        while (it.hasNext()) {
            callback.handleRegionEntry(it.next());
        }
    }

    protected void checkIfReplicatedAndLocalDestroy(EntryEventImpl event) {
        if (this.getScope().isDistributed() && this.getDataPolicy().withReplication() && !event.isDistributed() && !this.isUsedForSerialGatewaySenderQueue()) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_NOT_ALLOWED_TO_DO_A_LOCAL_DESTROY_ON_A_REPLICATED_REGION.toLocalizedString());
        }
    }

    protected int allSubregionsSize() {
        int sz = 1;
        for (LocalRegion r : this.subregions.values()) {
            if (r == null || !r.isInitialized() || r.isDestroyed()) continue;
            sz += r.allSubregionsSize();
        }
        return sz;
    }

    protected int allEntriesSize() {
        int sz = this.entryCount();
        Iterator itr = this.subregions.values().iterator();
        while (itr.hasNext()) {
            LocalRegion r = this.toRegion(itr.next());
            if (r == null || r.isDestroyed()) continue;
            sz += r.allEntriesSize();
        }
        return sz;
    }

    protected void invalidateAllEntries(RegionEvent rgnEvent) {
        Operation op = Operation.LOCAL_INVALIDATE;
        if (rgnEvent.getOperation().isDistributed()) {
            op = Operation.INVALIDATE;
        }
        Iterator itr = this.keySet().iterator();
        while (itr.hasNext()) {
            try {
                EntryEventImpl event = new EntryEventImpl(this, op, itr.next(), null, null, rgnEvent.isOriginRemote(), rgnEvent.getDistributedMember());
                event.setLocalInvalid(!rgnEvent.getOperation().isDistributed());
                this.basicInvalidate(event, false);
            }
            catch (EntryNotFoundException e) {}
        }
    }

    boolean hasListener() {
        CacheListener[] listeners = this.fetchCacheListenersField();
        return listeners != null && listeners.length > 0;
    }

    @Override
    public DiskStoreImpl getDiskStore() {
        return this.dsi;
    }

    private boolean useDefaultDiskStore() {
        assert (this.getDiskStoreName() == null);
        if (!Arrays.equals(this.getDiskDirs(), DiskStoreFactory.DEFAULT_DISK_DIRS)) {
            return false;
        }
        if (!Arrays.equals(this.getDiskDirSizes(), DiskStoreFactory.DEFAULT_DISK_DIR_SIZES)) {
            return false;
        }
        DiskWriteAttributesFactory dwf = new DiskWriteAttributesFactory();
        dwf.setSynchronous(false);
        if (dwf.create().equals(this.getDiskWriteAttributes())) {
            return true;
        }
        dwf.setSynchronous(true);
        return dwf.create().equals(this.getDiskWriteAttributes());
    }

    protected boolean usesDiskStore(RegionAttributes ra) {
        return !this.isProxy() && (this.getAttributes().getDataPolicy().withPersistence() || this.isOverflowEnabled());
    }

    protected DiskStoreImpl findDiskStore(RegionAttributes ra, InternalRegionArguments internalRegionArgs) {
        if (this.getAttributes().getDataPolicy().withPersistence()) {
            this.getCache().getPdxRegistry().creatingPersistentRegion();
        }
        if (this.usesDiskStore(ra)) {
            if (this.getDiskStoreName() != null) {
                DiskStoreImpl diskStore = (DiskStoreImpl)this.getGemFireCache().findDiskStore(this.getDiskStoreName());
                if (diskStore == null) {
                    throw new IllegalStateException(LocalizedStrings.CacheCreation_DISKSTORE_NOTFOUND_0.toLocalizedString(this.getDiskStoreName()));
                }
                return diskStore;
            }
            if (this.useDefaultDiskStore()) {
                return this.getGemFireCache().getOrCreateDefaultDiskStore();
            }
            DiskStoreFactory dsf = this.getGemFireCache().createDiskStoreFactory();
            dsf.setDiskDirsAndSizes(this.getDiskDirs(), this.getDiskDirSizes());
            DiskWriteAttributes dwa = this.getDiskWriteAttributes();
            dsf.setAutoCompact(dwa.isRollOplogs());
            dsf.setMaxOplogSize(dwa.getMaxOplogSize());
            dsf.setTimeInterval(dwa.getTimeInterval());
            if (dwa.getBytesThreshold() > 0L) {
                dsf.setQueueSize(1);
            } else {
                dsf.setQueueSize(0);
            }
            DiskStoreFactoryImpl dsfi = (DiskStoreFactoryImpl)dsf;
            return dsfi.createOwnedByRegion(this.getFullPath().replace('/', '_'), this instanceof PartitionedRegion, internalRegionArgs);
        }
        return null;
    }

    protected DiskRegion createDiskRegion(InternalRegionArguments internalRegionArgs) throws DiskAccessException {
        if (internalRegionArgs.getDiskRegion() != null) {
            DiskRegion dr = internalRegionArgs.getDiskRegion();
            dr.createDataStorage();
            return dr;
        }
        if (this.dsi != null) {
            DiskRegionStats stats = this instanceof BucketRegion ? internalRegionArgs.getPartitionedRegion().getDiskRegionStats() : new DiskRegionStats(this.getCache().getDistributedSystem(), this.getFullPath());
            EnumSet<DiskInitFile.DiskRegionFlag> diskFlags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
            if (this.getAttributes().getConcurrencyChecksEnabled()) {
                diskFlags.add(DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING);
            }
            return DiskRegion.create(this.dsi, this.getFullPath(), false, this.getDataPolicy().withPersistence(), this.isOverflowEnabled(), this.isDiskSynchronous(), stats, this.getCancelCriterion(), this, this.getAttributes(), diskFlags, "NO_PARTITITON", -1, this.getCompressor());
        }
        return null;
    }

    public ObjectSizer getObjectSizer() {
        ObjectSizer result = null;
        EvictionAttributes ea = this.getEvictionAttributes();
        if (ea != null) {
            result = ea.getObjectSizer();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTTLExpiryTask() {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            RegionTTLExpiryTask task = this.regionTTLExpiryTask;
            if (task != null) {
                task.cancel();
            }
            if (this.regionTimeToLive > 0) {
                this.regionTTLExpiryTask = (RegionTTLExpiryTask)this.cache.getExpirationScheduler().addExpiryTask(new RegionTTLExpiryTask(this));
                if (this.regionTTLExpiryTask != null && logger.isDebugEnabled()) {
                    logger.debug("Initialized Region TTL Expiry Task {}", this.regionTTLExpiryTask);
                }
            } else {
                this.regionTTLExpiryTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTTLExpiryTask(RegionTTLExpiryTask callingTask) {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            if (this.regionTTLExpiryTask != null && this.regionTTLExpiryTask != callingTask) {
                return;
            }
            if (this.regionTimeToLive <= 0) {
                this.regionTTLExpiryTask = null;
                return;
            }
            RegionTTLExpiryTask task = new RegionTTLExpiryTask(this);
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling Region TTL Expiry Task {} which replaces {}", task, this.regionTTLExpiryTask);
            }
            this.regionTTLExpiryTask = (RegionTTLExpiryTask)this.cache.getExpirationScheduler().addExpiryTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addIdleExpiryTask() {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            RegionIdleExpiryTask task = this.regionIdleExpiryTask;
            if (task != null) {
                task.cancel();
            }
            if (this.regionIdleTimeout > 0) {
                this.regionIdleExpiryTask = (RegionIdleExpiryTask)this.cache.getExpirationScheduler().addExpiryTask(new RegionIdleExpiryTask(this));
                if (this.regionIdleExpiryTask != null && logger.isDebugEnabled()) {
                    logger.debug("Initialized Region Idle Expiry Task {}", this.regionIdleExpiryTask);
                }
            } else {
                this.regionIdleExpiryTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleExpiryTask(RegionIdleExpiryTask callingTask) {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            if (this.regionIdleExpiryTask != null && this.regionIdleExpiryTask != callingTask) {
                return;
            }
            if (this.regionIdleTimeout <= 0) {
                this.regionIdleExpiryTask = null;
                return;
            }
            RegionIdleExpiryTask task = new RegionIdleExpiryTask(this);
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling Region Idle Expiry Task {} which replaces ", task, this.regionIdleExpiryTask);
            }
            this.regionIdleExpiryTask = (RegionIdleExpiryTask)this.cache.getExpirationScheduler().addExpiryTask(task);
        }
    }

    protected boolean isEntryIdleExpiryPossible() {
        return this.entryIdleTimeout > 0 || this.customEntryIdleTimeout != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTTLExpiryTask() {
        RegionTTLExpiryTask task;
        Object object = this.regionExpiryLock;
        synchronized (object) {
            task = this.regionTTLExpiryTask;
            if (task != null) {
                this.regionTTLExpiryTask = null;
            }
        }
        if (task != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIdleExpiryTask() {
        RegionIdleExpiryTask task;
        Object object = this.regionExpiryLock;
        synchronized (object) {
            task = this.regionIdleExpiryTask;
            if (task != null) {
                this.regionIdleExpiryTask = null;
            }
        }
        if (task != null) {
            task.cancel();
        }
    }

    @Override
    protected void regionTimeToLiveChanged(ExpirationAttributes oldTimeToLive) {
        this.addTTLExpiryTask();
    }

    @Override
    protected void regionIdleTimeoutChanged(ExpirationAttributes oldIdleTimeout) {
        this.addIdleExpiryTask();
    }

    @Override
    protected void timeToLiveChanged(ExpirationAttributes oldTimeToLive) {
        int oldTimeout = oldTimeToLive.getTimeout();
        if (this.customEntryTimeToLive != null) {
            this.rescheduleEntryExpiryTasks();
        } else if (this.entryTimeToLive > 0 && (oldTimeout == 0 || this.entryTimeToLive < oldTimeout)) {
            this.rescheduleEntryExpiryTasks();
        }
    }

    @Override
    protected void idleTimeoutChanged(ExpirationAttributes oldIdleTimeout) {
        int oldTimeout = oldIdleTimeout.getTimeout();
        if (this.customEntryIdleTimeout != null) {
            this.rescheduleEntryExpiryTasks();
        } else if (this.entryIdleTimeout > 0 && (oldTimeout == 0 || this.entryIdleTimeout < oldTimeout)) {
            this.rescheduleEntryExpiryTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescheduleEntryExpiryTasks() {
        if (this.isProxy()) {
            return;
        }
        if (!this.isInitialized()) {
            return;
        }
        Iterator<RegionEntry> it = this.entries.regionEntries().iterator();
        if (it.hasNext()) {
            try {
                if (this.isEntryExpiryPossible()) {
                    ExpiryTask.setNow();
                }
                while (it.hasNext()) {
                    this.addExpiryTask(it.next());
                }
            }
            finally {
                ExpiryTask.clearNow();
            }
        }
    }

    void addExpiryTaskIfAbsent(RegionEntry re) {
        this.addExpiryTask(re, true);
    }

    void addExpiryTask(RegionEntry re) {
        this.addExpiryTask(re, false);
    }

    private EntryExpiryTask createExpiryTask(RegionEntry re) {
        if (re == null || re.isDestroyedOrRemoved()) {
            return null;
        }
        if (this.customEntryIdleTimeout != null || this.customEntryTimeToLive != null) {
            boolean idleDisabled;
            CustomExpiry customIdle;
            ExpiryRegionEntry ere = new ExpiryRegionEntry(this, re);
            ExpirationAttributes ttlAtts = null;
            ExpirationAttributes idleAtts = null;
            RegionAttributes ra = this.getAttributes();
            CustomExpiry customTTL = ra.getCustomEntryTimeToLive();
            if (customTTL != null) {
                try {
                    ttlAtts = customTTL.getExpiry(ere);
                    if (ttlAtts != null) {
                        this.checkEntryTimeoutAction("timeToLive", ttlAtts.getAction());
                    }
                }
                catch (RegionDestroyedException rde) {
                }
                catch (Exception e) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.EntryExpiryTask_ERROR_CALCULATING_EXPIRATION_0, e.getMessage()), (Throwable)e);
                }
            }
            if (ttlAtts == null) {
                ttlAtts = ra.getEntryTimeToLive();
            }
            if ((customIdle = ra.getCustomEntryIdleTimeout()) != null) {
                try {
                    idleAtts = customIdle.getExpiry(ere);
                    if (idleAtts != null) {
                        this.checkEntryTimeoutAction("idleTimeout", idleAtts.getAction());
                    }
                }
                catch (RegionDestroyedException rde) {
                }
                catch (Exception e) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.EntryExpiryTask_ERROR_CALCULATING_EXPIRATION_0, e.getMessage()), (Throwable)e);
                }
            }
            if (idleAtts == null) {
                idleAtts = ra.getEntryIdleTimeout();
            }
            boolean ttlDisabled = ttlAtts == null || ttlAtts.getTimeout() == 0;
            boolean bl = idleDisabled = idleAtts == null || idleAtts.getTimeout() == 0;
            if (ttlDisabled && idleDisabled) {
                return null;
            }
            if ((ttlDisabled || ttlAtts.equals(ra.getEntryTimeToLive())) && (idleDisabled || idleAtts.equals(ra.getEntryIdleTimeout()))) {
                return new EntryExpiryTask(this, re);
            }
            return new CustomEntryExpiryTask(this, re, ttlAtts, idleAtts);
        }
        if (this.isEntryExpiryPossible()) {
            return new EntryExpiryTask(this, re);
        }
        return null;
    }

    private void addExpiryTask(RegionEntry re, boolean ifAbsent) {
        if (this.isProxy()) {
            return;
        }
        if (!this.isInitialized()) {
            return;
        }
        if (this.isEntryExpiryPossible()) {
            EntryExpiryTask newTask = null;
            EntryExpiryTask oldTask = null;
            if (ifAbsent && (oldTask = this.entryExpiryTasks.get(re)) != null) {
                boolean keepOldTask = true;
                if (this.customEntryIdleTimeout != null || this.customEntryTimeToLive != null) {
                    newTask = this.createExpiryTask(re);
                    if (newTask == null) {
                        this.cancelExpiryTask(re);
                        return;
                    }
                    long ntTime = newTask.getExpirationTime();
                    try {
                        if (ntTime != 0L && ntTime < oldTask.getExpirationTime()) {
                            keepOldTask = false;
                        }
                    }
                    catch (EntryNotFoundException ex) {
                        keepOldTask = false;
                    }
                }
                if (keepOldTask) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Expiry Task not added because one already present. Key={}" + re.getKey());
                    }
                    return;
                }
            }
            if (newTask == null && (newTask = this.createExpiryTask(re)) == null) {
                this.cancelExpiryTask(re);
                return;
            }
            oldTask = this.entryExpiryTasks.put(re, newTask);
            ExpirationScheduler es = this.cache.getExpirationScheduler();
            if (oldTask != null && oldTask.cancel()) {
                es.incCancels();
            }
            if (!es.addEntryExpiryTask(newTask)) {
                this.entryExpiryTasks.remove(re);
            }
        } else {
            this.cancelExpiryTask(re);
            if (logger.isTraceEnabled()) {
                logger.trace("addExpiryTask(key) ignored");
            }
        }
    }

    void cancelExpiryTask(RegionEntry re) {
        EntryExpiryTask oldTask = this.entryExpiryTasks.remove(re);
        if (oldTask != null && oldTask.cancel()) {
            this.cache.getExpirationScheduler().incCancels();
        }
    }

    public void cancelAllEntryExpiryTasks() {
        if (this.entryExpiryTasks == null) {
            return;
        }
        if (this.entryExpiryTasks.isEmpty()) {
            return;
        }
        boolean doPurge = false;
        for (EntryExpiryTask task : this.entryExpiryTasks.values()) {
            task.cancel();
            doPurge = true;
        }
        if (doPurge) {
            this.cache.getExpirationScheduler().forcePurge();
        }
    }

    long getLastAccessedTime(Object key2) throws EntryNotFoundException {
        RegionEntry entry = this.entries.getEntry(key2);
        if (entry == null) {
            throw new EntryNotFoundException(key2.toString());
        }
        try {
            return entry.getLastAccessed();
        }
        catch (InternalStatisticsDisabledException e) {
            return 0L;
        }
    }

    long getLastModifiedTime(Object key2) throws EntryNotFoundException {
        RegionEntry entry = this.entries.getEntry(key2);
        if (entry == null) {
            throw new EntryNotFoundException(key2.toString());
        }
        return entry.getLastModified();
    }

    protected final ImageState getImageState() {
        return this.imageState;
    }

    boolean lockGII() {
        ImageState is = this.getImageState();
        if (is.isReplicate() && !this.isInitialized()) {
            is.lockGII();
            if (this.isInitialized()) {
                is.unlockGII();
            } else {
                return true;
            }
        }
        return false;
    }

    void unlockGII() {
        ImageState is = this.getImageState();
        assert (is.isReplicate());
        is.unlockGII();
    }

    private boolean lockRIReadLock() {
        if (this.getImageState().isClient()) {
            this.getImageState().readLockRI();
            return true;
        }
        return false;
    }

    private void unlockRIReadLock() {
        assert (this.getImageState().isClient());
        this.getImageState().readUnlockRI();
    }

    public LocalRegion basicGetParentRegion() {
        return this.parentRegion;
    }

    Object basicGetEntryUserAttribute(Object entryKey) {
        Map userAttr = this.entryUserAttributes;
        if (userAttr == null) {
            return null;
        }
        return userAttr.get(entryKey);
    }

    public final TXStateInterface getTXState() {
        if (this.supportsTX) {
            return TXManagerImpl.getCurrentTXState();
        }
        return null;
    }

    final TXId getTXId() {
        TXStateInterface tx = this.getTXState();
        if (tx == null) {
            return null;
        }
        return (TXId)tx.getTransactionId();
    }

    protected final TXRegionState txReadRegion() {
        TXStateInterface tx = this.getTXState();
        if (tx != null) {
            return tx.txReadRegion(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXEntryState createReadEntry(TXRegionState txr, KeyInfo keyInfo, boolean createIfAbsent) {
        TXEntryState result = null;
        RegionEntry re = this.basicGetTXEntry(keyInfo);
        if (re != null) {
            boolean needsLRUCleanup = false;
            try {
                RegionEntry regionEntry = re;
                synchronized (regionEntry) {
                    if (!re.isRemoved()) {
                        LRUEntry le;
                        if (re instanceof DiskEntry && re instanceof LRUEntry && (le = (LRUEntry)re).testEvicted()) {
                            this.txLRUStart();
                            needsLRUCleanup = true;
                            re.getValue(this);
                        }
                        Object value2 = re.getValueInVM(this);
                        Object id = re.getTransformedValue();
                        result = txr.createReadEntry(this, keyInfo.getKey(), re, id, value2);
                    }
                }
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae);
                needsLRUCleanup = false;
                throw dae;
            }
            finally {
                if (needsLRUCleanup) {
                    this.txLRUEnd();
                }
            }
        }
        if (result == null && createIfAbsent) {
            result = txr.createReadEntry(this, keyInfo.getKey(), null, null, null);
        }
        return result;
    }

    protected TXStateInterface getJTAEnlistedTX() {
        if (this.ignoreJTA) {
            return null;
        }
        TXStateInterface tx = this.getTXState();
        if (tx != null) {
            return tx;
        }
        try {
            if (!this.ignoreJTA && this.cache.getJTATransactionManager() != null) {
                Transaction jtaTx = this.cache.getJTATransactionManager().getTransaction();
                if (jtaTx == null || jtaTx.getStatus() == 6) {
                    return null;
                }
                tx = this.cache.getTXMgr().beginJTA();
                jtaTx.registerSynchronization(tx);
                return tx;
            }
            return null;
        }
        catch (SystemException se) {
            this.stopper.checkCancelInProgress(se);
            this.jtaEnlistmentFailureCleanup(tx, se);
            return null;
        }
        catch (RollbackException re) {
            this.jtaEnlistmentFailureCleanup(tx, re);
            return null;
        }
        catch (IllegalStateException ie) {
            this.jtaEnlistmentFailureCleanup(tx, ie);
            return null;
        }
    }

    private final void jtaEnlistmentFailureCleanup(TXStateInterface tx, Exception reason) {
        if (this.cache == null) {
            return;
        }
        this.cache.getTXMgr().setTXState(null);
        if (tx != null) {
            tx.rollback();
        }
        String jtaTransName = null;
        try {
            jtaTransName = this.cache.getJTATransactionManager().getTransaction().toString();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ignore) {
            SystemFailure.checkFailure();
        }
        throw new FailedSynchronizationException(LocalizedStrings.LocalRegion_FAILED_ENLISTEMENT_WITH_TRANSACTION_0.toLocalizedString(jtaTransName), reason);
    }

    final void txLRUStart() {
        this.entries.disableLruUpdateCallback();
    }

    final void txLRUEnd() {
        this.entries.enableLruUpdateCallback();
        try {
            this.entries.lruUpdateCallback();
        }
        catch (DiskAccessException dae) {
            this.handleDiskAccessException(dae);
            throw dae;
        }
    }

    final void txDecRefCount(RegionEntry re) {
        this.entries.decTxRefCount(re);
    }

    List debugGetSubregionNames() {
        ArrayList names = new ArrayList();
        Iterator itr = this.subregions.keySet().iterator();
        while (itr.hasNext()) {
            names.add(itr.next());
        }
        return names;
    }

    protected static final void dispatchEvent(LocalRegion region, InternalCacheEvent event, EnumListenerEvent op) {
        CacheListener[] listeners;
        block10: {
            listeners = region.fetchCacheListenersField();
            if (listeners == null || listeners.length == 0) {
                return;
            }
            if (op != EnumListenerEvent.AFTER_REGION_CREATE) {
                try {
                    region.waitForRegionCreateEvent();
                }
                catch (CancelException e) {
                    if (!logger.isTraceEnabled()) break block10;
                    logger.trace("Dispatching events after cache closure for region {}", region.getFullPath());
                }
            }
        }
        if (!event.isGenerateCallbacks()) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            CacheListener listener = listeners[i];
            if (listener == null) continue;
            try {
                op.dispatchEvent(event, listener);
                continue;
            }
            catch (CancelException ignore) {
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.error(LocalizedMessage.create(LocalizedStrings.LocalRegion_EXCEPTION_OCCURRED_IN_CACHELISTENER), t);
            }
        }
    }

    public void checkForTransaction(String opName) {
        if (this.isTX()) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_0_OPERATIONS_ARE_NOT_ALLOWED_BECAUSE_THIS_THREAD_HAS_AN_ACTIVE_TRANSACTION.toLocalizedString(opName));
        }
    }

    @Override
    public RegionMap getRegionMap() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.checkReadiness();
        this.checkForNoAccess();
        this.discoverJTA();
        boolean isClient = this.imageState.isClient();
        if (isClient) {
            this.lockRIReadLock();
        }
        try {
            int n = this.entryCount();
            return n;
        }
        finally {
            if (isClient) {
                this.unlockRIReadLock();
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_VALUE_FOR_CONTAINSVALUEVALUE_CANNOT_BE_NULL.toLocalizedString());
        }
        this.checkReadiness();
        this.checkForNoAccess();
        boolean result = false;
        Iterator<Object> iterator = new EntriesSet(this, false, IteratorType.VALUES, false).iterator();
        Object val = null;
        while (iterator.hasNext()) {
            val = iterator.next();
            if (val == null || !value2.equals(val)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Set entrySet() {
        return this.entries(false);
    }

    @Override
    public Set keySet() {
        return this.keys();
    }

    @Override
    public Object remove(Object obj) {
        Object returnObject = null;
        try {
            returnObject = this.destroy(obj);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        return returnObject;
    }

    public void basicBridgeDestroyRegion(Object p_callbackArg, ClientProxyMembershipID client, boolean fromClient, EventID eventId) throws TimeoutException, EntryExistsException, CacheWriterException {
        Object callbackArg = p_callbackArg;
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        BridgeRegionEventImpl event = new BridgeRegionEventImpl(this, Operation.REGION_DESTROY, callbackArg, false, client.getDistributedMember(), client, eventId);
        this.basicDestroyRegion(event, true);
    }

    public void basicBridgeClear(Object p_callbackArg, ClientProxyMembershipID client, boolean fromClient, EventID eventId) throws TimeoutException, EntryExistsException, CacheWriterException {
        Object callbackArg = p_callbackArg;
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        BridgeRegionEventImpl event = new BridgeRegionEventImpl(this, Operation.REGION_CLEAR, callbackArg, false, client.getDistributedMember(), client, eventId);
        this.basicClear(event, true);
    }

    @Override
    void basicClear(RegionEventImpl regionEvent) {
        this.getDataView().checkSupportsRegionClear();
        this.basicClear(regionEvent, true);
    }

    void basicClear(RegionEventImpl regionEvent, boolean cacheWrite) {
        this.cmnClearRegion(regionEvent, cacheWrite, true);
    }

    void cmnClearRegion(RegionEventImpl regionEvent, boolean cacheWrite, boolean useRVV) {
        RegionVersionVector rvv = null;
        if (useRVV && this.dataPolicy.withReplication() && this.concurrencyChecksEnabled) {
            rvv = this.versionVector.getCloneForTransmission();
        }
        this.clearRegionLocally(regionEvent, cacheWrite, rvv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRegionLocally(RegionEventImpl regionEvent, boolean cacheWrite, RegionVersionVector vector) {
        RegionVersionVector myVector;
        boolean isGIIInProg;
        boolean isRvvDebugEnabled = logger.isTraceEnabled(LogMarker.RVV);
        RegionVersionVector rvv = vector;
        if (this.srp != null) {
            rvv = null;
        }
        if (rvv != null && this.dataPolicy.withStorage()) {
            boolean result;
            if (isRvvDebugEnabled) {
                logger.trace(LogMarker.RVV, "waiting for my version vector to dominate\nmine={}\nother=", this.versionVector.fullToString(), rvv);
            }
            if (!(result = this.versionVector.waitToDominate(rvv, this))) {
                if (isRvvDebugEnabled) {
                    logger.trace(LogMarker.RVV, "incrementing clearTimeouts for {} rvv={}", this.getName(), this.versionVector.fullToString());
                }
                this.getCachePerfStats().incClearTimeouts();
            }
        }
        if (isGIIInProg = this.lockGII()) {
            try {
                this.getImageState().setClearRegionFlag(true, rvv);
            }
            finally {
                this.unlockGII();
            }
        }
        if (cacheWrite && !isGIIInProg) {
            this.cacheWriteBeforeRegionClear(regionEvent);
        }
        if ((myVector = this.getVersionVector()) != null) {
            VersionTag tag;
            if (isRvvDebugEnabled) {
                logger.trace(LogMarker.RVV, "processing version information for {}", regionEvent);
            }
            if (!regionEvent.isOriginRemote() && !regionEvent.getOperation().isLocal()) {
                tag = VersionTag.create(this.getVersionMember());
                tag.setVersionTimeStamp(this.cacheTimeMillis());
                tag.setRegionVersion(myVector.getNextVersionWhileLocked());
                if (isRvvDebugEnabled) {
                    logger.trace(LogMarker.RVV, "generated version tag for clear: {}", tag);
                }
                regionEvent.setVersionTag(tag);
            } else {
                tag = regionEvent.getVersionTag();
                if (tag != null) {
                    if (isRvvDebugEnabled) {
                        logger.trace(LogMarker.RVV, "recording version tag for clear: {}", tag);
                    }
                    myVector.recordVersion(tag.getMemberID(), tag);
                }
            }
        }
        this.cancelAllEntryExpiryTasks();
        if (this.entryUserAttributes != null) {
            this.entryUserAttributes.clear();
        }
        if (rvv == null && myVector != null) {
            myVector.removeOldVersions();
        }
        if (this.diskRegion != null) {
            if (this.getDataPolicy().withPersistence()) {
                if (isRvvDebugEnabled) {
                    logger.trace(LogMarker.RVV, "Clear: Saved current rvv: {}", this.diskRegion.getRegionVersionVector());
                }
                this.diskRegion.writeRVV(this, null);
                this.diskRegion.writeRVVGC(this);
            }
            this.diskRegion.clear(this, rvv);
        } else {
            this.txClearRegion();
            Set remainingIDs = this.entries.clear(rvv);
            if (!this.dataPolicy.withPersistence() && myVector != null) {
                myVector.removeOldMembers(remainingIDs);
            }
        }
        if (!this.isProxy() && this.indexManager != null) {
            try {
                this.indexManager.rerunIndexCreationQuery();
            }
            catch (QueryException qe) {
                throw new CacheRuntimeException(LocalizedStrings.LocalRegion_EXCEPTION_OCCURED_WHILE_RE_CREATING_INDEX_DATA_ON_CLEARED_REGION.toLocalizedString(), qe){
                    private static final long serialVersionUID = 0L;
                };
            }
        }
        if (ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().afterRegionClear(regionEvent);
        }
        if (isGIIInProg) {
            return;
        }
        regionEvent.setEventType(EnumListenerEvent.AFTER_REGION_CLEAR);
        boolean hasListener = this.hasListener();
        if (hasListener) {
            this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_CLEAR, regionEvent);
        }
    }

    @Override
    void basicLocalClear(RegionEventImpl rEvent) {
        this.getDataView().checkSupportsRegionClear();
        this.cmnClearRegion(rEvent, false, false);
    }

    public void handleInterestEvent(InterestRegistrationEvent event) {
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_REGION_INTEREST_REGISTRATION_IS_ONLY_SUPPORTED_FOR_PARTITIONEDREGIONS.toLocalizedString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map basicGetAll(Collection keys, Object callback) {
        HashMap<Object, Object> allResults;
        block21: {
            block20: {
                boolean isDebugEnabled = logger.isDebugEnabled();
                if (isDebugEnabled) {
                    logger.debug("Processing getAll request for: {}", keys);
                }
                this.discoverJTA();
                allResults = new HashMap<Object, Object>();
                if (!this.hasServerProxy()) break block20;
                ArrayList keysList = keys instanceof List ? (ArrayList)keys : new ArrayList(keys);
                if (this.getTXState() == null && this.hasStorage()) {
                    if (keysList == keys) {
                        keysList = new ArrayList(keys);
                    }
                    Iterator i = keysList.iterator();
                    while (i.hasNext()) {
                        Object value2;
                        Object key2 = i.next();
                        Region.Entry entry = this.accessEntry(key2, true);
                        if (entry == null || (value2 = entry.getValue()) == null) continue;
                        allResults.put(key2, value2);
                        i.remove();
                    }
                    if (isDebugEnabled) {
                        logger.debug("Added local results for getAll request: {}", allResults);
                    }
                }
                if (keysList.isEmpty()) break block21;
                VersionedObjectList remoteResults = this.getServerProxy().getAll(keysList, callback);
                if (isDebugEnabled) {
                    logger.debug("remote getAll results are {}", remoteResults);
                }
                VersionedObjectList.Iterator it = remoteResults.iterator();
                while (it.hasNext()) {
                    Object value3;
                    VersionedObjectList.Entry entry = it.next();
                    Object key3 = entry.getKey();
                    boolean notOnServer = entry.isKeyNotOnServer();
                    boolean createTombstone = false;
                    if (notOnServer) {
                        createTombstone = entry.getVersionTag() != null && this.concurrencyChecksEnabled;
                        allResults.put(key3, null);
                        if (isDebugEnabled) {
                            logger.debug("Added remote result for missing key: {}", key3);
                        }
                        if (!createTombstone) continue;
                    }
                    if ((value3 = createTombstone ? Token.TOMBSTONE : entry.getObject()) instanceof Throwable) continue;
                    long startPut = CachePerfStats.getStatTime();
                    this.validateKey(key3);
                    EntryEventImpl event = new EntryEventImpl(this, Operation.LOCAL_LOAD_CREATE, key3, value3, callback, false, this.getMyId(), true);
                    event.setFromServer(true);
                    event.setVersionTag(entry.getVersionTag());
                    if (!this.alreadyInvalid(key3, event)) {
                        TXStateProxy tx = this.cache.getTXMgr().internalSuspend();
                        try {
                            this.basicPutEntry(event, 0L);
                        }
                        catch (ConcurrentCacheModificationException e) {
                            if (isDebugEnabled) {
                                logger.debug("getAll result for {} not stored in cache due to concurrent modification", key3);
                            }
                        }
                        finally {
                            this.cache.getTXMgr().resume(tx);
                        }
                        this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
                    }
                    if (createTombstone) continue;
                    allResults.put(key3, value3);
                    if (!isDebugEnabled) continue;
                    logger.debug("Added remote result for getAll request: {}, {}", key3, value3);
                }
                break block21;
            }
            for (Object key4 : keys) {
                try {
                    allResults.put(key4, this.get(key4, callback));
                }
                catch (Exception e) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.LocalRegion_THE_FOLLOWING_EXCEPTION_OCCURRED_ATTEMPTING_TO_GET_KEY_0, key4), (Throwable)e);
                }
            }
        }
        return allResults;
    }

    protected boolean hasStorage() {
        return this.getDataPolicy().withStorage();
    }

    private void verifyPutAllMap(Map map) {
        Object var2_2 = null;
        Set theEntries = map.entrySet();
        for (Map.Entry entry : theEntries) {
            Object key2 = entry.getKey();
            if (entry.getValue() == null || key2 == null) {
                throw new NullPointerException("Any key or value in putAll should not be null");
            }
            if (InternalResourceManager.isLowMemoryExceptionDisabled()) continue;
            this.checkIfAboveThreshold(key2);
        }
    }

    private void verifyRemoveAllKeys(Collection<Object> keys) {
        for (Object key2 : keys) {
            if (key2 != null) continue;
            throw new NullPointerException("Any key in removeAll must not be null");
        }
    }

    public VersionedObjectList basicBridgePutAll(Map map, Map<Object, VersionTag> retryVersions, ClientProxyMembershipID memberId, EventID eventId, boolean skipCallbacks, Object callbackArg) throws TimeoutException, CacheWriterException {
        long startPut = CachePerfStats.getStatTime();
        if (this.getAttributes().getEnableGateway()) {
            callbackArg = new GatewayEventCallbackArgument(callbackArg);
        }
        if (this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.PUTALL_CREATE, null, null, callbackArg, false, memberId.getDistributedMember(), !skipCallbacks, eventId);
        event.setContext(memberId);
        DistributedPutAllOperation putAllOp = new DistributedPutAllOperation(event, map.size(), true);
        VersionedObjectList result = this.basicPutAll(map, putAllOp, retryVersions);
        this.getCachePerfStats().endPutAll(startPut);
        return result;
    }

    public VersionedObjectList basicBridgeRemoveAll(ArrayList<Object> keys, ArrayList<VersionTag> retryVersions, ClientProxyMembershipID memberId, EventID eventId, Object callbackArg) throws TimeoutException, CacheWriterException {
        long startOp = CachePerfStats.getStatTime();
        if (this.getAttributes().getEnableGateway()) {
            callbackArg = new GatewayEventCallbackArgument(callbackArg);
        }
        if (this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.REMOVEALL_DESTROY, null, null, callbackArg, false, memberId.getDistributedMember(), true, eventId);
        event.setContext(memberId);
        DistributedRemoveAllOperation removeAllOp = new DistributedRemoveAllOperation(event, keys.size(), true);
        VersionedObjectList result = this.basicRemoveAll(keys, removeAllOp, retryVersions);
        this.getCachePerfStats().endRemoveAll(startOp);
        return result;
    }

    public VersionedObjectList basicImportPutAll(Map map, boolean skipCallbacks) {
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = new EntryEventImpl(this, Operation.PUTALL_CREATE, null, null, null, true, this.getMyId(), !skipCallbacks);
        DistributedPutAllOperation putAllOp = new DistributedPutAllOperation(event, map.size(), false);
        VersionedObjectList result = this.basicPutAll(map, putAllOp, null);
        this.getCachePerfStats().endPutAll(startPut);
        return result;
    }

    public final void putAll(Map map, Object callbackArg) {
        long startPut = CachePerfStats.getStatTime();
        DistributedPutAllOperation putAllOp = this.newPutAllOperation(map, callbackArg);
        if (putAllOp != null) {
            this.basicPutAll(map, putAllOp, null);
        }
        this.getCachePerfStats().endPutAll(startPut);
    }

    @Override
    public final void putAll(Map map) {
        this.putAll(map, (Object)null);
    }

    public final void removeAll(Collection keys) {
        this.removeAll(keys, (Object)null);
    }

    public final void removeAll(Collection keys, Object callbackArg) {
        long startOp = CachePerfStats.getStatTime();
        DistributedRemoveAllOperation op = this.newRemoveAllOperation(keys, callbackArg);
        if (op != null) {
            this.basicRemoveAll(keys, op, null);
        }
        this.getCachePerfStats().endRemoveAll(startOp);
    }

    public boolean requiresOneHopForMissingEntry(EntryEventImpl event) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedObjectList basicPutAll(final Map<?, ?> map, DistributedPutAllOperation putAllOp, final Map<Object, VersionTag> retryVersions) {
        VersionedObjectList succeeded;
        RuntimeException e;
        block28: {
            boolean serverIsVersioned;
            boolean partialResult;
            VersionedObjectList proxyResult;
            EventID eventId;
            EntryEventImpl event;
            boolean isDebugEnabled;
            block27: {
                isDebugEnabled = logger.isDebugEnabled();
                event = putAllOp.getBaseEvent();
                eventId = event.getEventId();
                if (eventId == null && this.generateEventID()) {
                    event.reserveNewEventId(this.cache.getDistributedSystem(), map.size());
                    eventId = event.getEventId();
                }
                e = null;
                this.verifyPutAllMap(map);
                proxyResult = null;
                partialResult = false;
                if (this.hasServerProxy()) {
                    if (this.isTX()) {
                        TXStateProxyImpl tx = (TXStateProxyImpl)this.cache.getTxManager().getTXState();
                        tx.getRealDeal(null, this);
                    }
                    try {
                        proxyResult = this.getServerProxy().putAll(map, eventId, !event.isGenerateCallbacks(), event.getCallbackArgument());
                        if (isDebugEnabled) {
                            logger.debug("PutAll received response from server: {}", proxyResult);
                        }
                    }
                    catch (PutAllPartialResultException e1) {
                        proxyResult = e1.getSucceededKeysAndVersions();
                        partialResult = true;
                        if (isDebugEnabled) {
                            logger.debug("putAll in client encountered a PutAllPartialResultException:{}\n. Adjusted keys are: ", e1.getMessage(), proxyResult.getKeys());
                        }
                        for (Throwable txException = e1.getFailure(); txException != null; txException = txException.getCause()) {
                            if (!(txException instanceof TransactionException)) continue;
                            e = (TransactionException)txException;
                            break;
                        }
                        if (e != null) break block27;
                        e = new ServerOperationException(LocalizedStrings.Region_PutAll_Applied_PartialKeys_At_Server_0.toLocalizedString(this.getFullPath()), e1.getFailure());
                    }
                }
            }
            succeeded = new VersionedObjectList(map.size(), true, this.concurrencyChecksEnabled);
            boolean bl = serverIsVersioned = proxyResult != null && proxyResult.regionIsVersioned() && !this.isTX() && this.dataPolicy != DataPolicy.EMPTY;
            if (!serverIsVersioned && !partialResult) {
                proxyResult = null;
            }
            this.lockRVVForBulkOp();
            try {
                boolean isVersionedResults;
                Iterator iterator;
                int size2;
                final DistributedPutAllOperation dpao = putAllOp;
                int n = size2 = proxyResult == null ? map.size() : proxyResult.size();
                if (isDebugEnabled) {
                    logger.debug("size of put result is {} maps is {} proxyResult is {}", size2, map, proxyResult);
                }
                final PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(size2);
                if (proxyResult != null) {
                    iterator = proxyResult.iterator();
                    isVersionedResults = true;
                } else {
                    iterator = map.entrySet().iterator();
                    isVersionedResults = false;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        int offset = 0;
                        EntryEventImpl tagHolder = EntryEventImpl.createVersionTagHolder();
                        while (iterator.hasNext()) {
                            Object value2;
                            LocalRegion.this.stopper.checkCancelInProgress(null);
                            Map.Entry mapEntry = (Map.Entry)iterator.next();
                            Object key2 = mapEntry.getKey();
                            VersionTag versionTag = null;
                            tagHolder.setVersionTag(null);
                            boolean overwritten = false;
                            if (isVersionedResults) {
                                versionTag = ((VersionedObjectList.Entry)mapEntry).getVersionTag();
                                value2 = map.get(key2);
                                if (isDebugEnabled) {
                                    logger.debug("putAll key {} -> {} version={}", key2, value2, versionTag);
                                }
                                if (versionTag == null && serverIsVersioned && LocalRegion.this.concurrencyChecksEnabled && LocalRegion.this.dataPolicy.withStorage()) {
                                    if (isDebugEnabled) {
                                        logger.debug("server returned no version information for {}", key2);
                                    }
                                    LocalRegion.this.localDestroyNoCallbacks(key2);
                                    LocalRegion.this.get(key2, event.getCallbackArgument(), false, null);
                                    overwritten = true;
                                }
                            } else {
                                value2 = mapEntry.getValue();
                                if (isDebugEnabled) {
                                    logger.debug("putAll {} -> {}", key2, value2);
                                }
                            }
                            try {
                                if (serverIsVersioned) {
                                    if (isDebugEnabled) {
                                        logger.debug("associating version tag with {} version={}", key2, versionTag);
                                    }
                                    tagHolder.setVersionTag(versionTag);
                                    tagHolder.setFromServer(true);
                                } else if (retryVersions != null && retryVersions.containsKey(key2)) {
                                    tagHolder.setVersionTag((VersionTag)retryVersions.get(key2));
                                }
                                if (!overwritten) {
                                    LocalRegion.this.basicEntryPutAll(key2, value2, dpao, offset, tagHolder);
                                }
                                LocalRegion.this.stopper.checkCancelInProgress(null);
                                succeeded.addKeyAndVersion(key2, tagHolder.getVersionTag());
                            }
                            catch (Exception ex) {
                                if (isDebugEnabled) {
                                    logger.debug("PutAll operation encountered exception for key {}", key2, ex);
                                }
                                partialKeys.saveFailedKey(key2, ex);
                            }
                            ++offset;
                        }
                    }
                };
                this.syncBulkOp(r, eventId);
                if (!partialKeys.hasFailure()) break block28;
                partialKeys.setSucceededKeysAndVersions(succeeded);
                logger.info(LocalizedMessage.create(LocalizedStrings.Region_PutAll_Applied_PartialKeys_0_1, new Object[]{this.getFullPath(), partialKeys}));
                if (isDebugEnabled) {
                    logger.debug(partialKeys.detailString());
                }
                if (e != null) break block28;
                if (dpao.isBridgeOperation()) {
                    if (partialKeys.getFailure() instanceof CancelException) {
                        e = (CancelException)partialKeys.getFailure();
                    } else {
                        if (partialKeys.getFailure() instanceof LowMemoryException) {
                            throw partialKeys.getFailure();
                        }
                        e = new PutAllPartialResultException(partialKeys);
                        if (isDebugEnabled) {
                            logger.debug("basicPutAll:" + partialKeys.detailString());
                        }
                    }
                    break block28;
                }
                throw partialKeys.getFailure();
            }
            catch (LowMemoryException lme) {
                throw lme;
            }
            catch (RuntimeException ex) {
                e = ex;
            }
            catch (Exception ex) {
                e = new RuntimeException(ex);
            }
            finally {
                this.unlockRVVForBulkOp();
            }
        }
        this.getDataView().postPutAll(putAllOp, succeeded, this);
        if (e != null) {
            throw e;
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedObjectList basicRemoveAll(Collection<Object> keys, DistributedRemoveAllOperation removeAllOp, final ArrayList<VersionTag> retryVersions) {
        VersionedObjectList succeeded;
        RuntimeException e;
        block33: {
            boolean serverIsVersioned;
            boolean partialResult;
            VersionedObjectList proxyResult;
            EventID eventId;
            boolean isTraceEnabled;
            boolean isDebugEnabled;
            block32: {
                isDebugEnabled = logger.isDebugEnabled();
                isTraceEnabled = logger.isTraceEnabled();
                EntryEventImpl event = removeAllOp.getBaseEvent();
                eventId = event.getEventId();
                if (eventId == null && this.generateEventID()) {
                    event.reserveNewEventId(this.cache.getDistributedSystem(), keys.size());
                    eventId = event.getEventId();
                }
                e = null;
                this.verifyRemoveAllKeys(keys);
                proxyResult = null;
                partialResult = false;
                if (this.hasServerProxy()) {
                    if (this.isTX()) {
                        TXStateProxyImpl tx = (TXStateProxyImpl)this.cache.getTxManager().getTXState();
                        tx.getRealDeal(null, this);
                    }
                    try {
                        proxyResult = this.getServerProxy().removeAll(keys, eventId, event.getCallbackArgument());
                        if (isDebugEnabled) {
                            logger.debug("removeAll received response from server: {}", proxyResult);
                        }
                    }
                    catch (PutAllPartialResultException e1) {
                        proxyResult = e1.getSucceededKeysAndVersions();
                        partialResult = true;
                        if (isDebugEnabled) {
                            logger.debug("removeAll in client encountered a BulkOpPartialResultException: {}\n. Adjusted keys are: {}", e1.getMessage(), proxyResult.getKeys());
                        }
                        for (Throwable txException = e1.getFailure(); txException != null; txException = txException.getCause()) {
                            if (!(txException instanceof TransactionException)) continue;
                            e = (TransactionException)txException;
                            break;
                        }
                        if (e != null) break block32;
                        e = new ServerOperationException(LocalizedStrings.Region_RemoveAll_Applied_PartialKeys_At_Server_0.toLocalizedString(this.getFullPath()), e1.getFailure());
                    }
                }
            }
            succeeded = new VersionedObjectList(keys.size(), true, this.concurrencyChecksEnabled);
            boolean bl = serverIsVersioned = proxyResult != null && proxyResult.regionIsVersioned() && !this.isTX() && this.getDataPolicy().withStorage();
            if (!serverIsVersioned && !partialResult) {
                proxyResult = null;
            }
            this.lockRVVForBulkOp();
            try {
                boolean isVersionedResults;
                Iterator iterator;
                int size2;
                final DistributedRemoveAllOperation op = removeAllOp;
                int n = size2 = proxyResult == null ? keys.size() : proxyResult.size();
                if (this.isInternalRegion()) {
                    if (isTraceEnabled) {
                        logger.trace("size of removeAll result is {} keys are {} proxyResult is {}", size2, keys, proxyResult);
                    } else if (isTraceEnabled) {
                        logger.trace("size of removeAll result is {} keys are {} proxyResult is {}", size2, keys, proxyResult);
                    }
                } else if (isTraceEnabled) {
                    logger.trace("size of removeAll result is {} keys are {} proxyResult is {}", size2, keys, proxyResult);
                }
                final PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(size2);
                if (proxyResult != null) {
                    iterator = proxyResult.iterator();
                    isVersionedResults = true;
                } else {
                    iterator = keys.iterator();
                    isVersionedResults = false;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        int offset = 0;
                        EntryEventImpl tagHolder = EntryEventImpl.createVersionTagHolder();
                        while (iterator.hasNext()) {
                            Object key2;
                            LocalRegion.this.stopper.checkCancelInProgress(null);
                            VersionTag versionTag = null;
                            tagHolder.setVersionTag(null);
                            if (isVersionedResults) {
                                Map.Entry mapEntry = (Map.Entry)iterator.next();
                                key2 = mapEntry.getKey();
                                versionTag = ((VersionedObjectList.Entry)mapEntry).getVersionTag();
                                if (isDebugEnabled) {
                                    logger.debug("removeAll key {} version={}", key2, versionTag);
                                }
                                if (versionTag == null) {
                                    if (isDebugEnabled) {
                                        logger.debug("removeAll found invalid version tag, which means the entry is not found at server for key={}.", key2);
                                    }
                                    succeeded.addKeyAndVersion(key2, null);
                                    continue;
                                }
                            } else {
                                key2 = iterator.next();
                                if (LocalRegion.this.isInternalRegion()) {
                                    if (isTraceEnabled) {
                                        logger.trace("removeAll {}", key2);
                                    }
                                } else if (isTraceEnabled) {
                                    logger.trace("removeAll {}", key2);
                                }
                            }
                            try {
                                VersionTag vt;
                                if (serverIsVersioned) {
                                    if (isDebugEnabled) {
                                        logger.debug("associating version tag with {} version={}", key2, versionTag);
                                    }
                                    tagHolder.setVersionTag(versionTag);
                                    tagHolder.setFromServer(true);
                                } else if (retryVersions != null && (vt = (VersionTag)retryVersions.get(offset)) != null) {
                                    tagHolder.setVersionTag(vt);
                                }
                                LocalRegion.this.basicEntryRemoveAll(key2, op, offset, tagHolder);
                                LocalRegion.this.stopper.checkCancelInProgress(null);
                                succeeded.addKeyAndVersion(key2, tagHolder.getVersionTag());
                            }
                            catch (Exception ex) {
                                partialKeys.saveFailedKey(key2, ex);
                            }
                            ++offset;
                        }
                    }
                };
                this.syncBulkOp(r, eventId);
                if (!partialKeys.hasFailure()) break block33;
                partialKeys.setSucceededKeysAndVersions(succeeded);
                logger.info(LocalizedMessage.create(LocalizedStrings.Region_RemoveAll_Applied_PartialKeys_0_1, new Object[]{this.getFullPath(), partialKeys}));
                if (isDebugEnabled) {
                    logger.debug(partialKeys.detailString());
                }
                if (e != null) break block33;
                if (op.isBridgeOperation()) {
                    if (partialKeys.getFailure() instanceof CancelException) {
                        e = (CancelException)partialKeys.getFailure();
                    } else {
                        if (partialKeys.getFailure() instanceof LowMemoryException) {
                            throw partialKeys.getFailure();
                        }
                        e = new PutAllPartialResultException(partialKeys);
                        if (isDebugEnabled) {
                            logger.debug("basicRemoveAll:" + partialKeys.detailString());
                        }
                    }
                    break block33;
                }
                throw partialKeys.getFailure();
            }
            catch (LowMemoryException lme) {
                throw lme;
            }
            catch (RuntimeException ex) {
                e = ex;
            }
            catch (Exception ex) {
                e = new RuntimeException(ex);
            }
            finally {
                this.unlockRVVForBulkOp();
            }
        }
        this.getDataView().postRemoveAll(removeAllOp, succeeded, this);
        if (e != null) {
            throw e;
        }
        return succeeded;
    }

    private void lockRVVForBulkOp() {
        if (this.versionVector != null && this.dataPolicy.withReplication()) {
            this.versionVector.lockForCacheModification(this);
        }
    }

    private void unlockRVVForBulkOp() {
        if (this.versionVector != null && this.dataPolicy.withReplication()) {
            this.versionVector.releaseCacheModificationLock(this);
        }
    }

    public final DistributedPutAllOperation newPutAllOperation(Map<?, ?> map, Object callbackArg) {
        if (map == null) {
            throw new NullPointerException(LocalizedStrings.AbstractRegion_MAP_CANNOT_BE_NULL.toLocalizedString());
        }
        if (map.isEmpty()) {
            return null;
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.discoverJTA();
        EntryEventImpl event = new EntryEventImpl(this, Operation.PUTALL_CREATE, null, null, callbackArg, true, this.getMyId());
        return new DistributedPutAllOperation(event, map.size(), false);
    }

    public final DistributedRemoveAllOperation newRemoveAllOperation(Collection<?> keys, Object callbackArg) {
        if (keys == null) {
            throw new NullPointerException("The keys Collection passed to removeAll was null.");
        }
        if (keys.isEmpty()) {
            return null;
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.discoverJTA();
        EntryEventImpl event = new EntryEventImpl(this, Operation.REMOVEALL_DESTROY, null, null, callbackArg, false, this.getMyId());
        return new DistributedRemoveAllOperation(event, keys.size(), false);
    }

    protected final void basicEntryPutAll(Object key2, Object value2, DistributedPutAllOperation putallOp, int offset, EntryEventImpl tagHolder) throws TimeoutException, CacheWriterException {
        assert (putallOp != null);
        this.checkReadiness();
        if (value2 == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_VALUE_CANNOT_BE_NULL.toLocalizedString());
        }
        this.validateArguments(key2, value2, null);
        EntryEventImpl event = EntryEventImpl.createPutAllEvent(putallOp, this, Operation.PUTALL_CREATE, key2, value2);
        if (tagHolder != null) {
            event.setVersionTag(tagHolder.getVersionTag());
            event.setFromServer(tagHolder.isFromServer());
        }
        if (this.generateEventID()) {
            event.setEventId(new EventID(putallOp.getBaseEvent().getEventId(), offset));
        }
        this.discoverJTA();
        this.performPutAllEntry(event);
        if (tagHolder != null) {
            tagHolder.setVersionTag(event.getVersionTag());
            tagHolder.isConcurrencyConflict(event.isConcurrencyConflict());
        }
    }

    protected final void basicEntryRemoveAll(Object key2, DistributedRemoveAllOperation op, int offset, EntryEventImpl tagHolder) throws TimeoutException, CacheWriterException {
        EntryEventImpl event;
        block6: {
            assert (op != null);
            this.checkReadiness();
            this.validateKey(key2);
            event = EntryEventImpl.createRemoveAllEvent(op, this, key2);
            if (tagHolder != null) {
                event.setVersionTag(tagHolder.getVersionTag());
                event.setFromServer(tagHolder.isFromServer());
            }
            if (this.generateEventID()) {
                event.setEventId(new EventID(op.getBaseEvent().getEventId(), offset));
            }
            this.discoverJTA();
            try {
                this.performRemoveAllEntry(event);
            }
            catch (EntryNotFoundException ignore) {
                if (event.getVersionTag() != null || !logger.isDebugEnabled()) break block6;
                logger.debug("RemoveAll encoutered EntryNotFoundException: event={}", event);
            }
        }
        if (tagHolder != null) {
            tagHolder.setVersionTag(event.getVersionTag());
            tagHolder.isConcurrencyConflict(event.isConcurrencyConflict());
        }
    }

    public void performPutAllEntry(EntryEventImpl event) {
        this.getDataView().putEntry(event, false, false, null, false, 0L, false);
    }

    public void performRemoveAllEntry(EntryEventImpl event) {
        this.basicDestroy(event, true, null);
    }

    public void postPutAllFireEvents(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts) {
        if (!this.dataPolicy.withStorage() && this.concurrencyChecksEnabled && putallOp.getBaseEvent().isBridgeEvent()) {
            successfulPuts.clear();
            putallOp.fillVersionedObjectList(successfulPuts);
        }
        HashSet successfulKeys = new HashSet(successfulPuts.size());
        for (Object key2 : successfulPuts.getKeys()) {
            successfulKeys.add(key2);
        }
        Iterator it = putallOp.eventIterator();
        while (it.hasNext()) {
            EntryEventImpl event = (EntryEventImpl)it.next();
            if (!successfulKeys.contains(event.getKey())) continue;
            EnumListenerEvent op = event.getOperation().isCreate() ? EnumListenerEvent.AFTER_CREATE : EnumListenerEvent.AFTER_UPDATE;
            this.invokePutCallbacks(op, event, !event.callbacksInvoked() && !event.isPossibleDuplicate(), false);
        }
    }

    public void postRemoveAllFireEvents(DistributedRemoveAllOperation op, VersionedObjectList successfulOps) {
        if (!this.dataPolicy.withStorage() && this.concurrencyChecksEnabled && op.getBaseEvent().isBridgeEvent()) {
            successfulOps.clear();
            op.fillVersionedObjectList(successfulOps);
        }
        HashSet successfulKeys = new HashSet(successfulOps.size());
        for (Object key2 : successfulOps.getKeys()) {
            successfulKeys.add(key2);
        }
        Iterator it = op.eventIterator();
        while (it.hasNext()) {
            EntryEventImpl event = (EntryEventImpl)it.next();
            if (!successfulKeys.contains(event.getKey())) continue;
            this.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, event, !event.callbacksInvoked() && !event.isPossibleDuplicate(), false);
        }
    }

    public void postPutAllSend(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts) {
    }

    public void postRemoveAllSend(DistributedRemoveAllOperation op, VersionedObjectList successfulOps) {
    }

    @Override
    protected boolean isCurrentlyLockGrantor() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleRemoteLocalRegionDestroyOrClose(InternalDistributedMember sender, int topSerial, Map subregionSerialNumbers, boolean regionDestroyed) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            this.basicHandleRemoteLocalRegionDestroyOrClose(sender, topSerial, subregionSerialNumbers, false, regionDestroyed);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    private final void basicHandleRemoteLocalRegionDestroyOrClose(InternalDistributedMember sender, int topSerial, Map subregionSerialNumbers, boolean subregion, boolean regionDestroyed) {
        int serialForThisRegion = topSerial;
        if (subregion) {
            Integer serialNumber = (Integer)subregionSerialNumbers.get(this.getFullPath());
            if (serialNumber == null) {
                return;
            }
            serialForThisRegion = serialNumber;
        }
        this.removeSenderFromAdvisor(sender, serialForThisRegion, regionDestroyed);
        Iterator itr = this.subregions.values().iterator();
        while (itr.hasNext()) {
            LocalRegion r = this.toRegion(itr.next());
            if (r == null || r.isDestroyed()) continue;
            r.basicHandleRemoteLocalRegionDestroyOrClose(sender, topSerial, subregionSerialNumbers, true, regionDestroyed);
        }
    }

    protected void removeSenderFromAdvisor(InternalDistributedMember sender, int serial, boolean regionDestroyed) {
    }

    public final boolean isUsedForPartitionedRegionAdmin() {
        return this.isUsedForPartitionedRegionAdmin;
    }

    public boolean shouldSyncForCrashedMember(InternalDistributedMember id) {
        return this.concurrencyChecksEnabled && this.dataPolicy.withReplication() && !this.isUsedForPartitionedRegionAdmin && !this.isUsedForMetaRegion && !this.isUsedForSerialGatewaySenderQueue;
    }

    @Override
    public void forceRolling() throws DiskAccessException {
        if (this.diskRegion != null) {
            this.diskRegion.forceRolling();
        }
    }

    @Deprecated
    public boolean notifyToRoll() {
        return this.forceCompaction();
    }

    @Override
    public boolean forceCompaction() {
        DiskRegion dr = this.getDiskRegion();
        if (dr != null) {
            if (dr.isCompactionPossible()) {
                return dr.forceCompaction();
            }
            throw new IllegalStateException("To call notifyToCompact you must configure the region with <disk-write-attributes allow-force-compaction=true/>");
        }
        return false;
    }

    @Override
    public File[] getDiskDirs() {
        if (this.getDiskStore() != null) {
            return this.getDiskStore().getDiskDirs();
        }
        return this.diskDirs;
    }

    @Override
    public int[] getDiskDirSizes() {
        if (this.getDiskStore() != null) {
            return this.getDiskStore().getDiskDirSizes();
        }
        return this.diskSizes;
    }

    public boolean isUsedForPartitionedRegionBucket() {
        return this.isUsedForPartitionedRegionBucket;
    }

    public boolean isUsedForSerialGatewaySenderQueue() {
        return this.isUsedForSerialGatewaySenderQueue;
    }

    public boolean isUsedForParallelGatewaySenderQueue() {
        return this.isUsedForParallelGatewaySenderQueue;
    }

    public SerialGatewaySenderImpl getSerialGatewaySender() {
        return this.serialGatewaySender;
    }

    public boolean isParallelWanEnabled() {
        Set<String> regionGatewaySenderIds = this.getAllGatewaySenderIds();
        if (regionGatewaySenderIds.isEmpty()) {
            return false;
        }
        Set<GatewaySender> cacheGatewaySenders = this.getCache().getAllGatewaySenders();
        for (GatewaySender sender : cacheGatewaySenders) {
            if (!regionGatewaySenderIds.contains(sender.getId()) || !sender.isParallel()) continue;
            return true;
        }
        return false;
    }

    public PartitionedRegion getPartitionedRegion() {
        if (!this.isUsedForPartitionedRegionBucket) {
            throw new IllegalArgumentException();
        }
        return ((BucketRegion)this).getPartitionedRegion();
    }

    public final boolean isUsedForMetaRegion() {
        return this.isUsedForMetaRegion;
    }

    public final boolean isMetaRegionWithTransactions() {
        return this.isMetaRegionWithTransactions;
    }

    public final boolean isInternalRegion() {
        return this.isSecret() || this.isUsedForMetaRegion() || this.isUsedForPartitionedRegionAdmin() || this.isUsedForPartitionedRegionBucket();
    }

    @Override
    public LoaderHelper createLoaderHelper(Object key2, Object callbackArgument, boolean netSearchAllowed, boolean netLoadAllowed, SearchLoadAndWriteProcessor searcher) {
        return new LoaderHelperImpl(this, key2, callbackArgument, netSearchAllowed, netLoadAllowed, searcher);
    }

    public final boolean hasNetLoader(CacheDistributionAdvisor distAdvisor) {
        return !distAdvisor.accept(netLoaderVisitor, null);
    }

    public final boolean hasNetWriter(CacheDistributionAdvisor distAdvisor) {
        return !distAdvisor.accept(netWriterVisitor, null);
    }

    protected boolean isSecret() {
        return false;
    }

    @Override
    public boolean supportsConcurrencyChecks() {
        return !this.isSecret() || this.dataPolicy.withPersistence();
    }

    protected boolean shouldNotifyBridgeClients() {
        return this.cache.getBridgeServers().size() > 0 && !this.isUsedForPartitionedRegionAdmin && !this.isUsedForPartitionedRegionBucket && !this.isUsedForMetaRegion;
    }

    protected boolean shouldNotifyGatewayHub() {
        if (!this.enableGateway) {
            return false;
        }
        return this.cache.getGatewayHubs().size() > 0;
    }

    protected boolean shouldNotifyGatewaySender() {
        return this.cache.getAllGatewaySenders().size() > 0;
    }

    protected boolean shouldNotifyGatewayHub(GatewayHubImpl hub) {
        return this.gatewayHubId == null || this.gatewayHubId.equals("") || this.gatewayHubId.equals(hub.getId()) || this.allGatewayHubIds != null && this.allGatewayHubIds.contains(hub.getId());
    }

    protected boolean shouldDispatchListenerEvent() {
        return this.hasListener();
    }

    @Override
    public final GemFireCacheImpl getGemFireCache() {
        return this.cache;
    }

    void cleanupForClient(CacheClientNotifier ccn, ClientProxyMembershipID client) {
        if (this.cache.isClosed()) {
            return;
        }
        if (this.isDestroyed) {
            return;
        }
        this.filterProfile.cleanupForClient(ccn, client);
        for (LocalRegion lr : new SubregionsSet(false)) {
            lr.cleanupForClient(ccn, client);
        }
    }

    public FilterProfile getFilterProfile() {
        return this.filterProfile;
    }

    public void destroyFilterProfile() {
        this.filterProfile = null;
    }

    protected HashMap getDestroyedSubregionSerialNumbers() {
        if (!this.isDestroyed) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_REGION_0_MUST_BE_DESTROYED_BEFORE_CALLING_GETDESTROYEDSUBREGIONSERIALNUMBERS.toLocalizedString(this.getFullPath()));
        }
        return this.destroyedSubregionSerialNumbers;
    }

    private HashMap collectSubregionSerialNumbers() {
        HashMap map = new HashMap();
        this.addSubregionSerialNumbers(map);
        return map;
    }

    private void addSubregionSerialNumbers(Map map) {
        for (Map.Entry entry : this.subregions.entrySet()) {
            LocalRegion subregion = (LocalRegion)entry.getValue();
            map.put(subregion.getFullPath(), subregion.getSerialNumber());
            subregion.addSubregionSerialNumbers(map);
        }
    }

    public SelectResults query(String p_predicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        String predicate = p_predicate;
        if (predicate == null) {
            throw new IllegalArgumentException("The input query predicate is null. A null predicate is not allowed.");
        }
        predicate = predicate.trim();
        SelectResults results = null;
        if (this.hasServerProxy()) {
            String queryString = null;
            predicate = predicate.trim();
            boolean matches = false;
            for (int i = 0; i < QUERY_PATTERNS.length; ++i) {
                if (!QUERY_PATTERNS[i].matcher(predicate).matches()) continue;
                matches = true;
                break;
            }
            queryString = matches ? predicate : "select * from " + this.getFullPath() + " this where " + predicate;
            try {
                results = this.getServerProxy().query(queryString, null);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw new QueryInvocationTargetException(e.getMessage(), cause);
            }
        } else {
            QueryService qs = this.getGemFireCache().getLocalQueryService();
            String queryStr = "select * from " + this.getFullPath() + " this where " + predicate;
            DefaultQuery query = (DefaultQuery)qs.newQuery(queryStr);
            results = (SelectResults)query.execute(new Object[0]);
        }
        return results;
    }

    protected void checkBeforeEntrySync(TXRmtEvent txEvent) {
    }

    public ResultCollector executeFunction(DistributedRegionFunctionExecutor execution, Function function, Object args, ResultCollector rc, Set filter, ServerToClientFunctionResultSender sender) {
        if (function.optimizeForWrite() && this.heapThresholdReached.get() && !InternalResourceManager.isLowMemoryExceptionDisabled()) {
            Set<DistributedMember> htrm = this.getHeapThresholdReachedMembers();
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(function.getId(), htrm), htrm);
        }
        LocalResultCollector<?, ?> localRC = execution.getLocalResultCollector(function, rc);
        DM dm = this.getDistributionManager();
        execution.setExecutionNodes(Collections.singleton(this.getMyId()));
        DistributedRegionFunctionResultSender resultSender = new DistributedRegionFunctionResultSender(dm, localRC, function, sender);
        RegionFunctionContextImpl context = new RegionFunctionContextImpl(function.getId(), this, args, filter, null, null, resultSender, execution.isReExecute());
        execution.executeFunctionOnLocalNode(function, context, resultSender, dm, this.isTX());
        return localRC;
    }

    public Set<DistributedMember> getHeapThresholdReachedMembers() {
        return Collections.singleton(this.cache.getMyId());
    }

    @Override
    public final void onEvent(MemoryEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Region:{} received a Memory event.{}", this, event);
        }
        this.setHeapThresholdFlag(event);
    }

    protected void setHeapThresholdFlag(MemoryEvent event) {
        assert (this.getScope().isLocal());
        if (event.isLocal()) {
            if (((MemoryEventType)((Object)event.getType())).isCriticalUp()) {
                this.heapThresholdReached.set(true);
            } else if (((MemoryEventType)((Object)event.getType())).isCriticalDown() || ((MemoryEventType)((Object)event.getType())).isCriticalDisabled()) {
                this.heapThresholdReached.set(false);
            }
        }
    }

    void updateSizeOnClearRegion(int sizeBeforeClear) {
    }

    @Override
    public int calculateValueSize(Object val) {
        return 0;
    }

    @Override
    public int calculateRegionEntryValueSize(RegionEntry re) {
        return 0;
    }

    void updateSizeOnPut(Object key2, int oldSize, int newSize) {
    }

    void updateSizeOnCreate(Object key2, int newSize) {
    }

    void updateSizeOnRemove(Object key2, int oldSize) {
    }

    int updateSizeOnEvict(Object key2, int oldSize) {
        return 0;
    }

    @Override
    public void updateSizeOnFaultIn(Object key2, int newSize, int bytesOnDisk) {
    }

    @Override
    public void initializeStats(long numEntriesInVM, long numOverflowOnDisk, long numOverflowBytesOnDisk) {
        this.getDiskRegion().getStats().incNumEntriesInVM(numEntriesInVM);
        this.getDiskRegion().getStats().incNumOverflowOnDisk(numOverflowOnDisk);
    }

    public void removeMemberFromCriticalList(DistributedMember member) {
        Assert.assertTrue(false);
    }

    public void initialCriticalMembers(boolean localHeapIsCritical, Set<InternalDistributedMember> critialMembers) {
        assert (this.getScope().isLocal());
        if (localHeapIsCritical) {
            this.heapThresholdReached.set(true);
        }
    }

    @Override
    public void destroyRecoveredEntry(Object key2) {
        EntryEventImpl event = new EntryEventImpl(this, Operation.LOCAL_DESTROY, key2, null, null, false, this.getMyId(), false);
        event.inhibitCacheListenerNotification(true);
        this.mapDestroy(event, true, false, null, false, true);
    }

    @Override
    public boolean lruLimitExceeded() {
        return this.entries.lruLimitExceeded();
    }

    @Override
    public DiskEntry getDiskEntry(Object key2) {
        RegionEntry re = this.entries.getEntry(key2);
        if (re != null && re.isRemoved() && !re.isTombstone()) {
            re = null;
        }
        return (DiskEntry)re;
    }

    public LocalRegion getDataRegionForRead(KeyInfo entryKey) {
        return this;
    }

    public LocalRegion getDataRegionForWrite(KeyInfo entryKey) {
        return this;
    }

    Set getRegionKeysForIteration() {
        return this.getRegionMap().keySet();
    }

    public final InternalDataView getSharedDataView() {
        return this.sharedDataView;
    }

    public DistributedMember getOwnerForKey(KeyInfo key2) {
        return this.getMyId();
    }

    public KeyInfo getKeyInfo(Object key2) {
        return new KeyInfo(key2, null, null);
    }

    public KeyInfo getKeyInfo(Object key2, Object callbackArg) {
        return this.getKeyInfo(key2, null, callbackArg);
    }

    public KeyInfo getKeyInfo(Object key2, Object value2, Object callbackArg) {
        return new KeyInfo(key2, null, callbackArg);
    }

    protected RegionEntry basicGetTXEntry(KeyInfo keyInfo) {
        return this.basicGetEntry(keyInfo.getKey());
    }

    void hubCreated(int hubTypeVal) {
        if (hubTypeVal > this.hubType) {
            this.hubType = hubTypeVal;
            this.distributeUpdatedProfileOnHubCreation();
        }
    }

    void senderCreated() {
        this.distributeUpdatedProfileOnSenderCreation();
    }

    void initializeSqlfHubDefinitionFlag(int highestOrderHubType) {
        this.hubType = highestOrderHubType;
    }

    void distributeUpdatedProfileOnHubCreation() {
    }

    void distributeUpdatedProfileOnSenderCreation() {
    }

    int getHubType() {
        return this.hubType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBackingMap() {
        Object sync = TombstoneService.DEBUG_TOMBSTONE_COUNT ? TombstoneService.debugSync : new Object();
        RegionMap regionMap = this.entries;
        synchronized (regionMap) {
            Object object = sync;
            synchronized (object) {
                if (this.entries instanceof AbstractRegionMap) {
                    ((AbstractRegionMap)this.entries).verifyTombstoneCount(this.tombstoneCount);
                }
                logger.debug("Dumping region of size {} tombstones: {}: {}", this.size(), this.getTombstoneCount(), this.toString());
                if (this.entries instanceof AbstractRegionMap) {
                    ((AbstractRegionMap)this.entries).dumpMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyTombstoneCount() {
        RegionMap regionMap = this.entries;
        synchronized (regionMap) {
            if (this.entries instanceof AbstractRegionMap) {
                // empty if block
            }
        }
    }

    private void checkIfConcurrentMapOpsAllowed() {
        if (this.srp == null && (this.dataPolicy == DataPolicy.NORMAL && this.scope.isDistributed() || this.dataPolicy == DataPolicy.EMPTY)) {
            throw new UnsupportedOperationException();
        }
    }

    public Object putIfAbsent(Object key2, Object value2, Object callbackArgument) {
        long startPut = CachePerfStats.getStatTime();
        this.checkIfConcurrentMapOpsAllowed();
        this.validateArguments(key2, value2, callbackArgument);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.discoverJTA();
        EntryEventImpl event = new EntryEventImpl(this, Operation.PUT_IF_ABSENT, key2, value2, callbackArgument, false, this.getMyId());
        Object oldValue = null;
        boolean ifNew = true;
        boolean ifOld = false;
        boolean requireOldValue = true;
        try {
            if (this.generateEventID()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            if (!this.basicPut(event, true, false, oldValue, true)) {
                return event.getOldValue();
            }
            if (!this.getDataView().isDeferredStats()) {
                this.getCachePerfStats().endPut(startPut, false);
            }
            return null;
        }
        catch (EntryNotFoundException e) {
            return event.getOldValue();
        }
    }

    @Override
    public Object putIfAbsent(Object key2, Object value2) {
        return this.putIfAbsent(key2, value2, null);
    }

    @Override
    public boolean remove(Object key2, Object value2) {
        return this.remove(key2, value2, null);
    }

    public boolean remove(Object key2, Object pvalue, Object callbackArg) {
        Object value2 = pvalue;
        this.checkIfConcurrentMapOpsAllowed();
        this.validateKey(key2);
        this.validateCallbackArg(callbackArg);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        if (value2 == null) {
            value2 = Token.INVALID;
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.REMOVE, key2, null, callbackArg, false, this.getMyId());
        try {
            if (this.generateEventID() && event.getEventId() == null) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.discoverJTA();
            this.getDataView().destroyExistingEntry(event, true, value2);
        }
        catch (EntryNotFoundException enfe) {
            return false;
        }
        catch (RegionDestroyedException rde) {
            if (!rde.getRegionFullPath().equals(this.getFullPath())) {
                RegionDestroyedException rde2 = new RegionDestroyedException(this.toString(), this.getFullPath());
                rde2.initCause(rde);
                throw rde2;
            }
            throw rde;
        }
        return true;
    }

    @Override
    public boolean replace(Object key2, Object oldValue, Object newValue) {
        return this.replace(key2, oldValue, newValue, null);
    }

    public boolean replace(Object key2, Object pexpectedOldValue, Object newValue, Object callbackArg) {
        this.checkIfConcurrentMapOpsAllowed();
        if (newValue == null) {
            throw new NullPointerException();
        }
        Object expectedOldValue = pexpectedOldValue;
        long startPut = CachePerfStats.getStatTime();
        this.validateArguments(key2, newValue, callbackArg);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        EntryEventImpl event = new EntryEventImpl(this, Operation.REPLACE, key2, newValue, callbackArg, false, this.getMyId());
        try {
            if (this.generateEventID()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.discoverJTA();
            if (expectedOldValue == null) {
                expectedOldValue = Token.INVALID;
            }
            if (!this.basicPut(event, false, true, expectedOldValue, false)) {
                return false;
            }
            if (!this.getDataView().isDeferredStats()) {
                this.getCachePerfStats().endPut(startPut, false);
            }
            return true;
        }
        catch (EntryNotFoundException e) {
            return false;
        }
    }

    @Override
    public Object replace(Object key2, Object value2) {
        return this.replaceWithCallbackArgument(key2, value2, null);
    }

    public Object replaceWithCallbackArgument(Object key2, Object value2, Object callbackArg) {
        long startPut = CachePerfStats.getStatTime();
        this.checkIfConcurrentMapOpsAllowed();
        if (value2 == null) {
            throw new NullPointerException();
        }
        this.validateArguments(key2, value2, callbackArg);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        EntryEventImpl event = new EntryEventImpl(this, Operation.REPLACE, key2, value2, callbackArg, false, this.getMyId());
        try {
            if (this.generateEventID()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.discoverJTA();
            if (!this.basicPut(event, false, true, null, true)) {
                return null;
            }
            if (!this.getDataView().isDeferredStats()) {
                this.getCachePerfStats().endPut(startPut, false);
            }
            return event.getOldValue();
        }
        catch (EntryNotFoundException enf) {
            return null;
        }
    }

    public Object basicBridgePutIfAbsent(Object key2, Object value2, boolean isObject, Object p_callbackArg, ClientProxyMembershipID client, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryExistsException, CacheWriterException {
        EventID eventId = clientEvent.getEventId();
        Object callbackArg = p_callbackArg;
        long startPut = CachePerfStats.getStatTime();
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.PUT_IF_ABSENT, key2, null, callbackArg, false, client.getDistributedMember(), true, eventId);
        event.setContext(client);
        event.setVersionTag(clientEvent.getVersionTag());
        if (value2 != null) {
            if (isObject) {
                event.setSerializedNewValue((byte[])value2);
            } else {
                event.setNewValue(value2);
            }
        }
        this.validateArguments(key2, event.basicGetNewValue(), p_callbackArg);
        boolean ifNew = true;
        boolean ifOld = false;
        boolean requireOldValue = true;
        boolean basicPut = this.basicPut(event, ifNew, ifOld, null, requireOldValue);
        this.getCachePerfStats().endPut(startPut, false);
        this.stopper.checkCancelInProgress(null);
        Object oldValue = event.getRawOldValue();
        if (oldValue == Token.NOT_AVAILABLE) {
            oldValue = AbstractRegion.handleNotAvailable(oldValue);
        }
        if (basicPut) {
            clientEvent.setVersionTag(event.getVersionTag());
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
        } else if (oldValue == null) {
            return Token.INVALID;
        }
        return oldValue;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public boolean basicBridgeReplace(Object key2, Object expectedOldValue, Object value2, boolean isObject, Object p_callbackArg, ClientProxyMembershipID client, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryExistsException, CacheWriterException {
        EventID eventId = clientEvent.getEventId();
        Object callbackArg = p_callbackArg;
        long startPut = CachePerfStats.getStatTime();
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.REPLACE, key2, null, callbackArg, false, client.getDistributedMember(), true, eventId);
        event.setContext(client);
        if (value2 != null) {
            if (isObject) {
                event.setSerializedNewValue((byte[])value2);
            } else {
                event.setNewValue(value2);
            }
        }
        this.validateArguments(key2, event.basicGetNewValue(), p_callbackArg);
        boolean ifNew = false;
        boolean ifOld = true;
        boolean requireOldValue = false;
        boolean success = this.basicPut(event, ifNew, ifOld, expectedOldValue, requireOldValue);
        clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
        if (success) {
            clientEvent.setVersionTag(event.getVersionTag());
        }
        this.getCachePerfStats().endPut(startPut, false);
        this.stopper.checkCancelInProgress(null);
        return success;
    }

    public Object basicBridgeReplace(Object key2, Object value2, boolean isObject, Object p_callbackArg, ClientProxyMembershipID client, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryExistsException, CacheWriterException {
        EventID eventId = clientEvent.getEventId();
        Object callbackArg = p_callbackArg;
        long startPut = CachePerfStats.getStatTime();
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.REPLACE, key2, null, callbackArg, false, client.getDistributedMember(), true, eventId);
        event.setContext(client);
        if (value2 != null) {
            if (isObject) {
                event.setSerializedNewValue((byte[])value2);
            } else {
                event.setNewValue(value2);
            }
        }
        this.validateArguments(key2, event.basicGetNewValue(), p_callbackArg);
        boolean ifNew = false;
        boolean ifOld = true;
        boolean requireOldValue = true;
        boolean succeeded = this.basicPut(event, ifNew, ifOld, null, requireOldValue);
        this.getCachePerfStats().endPut(startPut, false);
        this.stopper.checkCancelInProgress(null);
        clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
        if (succeeded) {
            clientEvent.setVersionTag(event.getVersionTag());
            Object oldValue = event.getRawOldValue();
            if (oldValue == Token.NOT_AVAILABLE) {
                oldValue = AbstractRegion.handleNotAvailable(oldValue);
            }
            if (oldValue == null) {
                oldValue = Token.INVALID;
            }
            return oldValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeRemove(Object key2, Object expectedOldValue, Object p_callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Object callbackArg = p_callbackArg;
        if (fromClient) {
            if (this.getAttributes().getEnableGateway()) {
                callbackArg = new GatewayEventCallbackArgument(callbackArg);
            }
            if (this.isGatewaySenderEnabled()) {
                callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
            }
        }
        EntryEventImpl event = new EntryEventImpl(this, Operation.REMOVE, key2, null, callbackArg, false, memberId.getDistributedMember(), true, clientEvent.getEventId());
        event.setContext(memberId);
        try {
            this.basicDestroy(event, true, expectedOldValue);
        }
        finally {
            clientEvent.setVersionTag(event.getVersionTag());
            clientEvent.setIsRedestroyedEntry(event.getIsRedestroyedEntry());
        }
    }

    @Override
    public long getVersionForMember(VersionSource member) {
        throw new IllegalStateException("Operation only implemented for disk region");
    }

    public IndexMap getIndexMap(String indexName, String indexedExpression, String fromClause) {
        return new IndexMapImpl();
    }

    public IndexMap getUnsortedIndexMap(String indexName, String indexedExpression, String fromClause) {
        return new IndexMapImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInUseByTransaction(boolean v) {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            if (v) {
                ++this.txRefCount;
            } else {
                --this.txRefCount;
                assert (this.txRefCount >= 0);
                if (this.txRefCount == 0) {
                    if (this.regionTTLExpiryTask == null && this.regionTimeToLive > 0) {
                        this.addTTLExpiryTask();
                    }
                    if (this.regionIdleExpiryTask == null && this.regionIdleTimeout > 0) {
                        this.addIdleExpiryTask();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expireRegion(RegionExpiryTask regionExpiryTask, boolean distributed, boolean destroy) {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            if (regionExpiryTask instanceof RegionTTLExpiryTask) {
                if (regionExpiryTask != this.regionTTLExpiryTask) {
                    return false;
                }
                this.regionTTLExpiryTask = null;
            } else {
                if (regionExpiryTask != this.regionIdleExpiryTask) {
                    return false;
                }
                this.regionIdleExpiryTask = null;
            }
            if (this.txRefCount > 0) {
                return false;
            }
        }
        Operation op = destroy ? (distributed ? Operation.REGION_EXPIRE_DESTROY : Operation.REGION_EXPIRE_LOCAL_DESTROY) : (distributed ? Operation.REGION_EXPIRE_INVALIDATE : Operation.REGION_EXPIRE_LOCAL_INVALIDATE);
        RegionEventImpl event = new RegionEventImpl((Region)this, op, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        if (destroy) {
            this.basicDestroyRegion(event, distributed);
        } else {
            this.basicInvalidateRegion(event);
        }
        return true;
    }

    static class RegionPerfStats
    extends CachePerfStats {
        CachePerfStats cachePerfStats;

        public RegionPerfStats(GemFireCacheImpl cache, CachePerfStats superStats, String regionName) {
            super(cache.getDistributedSystem(), regionName);
            this.cachePerfStats = superStats;
        }

        @Override
        public void incReliableQueuedOps(int inc) {
            this.stats.incInt(reliableQueuedOpsId, inc);
            this.cachePerfStats.incReliableQueuedOps(inc);
        }

        @Override
        public void incReliableQueueSize(int inc) {
            this.stats.incInt(reliableQueueSizeId, inc);
            this.cachePerfStats.incReliableQueueSize(inc);
        }

        @Override
        public void incReliableQueueMax(int inc) {
            this.stats.incInt(reliableQueueMaxId, inc);
            this.cachePerfStats.incReliableQueueMax(inc);
        }

        @Override
        public void incReliableRegions(int inc) {
            this.stats.incInt(reliableRegionsId, inc);
            this.cachePerfStats.incReliableRegions(inc);
        }

        @Override
        public void incReliableRegionsMissing(int inc) {
            this.stats.incInt(reliableRegionsMissingId, inc);
            this.cachePerfStats.incReliableRegionsMissing(inc);
        }

        @Override
        public void incReliableRegionsQueuing(int inc) {
            this.stats.incInt(reliableRegionsQueuingId, inc);
            this.cachePerfStats.incReliableRegionsQueuing(inc);
        }

        @Override
        public void incReliableRegionsMissingFullAccess(int inc) {
            this.stats.incInt(reliableRegionsMissingFullAccessId, inc);
            this.cachePerfStats.incReliableRegionsMissingFullAccess(inc);
        }

        @Override
        public void incReliableRegionsMissingLimitedAccess(int inc) {
            this.stats.incInt(reliableRegionsMissingLimitedAccessId, inc);
            this.cachePerfStats.incReliableRegionsMissingLimitedAccess(inc);
        }

        @Override
        public void incReliableRegionsMissingNoAccess(int inc) {
            this.stats.incInt(reliableRegionsMissingNoAccessId, inc);
            this.cachePerfStats.incReliableRegionsMissingNoAccess(inc);
        }

        @Override
        public void incQueuedEvents(int inc) {
            this.stats.incLong(eventsQueuedId, (long)inc);
            this.cachePerfStats.incQueuedEvents(inc);
        }

        @Override
        public long startLoad() {
            this.stats.incInt(loadsInProgressId, 1);
            return this.cachePerfStats.startLoad();
        }

        @Override
        public void endLoad(long start) {
            long ts = NanoTimer.getTime();
            this.stats.incLong(loadTimeId, ts - start);
            this.stats.incInt(loadsInProgressId, -1);
            this.stats.incInt(loadsCompletedId, 1);
            this.cachePerfStats.endLoad(start);
        }

        @Override
        public long startNetload() {
            this.stats.incInt(netloadsInProgressId, 1);
            this.cachePerfStats.startNetload();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endNetload(long start) {
            if (enableClockStats) {
                this.stats.incLong(netloadTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(netloadsInProgressId, -1);
            this.stats.incInt(netloadsCompletedId, 1);
            this.cachePerfStats.endNetload(start);
        }

        @Override
        public long startNetsearch() {
            this.stats.incInt(netsearchesInProgressId, 1);
            return this.cachePerfStats.startNetsearch();
        }

        @Override
        public void endNetsearch(long start) {
            long ts = NanoTimer.getTime();
            this.stats.incLong(netsearchTimeId, ts - start);
            this.stats.incInt(netsearchesInProgressId, -1);
            this.stats.incInt(netsearchesCompletedId, 1);
            this.cachePerfStats.endNetsearch(start);
        }

        @Override
        public long startCacheWriterCall() {
            this.stats.incInt(cacheWriterCallsInProgressId, 1);
            this.cachePerfStats.startCacheWriterCall();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endCacheWriterCall(long start) {
            if (enableClockStats) {
                this.stats.incLong(cacheWriterCallTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(cacheWriterCallsInProgressId, -1);
            this.stats.incInt(cacheWriterCallsCompletedId, 1);
            this.cachePerfStats.endCacheWriterCall(start);
        }

        @Override
        public long startCacheListenerCall() {
            this.stats.incInt(cacheListenerCallsInProgressId, 1);
            this.cachePerfStats.startCacheListenerCall();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endCacheListenerCall(long start) {
            if (enableClockStats) {
                this.stats.incLong(cacheListenerCallTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(cacheListenerCallsInProgressId, -1);
            this.stats.incInt(cacheListenerCallsCompletedId, 1);
            this.cachePerfStats.endCacheListenerCall(start);
        }

        @Override
        public long startGetInitialImage() {
            this.stats.incInt(getInitialImagesInProgressId, 1);
            this.cachePerfStats.startGetInitialImage();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endGetInitialImage(long start) {
            if (enableClockStats) {
                this.stats.incLong(getInitialImageTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(getInitialImagesInProgressId, -1);
            this.stats.incInt(getInitialImagesCompletedId, 1);
            this.cachePerfStats.endGetInitialImage(start);
        }

        @Override
        public void endNoGIIDone(long start) {
            if (enableClockStats) {
                this.stats.incLong(getInitialImageTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(getInitialImagesInProgressId, -1);
            this.cachePerfStats.endNoGIIDone(start);
        }

        @Override
        public void incGetInitialImageKeysReceived() {
            this.stats.incInt(getInitialImageKeysReceivedId, 1);
            this.cachePerfStats.incGetInitialImageKeysReceived();
        }

        @Override
        public long startIndexUpdate() {
            this.stats.incInt(indexUpdateInProgressId, 1);
            this.cachePerfStats.startIndexUpdate();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endIndexUpdate(long start) {
            long ts = RegionPerfStats.getStatTime();
            this.stats.incLong(indexUpdateTimeId, ts - start);
            this.stats.incInt(indexUpdateInProgressId, -1);
            this.stats.incInt(indexUpdateCompletedId, 1);
            this.cachePerfStats.endIndexUpdate(start);
        }

        @Override
        public void incRegions(int inc) {
            this.stats.incInt(regionsId, inc);
            this.cachePerfStats.incRegions(inc);
        }

        @Override
        public void incPartitionedRegions(int inc) {
            this.stats.incInt(partitionedRegionsId, inc);
            this.cachePerfStats.incPartitionedRegions(inc);
        }

        @Override
        public void incDestroys() {
            this.stats.incInt(destroysId, 1);
            this.cachePerfStats.incDestroys();
        }

        @Override
        public void incCreates() {
            this.stats.incInt(createsId, 1);
            this.cachePerfStats.incCreates();
        }

        @Override
        public void incInvalidates() {
            this.stats.incInt(invalidatesId, 1);
            this.cachePerfStats.incInvalidates();
        }

        @Override
        public void incTombstoneCount(int delta) {
            this.stats.incInt(tombstoneCountId, delta);
            this.cachePerfStats.incTombstoneCount(delta);
        }

        @Override
        public void incTombstoneGCCount() {
            this.stats.incInt(tombstoneGCCountId, 1);
            this.cachePerfStats.incTombstoneGCCount();
        }

        @Override
        public void incClearTimeouts() {
            this.stats.incInt(clearTimeoutsId, 1);
            this.cachePerfStats.incClearTimeouts();
        }

        @Override
        public void incConflatedEventsCount() {
            this.stats.incLong(conflatedEventsId, 1L);
            this.cachePerfStats.incConflatedEventsCount();
        }

        @Override
        public void endGet(long start, boolean miss) {
            if (enableClockStats) {
                this.stats.incLong(getTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(getsId, 1);
            if (miss) {
                this.stats.incInt(missesId, 1);
            }
            this.cachePerfStats.endGet(start, miss);
        }

        @Override
        public long endPut(long start, boolean isUpdate) {
            long total = 0L;
            if (isUpdate) {
                this.stats.incInt(updatesId, 1);
                if (enableClockStats) {
                    total = RegionPerfStats.getStatTime() - start;
                    this.stats.incLong(updateTimeId, total);
                }
            } else {
                this.stats.incInt(putsId, 1);
                if (enableClockStats) {
                    total = RegionPerfStats.getStatTime() - start;
                    this.stats.incLong(putTimeId, total);
                }
            }
            this.cachePerfStats.endPut(start, isUpdate);
            return total;
        }

        @Override
        public void endPutAll(long start) {
            this.stats.incInt(putallsId, 1);
            if (enableClockStats) {
                this.stats.incLong(putallTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.cachePerfStats.endPutAll(start);
        }

        @Override
        public void endQueryExecution(long executionTime) {
            this.stats.incInt(queryExecutionsId, 1);
            if (enableClockStats) {
                this.stats.incLong(queryExecutionTimeId, executionTime);
            }
            this.cachePerfStats.endQueryExecution(executionTime);
        }

        @Override
        public void endQueryResultsHashCollisionProbe(long start) {
            if (enableClockStats) {
                this.stats.incLong(queryResultsHashCollisionProbeTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.cachePerfStats.endQueryResultsHashCollisionProbe(start);
        }

        @Override
        public void incQueryResultsHashCollisions() {
            this.stats.incInt(queryResultsHashCollisionsId, 1);
            this.cachePerfStats.incQueryResultsHashCollisions();
        }

        @Override
        public void incTxConflictCheckTime(long delta) {
            this.stats.incLong(txConflictCheckTimeId, delta);
            this.cachePerfStats.incTxConflictCheckTime(delta);
        }

        @Override
        public void txSuccess(long opTime, long txLifeTime, int txChanges) {
            this.stats.incInt(txCommitsId, 1);
            this.stats.incInt(txCommitChangesId, txChanges);
            this.stats.incLong(txCommitTimeId, opTime);
            this.stats.incLong(txSuccessLifeTimeId, txLifeTime);
            this.cachePerfStats.txSuccess(opTime, txLifeTime, txChanges);
        }

        @Override
        public void txFailure(long opTime, long txLifeTime, int txChanges) {
            this.stats.incInt(txFailuresId, 1);
            this.stats.incInt(txFailureChangesId, txChanges);
            this.stats.incLong(txFailureTimeId, opTime);
            this.stats.incLong(txFailedLifeTimeId, txLifeTime);
            this.cachePerfStats.txFailure(opTime, txLifeTime, txChanges);
        }

        @Override
        public void txRollback(long opTime, long txLifeTime, int txChanges) {
            this.stats.incInt(txRollbacksId, 1);
            this.stats.incInt(txRollbackChangesId, txChanges);
            this.stats.incLong(txRollbackTimeId, opTime);
            this.stats.incLong(txRollbackLifeTimeId, txLifeTime);
            this.cachePerfStats.txRollback(opTime, txLifeTime, txChanges);
        }

        @Override
        public void incEventQueueSize(int items) {
            this.stats.incInt(eventQueueSizeId, items);
            this.cachePerfStats.incEventQueueSize(items);
        }

        @Override
        public void incEventQueueThrottleCount(int items) {
            this.stats.incInt(eventQueueThrottleCountId, items);
            this.cachePerfStats.incEventQueueThrottleCount(items);
        }

        @Override
        protected void incEventQueueThrottleTime(long nanos) {
            this.stats.incLong(eventQueueThrottleTimeId, nanos);
            this.cachePerfStats.incEventQueueThrottleTime(nanos);
        }

        @Override
        protected void incEventThreads(int items) {
            this.stats.incInt(eventThreadsId, items);
            this.cachePerfStats.incEventThreads(items);
        }

        @Override
        public void incEntryCount(int delta) {
            this.stats.incLong(entryCountId, (long)delta);
            this.cachePerfStats.incEntryCount(delta);
        }

        @Override
        public void incRetries() {
            this.stats.incInt(retriesId, 1);
            this.cachePerfStats.incRetries();
        }

        @Override
        public void incDiskTasksWaiting() {
            this.stats.incInt(diskTasksWaitingId, 1);
            this.cachePerfStats.incDiskTasksWaiting();
        }

        @Override
        public void decDiskTasksWaiting() {
            this.stats.incInt(diskTasksWaitingId, -1);
            this.cachePerfStats.decDiskTasksWaiting();
        }

        @Override
        public void decDiskTasksWaiting(int count) {
            this.stats.incInt(diskTasksWaitingId, -count);
            this.cachePerfStats.decDiskTasksWaiting(count);
        }

        @Override
        public void incEvictorJobsStarted() {
            this.stats.incInt(evictorJobsStartedId, 1);
            this.cachePerfStats.incEvictorJobsStarted();
        }

        @Override
        public void incEvictorJobsCompleted() {
            this.stats.incInt(evictorJobsCompletedId, 1);
            this.cachePerfStats.incEvictorJobsCompleted();
        }

        @Override
        public void incEvictorQueueSize(int delta) {
            this.stats.incInt(evictorQueueSizeId, delta);
            this.cachePerfStats.incEvictorQueueSize(delta);
        }

        @Override
        public void incEvictWorkTime(long delta) {
            this.stats.incLong(evictWorkTimeId, delta);
            this.cachePerfStats.incEvictWorkTime(delta);
        }

        @Override
        public void incClearCount() {
            this.stats.incInt(clearsId, 1);
            this.cachePerfStats.incClearCount();
        }

        @Override
        public void incPRQueryRetries() {
            this.stats.incLong(partitionedRegionQueryRetriesId, 1L);
            this.cachePerfStats.incPRQueryRetries();
        }

        @Override
        public void incNonSingleHopsCount() {
            this.stats.incLong(nonSingleHopsCountId, 1L);
            this.cachePerfStats.incNonSingleHopsCount();
        }

        @Override
        public void incMetaDataRefreshCount() {
            this.stats.incLong(metaDataRefreshCountId, 1L);
            this.cachePerfStats.incMetaDataRefreshCount();
        }

        @Override
        public void endImport(long entryCount, long start) {
            this.stats.incLong(importedEntriesCountId, entryCount);
            if (enableClockStats) {
                this.stats.incLong(importTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.cachePerfStats.endImport(entryCount, start);
        }

        @Override
        public void endExport(long entryCount, long start) {
            this.stats.incLong(exportedEntriesCountId, entryCount);
            if (enableClockStats) {
                this.stats.incLong(exportTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.cachePerfStats.endExport(entryCount, start);
        }

        @Override
        public long startCompression() {
            this.stats.incLong(compressionCompressionsId, 1L);
            this.cachePerfStats.stats.incLong(compressionCompressionsId, 1L);
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endCompression(long startTime, long startSize, long endSize) {
            if (enableClockStats) {
                long time = RegionPerfStats.getStatTime() - startTime;
                this.stats.incLong(compressionCompressTimeId, time);
                this.cachePerfStats.stats.incLong(compressionCompressTimeId, time);
            }
            this.stats.incLong(compressionPreCompressedBytesId, startSize);
            this.stats.incLong(compressionPostCompressedBytesId, endSize);
            this.cachePerfStats.stats.incLong(compressionPreCompressedBytesId, startSize);
            this.cachePerfStats.stats.incLong(compressionPostCompressedBytesId, endSize);
        }

        @Override
        public long startDecompression() {
            this.stats.incLong(compressionDecompressionsId, 1L);
            this.cachePerfStats.stats.incLong(compressionDecompressionsId, 1L);
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endDecompression(long startTime) {
            if (enableClockStats) {
                long time = RegionPerfStats.getStatTime() - startTime;
                this.stats.incLong(compressionDecompressTimeId, time);
                this.cachePerfStats.stats.incLong(compressionDecompressTimeId, time);
            }
        }
    }

    public class NonTXEntry
    implements Region.Entry {
        private final Object key;
        private boolean entryIsDestroyed = false;

        @Override
        public boolean isLocal() {
            return true;
        }

        public NonTXEntry(RegionEntry regionEntry) {
            if (regionEntry == null) {
                throw new IllegalArgumentException(LocalizedStrings.LocalRegion_REGIONENTRY_SHOULD_NOT_BE_NULL.toLocalizedString());
            }
            this.key = regionEntry.getKey();
        }

        public RegionEntry getRegionEntry() {
            RegionEntry re = LocalRegion.this.getRegionMap().getEntry(this.key);
            if (re == null) {
                throw new EntryDestroyedException(this.key.toString());
            }
            return re;
        }

        private RegionEntry basicGetEntry() {
            RegionEntry re = LocalRegion.this.basicGetEntry(this.key);
            if (re == null) {
                throw new EntryDestroyedException(this.key.toString());
            }
            return re;
        }

        @Override
        public boolean isDestroyed() {
            if (this.entryIsDestroyed) {
                return true;
            }
            if (LocalRegion.this.isDestroyed) {
                this.entryIsDestroyed = true;
            } else if (LocalRegion.this.basicGetEntry(this.key) == null) {
                this.entryIsDestroyed = true;
            }
            return this.entryIsDestroyed;
        }

        @Override
        public Object getKey() {
            return this.basicGetEntry().getKey();
        }

        @Override
        public Object getValue() {
            return this.getValue(false);
        }

        public Object getValue(boolean ignoreCopyOnRead) {
            Object value2 = LocalRegion.this.getDeserialized(this.basicGetEntry(), false, ignoreCopyOnRead, false);
            if (value2 == null) {
                throw new EntryDestroyedException(this.getKey().toString());
            }
            if (Token.isInvalid(value2)) {
                return null;
            }
            return value2;
        }

        public Object getRawValue() {
            Object value2 = this.basicGetEntry().getValue((LocalRegion)this.getRegion());
            if (value2 == null) {
                throw new EntryDestroyedException(this.getRegionEntry().getKey().toString());
            }
            if (Token.isInvalid(value2)) {
                return null;
            }
            return value2;
        }

        public Region getRegion() {
            this.basicGetEntry();
            return LocalRegion.this;
        }

        @Override
        public CacheStatistics getStatistics() {
            this.basicGetEntry();
            if (!LocalRegion.this.statisticsEnabled) {
                throw new StatisticsDisabledException(LocalizedStrings.LocalRegion_STATISTICS_DISABLED_FOR_REGION_0.toLocalizedString(LocalRegion.this.getFullPath()));
            }
            return new CacheStatisticsImpl(this.basicGetEntry(), LocalRegion.this);
        }

        @Override
        public Object getUserAttribute() {
            this.basicGetEntry();
            Map userAttr = LocalRegion.this.entryUserAttributes;
            if (userAttr == null) {
                return null;
            }
            return userAttr.get(this.basicGetEntry().getKey());
        }

        @Override
        public Object setUserAttribute(Object value2) {
            if (LocalRegion.this.entryUserAttributes == null) {
                LocalRegion.this.entryUserAttributes = new Hashtable();
            }
            return LocalRegion.this.entryUserAttributes.put(this.basicGetEntry().getKey(), value2);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof NonTXEntry)) {
                return false;
            }
            NonTXEntry lre = (NonTXEntry)obj;
            return this.basicGetEntry().equals(lre.getRegionEntry()) && this.getRegion() == lre.getRegion();
        }

        @Override
        public int hashCode() {
            return this.basicGetEntry().hashCode() ^ this.getRegion().hashCode();
        }

        public String toString() {
            return "NonTXEntry@" + Integer.toHexString(System.identityHashCode(this)) + ' ' + this.getRegionEntry();
        }

        @Override
        public Object setValue(Object arg0) {
            return LocalRegion.this.put(this.getKey(), arg0);
        }
    }

    private class SubregionsSet
    extends AbstractSet {
        final boolean recursive;

        SubregionsSet(boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator currItr;
                List itrQ;
                Object nextElem;
                {
                    this.currItr = LocalRegion.this.subregions.values().iterator();
                    this.nextElem = null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_THIS_ITERATOR_DOES_NOT_SUPPORT_MODIFICATION.toLocalizedString());
                }

                @Override
                public boolean hasNext() {
                    if (this.nextElem != null) {
                        return true;
                    }
                    Object el = this.next(true);
                    if (el != null) {
                        this.nextElem = el;
                        return true;
                    }
                    return false;
                }

                private boolean _hasNext() {
                    return this.currItr != null && this.currItr.hasNext();
                }

                public Object next() {
                    return this.next(false);
                }

                private Object next(boolean nullOK) {
                    Iterator nextIterator;
                    LocalRegion rgn;
                    if (this.nextElem != null) {
                        Object next2 = this.nextElem;
                        this.nextElem = null;
                        return next2;
                    }
                    do {
                        rgn = null;
                        if (!this._hasNext()) {
                            if (this.itrQ == null || this.itrQ.isEmpty()) {
                                if (nullOK) {
                                    return null;
                                }
                                throw new NoSuchElementException();
                            }
                            this.currItr = (Iterator)this.itrQ.remove(0);
                            continue;
                        }
                        rgn = (LocalRegion)this.currItr.next();
                    } while (rgn == null || !rgn.isInitialized() || rgn.isDestroyed());
                    if (SubregionsSet.this.recursive && (nextIterator = rgn.subregions.values().iterator()).hasNext()) {
                        if (this.itrQ == null) {
                            this.itrQ = new ArrayList();
                        }
                        this.itrQ.add(nextIterator);
                    }
                    if (!this._hasNext()) {
                        this.currItr = this.itrQ == null || this.itrQ.isEmpty() ? null : (Iterator)this.itrQ.remove(0);
                    }
                    return rgn;
                }
            };
        }

        @Override
        public int size() {
            if (this.recursive) {
                return LocalRegion.this.allSubregionsSize() - 1;
            }
            return LocalRegion.this.subregions.size();
        }

        @Override
        public Object[] toArray() {
            ArrayList temp = new ArrayList(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                temp.add(iter.next());
            }
            return temp.toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            ArrayList temp = new ArrayList(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                temp.add(iter.next());
            }
            return temp.toArray(array);
        }
    }

    class EventDispatcher
    implements Runnable {
        InternalCacheEvent event;
        EnumListenerEvent op;

        EventDispatcher(InternalCacheEvent event, EnumListenerEvent op) {
            this.event = event;
            this.op = op;
        }

        @Override
        public void run() {
            LocalRegion.dispatchEvent(LocalRegion.this, this.event, this.op);
        }
    }

    private static class ExpiryRegionEntry
    implements Region.Entry {
        private final LocalRegion region;
        private final RegionEntry re;

        public ExpiryRegionEntry(LocalRegion lr, RegionEntry re) {
            this.region = lr;
            this.re = re;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.re == null ? 0 : this.re.hashCode());
            result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpiryRegionEntry other = (ExpiryRegionEntry)obj;
            if (this.re == null ? other.re != null : !this.re.equals(other.re)) {
                return false;
            }
            return !(this.region == null ? other.region != null : !this.region.equals(other.region));
        }

        public String toString() {
            return "region=" + this.region.getFullPath() + ", key=" + this.getKey() + " value=" + this.getValue();
        }

        public Region getRegion() {
            return this.region;
        }

        private RegionEntry getCheckedRegionEntry() throws EntryNotFoundException {
            RegionEntry result = this.re;
            if (this.re.isDestroyedOrRemoved()) {
                throw new EntryNotFoundException("Entry for key " + this.re.getKey() + " no longer exists");
            }
            return result;
        }

        @Override
        public Object getValue() {
            Object value2 = this.region.getDeserialized(this.getCheckedRegionEntry(), false, false, false);
            if (value2 == null) {
                throw new EntryDestroyedException(this.getKey().toString());
            }
            if (Token.isInvalid(value2)) {
                return null;
            }
            return value2;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public CacheStatistics getStatistics() {
            LocalRegion lr = this.region;
            if (!lr.statisticsEnabled) {
                throw new StatisticsDisabledException(LocalizedStrings.LocalRegion_STATISTICS_DISABLED_FOR_REGION_0.toLocalizedString(lr.getFullPath()));
            }
            return new CacheStatisticsImpl(this.getCheckedRegionEntry(), lr);
        }

        @Override
        public Object getUserAttribute() {
            Map userAttr = this.region.entryUserAttributes;
            if (userAttr == null) {
                return null;
            }
            return userAttr.get(this.getKey());
        }

        @Override
        public Object setUserAttribute(Object userAttribute) {
            LocalRegion lr = this.region;
            if (lr.entryUserAttributes == null) {
                lr.entryUserAttributes = new Hashtable();
            }
            return lr.entryUserAttributes.put(this.getKey(), userAttribute);
        }

        @Override
        public boolean isDestroyed() {
            return this.re.isDestroyedOrRemoved();
        }

        @Override
        public Object setValue(Object value2) {
            return this.region.put(this.getKey(), value2);
        }

        @Override
        public Object getKey() {
            return this.re.getKey();
        }
    }

    public static interface RegionEntryCallback {
        public void handleRegionEntry(RegionEntry var1);
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            this.checkFailure();
            GemFireCacheImpl c = LocalRegion.this.getCache();
            if (c == null) {
                return LocalizedStrings.LocalRegion_THE_CACHE_IS_NOT_AVAILABLE.toLocalizedString();
            }
            return c.getCancelCriterion().cancelInProgress();
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            this.checkFailure();
            GemFireCacheImpl c = LocalRegion.this.getCache();
            if (c == null) {
                return new CacheClosedException("No cache", e);
            }
            return c.getCancelCriterion().generateCancelledException(e);
        }
    }

    public static enum IteratorType {
        KEYS,
        VALUES,
        ENTRIES;

    }

    public static interface TestCallable {
        public void call(LocalRegion var1, Operation var2, RegionEntry var3);
    }
}

