/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.InternalDataView;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import java.util.Collection;
import java.util.Set;

public class LocalRegionDataView
implements InternalDataView {
    @Override
    public Object getDeserializedValue(KeyInfo keyInfo, LocalRegion localRegion, boolean updateStats, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones) {
        return localRegion.getDeserializedValue(keyInfo, updateStats, disableCopyOnRead, preferCD, clientEvent, returnTombstones);
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        LocalRegion lr = event.getLocalRegion();
        lr.mapDestroy(event, cacheWrite, false, expectedOldValue);
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        try {
            event.getLocalRegion().entries.invalidate(event, invokeCallbacks, forceNewEntry, false);
        }
        catch (ConcurrentCacheModificationException e) {
            // empty catch block
        }
    }

    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        try {
            event.getLocalRegion().entries.updateEntryVersion(event);
        }
        catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
            // empty catch block
        }
    }

    @Override
    public int entryCount(LocalRegion localRegion) {
        return localRegion.getRegionSize();
    }

    @Override
    public Object getValueInVM(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead) {
        return localRegion.nonTXbasicGetValueInVM(keyInfo);
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo, LocalRegion localRegion) {
        return localRegion.nonTXContainsKey(keyInfo);
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo, LocalRegion localRegion) {
        return localRegion.nonTXContainsValueForKey(keyInfo);
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, LocalRegion localRegion, boolean allowTombstones) {
        return localRegion.nonTXGetEntry(keyInfo, false, allowTombstones);
    }

    @Override
    public Region.Entry accessEntry(KeyInfo keyInfo, LocalRegion localRegion) {
        return localRegion.nonTXGetEntry(keyInfo, true, false);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        return event.getLocalRegion().virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
    }

    @Override
    public boolean isDeferredStats() {
        return false;
    }

    @Override
    public Object findObject(KeyInfo keyInfo, LocalRegion r, boolean isCreate, boolean generateCallbacks, Object value2, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) {
        return r.nonTxnFindObject(keyInfo, isCreate, generateCallbacks, value2, disableCopyOnRead, preferCD, clientEvent, returnTombstones);
    }

    @Override
    public Region.Entry<?, ?> getEntryForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        AbstractRegionEntry re = (AbstractRegionEntry)keyInfo.getKey();
        if (re != null && !re.isDestroyedOrRemoved() || allowTombstones && re.isTombstone()) {
            LocalRegion localRegion = currRgn;
            localRegion.getClass();
            return localRegion.new LocalRegion.NonTXEntry(re);
        }
        return null;
    }

    @Override
    public Object getKeyForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        AbstractRegionEntry re = (AbstractRegionEntry)keyInfo.getKey();
        if (re != null && (!re.isDestroyedOrRemoved() || allowTombstones && re.isTombstone())) {
            return re.getKey();
        }
        return null;
    }

    @Override
    public Set getAdditionalKeysForIterator(LocalRegion currRgn) {
        return null;
    }

    @Override
    public Object getSerializedValue(LocalRegion localRegion, KeyInfo key2, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        this.destroyExistingEntry(event, cacheWrite, expectedOldValue);
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        this.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
    }

    @Override
    public Set getBucketKeys(LocalRegion localRegion, int bucketId, boolean allowTombstones) {
        throw new IllegalStateException();
    }

    @Override
    public Region.Entry getEntryOnRemote(KeyInfo key2, LocalRegion localRegion, boolean allowTombstones) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public void checkSupportsRegionDestroy() throws UnsupportedOperationInTransactionException {
    }

    @Override
    public void checkSupportsRegionInvalidate() throws UnsupportedOperationInTransactionException {
    }

    @Override
    public void checkSupportsRegionClear() throws UnsupportedOperationInTransactionException {
    }

    @Override
    public Collection<?> getRegionKeysForIteration(LocalRegion currRegion) {
        return currRegion.getRegionMap().regionEntries();
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, LocalRegion region) {
        if (!region.dataPolicy.withStorage() && region.concurrencyChecksEnabled && putallOp.getBaseEvent().isBridgeEvent()) {
            successfulPuts.clear();
            putallOp.fillVersionedObjectList(successfulPuts);
        }
        region.postPutAllSend(putallOp, successfulPuts);
        region.postPutAllFireEvents(putallOp, successfulPuts);
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, LocalRegion region) {
        if (!region.dataPolicy.withStorage() && region.concurrencyChecksEnabled && op.getBaseEvent().isBridgeEvent()) {
            successfulOps.clear();
            op.fillVersionedObjectList(successfulOps);
        }
        region.postRemoveAllSend(op, successfulOps);
        region.postRemoveAllFireEvents(op, successfulOps);
    }
}

