/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.FunctionStreamingOrderedReplyMessage;
import com.gemstone.gemfire.internal.cache.FunctionStreamingReplyMessage;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TransactionMessage;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.MemberFunctionResultSender;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionContextImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class MemberFunctionStreamingMessage
extends DistributionMessage
implements TransactionMessage,
MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    transient int replyMsgNum = 0;
    transient boolean replyLastMsg;
    private Function functionObject;
    private String functionName;
    Object args;
    private int processorId;
    private int txUniqId = -1;
    private InternalDistributedMember txMemberId = null;
    private boolean isFnSerializationReqd;
    private Set<String> regionPathSet;
    private boolean isReExecute;
    private static final short IS_REEXECUTE = 64;

    public MemberFunctionStreamingMessage() {
    }

    public MemberFunctionStreamingMessage(Function function, int procId, Object ar, boolean isFnSerializationReqd, boolean isReExecute) {
        this.functionObject = function;
        this.processorId = procId;
        this.args = ar;
        this.isFnSerializationReqd = isFnSerializationReqd;
        this.isReExecute = isReExecute;
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
    }

    public MemberFunctionStreamingMessage(Function function, int procId, Object ar, boolean isFnSerializationReqd, Set<String> regions, boolean isReExecute) {
        this.functionObject = function;
        this.processorId = procId;
        this.args = ar;
        this.isFnSerializationReqd = isFnSerializationReqd;
        this.regionPathSet = regions;
        this.isReExecute = isReExecute;
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
    }

    public MemberFunctionStreamingMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    private TXStateProxy prepForTransaction() throws InterruptedException {
        if (this.txUniqId == -1) {
            return null;
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return null;
        }
        TXManagerImpl mgr = cache.getTXMgr();
        return mgr.masqueradeAs(this);
    }

    private void cleanupTransasction(TXStateProxy tx) {
        if (this.txUniqId != -1) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                return;
            }
            TXManagerImpl mgr = cache.getTXMgr();
            mgr.unmasquerade(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        Throwable thr = null;
        ReplyException rex = null;
        if (this.functionObject == null) {
            rex = new ReplyException(new FunctionException(LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(this.functionName)));
            this.replyWithException(dm, rex);
            return;
        }
        FunctionStats stats = FunctionStats.getFunctionStats(this.functionObject.getId(), dm.getSystem());
        TXStateProxy tx = null;
        try {
            tx = this.prepForTransaction();
            MemberFunctionResultSender resultSender = new MemberFunctionResultSender(dm, this, this.functionObject);
            HashSet<Region> regions = new HashSet<Region>();
            if (this.regionPathSet != null) {
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                for (String regionPath : this.regionPathSet) {
                    if (this.checkCacheClosing(dm) || this.checkDSClosing(dm)) {
                        thr = new CacheClosedException(LocalizedStrings.PartitionMessage_REMOTE_CACHE_IS_CLOSED_0.toLocalizedString(dm.getId()));
                        return;
                    }
                    regions.add(cache.getRegion(regionPath));
                }
            }
            MultiRegionFunctionContextImpl context = new MultiRegionFunctionContextImpl(this.functionObject.getId(), this.args, resultSender, regions, this.isReExecute);
            long start = stats.startTime();
            stats.startFunctionExecution(this.functionObject.hasResult());
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on remote member with context: {}", this.functionObject.getId(), context.toString());
            }
            this.functionObject.execute(context);
            if (!this.replyLastMsg && this.functionObject.hasResult()) {
                throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(this.functionObject.getId()));
            }
            stats.endFunctionExecution(start, this.functionObject.hasResult());
        }
        catch (FunctionException functionException) {
            if (logger.isDebugEnabled()) {
                logger.debug("FunctionException occured on remote member while executing Function: {}", this.functionObject.getId(), functionException);
            }
            stats.endFunctionExecutionWithException(this.functionObject.hasResult());
            rex = new ReplyException(functionException);
            this.replyWithException(dm, rex);
        }
        catch (CancelException exception) {
            thr = null;
            if (logger.isDebugEnabled()) {
                logger.debug("shutdown caught, abandoning message: {}", exception.getMessage(), exception);
            }
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception occured on remote member while executing Function: {}", this.functionObject.getId(), exception);
            }
            stats.endFunctionExecutionWithException(this.functionObject.hasResult());
            rex = new ReplyException(exception);
            this.replyWithException(dm, rex);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            thr = t;
        }
        finally {
            this.cleanupTransasction(tx);
            if (thr != null) {
                rex = new ReplyException(thr);
                this.replyWithException(dm, rex);
            }
        }
    }

    private void replyWithException(DistributionManager dm, ReplyException rex) {
        ReplyMessage.send(this.getSender(), this.processorId, rex, (ReplySender)dm);
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public int getDSFID() {
        return 1202;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        Object object;
        super.fromData(in);
        short flags = in.readShort();
        if ((flags & 1) != 0) {
            this.processorId = in.readInt();
            ReplyProcessor21.setMessageRPId(this.processorId);
        }
        if ((flags & 4) != 0) {
            this.txUniqId = in.readInt();
        }
        if ((flags & 2) != 0) {
            this.txMemberId = (InternalDistributedMember)DataSerializer.readObject(in);
        }
        if ((object = DataSerializer.readObject(in)) instanceof String) {
            this.isFnSerializationReqd = false;
            this.functionObject = FunctionService.getFunction((String)object);
            if (this.functionObject == null) {
                this.functionName = (String)object;
            }
        } else {
            this.functionObject = (Function)object;
            this.isFnSerializationReqd = true;
        }
        this.args = DataSerializer.readObject(in);
        this.regionPathSet = (Set)DataSerializer.readObject(in);
        this.isReExecute = (flags & 0x40) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        short flags = 0;
        if (this.processorId != 0) {
            flags = (short)(flags | 1);
        }
        if (this.txUniqId != -1) {
            flags = (short)(flags | 4);
        }
        if (this.txMemberId != null) {
            flags = (short)(flags | 2);
        }
        if (this.isReExecute) {
            flags = (short)(flags | 0x40);
        }
        out.writeShort(flags);
        if (this.processorId != 0) {
            out.writeInt(this.processorId);
        }
        if (this.txUniqId != -1) {
            out.writeInt(this.txUniqId);
        }
        if (this.txMemberId != null) {
            DataSerializer.writeObject(this.txMemberId, out);
        }
        if (this.isFnSerializationReqd) {
            DataSerializer.writeObject(this.functionObject, out);
        } else {
            DataSerializer.writeObject(this.functionObject.getId(), out);
        }
        DataSerializer.writeObject(this.args, out);
        DataSerializer.writeObject(this.regionPathSet, out);
    }

    public synchronized boolean sendReplyForOneResult(DM dm, Object oneResult, boolean lastResult, boolean sendResultsInOrder) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        if (this.replyLastMsg) {
            return false;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int msgNum = this.replyMsgNum;
        this.replyLastMsg = lastResult;
        this.sendReply(this.getSender(), this.processorId, dm, oneResult, msgNum, lastResult, sendResultsInOrder);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending reply message count: {} to co-ordinating node", this.replyMsgNum);
        }
        ++this.replyMsgNum;
        return false;
    }

    protected void sendReply(InternalDistributedMember member, int procId, DM dm, Object oneResult, int msgNum, boolean lastResult, boolean sendResultsInOrder) {
        if (sendResultsInOrder) {
            FunctionStreamingOrderedReplyMessage.send(member, procId, null, dm, oneResult, msgNum, lastResult);
        } else {
            FunctionStreamingReplyMessage.send(member, procId, null, dm, oneResult, msgNum, lastResult);
        }
    }

    @Override
    public int getProcessorType() {
        return 80;
    }

    public final boolean checkCacheClosing(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return cache == null || cache.getCancelCriterion().cancelInProgress() != null;
    }

    public final boolean checkDSClosing(DistributionManager dm) {
        InternalDistributedSystem ds = dm.getSystem();
        return ds == null || ds.isDisconnecting();
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    public int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public final InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return null;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }
}

