/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.SystemUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public final class MinimumSystemRequirements {
    public static final String JAVA_VERSION = "1.7.0_72";
    private static final Logger logger = LogService.getLogger();

    private MinimumSystemRequirements() {
    }

    public static void assertLogAndExit() {
        if (!MinimumSystemRequirements.checkAndLog()) {
            System.exit(1);
        }
    }

    public static boolean checkAndLog() {
        boolean minimumSystemRequirementsMet = true;
        if (!(minimumSystemRequirementsMet &= MinimumSystemRequirements.checkJavaVersion())) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.MinimumSystemRequirements_NOT_MET));
        }
        return minimumSystemRequirementsMet;
    }

    private static boolean checkJavaVersion() {
        if (SystemUtils.isJavaVersionAtLeast(JAVA_VERSION)) {
            return true;
        }
        logger.fatal(LocalizedMessage.create(LocalizedStrings.MinimumSystemRequirements_JAVA_VERSION, JAVA_VERSION));
        return false;
    }
}

