/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionStatus;

public class PartitionedRegionStatus
extends RegionStatus {
    private static final long serialVersionUID = -6755318987122602065L;
    protected int numberOfLocalEntries;

    public PartitionedRegionStatus(PartitionedRegion region) {
        this.initialize(region);
    }

    public int getNumberOfLocalEntries() {
        return this.numberOfLocalEntries;
    }

    protected void setNumberOfLocalEntries(int numberOfLocalEntries) {
        this.numberOfLocalEntries = numberOfLocalEntries;
    }

    @Override
    public long getHeapSize() {
        return this.heapSize;
    }

    private void setHeapSize(long heapSize) {
        this.heapSize = heapSize;
    }

    private void initialize(PartitionedRegion region) {
        this.setNumberOfEntries(region.size());
        PartitionedRegionDataStore ds = region.getDataStore();
        int numLocalEntries = 0;
        long heapSize = 0L;
        if (ds != null) {
            CachePerfStats cpStats = ds.getCachePerfStats();
            numLocalEntries = (int)cpStats.getEntries();
            heapSize = ds.currentAllocatedMemory();
        }
        this.setNumberOfLocalEntries(numLocalEntries);
        this.setHeapSize(heapSize);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PartitionedRegionStatus[").append("numberOfEntries=").append(this.numberOfEntries).append("; numberOfLocalEntries=").append(this.numberOfLocalEntries).append("; heapSize=").append(this.heapSize).append("]");
        return buffer.toString();
    }
}

