/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BytesAndBitsForCompactor;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class PreferBytesCachedDeserializable
implements CachedDeserializable,
DataSerializableFixedID {
    private byte[] value;
    static final int MEM_OVERHEAD = 12;

    public PreferBytesCachedDeserializable() {
    }

    PreferBytesCachedDeserializable(byte[] serializedValue) {
        this.value = serializedValue;
        if (serializedValue == null) {
            throw new NullPointerException(LocalizedStrings.PreferBytesCachedDeserializable_VALUE_MUST_NOT_BE_NULL.toLocalizedString());
        }
    }

    public PreferBytesCachedDeserializable(Object object) {
        this.value = EntryEventImpl.serialize(object);
    }

    @Override
    public Object getDeserializedValue(Region r, RegionEntry re) {
        return EntryEventImpl.deserialize(this.value);
    }

    @Override
    public Object getDeserializedForReading() {
        return this.getDeserializedValue(null, null);
    }

    @Override
    public Object getDeserializedWritableCopy(Region r, RegionEntry re) {
        return this.getDeserializedValue(r, re);
    }

    @Override
    public byte[] getSerializedValue() {
        return this.value;
    }

    @Override
    public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
        wrapper.setData(this.value, userBits, this.value.length, false);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getSizeInBytes() {
        return 12 + CachedDeserializableFactory.getByteSize(this.value);
    }

    @Override
    public int getValueSizeInBytes() {
        return CachedDeserializableFactory.getByteSize(this.value);
    }

    @Override
    public int getDSFID() {
        return -65;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.value = DataSerializer.readByteArray(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeByteArray(this.value, out);
    }

    String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    public String toString() {
        return this.getShortClassName() + "@" + this.hashCode();
    }

    @Override
    public void writeValueAsByteArray(DataOutput out) throws IOException {
        this.toData(out);
    }

    @Override
    public String getStringForm() {
        try {
            return StringUtils.forceToString(this.getDeserializedForReading());
        }
        catch (RuntimeException ex) {
            return "Could not convert object to string because " + ex;
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

