/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.query.internal.IndexUpdater;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.InternalStatisticsDisabledException;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXRmtEvent;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.lru.LRUEntry;
import com.gemstone.gemfire.internal.cache.lru.NewLRUClockHand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionHolder;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

final class ProxyRegionMap
implements RegionMap {
    private final IndexUpdater indexUpdater;
    private final LocalRegion owner;
    private final RegionMap.Attributes attr;
    private static final RegionEntry markerEntry = new ProxyRegionEntry();

    protected ProxyRegionMap(LocalRegion owner, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs) {
        this.owner = owner;
        this.attr = attr;
        this.indexUpdater = internalRegionArgs != null ? internalRegionArgs.getIndexUpdater() : null;
    }

    @Override
    public final IndexUpdater getIndexUpdater() {
        return this.indexUpdater;
    }

    @Override
    public RegionEntryFactory getEntryFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegionMap.Attributes getAttributes() {
        return this.attr;
    }

    @Override
    public void setOwner(Object r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeOwner(LocalRegion r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Set keySet() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection<RegionEntry> regionEntries() {
        return Collections.emptySet();
    }

    @Override
    public boolean containsKey(Object key2) {
        return false;
    }

    @Override
    public RegionEntry getEntry(Object key2) {
        return null;
    }

    @Override
    public Set<VersionSource> clear(RegionVersionVector rvv) {
        RegionVersionVector v = this.owner.getVersionVector();
        if (v != null) {
            return v.getDepartedMembersSet();
        }
        return Collections.emptySet();
    }

    public void diskClear() {
    }

    @Override
    public RegionEntry initRecoveredEntry(Object key2, DiskEntry.RecoveredEntry value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegionEntry updateRecoveredEntry(Object key2, DiskEntry.RecoveredEntry value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean initialImagePut(Object key2, long lastModified, Object newValue, boolean wasRecovered, boolean deferLRUCallback, VersionTag version, InternalDistributedMember sender, boolean forceValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean destroy(EntryEventImpl event, boolean inTokenMode, boolean duringRI, boolean cacheWrite, boolean isEviction, Object expectedOldValue, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        if (event.getOperation().isLocal()) {
            throw new EntryNotFoundException(event.getKey().toString());
        }
        if (cacheWrite) {
            this.owner.cacheWriteBeforeDestroy(event, expectedOldValue);
        }
        this.owner.recordEvent(event);
        this.owner.basicDestroyPart2(markerEntry, event, inTokenMode, false, duringRI, true);
        this.owner.basicDestroyPart3(markerEntry, event, inTokenMode, duringRI, true, expectedOldValue);
        return true;
    }

    @Override
    public boolean invalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry, boolean forceCallback) throws EntryNotFoundException {
        if (event.getOperation().isLocal()) {
            throw new EntryNotFoundException(event.getKey().toString());
        }
        this.owner.cacheWriteBeforeInvalidate(event, invokeCallbacks, forceNewEntry);
        this.owner.recordEvent(event);
        this.owner.basicInvalidatePart2(markerEntry, event, false, true);
        this.owner.basicInvalidatePart3(markerEntry, event, true);
        return true;
    }

    public void evictEntry(Object key2) {
    }

    @Override
    public void evictValue(Object key2) {
    }

    @Override
    public RegionEntry basicPut(EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, boolean overwriteDestroyed) throws CacheWriterException, TimeoutException {
        boolean cacheWrite;
        if (!event.isOriginRemote() && event.getOperation() != Operation.REPLACE) {
            event.makeCreate();
        }
        CacheWriter cacheWriter = this.owner.basicGetWriter();
        boolean bl = cacheWrite = !event.isOriginRemote() && !event.isNetSearch() && !event.getInhibitDistribution() && event.isGenerateCallbacks() && (cacheWriter != null || this.owner.hasServerProxy() || this.owner.scope.isDistributed());
        if (cacheWrite) {
            Set netWriteRecipients;
            if (cacheWriter == null && this.owner.scope.isDistributed()) {
                CacheDistributionAdvisor cda = ((DistributedRegion)this.owner).getDistributionAdvisor();
                netWriteRecipients = cda.adviseNetWrite();
            } else {
                netWriteRecipients = null;
            }
            if (event.getOperation() != Operation.REPLACE) {
                event.makeCreate();
            }
            this.owner.cacheWriteBeforePut(event, netWriteRecipients, cacheWriter, requireOldValue, expectedOldValue);
        }
        this.owner.recordEvent(event);
        lastModified = this.owner.basicPutPart2(event, markerEntry, true, lastModified, false);
        IndexUpdater indexUpdater = this.getIndexUpdater();
        if (indexUpdater != null) {
            indexUpdater.onEvent(this.owner, event, markerEntry);
        }
        this.owner.basicPutPart3(event, markerEntry, true, lastModified, true, ifNew, ifOld, expectedOldValue, requireOldValue);
        return markerEntry;
    }

    @Override
    public void writeSyncIfPresent(Object key2, Runnable runner) {
    }

    @Override
    public void removeIfDestroyed(Object key2) {
    }

    @Override
    public void txApplyDestroy(Object key2, TransactionId txId, TXRmtEvent txEvent, boolean inTokenMode, boolean inRI, Operation op, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, boolean isOriginRemote, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        this.owner.txApplyDestroyPart2(markerEntry, key2, inTokenMode, false);
        if (!inTokenMode) {
            if (txEvent != null) {
                txEvent.addDestroy(this.owner, markerEntry, key2, aCallbackArgument);
            }
            if (AbstractRegionMap.shouldCreateCBEvent(this.owner, false, !inTokenMode)) {
                EntryEventImpl e = AbstractRegionMap.createCBEvent(this.owner, op, key2, null, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                AbstractRegionMap.switchEventOwnerAndOriginRemote(e, txEntryState == null);
                if (pendingCallbacks == null) {
                    this.owner.invokeTXCallbacks(EnumListenerEvent.AFTER_DESTROY, e, true);
                } else {
                    pendingCallbacks.add(e);
                }
            }
        }
    }

    @Override
    public void txApplyInvalidate(Object key2, Object newValue, boolean didDestroy, TransactionId txId, TXRmtEvent txEvent, boolean localOp, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        this.owner.txApplyInvalidatePart2(markerEntry, key2, didDestroy, true, false);
        if (this.owner.isInitialized()) {
            if (txEvent != null) {
                txEvent.addInvalidate(this.owner, markerEntry, key2, newValue, aCallbackArgument);
            }
            if (AbstractRegionMap.shouldCreateCBEvent(this.owner, true, this.owner.isInitialized())) {
                EntryEventImpl e = AbstractRegionMap.createCBEvent(this.owner, localOp ? Operation.LOCAL_INVALIDATE : Operation.INVALIDATE, key2, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                AbstractRegionMap.switchEventOwnerAndOriginRemote(e, txEntryState == null);
                if (pendingCallbacks == null) {
                    this.owner.invokeTXCallbacks(EnumListenerEvent.AFTER_INVALIDATE, e, true);
                } else {
                    pendingCallbacks.add(e);
                }
            }
        }
    }

    @Override
    public void txApplyPut(Operation p_putOp, Object key2, Object newValue, boolean didDestroy, TransactionId txId, TXRmtEvent txEvent, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        Operation putOp = p_putOp.getCorrespondingCreateOp();
        long lastMod = this.owner.cacheTimeMillis();
        this.owner.txApplyPutPart2(markerEntry, key2, newValue, lastMod, true, didDestroy, false);
        if (this.owner.isInitialized()) {
            if (txEvent != null) {
                txEvent.addPut(putOp, this.owner, markerEntry, key2, newValue, aCallbackArgument);
            }
            if (AbstractRegionMap.shouldCreateCBEvent(this.owner, false, this.owner.isInitialized())) {
                EntryEventImpl e = AbstractRegionMap.createCBEvent(this.owner, putOp, key2, newValue, txId, txEvent, eventId, aCallbackArgument, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
                AbstractRegionMap.switchEventOwnerAndOriginRemote(e, txEntryState == null);
                if (pendingCallbacks == null) {
                    this.owner.invokeTXCallbacks(EnumListenerEvent.AFTER_CREATE, e, true);
                } else {
                    pendingCallbacks.add(e);
                }
            }
        }
    }

    @Override
    public void lruUpdateCallback() {
    }

    @Override
    public boolean disableLruUpdateCallback() {
        return false;
    }

    @Override
    public void enableLruUpdateCallback() {
    }

    @Override
    public void decTxRefCount(RegionEntry e) {
    }

    @Override
    public final boolean lruLimitExceeded() {
        return false;
    }

    @Override
    public void lruCloseStats() {
    }

    @Override
    public void resetThreadLocals() {
    }

    @Override
    public void removeEntry(Object key2, RegionEntry entry, boolean updateStats) {
    }

    @Override
    public void removeEntry(Object key2, RegionEntry re, boolean updateStat, EntryEventImpl event, LocalRegion owner, IndexUpdater indexUpdater) {
    }

    @Override
    public void lruUpdateCallback(int n) {
    }

    @Override
    public void lruEntryFaultIn(LRUEntry entry) {
    }

    @Override
    public void copyRecoveredEntries(RegionMap rm2) {
        throw new IllegalStateException("copyRecoveredEntries should never be called on proxy");
    }

    @Override
    public boolean removeTombstone(RegionEntry re, VersionHolder destroyedVersion, boolean isEviction, boolean isScheduledTombstone) {
        throw new IllegalStateException("removeTombstone should never be called on a proxy");
    }

    @Override
    public boolean isTombstoneNotNeeded(RegionEntry re, int destroyedVersion) {
        throw new IllegalStateException("removeTombstone should never be called on a proxy");
    }

    @Override
    public void unscheduleTombstone(RegionEntry re) {
    }

    @Override
    public void setEntryFactory(RegionEntryFactory f) {
        throw new IllegalStateException("Should not be called on a ProxyRegionMap");
    }

    @Override
    public void updateEntryVersion(EntryEventImpl event) {
    }

    @Override
    public RegionEntry getEntryInVM(Object key2) {
        return null;
    }

    @Override
    public int sizeInVM() {
        return 0;
    }

    public static class ProxyRegionEntry
    implements RegionEntry {
        @Override
        public long getLastModified() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public long getLastAccessed() throws InternalStatisticsDisabledException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public long getHitCount() throws InternalStatisticsDisabledException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public long getMissCount() throws InternalStatisticsDisabledException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public VersionStamp getVersionStamp() {
            return null;
        }

        @Override
        public boolean isTombstone() {
            return false;
        }

        @Override
        public VersionTag generateVersionTag(VersionSource member, boolean withDelta, LocalRegion region, EntryEventImpl event) {
            return null;
        }

        public void processVersionTag(EntryEvent ev) {
        }

        @Override
        public void makeTombstone(LocalRegion r, VersionTag isOperationRemote) {
        }

        @Override
        public void updateStatsForPut(long lastModifiedTime) {
        }

        @Override
        public void setRecentlyUsed() {
        }

        @Override
        public void updateStatsForGet(boolean hit, long time) {
        }

        @Override
        public void txDidDestroy(long currTime) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public void resetCounts() throws InternalStatisticsDisabledException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public void removePhase1(LocalRegion r, boolean isClear) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public void removePhase2() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isRemoved() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isRemovedPhase2() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean fillInValue(LocalRegion r, InitialImageOperation.Entry entry, ByteArrayDataInput in, DM mgr) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isOverflowedToDisk(LocalRegion r, DistributedRegion.DiskPosition dp) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object getKey() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object getValue(RegionEntryContext context) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public void setValue(RegionEntryContext context, Object value2) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object _getValue() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Token getValueAsToken() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object _getValueUse(RegionEntryContext context, boolean decompress) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object getTransformedValue() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object getValueInVM(RegionEntryContext context) {
            return null;
        }

        @Override
        public Object getValueOnDisk(LocalRegion r) throws EntryNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object getValueOnDiskOrBuffer(LocalRegion r) throws EntryNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object getSerializedValueOnDisk(LocalRegion localRegion) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean initialImagePut(LocalRegion region, long lastModified, Object newValue, boolean wasRecovered, boolean versionTagAccepted) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean initialImageInit(LocalRegion region, long lastModified, Object newValue, boolean create, boolean wasRecovered, boolean versionTagAccepted) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean destroy(LocalRegion region, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean getValueWasResultOfSearch() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public void setValueResultOfSearch(boolean v) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean dispatchListenerEvents(EntryEventImpl event) throws InterruptedException {
            event.invokeCallbacks(event.getRegion(), event.inhibitCacheListenerNotification(), false);
            return true;
        }

        @Override
        public boolean hasStats() {
            return false;
        }

        @Override
        public Object getValueInVMOrDiskWithoutFaultIn(LocalRegion owner) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public Object getValueOffHeapOrDiskWithoutFaultIn(LocalRegion owner) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        public void processVersionTag(LocalRegion r, VersionTag tag, InternalDistributedMember thisVM, InternalDistributedMember sender) {
        }

        @Override
        public boolean isUpdateInProgress() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public void setUpdateInProgress(boolean underUpdate) {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isValueNull() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isInvalid() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isDestroyed() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public void setValueToNull() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isInvalidOrRemoved() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isDestroyedOrRemoved() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isDestroyedOrRemovedButNotTombstone() {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public void returnToPool() {
        }

        @Override
        public void setValueWithTombstoneCheck(Object value2, EntryEvent event) throws RegionClearedException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isCacheListenerInvocationInProgress() {
            return false;
        }

        @Override
        public void setCacheListenerInvocationInProgress(boolean isListenerInvoked) {
        }

        @Override
        public void setValue(RegionEntryContext context, Object value2, EntryEventImpl event) throws RegionClearedException {
            throw new UnsupportedOperationException(LocalizedStrings.ProxyRegionMap_NO_ENTRY_SUPPORT_ON_REGIONS_WITH_DATAPOLICY_0.toLocalizedString(DataPolicy.EMPTY));
        }

        @Override
        public boolean isInUseByTransaction() {
            return false;
        }

        @Override
        public void setInUseByTransaction(boolean v) {
        }

        @Override
        public void incRefCount() {
        }

        @Override
        public void decRefCount(NewLRUClockHand lruList, LocalRegion lr) {
        }

        @Override
        public void resetRefCount(NewLRUClockHand lruList) {
        }
    }
}

