/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.internal.cache.ExpiryTask;
import com.gemstone.gemfire.internal.cache.LocalRegion;

abstract class RegionExpiryTask
extends ExpiryTask {
    private boolean isCanceled = false;

    protected RegionExpiryTask(LocalRegion reg) {
        super(reg);
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    protected ExpirationAttributes getIdleAttributes() {
        return this.getLocalRegion().getRegionIdleTimeout();
    }

    @Override
    protected ExpirationAttributes getTTLAttributes() {
        return this.getLocalRegion().getRegionTimeToLive();
    }

    @Override
    protected final long getLastAccessedTime() {
        return this.getLocalRegion().getLastAccessedTime();
    }

    @Override
    protected final long getLastModifiedTime() {
        return this.getLocalRegion().getLastModifiedTime();
    }

    @Override
    protected final boolean destroy(boolean isPending) throws CacheException {
        return this.getLocalRegion().expireRegion(this, true, true);
    }

    @Override
    protected final boolean invalidate() throws TimeoutException {
        return this.getLocalRegion().expireRegion(this, true, false);
    }

    @Override
    protected final boolean localDestroy() throws CacheException {
        return this.getLocalRegion().expireRegion(this, false, true);
    }

    @Override
    protected final boolean localInvalidate() {
        return this.getLocalRegion().expireRegion(this, false, false);
    }

    @Override
    public boolean cancel() {
        this.isCanceled = true;
        return super.cancel();
    }

    @Override
    protected final void performTimeout() throws CacheException {
        if (this.isCanceled) {
            return;
        }
        super.performTimeout();
    }

    @Override
    protected final void basicPerformTimeout(boolean isPending) throws CacheException {
        if (this.isCanceled) {
            return;
        }
        if (!this.isExpirationAllowed()) {
            return;
        }
        if (this.isExpirationPossible()) {
            if (this.expire(isPending)) {
                this.reschedule();
            }
        } else {
            this.reschedule();
        }
    }

    @Override
    protected final void reschedule() throws CacheException {
        if (this.isCacheClosing() || this.getLocalRegion().isClosed() || this.getLocalRegion().isDestroyed() || !this.isExpirationAllowed()) {
            return;
        }
        this.addExpiryTask();
    }

    @Override
    public String toString() {
        String expireTime = "<unavailable>";
        try {
            expireTime = String.valueOf(this.getExpirationTime());
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
        }
        return super.toString() + " for " + this.getLocalRegion().getFullPath() + ", expiration time: " + expireTime + " [now: " + RegionExpiryTask.getNow() + "]";
    }
}

