/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.cache.ProxyRegionMap;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.VMLRURegionMap;
import com.gemstone.gemfire.internal.cache.VMRegionMap;

class RegionMapFactory {
    RegionMapFactory() {
    }

    public static RegionMap createVM(LocalRegion owner, RegionMap.Attributes attrs, InternalRegionArguments internalRegionArgs) {
        if (owner.isProxy()) {
            return new ProxyRegionMap(owner, attrs, internalRegionArgs);
        }
        if (owner.getEvictionController() != null) {
            return new VMLRURegionMap(owner, attrs, internalRegionArgs);
        }
        return new VMRegionMap(owner, attrs, internalRegionArgs);
    }

    public static RegionMap createVM(PlaceHolderDiskRegion owner, DiskStoreImpl ds, InternalRegionArguments internalRegionArgs) {
        RegionMap.Attributes ma = new RegionMap.Attributes();
        ma.statisticsEnabled = owner.getStatisticsEnabled();
        ma.loadFactor = owner.getLoadFactor();
        ma.initialCapacity = owner.getInitialCapacity();
        ma.concurrencyLevel = owner.getConcurrencyLevel();
        if (owner.getLruAlgorithm() != 0) {
            return new VMLRURegionMap(owner, ma, internalRegionArgs);
        }
        return new VMRegionMap(owner, ma, internalRegionArgs);
    }
}

