/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.NonLocalRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.RemoteOperationMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RemoteFetchEntryMessage
extends RemoteOperationMessage {
    private static final Logger logger = LogService.getLogger();
    private Object key;

    public RemoteFetchEntryMessage() {
    }

    private RemoteFetchEntryMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor, Object key2) {
        super(recipient, regionPath, processor);
        this.key = key2;
    }

    public static FetchEntryResponse send(InternalDistributedMember recipient, LocalRegion r, Object key2) throws RemoteOperationException {
        Assert.assertTrue(recipient != null, "RemoteFetchEntryMessage NULL recipient");
        FetchEntryResponse p = new FetchEntryResponse(r.getSystem(), Collections.singleton(recipient), r, key2);
        RemoteFetchEntryMessage m = new RemoteFetchEntryMessage(recipient, r.getFullPath(), p, key2);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.RemoteFetchEntryMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected final boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        if (!(r instanceof PartitionedRegion)) {
            r.waitOnInitialization();
        }
        try {
            if (r.keyRequiresRegionContext()) {
                ((KeyWithRegionContext)this.key).setRegionContext(r);
            }
            KeyInfo keyInfo = r.getKeyInfo(this.key);
            Region.Entry re = r.getDataView().getEntry(keyInfo, r, true);
            if (re == null) {
                throw new EntryNotFoundException(this.key.toString());
            }
            NonLocalRegionEntry nlre = new NonLocalRegionEntry(re, r);
            LocalRegion dataReg = r.getDataRegionForRead(keyInfo);
            EntrySnapshot val = new EntrySnapshot(nlre, dataReg, r, false);
            FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), val, dm, null);
        }
        catch (TransactionException tex) {
            FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(tex));
        }
        catch (EntryNotFoundException enfe) {
            FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(LocalizedStrings.RemoteFetchEntryMessage_ENTRY_NOT_FOUND.toLocalizedString(), enfe));
        }
        catch (PrimaryBucketException pbe) {
            FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(pbe));
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.key);
    }

    @Override
    public int getDSFID() {
        return -33;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
    }

    public void setKey(Object key2) {
        this.key = key2;
    }

    public static class FetchEntryResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile EntrySnapshot returnValue;
        final LocalRegion region;
        final Object key;

        public FetchEntryResponse(InternalDistributedSystem ds, Set recipients, LocalRegion theRegion, Object key2) {
            super(ds, (Collection)recipients);
            this.region = theRegion;
            this.key = key2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof FetchEntryReplyMessage) {
                    FetchEntryReplyMessage reply = (FetchEntryReplyMessage)msg;
                    this.returnValue = reply.getValue();
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "FetchEntryResponse return value is {}", this.returnValue);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public EntrySnapshot waitForResponse() throws EntryNotFoundException, RemoteOperationException {
            try {
                this.waitForCacheException();
            }
            catch (RemoteOperationException e) {
                e.checkKey(this.key);
                String msg = "FetchEntryResponse got remote RemoteOperationException; rethrowing";
                logger.debug("FetchEntryResponse got remote RemoteOperationException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (EntryNotFoundException e) {
                throw e;
            }
            catch (TransactionException e) {
                throw e;
            }
            catch (RegionDestroyedException e) {
                throw e;
            }
            catch (CacheException ce) {
                logger.debug("FetchEntryResponse got remote CacheException; forcing reattempt.", (Throwable)ce);
                throw new RemoteOperationException(LocalizedStrings.RemoteFetchEntryMessage_FETCHENTRYRESPONSE_GOT_REMOTE_CACHEEXCEPTION_FORCING_REATTEMPT.toLocalizedString(), ce);
            }
            return this.returnValue;
        }
    }

    public static final class FetchEntryReplyMessage
    extends ReplyMessage {
        private EntrySnapshot value;

        public FetchEntryReplyMessage() {
        }

        private FetchEntryReplyMessage(int processorId, EntrySnapshot value2, ReplyException re) {
            this.processorId = processorId;
            this.value = value2;
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, EntrySnapshot value2, DM dm, ReplyException re) {
            Assert.assertTrue(recipient != null, "FetchEntryReplyMessage NULL recipient");
            FetchEntryReplyMessage m = new FetchEntryReplyMessage(processorId, value2, re);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM);
            long startTime = this.getTimestamp();
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "FetchEntryReplyMessage process invoking reply processor with processorId:{}", this.processorId);
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.trace(LogMarker.DM, "FetchEntryReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM, "{}  processed  {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        public EntrySnapshot getValue() {
            return this.value;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            if (this.value == null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                InternalDataSerializer.invokeToData(this.value, out);
            }
        }

        @Override
        public int getDSFID() {
            return -34;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            boolean nullEntry = in.readBoolean();
            if (!nullEntry) {
                FetchEntryResponse processor = (FetchEntryResponse)ReplyProcessor21.getProcessor(this.processorId);
                if (processor == null) {
                    throw new OperationCancelledException("This operation was cancelled (null processor)");
                }
                this.value = new EntrySnapshot(in, processor.region);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("FetchEntryReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning value=").append(this.value);
            return sb.toString();
        }
    }
}

