/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.distributed.GatewayCancelledException;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GatewayImpl;
import com.gemstone.gemfire.internal.cache.GatewayStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;

public class SingleWriteSingleReadRegionQueue
implements RegionQueue {
    private static final Logger logger = LogService.getLogger();
    protected long _headKey = -1L;
    protected final AtomicLong _tailKey = new AtomicLong();
    protected final LinkedList<Long> _peekedIds = new LinkedList();
    private final String _regionName;
    private final String _diskStoreName;
    protected String _overflowDirectory;
    protected int _maximumQueueMemory;
    protected int _batchSize;
    protected boolean _enableConflation;
    protected boolean _enablePersistence;
    protected GatewayStats _stats;
    protected Region _region;
    protected Map _indexes;
    protected static final long MAXIMUM_KEY = Long.MAX_VALUE;
    private static final boolean NO_ACK = Boolean.getBoolean("gemfire.gateway-queue-no-ack");
    private static final String HEAD_KEY_57 = "HEAD_KEY";
    private static final String TAIL_KEY_57 = "TAIL_KEY";

    public SingleWriteSingleReadRegionQueue(Cache cache, String regionName, GatewayQueueAttributes attributes, CacheListener listener, GatewayStats stats) {
        this(cache, regionName, attributes, listener, stats, -1L, -1L);
    }

    @Override
    public Region getRegion() {
        return this._region;
    }

    public SingleWriteSingleReadRegionQueue(Cache cache, String regionName, GatewayQueueAttributes attributes, CacheListener listener, GatewayStats stats, long headKey, long tailKey) {
        this._regionName = regionName;
        assert (attributes != null);
        this._diskStoreName = attributes.getDiskStoreName();
        this._overflowDirectory = this._diskStoreName == null ? attributes.getOverflowDirectory() : null;
        this._enableConflation = attributes.getBatchConflation();
        this._maximumQueueMemory = attributes.getMaximumQueueMemory();
        this._batchSize = attributes.getBatchSize();
        this._enablePersistence = attributes.getEnablePersistence();
        this._stats = stats;
        this._headKey = headKey;
        this._tailKey.set(tailKey);
        this._indexes = new HashMap();
        this.initializeRegion(cache, listener);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Contains {} elements", this, this.size());
        }
    }

    public void destroy() {
        this.getRegion().localDestroyRegion();
    }

    @Override
    public synchronized void put(Object object) throws CacheException {
        this.putAndGetKey(object);
    }

    protected long putAndGetKey(Object object) throws CacheException {
        Long key2 = this.getTailKey();
        this._region.put(key2, object);
        this.incrementTailKey();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Inserted {} -> {}", this, key2, object);
        }
        if (object instanceof Conflatable) {
            this.removeOldEntry((Conflatable)object, key2);
        }
        return key2;
    }

    @Override
    public synchronized Object take() throws CacheException {
        this.resetLastPeeked();
        Object object = this.peekAhead();
        if (object != null) {
            Long key2 = this._peekedIds.getLast();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Retrieved {} -> {}", this, key2, object);
            }
            this._region.destroy(key2, "WAN_QUEUE_TOKEN");
            this.updateHeadKey(key2);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Destroyed {} -> {}", this, key2, object);
            }
        }
        return object;
    }

    @Override
    public List take(int batchSize) throws CacheException {
        Object obj;
        ArrayList<Object> batch = new ArrayList<Object>(batchSize * 2);
        for (int i = 0; i < batchSize && (obj = this.take()) != null; ++i) {
            batch.add(obj);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Took a batch of {} entries", this, batch.size());
        }
        return batch;
    }

    @Override
    public synchronized void remove() throws CacheException {
        Long key2;
        block4: {
            if (this._peekedIds.isEmpty()) {
                return;
            }
            key2 = this._peekedIds.removeFirst();
            try {
                this.removeIndex(key2);
                this._region.destroy(key2, "WAN_QUEUE_TOKEN");
            }
            catch (EntryNotFoundException ok) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("{}: Did not destroy entry at {} it was not there. It should have been removed by conflation.", this, key2);
            }
        }
        this.updateHeadKey(key2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Destroyed entry at key {}", this, key2);
        }
    }

    @Override
    public void remove(int batchSize) throws CacheException {
        for (int i = 0; i < batchSize; ++i) {
            this.remove();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Removed a batch of {}", this, batchSize);
        }
    }

    @Override
    public Object peek() throws CacheException {
        this.resetLastPeeked();
        Object object = this.peekAhead();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Peeked {} -> {}", this, this._peekedIds, object);
        }
        return object;
    }

    @Override
    public List peek(int batchSize) throws CacheException {
        return this.peek(batchSize, -1);
    }

    @Override
    public List peek(int batchSize, int timeToWait) throws CacheException {
        return this.peek(0, batchSize, timeToWait);
    }

    public List peek(int startIndex, int batchSize, int timeToWait) throws CacheException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        long start = System.currentTimeMillis();
        long end = start + (long)timeToWait;
        if (isDebugEnabled) {
            logger.debug("{}: Peek start time={} end time={} time to wait={}", this, start, end, timeToWait);
        }
        ArrayList<Object> batch = new ArrayList<Object>(batchSize * 2);
        this.resetLastPeeked();
        while (batch.size() < batchSize) {
            Object object = this.peekAhead();
            if (object != null) {
                batch.add(object);
                continue;
            }
            long currentTime = System.currentTimeMillis();
            if (isDebugEnabled) {
                logger.debug("{}: Peek current time: {}", this, currentTime);
            }
            if (timeToWait == -1 || end <= currentTime) {
                if (!isDebugEnabled) break;
                logger.debug("{}: Peek breaking", this);
                break;
            }
            if (isDebugEnabled) {
                logger.debug("{}: Peek continuing", this);
            }
            try {
                Thread.sleep(this.getTimeToSleep(timeToWait));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (isDebugEnabled) {
            logger.debug("{}: Peeked a batch of {} entries", this, batch.size());
        }
        return batch;
    }

    private long getTimeToSleep(int timeToWait) {
        long timeToSleep = Math.min(50L, (long)((double)timeToWait * 0.05));
        if (timeToSleep == 0L) {
            timeToSleep = (long)((double)timeToWait * 0.5);
        }
        if (timeToSleep == 0L) {
            timeToSleep = timeToWait;
        }
        return timeToSleep;
    }

    public String toString() {
        return "queue " + this._regionName;
    }

    @Override
    public int size() {
        int size2 = ((LocalRegion)this._region).entryCount();
        return size2;
    }

    @Override
    public void addCacheListener(CacheListener listener) {
        AttributesMutator mutator = this._region.getAttributesMutator();
        mutator.setCacheListener(listener);
    }

    @Override
    public void removeCacheListener() {
        AttributesMutator mutator = this._region.getAttributesMutator();
        mutator.setCacheListener(null);
    }

    protected boolean removeOldEntry(Conflatable object, Long tailKey) throws CacheException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean keepOldEntry = true;
        if (this._enableConflation && object.shouldBeConflated()) {
            Long previousIndex;
            if (isDebugEnabled) {
                logger.debug("{}: Conflating {} at queue index={} queue size={} head={} tail={}", this, object, tailKey, this.size(), this._headKey, tailKey);
            }
            String regionName = object.getRegionToConflate();
            Object key2 = object.getKeyToConflate();
            HashMap<Object, Long> latestIndexesForRegion = (HashMap<Object, Long>)this._indexes.get(regionName);
            if (latestIndexesForRegion == null) {
                latestIndexesForRegion = new HashMap<Object, Long>();
                this._indexes.put(regionName, latestIndexesForRegion);
            }
            if ((previousIndex = latestIndexesForRegion.put(key2, tailKey)) != null) {
                if (isDebugEnabled) {
                    logger.debug("{}: Indexes contains index={} for key={} head={} tail={} and it can be used", this, previousIndex, key2, this._headKey, tailKey);
                }
                keepOldEntry = false;
            } else {
                if (isDebugEnabled) {
                    logger.debug("{}: No old entry for key={} head={} tail={} not removing old entry", this, key2, this._headKey, tailKey);
                }
                this._stats.incConflationIndexesMapSize();
                keepOldEntry = true;
            }
            if (!keepOldEntry) {
                Conflatable previous = (Conflatable)this._region.remove(previousIndex);
                if (isDebugEnabled) {
                    logger.debug("{}: Previous conflatable at key={} head={} tail={}: {}", this, previousIndex, this._headKey, tailKey, previous);
                    logger.debug("{}: Current conflatable at key={} head={} tail={}: {}", this, tailKey, this._headKey, tailKey, object);
                    if (previous != null) {
                        logger.debug("{}: Removed {} and added {} for key={} head={} tail={} in queue for region={} old event {}", this, this.deserialize(previous.getValueToConflate()), this.deserialize(object.getValueToConflate()), key2, this._headKey, tailKey, regionName, previous);
                    }
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: Not conflating {} queue size: {} head={} tail={}", object, this.size(), this._headKey, tailKey);
        }
        return keepOldEntry;
    }

    private Object optimalGet(Long k) {
        LocalRegion lr = (LocalRegion)this._region;
        Object o = null;
        try {
            o = lr.getValueInVMOrDiskWithoutFaultIn(k);
            if (o != null && o instanceof CachedDeserializable) {
                o = ((CachedDeserializable)o).getDeserializedValue(lr, lr.getRegionEntry(k));
            }
        }
        catch (EntryNotFoundException ok) {
            // empty catch block
        }
        if (o == Token.TOMBSTONE) {
            o = null;
        }
        return o;
    }

    private void removeIndex(Long qkey) {
        Conflatable object;
        Object o;
        if (this._enableConflation && (o = this.optimalGet(qkey)) instanceof Conflatable && (object = (Conflatable)o).shouldBeConflated()) {
            String regionName = object.getRegionToConflate();
            Object key2 = object.getKeyToConflate();
            Map latestIndexesForRegion = (Map)this._indexes.get(regionName);
            if (latestIndexesForRegion != null) {
                Long index2 = (Long)latestIndexesForRegion.remove(key2);
                this._stats.decConflationIndexesMapSize();
                if (logger.isDebugEnabled() && index2 != null) {
                    logger.debug("{}: Removed index {} for {}", this, index2, object);
                }
            }
        }
    }

    protected Object deserialize(Object serializedBytes) {
        Object deserializedObject = serializedBytes;
        if (serializedBytes instanceof byte[]) {
            byte[] serializedBytesCast = (byte[])serializedBytes;
            try {
                deserializedObject = EntryEventImpl.deserialize(serializedBytesCast);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return deserializedObject;
    }

    private boolean before(long a, long b) {
        return a < b ^ a - b > 0x3FFFFFFFFFFFFFFFL;
    }

    private boolean beforeOrEquals(long a, long b) {
        return a <= b && b - a < 0x3FFFFFFFFFFFFFFFL;
    }

    private long inc(long value2) {
        value2 = ++value2 == Long.MAX_VALUE ? 0L : value2;
        return value2;
    }

    protected void resetLastPeeked() {
        this._peekedIds.clear();
    }

    protected Object peekAhead() throws CacheException {
        long currentKey;
        boolean isDebugEnabled = logger.isDebugEnabled();
        Object object = null;
        long l = currentKey = this._peekedIds.isEmpty() ? this.getHeadKey() : this._peekedIds.getLast() + 1L;
        while (this.before(currentKey, this.getTailKey()) && (object = this.optimalGet(currentKey)) == null) {
            if (isDebugEnabled) {
                logger.debug("{}: Trying head key + offset: {}", currentKey);
            }
            currentKey = this.inc(currentKey);
            if (this._stats == null) continue;
            this._stats.incEventsNotQueuedConflated();
        }
        if (isDebugEnabled) {
            logger.debug("{}: Peeked {} -> {}", this, currentKey, object);
        }
        if (object != null) {
            this._peekedIds.addLast(currentKey);
        }
        return object;
    }

    protected Object[] peekAheadGetKeyAndValue() throws CacheException {
        Object[] objectArray;
        long currentKey;
        boolean isDebugEnabled = logger.isDebugEnabled();
        Object object = null;
        long l = currentKey = this._peekedIds.isEmpty() ? this.getHeadKey() : this._peekedIds.getLast() + 1L;
        while (this.before(currentKey, this.getTailKey())) {
            Object v = this._region.get(currentKey);
            object = v;
            if (v != null) break;
            if (isDebugEnabled) {
                logger.debug("{}: Trying head key + offset: {}", this, currentKey);
            }
            currentKey = this.inc(currentKey);
            if (this._stats == null) continue;
            this._stats.incEventsNotQueuedConflated();
        }
        if (isDebugEnabled) {
            logger.debug("{}: Peeked {} -> {}", this, currentKey, object);
        }
        if (object != null) {
            this._peekedIds.addLast(currentKey);
        }
        if (object != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = currentKey;
            objectArray = objectArray2;
            objectArray2[1] = object;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    protected long getTailKey() throws CacheException {
        this.initializeKeys();
        long tailKey = this._tailKey.get();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Determined tail key: {}", this, tailKey);
        }
        return tailKey;
    }

    protected void incrementTailKey() throws CacheException {
        this._tailKey.set(this.inc(this._tailKey.get()));
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Incremented TAIL_KEY for region {} to {}", this, this._region.getName(), this._tailKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeKeys() throws CacheException {
        if (this._tailKey.get() != -1L) {
            return;
        }
        SingleWriteSingleReadRegionQueue singleWriteSingleReadRegionQueue = this;
        synchronized (singleWriteSingleReadRegionQueue) {
            long largestKey = -1L;
            long largestKeyLessThanHalfMax = -1L;
            long smallestKey = -1L;
            long smallestKeyGreaterThanHalfMax = -1L;
            this.remove57Keys();
            Set keySet = this._region.keySet();
            Iterator itr = keySet.iterator();
            while (itr.hasNext()) {
                long key2 = (Long)itr.next();
                if (key2 > largestKey) {
                    largestKey = key2;
                }
                if (key2 > largestKeyLessThanHalfMax && key2 < 0x3FFFFFFFFFFFFFFFL) {
                    largestKeyLessThanHalfMax = key2;
                }
                if (key2 < smallestKey || smallestKey == -1L) {
                    smallestKey = key2;
                }
                if (key2 >= smallestKeyGreaterThanHalfMax && smallestKeyGreaterThanHalfMax != -1L || key2 <= 0x3FFFFFFFFFFFFFFFL) continue;
                smallestKeyGreaterThanHalfMax = key2;
            }
            if (smallestKeyGreaterThanHalfMax != -1L && largestKeyLessThanHalfMax != -1L && smallestKeyGreaterThanHalfMax - largestKeyLessThanHalfMax > 0x3FFFFFFFFFFFFFFFL) {
                this._headKey = smallestKeyGreaterThanHalfMax;
                this._tailKey.set(this.inc(largestKeyLessThanHalfMax));
                logger.info(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_0_DURING_FAILOVER_DETECTED_THAT_KEYS_HAVE_WRAPPED, new Object[]{this, this._tailKey, this._headKey}));
            } else {
                this._headKey = smallestKey == -1L ? 0L : smallestKey;
                this._tailKey.set(this.inc(largestKey));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Initialized tail key to: {}, head key to: {}", this, this._tailKey, this._headKey);
            }
        }
    }

    private void remove57Keys() {
        boolean was57File = false;
        if (this._region.containsKey(HEAD_KEY_57)) {
            this._region.destroy(HEAD_KEY_57);
            was57File = true;
        }
        if (this._region.containsKey(TAIL_KEY_57)) {
            this._region.destroy(TAIL_KEY_57);
            was57File = true;
        }
        if (was57File) {
            logger.info(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_57_QUEUE_UPGRADED, this._regionName));
        }
    }

    protected long getHeadKey() throws CacheException {
        this.initializeKeys();
        long headKey = this._headKey;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Determined head key: {}", this, headKey);
        }
        return headKey;
    }

    protected void updateHeadKey(long destroyedKey) throws CacheException {
        this._headKey = this.inc(destroyedKey);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Incremented HEAD_KEY for region {} to {}", this, this._region.getName(), this._headKey);
        }
    }

    protected boolean isPersistent() {
        return this._enablePersistence;
    }

    protected void initializeRegion(Cache cache, CacheListener listener) {
        GemFireCacheImpl gemCache = (GemFireCacheImpl)cache;
        this._region = cache.getRegion(this._regionName);
        if (this._region == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(NO_ACK ? Scope.DISTRIBUTED_NO_ACK : Scope.DISTRIBUTED_ACK);
            if (this._enablePersistence) {
                factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            } else {
                factory.setDataPolicy(DataPolicy.REPLICATE);
            }
            if (listener != null) {
                factory.setCacheListener(listener);
            }
            EvictionAttributes ea = EvictionAttributes.createLRUMemoryAttributes(this._maximumQueueMemory, null, EvictionAction.OVERFLOW_TO_DISK);
            factory.setEvictionAttributes(ea);
            if (this._overflowDirectory != null && !this._overflowDirectory.equals(".")) {
                DiskWriteAttributesFactory dwaf = new DiskWriteAttributesFactory();
                dwaf.setSynchronous(true);
                dwaf.setMaxOplogSizeInBytes(GatewayImpl.QUEUE_OPLOG_SIZE);
                dwaf.setRollOplogs(false);
                DiskWriteAttributes dwa = dwaf.create();
                factory.setDiskWriteAttributes(dwa);
                File[] diskDirs = new File[]{new File(this._overflowDirectory)};
                if (!diskDirs[0].mkdirs() && !diskDirs[0].isDirectory()) {
                    throw new DiskAccessException("Could not create directory " + diskDirs[0].getAbsolutePath(), this._region);
                }
                factory.setDiskDirsAndSizes(diskDirs, new int[]{Integer.MAX_VALUE});
            } else {
                factory.setDiskStoreName(this._diskStoreName);
                factory.setDiskSynchronous(true);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Attempting to create queue region: {}", this, this._regionName);
            }
            RegionAttributes ra = factory.createRegionAttributes();
            try {
                SingleReadWriteMetaRegion meta = new SingleReadWriteMetaRegion(this._regionName, ra, null, gemCache);
                try {
                    this._region = gemCache.createVMRegion(this._regionName, ra, new InternalRegionArguments().setInternalMetaRegion(meta).setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null));
                    ((LocalRegion)this._region).destroyFilterProfile();
                }
                catch (IOException veryUnLikely) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_UNEXPECTED_EXCEPTION_DURING_INIT_OF_0, this.getClass()), (Throwable)veryUnLikely);
                }
                catch (ClassNotFoundException alsoUnlikely) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_UNEXPECTED_EXCEPTION_DURING_INIT_OF_0, this.getClass()), (Throwable)alsoUnlikely);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Created queue region: {}", this, this._region);
                }
            }
            catch (CacheException e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_0_THE_QUEUE_REGION_NAMED_1_COULD_NOT_BE_CREATED, new Object[]{this, this._regionName}), (Throwable)e);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: Retrieved queue region: {}", this, this._region);
        }
    }

    public void destroyPersistentFiles(Cache cache) {
        DiskStoreImpl diskStore = (DiskStoreImpl)cache.findDiskStore(this._diskStoreName);
        String region = "/" + this._regionName;
        if (diskStore.getDiskInitFile().getDiskRegionByName(region) != null) {
            diskStore.destroyRegion(region);
        }
    }

    private static class SingleReadWriteMetaRegion
    extends DistributedRegion {
        @Override
        protected CancelCriterion createStopper() {
            return new Stopper();
        }

        protected SingleReadWriteMetaRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache) {
            super(regionName, attrs, parentRegion, cache, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null));
        }

        @Override
        protected boolean isCopyOnRead() {
            return false;
        }

        @Override
        public final boolean isSecret() {
            return true;
        }

        @Override
        public void createEventTracker() {
        }

        @Override
        protected final boolean shouldNotifyBridgeClients() {
            return false;
        }

        @Override
        public final boolean generateEventID() {
            return false;
        }

        protected class Stopper
        extends CancelCriterion {
            protected Stopper() {
            }

            @Override
            public String cancelInProgress() {
                this.checkFailure();
                GemFireCacheImpl gfc = SingleReadWriteMetaRegion.this.getCache();
                assert (gfc != null);
                if (gfc.closingGatewayHubsByShutdownAll) {
                    return "Gateway hubs are being closed by shutdownall.";
                }
                return gfc.getCancelCriterion().cancelInProgress();
            }

            @Override
            public RuntimeException generateCancelledException(Throwable e) {
                String result = this.cancelInProgress();
                return new GatewayCancelledException(result, e);
            }
        }
    }
}

