/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.StatisticsDisabledException;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXEntryUserAttrState;
import com.gemstone.gemfire.internal.cache.TXRegionState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Hashtable;

public class TXEntry
implements Region.Entry {
    private final LocalRegion localRegion;
    protected final KeyInfo keyInfo;
    private boolean entryIsDestroyed = false;
    private final boolean rememberReads;
    private final TXStateInterface myTX;

    TXEntry(LocalRegion localRegion, KeyInfo key2, TXStateInterface tx) {
        this(localRegion, key2, tx, true);
    }

    TXEntry(LocalRegion localRegion, KeyInfo key2, TXStateInterface tx, boolean rememberReads) {
        this.localRegion = localRegion;
        this.localRegion.validateKey(key2.getKey());
        this.keyInfo = key2;
        this.myTX = tx;
        this.rememberReads = rememberReads;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    protected void checkTX() {
        if (!this.myTX.isInProgressAndSameAs(this.localRegion.getTXState())) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_REGIONENTRY_WAS_CREATED_WITH_TRANSACTION_THAT_IS_NO_LONGER_ACTIVE.toLocalizedString(this.myTX.getTransactionId()));
        }
    }

    @Override
    public boolean isDestroyed() {
        if (this.entryIsDestroyed) {
            return true;
        }
        this.checkTX();
        try {
            if (!this.myTX.containsKey(this.keyInfo, this.localRegion)) {
                this.entryIsDestroyed = true;
            }
        }
        catch (RegionDestroyedException ex) {
            this.entryIsDestroyed = true;
        }
        catch (CancelException ex) {
            this.entryIsDestroyed = true;
        }
        return this.entryIsDestroyed;
    }

    @Override
    public Object getKey() {
        this.checkEntryDestroyed();
        return this.keyInfo.getKey();
    }

    @Override
    public Object getValue() {
        this.checkTX();
        Object value2 = this.myTX.getDeserializedValue(this.keyInfo, this.localRegion, false, false, false, null, false);
        if (value2 == null) {
            throw new EntryDestroyedException(this.keyInfo.getKey().toString());
        }
        if (Token.isInvalid(value2)) {
            return null;
        }
        return value2;
    }

    public Region getRegion() {
        this.checkEntryDestroyed();
        return this.localRegion;
    }

    @Override
    public CacheStatistics getStatistics() {
        this.checkEntryDestroyed();
        this.checkTX();
        if (!this.localRegion.statisticsEnabled) {
            throw new StatisticsDisabledException(LocalizedStrings.LocalRegion_STATISTICS_DISABLED_FOR_REGION_0.toLocalizedString(this.localRegion.getFullPath()));
        }
        return new CacheStatistics(){

            @Override
            public long getLastModifiedTime() {
                return TXEntry.this.getRegion() != null ? ((LocalRegion)TXEntry.this.getRegion()).cacheTimeMillis() : System.currentTimeMillis();
            }

            @Override
            public long getLastAccessedTime() {
                return TXEntry.this.getRegion() != null ? ((LocalRegion)TXEntry.this.getRegion()).cacheTimeMillis() : System.currentTimeMillis();
            }

            @Override
            public long getMissCount() {
                return 0L;
            }

            @Override
            public long getHitCount() {
                return 0L;
            }

            @Override
            public float getHitRatio() {
                return 0.0f;
            }

            @Override
            public void resetCounts() {
            }
        };
    }

    @Override
    public Object getUserAttribute() {
        this.checkTX();
        this.throwIfUAOperationForPR();
        TXEntryUserAttrState tx = this.txReadUA(this.keyInfo);
        if (tx != null) {
            return tx.getPendingValue();
        }
        this.checkEntryDestroyed();
        return this.localRegion.basicGetEntryUserAttribute(this.keyInfo.getKey());
    }

    @Override
    public Object setUserAttribute(Object value2) {
        this.checkTX();
        this.throwIfUAOperationForPR();
        TXEntryUserAttrState tx = this.txWriteUA(this.keyInfo);
        if (tx != null) {
            return tx.setPendingValue(value2);
        }
        this.checkEntryDestroyed();
        if (this.localRegion.entryUserAttributes == null) {
            this.localRegion.entryUserAttributes = new Hashtable();
        }
        return this.localRegion.entryUserAttributes.put(this.keyInfo, value2);
    }

    private void throwIfUAOperationForPR() {
        if (this.localRegion instanceof PartitionedRegion) {
            throw new UnsupportedOperationException(LocalizedStrings.TXEntry_UA_NOT_SUPPORTED_FOR_PR.toLocalizedString());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TXEntry)) {
            return false;
        }
        TXEntry lre = (TXEntry)obj;
        return this.keyInfo.getKey().equals(lre.keyInfo.getKey()) && this.getRegion() == lre.getRegion();
    }

    @Override
    public int hashCode() {
        return this.keyInfo.getKey().hashCode() ^ this.getRegion().hashCode();
    }

    private void checkEntryDestroyed() {
        if (this.isDestroyed()) {
            throw new EntryDestroyedException(this.keyInfo.getKey().toString());
        }
    }

    private final TXEntryUserAttrState txReadUA(KeyInfo ki) {
        TXRegionState txr = this.myTX.txReadRegion(this.localRegion);
        if (txr != null) {
            return txr.readEntryUserAttr(ki.getKey());
        }
        return null;
    }

    protected final TXEntryUserAttrState txWriteUA(KeyInfo ki) {
        TXRegionState txr = this.myTX.txWriteRegion(this.localRegion, ki);
        if (txr != null) {
            return txr.writeEntryUserAttr(ki.getKey(), this.localRegion);
        }
        return null;
    }

    @Override
    public Object setValue(Object arg0) {
        return this.localRegion.put(this.getKey(), arg0);
    }
}

