/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.QueuedOperation;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXEntryStateFactory;
import com.gemstone.gemfire.internal.cache.TXRegionState;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.delta.Delta;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.pdx.PdxSerializationException;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public class TXEntryState {
    private Object originalVersionId;
    private final Object originalValue;
    protected int modSerialNum;
    private int farSideEventOffset = -1;
    private int nearSideEventOffset = -1;
    private Object pendingValue;
    private Object callBackArgument;
    private byte op;
    private byte destroy;
    private static final byte DESTROY_NONE = 0;
    private static final byte DESTROY_LOCAL = 1;
    private static final byte DESTROY_DISTRIBUTED = 2;
    private static final byte OP_NULL = 0;
    private static final byte OP_L_DESTROY = 1;
    private static final byte OP_CREATE_LD = 2;
    private static final byte OP_LLOAD_CREATE_LD = 3;
    private static final byte OP_NLOAD_CREATE_LD = 4;
    private static final byte OP_PUT_LD = 5;
    private static final byte OP_LLOAD_PUT_LD = 6;
    private static final byte OP_NLOAD_PUT_LD = 7;
    private static final byte OP_D_INVALIDATE_LD = 8;
    private static final byte OP_D_DESTROY = 9;
    private static final byte OP_L_INVALIDATE = 10;
    private static final byte OP_PUT_LI = 11;
    private static final byte OP_LLOAD_PUT_LI = 12;
    private static final byte OP_NLOAD_PUT_LI = 13;
    private static final byte OP_D_INVALIDATE = 14;
    private static final byte OP_CREATE_LI = 15;
    private static final byte OP_LLOAD_CREATE_LI = 16;
    private static final byte OP_NLOAD_CREATE_LI = 17;
    private static final byte OP_CREATE = 18;
    private static final byte OP_SEARCH_CREATE = 19;
    private static final byte OP_LLOAD_CREATE = 20;
    private static final byte OP_NLOAD_CREATE = 21;
    private static final byte OP_LOCAL_CREATE = 22;
    private static final byte OP_PUT = 23;
    private static final byte OP_SEARCH_PUT = 24;
    private static final byte OP_LLOAD_PUT = 25;
    private static final byte OP_NLOAD_PUT = 26;
    private static final boolean DETECT_READ_CONFLICTS;
    private final RegionEntry refCountEntry;
    private boolean dirty;
    private boolean bulkOp;
    private FilterRoutingInfo filterRoutingInfo = null;
    private Set<InternalDistributedMember> adjunctRecipients = null;
    private VersionTag versionTag = null;
    private long tailKey = -1L;
    private VersionTag remoteVersionTag = null;
    private TXRegionState txRegionState = null;
    private static final TXEntryStateFactory factory;

    protected TXEntryState() {
        this.op = 0;
        this.originalVersionId = Token.REMOVED_PHASE1;
        this.originalValue = Token.REMOVED_PHASE1;
        this.refCountEntry = null;
    }

    protected TXEntryState(RegionEntry re, Object pvId, Object pv, TXRegionState txRegionState) {
        Object vId = pvId;
        if (vId == null) {
            vId = Token.REMOVED_PHASE1;
        }
        if (pv == null) {
            pv = Token.REMOVED_PHASE1;
        }
        this.op = 0;
        this.pendingValue = pv;
        this.originalVersionId = vId;
        this.originalValue = pv;
        if (txRegionState.needsRefCounts()) {
            this.refCountEntry = re;
            if (re != null) {
                re.incRefCount();
            }
        } else {
            this.refCountEntry = null;
        }
        this.txRegionState = txRegionState;
    }

    public TXRegionState getTXRegionState() {
        return this.txRegionState;
    }

    public Object getOriginalVersionId() {
        return this.originalVersionId;
    }

    public Object getOriginalValue() {
        Object value2 = this.originalValue;
        if (value2 instanceof Delta) {
            value2 = ((Delta)value2).getResultantValue();
        }
        return value2;
    }

    public Object getPendingValue() {
        Object value2 = this.pendingValue;
        if (value2 instanceof Delta) {
            value2 = ((Delta)value2).getResultantValue();
        }
        return value2;
    }

    public Object getCallbackArgument() {
        return this.callBackArgument;
    }

    public Object getNearSidePendingValue() {
        if (this.isOpLocalDestroy()) {
            return null;
        }
        if (this.isOpLocalInvalidate()) {
            return Token.LOCAL_INVALID;
        }
        return this.getPendingValue();
    }

    void setPendingValue(Object pv) {
        if (pv instanceof Delta) {
            Object toMerge = this.pendingValue;
            this.pendingValue = ((Delta)pv).merge(toMerge, this.op == 18);
        } else {
            this.pendingValue = pv;
        }
    }

    void setCallbackArgument(Object callbackArgument) {
        this.callBackArgument = callbackArgument;
    }

    public void updateForWrite(int modNum) {
        this.dirty = true;
        this.modSerialNum = modNum;
    }

    public boolean isDirty() {
        return DETECT_READ_CONFLICTS || this.dirty;
    }

    public boolean hasOp() {
        return this.op != 0;
    }

    public boolean existsLocally() {
        if (this.op == 0) {
            return !Token.isRemoved(this.getOriginalValue());
        }
        return this.op > 9;
    }

    private boolean isOpLocalDestroy() {
        return this.op >= 1 && this.op <= 8;
    }

    private boolean isOpLocalInvalidate() {
        return this.op >= 10 && this.op <= 17 && this.op != 14;
    }

    public boolean noValueInSystem() {
        if (this.op == 9 || this.op == 8 || this.op == 14) {
            return true;
        }
        if (this.getNearSidePendingValue() == Token.INVALID) {
            return this.op >= 2 && this.op != 10 && this.op != 19 && this.op != 22 && this.op != 24;
        }
        return false;
    }

    public boolean isLocallyValid(boolean isProxy) {
        if (this.op == 0) {
            if (isProxy) {
                return true;
            }
            return !Token.isInvalidOrRemoved(this.getOriginalValue());
        }
        return this.op >= 18 && !Token.isInvalid(this.getNearSidePendingValue());
    }

    public Object getValueInVM(Object key2) throws EntryNotFoundException {
        if (!this.existsLocally()) {
            throw new EntryNotFoundException(String.valueOf(key2));
        }
        return this.getNearSidePendingValue();
    }

    public Object getValue(Object key2, Region r, boolean preferCD) {
        if (!this.existsLocally()) {
            return null;
        }
        Object v = this.getNearSidePendingValue();
        if (v instanceof CachedDeserializable && !preferCD) {
            v = ((CachedDeserializable)v).getDeserializedValue(r, this.refCountEntry);
        }
        return v;
    }

    private final boolean isOpCreate() {
        return this.op >= 15 && this.op <= 22;
    }

    final boolean isOpCreateEvent() {
        return this.isOpCreate();
    }

    private final boolean isOpPut() {
        return this.op >= 23;
    }

    protected final boolean isOpPutEvent() {
        return this.isOpPut();
    }

    private final boolean isOpInvalidate() {
        return this.op <= 14 && this.op >= 10;
    }

    final boolean isOpInvalidateEvent() {
        return this.isOpInvalidate();
    }

    private final boolean isOpDestroy() {
        return this.op <= 9 && this.op >= 1;
    }

    final boolean isOpDestroyEvent(LocalRegion r) {
        return this.isOpDestroy() && (r.isProxy() || this.getOriginalValue() != null && !Token.isRemoved(this.getOriginalValue()));
    }

    final boolean isOpAnyEvent(LocalRegion r) {
        return this.isOpPutEvent() || this.isOpCreateEvent() || this.isOpInvalidateEvent() || this.isOpDestroyEvent(r);
    }

    final boolean isOpSearchOrLoad() {
        return this.op >= 19 && this.op != 23 && this.op != 22;
    }

    final boolean isOpSearch() {
        return this.op == 19 || this.op == 24;
    }

    final boolean isOpLocalLoad() {
        return this.op == 20 || this.op == 25;
    }

    final boolean isOpNetLoad() {
        return this.op == 21 || this.op == 26;
    }

    final boolean isOpLoad() {
        return this.isOpLocalLoad() || this.isOpNetLoad();
    }

    private String opToString() {
        return this.opToString(this.op);
    }

    private String opToString(byte opCode) {
        switch (opCode) {
            case 0: {
                return "OP_NULL";
            }
            case 1: {
                return "OP_L_DESTROY";
            }
            case 2: {
                return "OP_CREATE_LD";
            }
            case 3: {
                return "OP_LLOAD_CREATE_LD";
            }
            case 4: {
                return "OP_NLOAD_CREATE_LD";
            }
            case 5: {
                return "OP_PUT_LD";
            }
            case 6: {
                return "OP_LLOAD_PUT_LD";
            }
            case 7: {
                return "OP_NLOAD_PUT_LD";
            }
            case 8: {
                return "OP_D_INVALIDATE_LD";
            }
            case 9: {
                return "OP_D_DESTROY";
            }
            case 10: {
                return "OP_L_INVALIDATE";
            }
            case 11: {
                return "OP_PUT_LI";
            }
            case 12: {
                return "OP_LLOAD_PUT_LI";
            }
            case 13: {
                return "OP_NLOAD_PUT_LI";
            }
            case 14: {
                return "OP_D_INVALIDATE";
            }
            case 15: {
                return "OP_CREATE_LI";
            }
            case 16: {
                return "OP_LLOAD_CREATE_LI";
            }
            case 17: {
                return "OP_NLOAD_CREATE_LI";
            }
            case 18: {
                return "OP_CREATE";
            }
            case 19: {
                return "OP_SEARCH_CREATE";
            }
            case 20: {
                return "OP_LLOAD_CREATE";
            }
            case 21: {
                return "OP_NLOAD_CREATE";
            }
            case 22: {
                return "OP_LOCAL_CREATE";
            }
            case 23: {
                return "OP_PUT";
            }
            case 24: {
                return "OP_SEARCH_PUT";
            }
            case 25: {
                return "OP_LLOAD_PUT";
            }
            case 26: {
                return "OP_NLOAD_PUT";
            }
        }
        return "<unhandled op " + opCode + " >";
    }

    protected Operation getNearSideOperation() {
        switch (this.op) {
            case 0: {
                return null;
            }
            case 1: {
                return Operation.LOCAL_DESTROY;
            }
            case 2: {
                return Operation.LOCAL_DESTROY;
            }
            case 3: {
                return Operation.LOCAL_DESTROY;
            }
            case 4: {
                return Operation.LOCAL_DESTROY;
            }
            case 5: {
                return Operation.LOCAL_DESTROY;
            }
            case 6: {
                return Operation.LOCAL_DESTROY;
            }
            case 7: {
                return Operation.LOCAL_DESTROY;
            }
            case 8: {
                return Operation.LOCAL_DESTROY;
            }
            case 9: {
                return this.getDestroyOperation();
            }
            case 10: {
                return Operation.LOCAL_INVALIDATE;
            }
            case 11: {
                return Operation.LOCAL_INVALIDATE;
            }
            case 12: {
                return Operation.LOCAL_INVALIDATE;
            }
            case 13: {
                return Operation.LOCAL_INVALIDATE;
            }
            case 14: {
                return Operation.INVALIDATE;
            }
            case 15: {
                return this.getCreateOperation();
            }
            case 16: {
                return this.getCreateOperation();
            }
            case 17: {
                return this.getCreateOperation();
            }
            case 18: {
                return this.getCreateOperation();
            }
            case 19: {
                return Operation.SEARCH_CREATE;
            }
            case 20: {
                return Operation.LOCAL_LOAD_CREATE;
            }
            case 21: {
                return Operation.NET_LOAD_CREATE;
            }
            case 22: {
                return this.getCreateOperation();
            }
            case 23: {
                return this.getUpdateOperation();
            }
            case 24: {
                return Operation.SEARCH_UPDATE;
            }
            case 25: {
                return Operation.LOCAL_LOAD_UPDATE;
            }
            case 26: {
                return Operation.NET_LOAD_CREATE;
            }
        }
        throw new IllegalStateException(LocalizedStrings.TXEntryState_UNHANDLED_OP_0.toLocalizedString(this.op));
    }

    private boolean isBulkOp() {
        return this.bulkOp;
    }

    private static int generateEventOffset(TXState txState) {
        long seqId = EventID.reserveSequenceId();
        int offset = (int)(seqId - txState.getBaseSequenceId());
        return offset;
    }

    private void generateBothEventOffsets(TXState txState) {
        assert (this.farSideEventOffset == -1);
        this.farSideEventOffset = TXEntryState.generateEventOffset(txState);
        this.generateNearSideEventOffset(txState);
    }

    private void generateSharedEventOffset(TXState txState) {
        assert (this.farSideEventOffset == -1);
        this.generateNearSideEventOffset(txState);
        this.farSideEventOffset = this.nearSideEventOffset;
    }

    private void generateNearSideOnlyEventOffset(TXState txState) {
        this.generateNearSideEventOffset(txState);
    }

    private void generateNearSideEventOffset(TXState txState) {
        assert (this.nearSideEventOffset == -1);
        this.nearSideEventOffset = TXEntryState.generateEventOffset(txState);
    }

    private int getFarSideEventOffset() {
        assert (this.nearSideEventOffset != -1);
        return this.nearSideEventOffset;
    }

    private static EventID createEventID(TXState txState, int offset) {
        return new EventID(txState.getBaseMembershipId(), txState.getBaseThreadId(), txState.getBaseSequenceId() + (long)offset);
    }

    private EventID getNearSideEventId(TXState txState) {
        assert (this.nearSideEventOffset != -1);
        return TXEntryState.createEventID(txState, this.nearSideEventOffset);
    }

    void generateEventOffsets(TXState txState) {
        switch (this.op) {
            case 0: {
                break;
            }
            case 1: {
                this.generateNearSideOnlyEventOffset(txState);
                break;
            }
            case 2: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 3: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 4: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 5: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 6: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 7: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 8: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 9: {
                this.generateSharedEventOffset(txState);
                break;
            }
            case 10: {
                this.generateNearSideOnlyEventOffset(txState);
                break;
            }
            case 11: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 12: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 13: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 14: {
                this.generateSharedEventOffset(txState);
                break;
            }
            case 15: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 16: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 17: {
                this.generateBothEventOffsets(txState);
                break;
            }
            case 18: {
                this.generateSharedEventOffset(txState);
                break;
            }
            case 19: {
                this.generateNearSideOnlyEventOffset(txState);
                break;
            }
            case 20: {
                this.generateSharedEventOffset(txState);
                break;
            }
            case 21: {
                this.generateSharedEventOffset(txState);
                break;
            }
            case 22: {
                this.generateNearSideOnlyEventOffset(txState);
                break;
            }
            case 23: {
                this.generateSharedEventOffset(txState);
                break;
            }
            case 24: {
                this.generateNearSideOnlyEventOffset(txState);
                break;
            }
            case 25: {
                this.generateSharedEventOffset(txState);
                break;
            }
            case 26: {
                this.generateSharedEventOffset(txState);
                break;
            }
            default: {
                throw new IllegalStateException("<unhandled op " + this.op + " >");
            }
        }
    }

    private Operation getFarSideOperation() {
        switch (this.op) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return this.getCreateOperation();
            }
            case 3: {
                return Operation.LOCAL_LOAD_CREATE;
            }
            case 4: {
                return Operation.NET_LOAD_CREATE;
            }
            case 5: {
                return this.getUpdateOperation();
            }
            case 6: {
                return Operation.LOCAL_LOAD_UPDATE;
            }
            case 7: {
                return Operation.NET_LOAD_UPDATE;
            }
            case 8: {
                return Operation.INVALIDATE;
            }
            case 9: {
                return this.getDestroyOperation();
            }
            case 10: {
                return null;
            }
            case 11: {
                return this.getUpdateOperation();
            }
            case 12: {
                return Operation.LOCAL_LOAD_UPDATE;
            }
            case 13: {
                return Operation.NET_LOAD_UPDATE;
            }
            case 14: {
                return Operation.INVALIDATE;
            }
            case 15: {
                return this.getCreateOperation();
            }
            case 16: {
                return Operation.LOCAL_LOAD_CREATE;
            }
            case 17: {
                return Operation.NET_LOAD_CREATE;
            }
            case 18: {
                return this.getCreateOperation();
            }
            case 19: {
                return null;
            }
            case 20: {
                return Operation.LOCAL_LOAD_CREATE;
            }
            case 21: {
                return Operation.NET_LOAD_CREATE;
            }
            case 22: {
                return this.getCreateOperation();
            }
            case 23: {
                return this.getUpdateOperation();
            }
            case 24: {
                return null;
            }
            case 25: {
                return Operation.LOCAL_LOAD_UPDATE;
            }
            case 26: {
                return Operation.NET_LOAD_UPDATE;
            }
        }
        throw new IllegalStateException(LocalizedStrings.TXEntryState_UNHANDLED_OP_0.toLocalizedString(this.op));
    }

    EntryEvent getEvent(LocalRegion r, Object key2, TXState txs) {
        LocalRegion eventRegion = r;
        if (r.isUsedForPartitionedRegionBucket()) {
            eventRegion = r.getPartitionedRegion();
        }
        TxEntryEventImpl result = new TxEntryEventImpl(eventRegion, key2);
        if (this.destroy == 0 || this.isOpDestroy()) {
            result.setOldValue(this.getOriginalValue());
        }
        if (txs.isOriginRemoteForEvents()) {
            result.setOriginRemote(true);
        } else {
            result.setOriginRemote(false);
        }
        result.setTransactionId(txs.getTransactionId());
        return result;
    }

    public boolean invalidate(EntryEventImpl event) throws EntryNotFoundException {
        if (event.isLocalInvalid()) {
            this.performOp(this.adviseOp((byte)10, event), event);
        } else {
            this.performOp(this.adviseOp((byte)14, event), event);
        }
        return true;
    }

    public boolean destroy(EntryEventImpl event, boolean cacheWrite, boolean originRemote) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        LocalRegion lr = event.getRegion();
        CacheWriter cWriter = lr.basicGetWriter();
        byte advisedOp = this.adviseOp(cacheWrite ? (byte)9 : 1, event);
        if (cWriter != null && cacheWrite && !event.inhibitAllNotifications()) {
            boolean oldOriginRemote = event.isOriginRemote();
            if (event.hasClientOrigin() || originRemote) {
                event.setOriginRemote(true);
            }
            cWriter.beforeDestroy(event);
            event.setOriginRemote(oldOriginRemote);
        }
        if (advisedOp != 0) {
            this.bulkOp = event.getOperation().isRemoveAll();
            if (cacheWrite) {
                this.performOp(advisedOp, event);
                this.destroy = (byte)2;
            } else {
                this.performOp(advisedOp, event);
                if (this.destroy != 2) {
                    this.destroy = 1;
                }
            }
        }
        return true;
    }

    public boolean basicPut(EntryEventImpl event, boolean ifNew, boolean originRemote) throws CacheWriterException, TimeoutException {
        byte putOp = 18;
        boolean doingCreate = true;
        if (!ifNew && this.existsLocally()) {
            putOp = 23;
            doingCreate = false;
        }
        if (doingCreate) {
            event.makeCreate();
        } else {
            event.makeUpdate();
        }
        if (event.isNetSearch()) {
            putOp = (byte)(putOp + 1);
        } else if (event.isLocalLoad()) {
            putOp = (byte)(putOp + 2);
        } else if (event.isNetLoad()) {
            putOp = (byte)(putOp + 3);
        }
        this.bulkOp = event.getOperation().isPutAll();
        byte advisedOp = this.adviseOp(putOp, event);
        LocalRegion lr = event.getRegion();
        if (!event.isNetSearch()) {
            CacheWriter cWriter = lr.basicGetWriter();
            boolean oldOriginRemote = event.isOriginRemote();
            if (event.hasClientOrigin() || originRemote) {
                event.setOriginRemote(true);
            }
            if (cWriter != null && event.isGenerateCallbacks() && !event.inhibitAllNotifications()) {
                if (doingCreate) {
                    cWriter.beforeCreate(event);
                } else {
                    cWriter.beforeUpdate(event);
                }
            }
            event.setOriginRemote(oldOriginRemote);
        }
        this.performOp(advisedOp, event);
        if (putOp == 18) {
            this.fetchRemoteVersionTag(event);
        }
        return true;
    }

    private void fetchRemoteVersionTag(EntryEventImpl event) {
        if (event.getRegion() instanceof DistributedRegion) {
            DistributedRegion dr = (DistributedRegion)event.getRegion();
            if (dr.dataPolicy == DataPolicy.NORMAL || dr.dataPolicy == DataPolicy.PRELOADED) {
                VersionTag tag = null;
                try {
                    tag = dr.fetchRemoteVersionTag(event.getKey());
                }
                catch (EntryNotFoundException e) {
                    // empty catch block
                }
                if (tag != null) {
                    this.setRemoteVersionTag(tag);
                }
            }
        }
    }

    private byte adviseOp(byte requestedOpCode, EntryEventImpl event) {
        Object oldVal = this.op == 0 ? this.getOriginalValue() : this.getNearSidePendingValue();
        LocalRegion region = event.getRegion();
        boolean needOldValue = region instanceof HARegion || region instanceof BucketRegion;
        event.setTXEntryOldValue(oldVal, needOldValue);
        int advisedOpCode = 0;
        block0 : switch (requestedOpCode) {
            case 1: {
                switch (this.op) {
                    case 0: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        throw new IllegalStateException(LocalizedStrings.TXEntryState_UNEXPECTED_CURRENT_OP_0_FOR_REQUESTED_OP_1.toLocalizedString(this.opToString(), this.opToString((byte)requestedOpCode)));
                    }
                    case 10: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 11: {
                        advisedOpCode = 5;
                        break block0;
                    }
                    case 12: {
                        advisedOpCode = 6;
                        break block0;
                    }
                    case 13: {
                        advisedOpCode = 7;
                        break block0;
                    }
                    case 14: {
                        advisedOpCode = 8;
                        break block0;
                    }
                    case 15: {
                        advisedOpCode = 2;
                        break block0;
                    }
                    case 16: {
                        advisedOpCode = 3;
                        break block0;
                    }
                    case 17: {
                        advisedOpCode = 4;
                        break block0;
                    }
                    case 18: {
                        advisedOpCode = 2;
                        break block0;
                    }
                    case 19: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 20: {
                        advisedOpCode = 3;
                        break block0;
                    }
                    case 21: {
                        advisedOpCode = 4;
                        break block0;
                    }
                    case 22: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 23: {
                        advisedOpCode = 5;
                        break block0;
                    }
                    case 24: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 25: {
                        advisedOpCode = 6;
                        break block0;
                    }
                    case 26: {
                        advisedOpCode = 7;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.TXEntryState_UNHANDLED_0.toLocalizedString(this.opToString()));
            }
            case 9: {
                Assert.assertTrue(!this.isOpDestroy(), "Transactional destroy assertion op=" + this.op);
                advisedOpCode = requestedOpCode;
                break;
            }
            case 10: {
                switch (this.op) {
                    case 0: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        throw new IllegalStateException(LocalizedStrings.TXEntryState_UNEXPECTED_CURRENT_OP_0_FOR_REQUESTED_OP_1.toLocalizedString(this.opToString(), this.opToString((byte)requestedOpCode)));
                    }
                    case 10: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 12: 
                    case 13: 
                    case 16: 
                    case 17: {
                        advisedOpCode = this.op;
                        break block0;
                    }
                    case 11: {
                        advisedOpCode = 11;
                        break block0;
                    }
                    case 15: {
                        advisedOpCode = 15;
                        break block0;
                    }
                    case 14: {
                        advisedOpCode = 14;
                        break block0;
                    }
                    case 18: {
                        advisedOpCode = 15;
                        break block0;
                    }
                    case 19: {
                        advisedOpCode = 22;
                        break block0;
                    }
                    case 20: {
                        advisedOpCode = 16;
                        break block0;
                    }
                    case 21: {
                        advisedOpCode = 17;
                        break block0;
                    }
                    case 22: {
                        advisedOpCode = 22;
                        break block0;
                    }
                    case 23: {
                        advisedOpCode = 11;
                        break block0;
                    }
                    case 24: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 25: {
                        advisedOpCode = 12;
                        break block0;
                    }
                    case 26: {
                        advisedOpCode = 13;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.TXEntryState_UNHANDLED_0.toLocalizedString(this.opToString()));
            }
            case 14: {
                switch (this.op) {
                    case 0: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        throw new IllegalStateException(LocalizedStrings.TXEntryState_UNEXPECTED_CURRENT_OP_0_FOR_REQUESTED_OP_1.toLocalizedString(this.opToString(), this.opToString((byte)requestedOpCode)));
                    }
                    case 10: 
                    case 14: {
                        advisedOpCode = 14;
                        break block0;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: {
                        advisedOpCode = this.op;
                        break block0;
                    }
                    case 18: {
                        advisedOpCode = 18;
                        break block0;
                    }
                    case 19: {
                        advisedOpCode = 22;
                        break block0;
                    }
                    case 20: {
                        advisedOpCode = 18;
                        break block0;
                    }
                    case 21: {
                        advisedOpCode = 18;
                        break block0;
                    }
                    case 22: {
                        advisedOpCode = 22;
                        break block0;
                    }
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.TXEntryState_UNHANDLED_0.toLocalizedString(this.opToString()));
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                advisedOpCode = requestedOpCode;
                break;
            }
            case 23: {
                switch (this.op) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: {
                        advisedOpCode = 18;
                        break block0;
                    }
                }
                advisedOpCode = requestedOpCode;
                break;
            }
            case 24: {
                switch (this.op) {
                    case 0: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 10: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 11: {
                        advisedOpCode = 23;
                        break block0;
                    }
                    case 12: {
                        advisedOpCode = 25;
                        break block0;
                    }
                    case 13: {
                        advisedOpCode = 26;
                        break block0;
                    }
                    case 15: {
                        advisedOpCode = 18;
                        break block0;
                    }
                    case 16: {
                        advisedOpCode = 20;
                        break block0;
                    }
                    case 17: {
                        advisedOpCode = 21;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.TXEntryState_PREVIOUS_OP_0_UNEXPECTED_FOR_REQUESTED_OP_1.toLocalizedString(this.opToString(), this.opToString((byte)requestedOpCode)));
            }
            case 25: 
            case 26: {
                switch (this.op) {
                    case 0: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        advisedOpCode = requestedOpCode;
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 22: {
                        if (requestedOpCode == 25) {
                            advisedOpCode = 20;
                            break block0;
                        }
                        advisedOpCode = 21;
                        break block0;
                    }
                }
                throw new IllegalStateException(LocalizedStrings.TXEntryState_PREVIOUS_OP_0_UNEXPECTED_FOR_REQUESTED_OP_1.toLocalizedString(this.opToString(), this.opToString((byte)requestedOpCode)));
            }
            default: {
                throw new IllegalStateException(LocalizedStrings.TXEntryState_OPCODE_0_SHOULD_NEVER_BE_REQUESTED.toLocalizedString(this.opToString((byte)requestedOpCode)));
            }
        }
        return (byte)advisedOpCode;
    }

    private void performOp(byte advisedOpCode, EntryEventImpl event) {
        this.op = advisedOpCode;
        event.putValueTXEntry(this);
    }

    private boolean areIdentical(Object o1, Object o2) {
        return o1 == o2;
    }

    void checkForConflict(LocalRegion r, Object key2) throws CommitConflictException {
        if (!this.isDirty()) {
            return;
        }
        if (this.isOpSearch()) {
            return;
        }
        try {
            r.checkReadiness();
            RegionEntry re = r.basicGetEntry(key2);
            Object curCmtVersionId = null;
            if (re == null || re.isValueNull()) {
                curCmtVersionId = Token.REMOVED_PHASE1;
            } else {
                if (re.getValueWasResultOfSearch()) {
                    return;
                }
                curCmtVersionId = re.getTransformedValue();
            }
            if (!this.areIdentical(this.getOriginalVersionId(), curCmtVersionId)) {
                String toString;
                String fromString = this.calcConflictString(this.getOriginalVersionId());
                if (fromString.equals(toString = this.calcConflictString(curCmtVersionId))) {
                    throw new CommitConflictException(LocalizedStrings.TXEntryState_ENTRY_FOR_KEY_0_ON_REGION_1_HAD_A_STATE_CHANGE.toLocalizedString(key2, r.getDisplayName()));
                }
                throw new CommitConflictException(LocalizedStrings.TXEntryState_ENTRY_FOR_KEY_0_ON_REGION_1_HAD_ALREADY_BEEN_CHANGED_FROM_2_TO_3.toLocalizedString(key2, r.getDisplayName(), fromString, toString));
            }
        }
        catch (CacheRuntimeException ex) {
            r.getCancelCriterion().checkCancelInProgress(null);
            throw new CommitConflictException(LocalizedStrings.TXEntryState_CONFLICT_CAUSED_BY_CACHE_EXCEPTION.toLocalizedString(), ex);
        }
    }

    private String calcConflictString(Object obj) {
        Object o = obj;
        if (o instanceof CachedDeserializable) {
            try {
                o = ((CachedDeserializable)o).getDeserializedForReading();
            }
            catch (PdxSerializationException e) {
                o = "<value unavailable>";
            }
        }
        if (o == null) {
            return "<null>";
        }
        if (Token.isRemoved(o)) {
            return "<null>";
        }
        if (o == Token.INVALID) {
            return "<invalidated>";
        }
        if (o == Token.LOCAL_INVALID) {
            return "<local invalidated>";
        }
        return "<" + StringUtils.forceToString(o) + ">";
    }

    private final boolean didDestroy() {
        return this.destroy != 0;
    }

    private final boolean didDistributedDestroy() {
        return this.destroy == 2;
    }

    int entryCountMod() {
        switch (this.op) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.getOriginalValue() == null || Token.isRemoved(this.getOriginalValue())) {
                    return 0;
                }
                return -1;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                if (this.getOriginalValue() == null || Token.isRemoved(this.getOriginalValue())) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    boolean wasCreatedByTX() {
        return this.isOpCreate();
    }

    private final void txApplyDestroyLocally(LocalRegion r, Object key2, TXState txState) {
        boolean invokeCallbacks = this.isOpDestroyEvent(r);
        ArrayList<EntryEventImpl> pendingCallbacks = invokeCallbacks ? txState.getPendingCallbacks() : new ArrayList<EntryEventImpl>();
        try {
            r.txApplyDestroy(key2, txState.getTransactionId(), null, false, this.getDestroyOperation(), this.getNearSideEventId(txState), this.callBackArgument, pendingCallbacks, this.getFilterRoutingInfo(), txState.bridgeContext, false, this, null, -1L);
        }
        catch (RegionDestroyedException ignore) {
        }
        catch (EntryDestroyedException ignore) {
            // empty catch block
        }
    }

    private final void txApplyInvalidateLocally(LocalRegion r, Object key2, Object newValue, boolean didDestroy, TXState txState) {
        try {
            r.txApplyInvalidate(key2, newValue, didDestroy, txState.getTransactionId(), null, this.isOpLocalInvalidate(), this.getNearSideEventId(txState), this.callBackArgument, txState.getPendingCallbacks(), this.getFilterRoutingInfo(), txState.bridgeContext, this, null, -1L);
        }
        catch (RegionDestroyedException ignore) {
        }
        catch (EntryDestroyedException ignore) {
            // empty catch block
        }
    }

    private final void txApplyPutLocally(LocalRegion r, Operation putOp, Object key2, Object newValue, boolean didDestroy, TXState txState) {
        try {
            r.txApplyPut(putOp, key2, newValue, didDestroy, txState.getTransactionId(), null, this.getNearSideEventId(txState), this.callBackArgument, txState.getPendingCallbacks(), this.getFilterRoutingInfo(), txState.bridgeContext, this, null, -1L);
        }
        catch (RegionDestroyedException ignore) {
        }
        catch (EntryDestroyedException ignore) {
            // empty catch block
        }
    }

    boolean cleanupNonDirty(LocalRegion r) {
        if (this.isDirty()) {
            return false;
        }
        this.cleanup(r);
        return true;
    }

    void buildMessage(LocalRegion r, Object key2, TXCommitMessage msg, Set otherRecipients) {
        if (!this.isDirty()) {
            return;
        }
        switch (this.op) {
            case 0: 
            case 1: 
            case 10: 
            case 19: 
            case 24: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                msg.addOp(r, key2, this, otherRecipients);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled op=" + this.opToString());
            }
        }
    }

    void buildCompleteMessage(LocalRegion r, Object key2, TXCommitMessage msg, Set otherRecipients) {
        if (!this.isDirty()) {
            return;
        }
        switch (this.op) {
            case 0: 
            case 1: 
            case 10: 
            case 19: 
            case 24: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                msg.addOp(r, key2, this, otherRecipients);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled op=" + this.opToString());
            }
        }
    }

    void applyChanges(LocalRegion r, Object key2, TXState txState) {
        if (!this.isDirty()) {
            return;
        }
        switch (this.op) {
            case 0: {
                break;
            }
            case 1: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 2: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 3: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 4: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 5: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 6: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 7: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 8: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 9: {
                this.txApplyDestroyLocally(r, key2, txState);
                break;
            }
            case 10: {
                this.txApplyInvalidateLocally(r, key2, Token.LOCAL_INVALID, this.didDestroy(), txState);
                break;
            }
            case 11: {
                this.txApplyPutLocally(r, this.getUpdateOperation(), key2, Token.LOCAL_INVALID, this.didDestroy(), txState);
                break;
            }
            case 12: {
                this.txApplyPutLocally(r, this.getUpdateOperation(), key2, Token.LOCAL_INVALID, this.didDestroy(), txState);
                break;
            }
            case 13: {
                this.txApplyPutLocally(r, this.getUpdateOperation(), key2, Token.LOCAL_INVALID, this.didDestroy(), txState);
                break;
            }
            case 14: {
                this.txApplyInvalidateLocally(r, key2, Token.INVALID, this.didDestroy(), txState);
                break;
            }
            case 15: {
                this.txApplyPutLocally(r, this.getCreateOperation(), key2, Token.LOCAL_INVALID, this.didDestroy(), txState);
                break;
            }
            case 16: {
                this.txApplyPutLocally(r, this.getCreateOperation(), key2, Token.LOCAL_INVALID, this.didDestroy(), txState);
                break;
            }
            case 17: {
                this.txApplyPutLocally(r, this.getCreateOperation(), key2, Token.LOCAL_INVALID, this.didDestroy(), txState);
                break;
            }
            case 18: {
                this.txApplyPutLocally(r, this.getCreateOperation(), key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            case 19: {
                this.txApplyPutLocally(r, Operation.SEARCH_CREATE, key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            case 20: {
                this.txApplyPutLocally(r, Operation.LOCAL_LOAD_CREATE, key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            case 21: {
                this.txApplyPutLocally(r, Operation.NET_LOAD_CREATE, key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            case 22: {
                this.txApplyPutLocally(r, this.getCreateOperation(), key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            case 23: {
                this.txApplyPutLocally(r, this.getUpdateOperation(), key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            case 24: {
                this.txApplyPutLocally(r, Operation.SEARCH_UPDATE, key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            case 25: {
                this.txApplyPutLocally(r, Operation.LOCAL_LOAD_UPDATE, key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            case 26: {
                this.txApplyPutLocally(r, Operation.NET_LOAD_UPDATE, key2, this.getPendingValue(), this.didDestroy(), txState);
                break;
            }
            default: {
                throw new IllegalStateException(LocalizedStrings.TXEntryState_UNHANDLED_OP_0.toLocalizedString(this.opToString()));
            }
        }
    }

    private Operation getCreateOperation() {
        return this.isBulkOp() ? Operation.PUTALL_CREATE : Operation.CREATE;
    }

    private Operation getUpdateOperation() {
        return this.isBulkOp() ? Operation.PUTALL_UPDATE : Operation.UPDATE;
    }

    private Operation getDestroyOperation() {
        if (this.isOpLocalDestroy()) {
            return Operation.LOCAL_DESTROY;
        }
        if (this.isBulkOp()) {
            return Operation.REMOVEALL_DESTROY;
        }
        return Operation.DESTROY;
    }

    void toFarSideData(DataOutput out, boolean largeModCount, boolean sendVersionTag, boolean sendShadowKey) throws IOException {
        Operation operation = this.getFarSideOperation();
        out.writeByte(operation.ordinal);
        if (largeModCount) {
            out.writeInt(this.modSerialNum);
        } else {
            out.writeByte(this.modSerialNum);
        }
        DataSerializer.writeObject(this.getCallbackArgument(), out);
        DataSerializer.writeObject(this.getFilterRoutingInfo(), out);
        if (sendVersionTag) {
            DataSerializer.writeObject(this.getVersionTag(), out);
            assert (this.getVersionTag() != null || !this.txRegionState.getRegion().concurrencyChecksEnabled || this.txRegionState.getRegion().dataPolicy != DataPolicy.REPLICATE) : "tag:" + this.getVersionTag() + " r:" + this.txRegionState.getRegion() + " op:" + this.opToString() + " key:";
        }
        if (sendShadowKey) {
            out.writeLong(this.tailKey);
        }
        out.writeInt(this.getFarSideEventOffset());
        if (!operation.isDestroy()) {
            out.writeBoolean(this.didDistributedDestroy());
            if (!operation.isInvalidate()) {
                boolean sendObject = Token.isInvalidOrRemoved(this.getPendingValue());
                sendObject = sendObject || this.getPendingValue() instanceof byte[];
                out.writeBoolean(sendObject);
                if (sendObject) {
                    DataSerializer.writeObject(this.getPendingValue(), out);
                } else {
                    DataSerializer.writeObjectAsByteArray(this.getPendingValue(), out);
                }
            }
        }
    }

    public FilterRoutingInfo getFilterRoutingInfo() {
        return this.filterRoutingInfo;
    }

    QueuedOperation toFarSideQueuedOp(Object key2) {
        Operation operation = this.getFarSideOperation();
        byte[] valueBytes = null;
        int deserializationPolicy = 0;
        if (!operation.isDestroy() && !operation.isInvalidate()) {
            Object v = this.getPendingValue();
            if (v == null || v instanceof byte[]) {
                valueBytes = (byte[])v;
            } else {
                Assert.assertTrue(!(v instanceof Delta));
                deserializationPolicy = 2;
                valueBytes = EntryEventImpl.serialize(v);
            }
        }
        return new QueuedOperation(operation, key2, valueBytes, null, (byte)deserializationPolicy, null);
    }

    void cleanup(LocalRegion r) {
        if (this.refCountEntry != null) {
            r.txDecRefCount(this.refCountEntry);
        }
    }

    int getSortValue() {
        return this.modSerialNum;
    }

    public static TXEntryStateFactory getFactory() {
        return factory;
    }

    public void setFilterRoutingInfo(FilterRoutingInfo fri) {
        this.filterRoutingInfo = fri;
    }

    public Set<InternalDistributedMember> getAdjunctRecipients() {
        return this.adjunctRecipients;
    }

    public void setAdjunctRecipients(Set<InternalDistributedMember> members) {
        this.adjunctRecipients = members;
    }

    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(VersionTag versionTag) {
        this.versionTag = versionTag;
    }

    public VersionTag getRemoteVersionTag() {
        return this.remoteVersionTag;
    }

    public void setRemoteVersionTag(VersionTag remoteVersionTag) {
        this.remoteVersionTag = remoteVersionTag;
    }

    public long getTailKey() {
        return this.tailKey;
    }

    public void setTailKey(long tailKey) {
        this.tailKey = tailKey;
    }

    static {
        Assert.assertTrue(true, "search offset inconsistent");
        Assert.assertTrue(true, "lload offset inconsistent");
        Assert.assertTrue(true, "nload offset inconsistent");
        DETECT_READ_CONFLICTS = Boolean.getBoolean("gemfire.detectReadConflicts");
        factory = new TXEntryStateFactory(){

            @Override
            public TXEntryState createEntry() {
                return new TXEntryState();
            }

            @Override
            public TXEntryState createEntry(RegionEntry re, Object vId, Object pendingValue, Object entryKey, TXRegionState txrs) {
                return new TXEntryState(re, vId, pendingValue, txrs);
            }
        };
    }

    public final class TxEntryEventImpl
    extends EntryEventImpl
    implements Comparable {
        TxEntryEventImpl(LocalRegion r, Object key2) {
            super(r, TXEntryState.this.getNearSideOperation(), key2, TXEntryState.this.getNearSidePendingValue(), TXEntryState.this.getCallbackArgument(), false, r.getMyId());
        }

        private int getSortValue() {
            return TXEntryState.this.getSortValue();
        }

        public int compareTo(Object o) {
            TxEntryEventImpl other = (TxEntryEventImpl)o;
            return this.getSortValue() - other.getSortValue();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TxEntryEventImpl)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return this.getSortValue();
        }
    }
}

