/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class TXEntryUserAttrState {
    private final Object originalValue;
    private Object pendingValue;

    public TXEntryUserAttrState(Object originalValue) {
        this.originalValue = originalValue;
        this.pendingValue = originalValue;
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public Object getPendingValue() {
        return this.pendingValue;
    }

    public Object setPendingValue(Object pv) {
        Object result = this.pendingValue;
        this.pendingValue = pv;
        return result;
    }

    void checkForConflict(LocalRegion r, Object key2) throws CommitConflictException {
        Object curCmtValue = r.basicGetEntryUserAttribute(key2);
        if (this.originalValue != curCmtValue) {
            throw new CommitConflictException(LocalizedStrings.TXEntryUserAttrState_ENTRY_USER_ATTRIBUTE_FOR_KEY_0_ON_REGION_1_HAD_ALREADY_BEEN_CHANGED_TO_2.toLocalizedString(key2, r.getFullPath(), curCmtValue));
        }
    }

    void applyChanges(LocalRegion r, Object key2) {
        try {
            Region.Entry re = r.getEntry(key2);
            re.setUserAttribute(this.pendingValue);
        }
        catch (CacheRuntimeException cacheRuntimeException) {
            // empty catch block
        }
    }
}

