/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.SynchronizationCommitConflictException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.TransactionWriterException;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.cache.client.internal.ServerRegionDataAccess;
import com.gemstone.gemfire.distributed.TXManagerCancelledException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.NonLocalRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.TXBucketRegionState;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXEntry;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXEvent;
import com.gemstone.gemfire.internal.cache.TXLockRequest;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXRegionState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.partitioned.PutAllPRMessage;
import com.gemstone.gemfire.internal.cache.partitioned.RemoveAllPRMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.tx.TransactionalOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;

public class TXState
implements TXStateInterface {
    private static final Logger logger = LogService.getLogger();
    private final long beginTime;
    final IdentityHashMap<LocalRegion, TXRegionState> regions;
    private boolean completionStarted;
    private boolean closed = false;
    private final Object completionGuard = new Object();
    private TXLockRequest locks = null;
    private long jtaLifeTime;
    private int modSerialNum;
    private final List<EntryEventImpl> pendingCallbacks = new ArrayList<EntryEventImpl>();
    private Runnable internalAfterReservation;
    private Runnable internalAfterConflictCheck = null;
    private Runnable internalAfterApplyChanges = null;
    private Runnable internalAfterReleaseLocalLocks = null;
    Runnable internalDuringIndividualSend = null;
    Runnable internalAfterIndividualSend = null;
    Runnable internalDuringIndividualCommitProcess;
    Runnable internalAfterIndividualCommitProcess;
    private Runnable internalAfterSend = null;
    private Runnable internalBeforeSend = null;
    private byte[] baseMembershipId;
    private long baseThreadId;
    private long baseSequenceId;
    private final TXStateProxy proxy;
    private boolean firedWriter = false;
    private final boolean onBehalfOfRemoteStub;
    private boolean gotBucketLocks = false;
    private TXCommitMessage commitMessage = null;
    ClientProxyMembershipID bridgeContext = null;
    protected Set<EventID> seenEvents = new HashSet<EventID>();
    private Map<EventID, Boolean> seenResults = new HashMap<EventID, Boolean>();
    static final TXEntryState ENTRY_EXISTS = new TXEntryState();

    public TXState(TXStateProxy proxy, boolean onBehalfOfRemoteStub) {
        this.beginTime = CachePerfStats.getStatTime();
        this.regions = new IdentityHashMap();
        this.proxy = proxy;
        this.onBehalfOfRemoteStub = onBehalfOfRemoteStub;
    }

    private boolean hasSeenEvent(EntryEventImpl event) {
        assert (event != null);
        if (event.getEventId() == null) {
            return false;
        }
        return this.seenEvents.contains(event.getEventId());
    }

    private void recordEvent(EntryEventImpl event) {
        assert (event != null);
        if (event.getEventId() != null) {
            this.seenEvents.add(event.getEventId());
        }
    }

    private void recordEventAndResult(EntryEventImpl event, boolean result) {
        this.recordEvent(event);
        if (event.getEventId() != null) {
            this.seenResults.put(event.getEventId(), result);
        }
    }

    private boolean getRecordedResult(EntryEventImpl event) {
        assert (event != null);
        assert (this.seenResults.containsKey(event.getEventId()));
        return this.seenResults.get(event.getEventId());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass()).append("@").append(System.identityHashCode(this)).append(" onBehalfOfRemoteStub:").append(this.onBehalfOfRemoteStub);
        return builder.toString();
    }

    @Override
    public TransactionId getTransactionId() {
        return this.proxy.getTxId();
    }

    public void firePendingCallbacks() {
        for (EntryEventImpl ee : this.getPendingCallbacks()) {
            if (ee.getOperation().isDestroy()) {
                ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_DESTROY, ee, true);
                continue;
            }
            if (ee.getOperation().isInvalidate()) {
                ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_INVALIDATE, ee, true);
                continue;
            }
            if (ee.getOperation().isCreate()) {
                ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_CREATE, ee, true);
                continue;
            }
            ee.getRegion().invokeTXCallbacks(EnumListenerEvent.AFTER_UPDATE, ee, true);
        }
    }

    public List<EntryEventImpl> getPendingCallbacks() {
        return this.pendingCallbacks;
    }

    @Override
    public TXRegionState readRegion(LocalRegion r) {
        return this.regions.get(r);
    }

    @Override
    public void rmRegion(LocalRegion r) {
        TXRegionState txr = this.regions.remove(r);
        if (txr != null) {
            txr.cleanup(r);
        }
    }

    @Override
    public TXRegionState writeRegion(LocalRegion r) {
        TXRegionState result = this.readRegion(r);
        if (result == null) {
            result = r instanceof BucketRegion ? new TXBucketRegionState((BucketRegion)r, this) : new TXRegionState(r, this);
            this.regions.put(r, result);
        }
        return result;
    }

    @Override
    public long getBeginTime() {
        return this.beginTime;
    }

    @Override
    public int getChanges() {
        int changes = 0;
        for (TXRegionState txrs : this.regions.values()) {
            changes += txrs.getChanges();
        }
        return changes;
    }

    @Override
    public boolean isInProgress() {
        return !this.closed;
    }

    @Override
    public int nextModSerialNum() {
        ++this.modSerialNum;
        return this.modSerialNum;
    }

    @Override
    public boolean needsLargeModCount() {
        return this.modSerialNum > 127;
    }

    private void reserveAndCheck() throws CommitConflictException {
        if (this.closed) {
            return;
        }
        long conflictStart = CachePerfStats.getStatTime();
        this.locks = this.createLockRequest();
        this.locks.obtain();
        if (CachePerfStats.enableClockStats) {
            this.proxy.getTxMgr().getCachePerfStats().incTxConflictCheckTime(CachePerfStats.getStatTime() - conflictStart);
        }
        if (this.internalAfterReservation != null) {
            this.internalAfterReservation.run();
        }
        this.checkForConflicts();
    }

    byte[] getBaseMembershipId() {
        return this.baseMembershipId;
    }

    long getBaseThreadId() {
        return this.baseThreadId;
    }

    long getBaseSequenceId() {
        return this.baseSequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws CommitConflictException {
        if (this.closed) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("committing transaction {}", this.getTransactionId());
        }
        Object object = this.completionGuard;
        synchronized (object) {
            this.completionStarted = true;
        }
        if (this.onBehalfOfRemoteStub && !this.proxy.isCommitOnBehalfOfRemoteStub()) {
            throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_CANNOT_COMMIT_REMOTED_TRANSACTION.toLocalizedString());
        }
        this.cleanupNonDirtyRegions();
        try {
            try {
                this.lockBucketRegions();
            }
            catch (PrimaryBucketException pbe) {
                TransactionDataRebalancedException re = new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
                re.initCause(pbe);
                throw re;
            }
            if (this.locks == null) {
                this.reserveAndCheck();
            }
            if (this.internalAfterConflictCheck != null) {
                this.internalAfterConflictCheck.run();
            }
            TransactionWriter writer = this.proxy.getTxMgr().getWriter();
            if (!this.firedWriter && writer != null) {
                try {
                    this.firedWriter = true;
                    writer.beforeCommit(this.getEvent());
                }
                catch (TransactionWriterException twe) {
                    this.cleanup();
                    throw new CommitConflictException(twe);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    this.cleanup();
                    SystemFailure.checkFailure();
                    throw new CommitConflictException(t);
                }
            }
            List entries = this.generateEventOffsets();
            TXCommitMessage msg = null;
            try {
                this.attachFilterProfileInformation(entries);
                this.applyChanges(entries);
                if (this.internalAfterApplyChanges != null) {
                    this.internalAfterApplyChanges.run();
                }
                this.commitMessage = msg = this.buildMessage();
                if (this.internalBeforeSend != null) {
                    this.internalBeforeSend.run();
                }
                msg.send(this.locks.getDistributedLockId());
                if (this.internalAfterSend != null) {
                    this.internalAfterSend.run();
                }
                this.firePendingCallbacks();
                this.commitMessage = this.buildCompleteMessage();
            }
            finally {
                if (msg != null) {
                    msg.releaseViewVersions();
                }
                this.locks.releaseLocal();
                if (this.internalAfterReleaseLocalLocks != null) {
                    this.internalAfterReleaseLocalLocks.run();
                }
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void attachFilterProfileInformation(List entries) {
        for (TXEntryStateWithRegionAndKey o : entries) {
            try {
                if (!o.r.isUsedForPartitionedRegionBucket()) continue;
                BucketRegion bucket = (BucketRegion)o.r;
                EntryEventImpl ev = (EntryEventImpl)o.es.getEvent(o.r, o.key, o.es.getTXRegionState().getTXState());
                FilterRoutingInfo fri = bucket.getPartitionedRegion().getRegionAdvisor().adviseFilterRouting(ev, Collections.EMPTY_SET);
                o.es.setFilterRoutingInfo(fri);
                Set set = bucket.getAdjunctReceivers(ev, Collections.EMPTY_SET, new HashSet(), fri);
                o.es.setAdjunctRecipients(set);
            }
            catch (RegionDestroyedException ex) {
            }
            catch (CancelException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        if (this.closed) {
            return;
        }
        Object object = this.completionGuard;
        synchronized (object) {
            this.completionStarted = true;
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForPreviousCompletion() {
        Object object = this.completionGuard;
        synchronized (object) {
            if (!this.completionStarted) {
                return false;
            }
            while (this.commitMessage == null && !this.closed) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting for previous completion for transaction {}", this.getTransactionId());
                }
                try {
                    this.completionGuard.wait();
                }
                catch (InterruptedException e) {
                    this.proxy.getCache().getCancelCriterion().checkCancelInProgress(e);
                    Thread.currentThread().interrupt();
                    return true;
                }
            }
        }
        return true;
    }

    private List generateEventOffsets() {
        this.baseMembershipId = EventID.getMembershipId(this.proxy.getTxMgr().getDM().getSystem());
        this.baseThreadId = EventID.getThreadId();
        this.baseSequenceId = EventID.getSequenceId();
        List entries = this.getSortedEntries();
        for (TXEntryStateWithRegionAndKey o : entries) {
            o.es.generateEventOffsets(this);
        }
        return entries;
    }

    private TXLockRequest createLockRequest() {
        TXLockRequest result = new TXLockRequest();
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            LocalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.createLockRequest(r, result);
        }
        return result;
    }

    private void checkForConflicts() throws CommitConflictException, PrimaryBucketException {
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            LocalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            try {
                txrs.checkForConflicts(r);
            }
            catch (DiskAccessException dae) {
                r.handleDiskAccessException(dae);
                throw dae;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lockBucketRegions() throws PrimaryBucketException {
        boolean lockingSucceeded;
        block10: do {
            lockingSucceeded = true;
            Iterator<Map.Entry<LocalRegion, TXRegionState>> it = this.regions.entrySet().iterator();
            HashSet<BucketRegion> obtained = new HashSet<BucketRegion>();
            while (it.hasNext()) {
                boolean lockObtained;
                LocalRegion r;
                block22: {
                    Map.Entry<LocalRegion, TXRegionState> me = it.next();
                    r = me.getKey();
                    if (!(r instanceof BucketRegion)) continue;
                    BucketRegion b = (BucketRegion)r;
                    lockObtained = false;
                    try {
                        boolean locked = b.doLockForPrimary(true);
                        if (locked) {
                            obtained.add(b);
                            lockObtained = true;
                            break block22;
                        }
                        r.getCancelCriterion().checkCancelInProgress(null);
                        if (logger.isDebugEnabled()) {
                            logger.debug("tryLock failed for commit on {}. Releasing locks and retrying", r.getFullPath());
                        }
                        if (lockObtained) continue block10;
                    }
                    catch (RegionDestroyedException rde) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug("RegionDestroyedException while locking bucket region {}", r.getFullPath(), rde);
                            }
                            throw new TransactionDataRebalancedException("Bucket rebalanced during commit: " + r.getFullPath());
                        }
                        catch (Throwable throwable) {
                            if (!lockObtained) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Unexpected exception while locking bucket {}", r.getFullPath());
                                }
                                for (BucketRegion br : obtained) {
                                    br.doUnlockForPrimary();
                                }
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                                lockingSucceeded = false;
                            }
                            throw throwable;
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Unexpected exception while locking bucket {}", r.getFullPath());
                    }
                    for (BucketRegion br : obtained) {
                        br.doUnlockForPrimary();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    lockingSucceeded = false;
                    continue block10;
                }
                if (lockObtained) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected exception while locking bucket {}", r.getFullPath());
                }
                for (BucketRegion br : obtained) {
                    br.doUnlockForPrimary();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                lockingSucceeded = false;
            }
        } while (!lockingSucceeded);
        this.gotBucketLocks = true;
    }

    private void cleanupNonDirtyRegions() {
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            LocalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.cleanupNonDirtyEntries(r);
        }
    }

    private TXCommitMessage buildMessage() {
        TXCommitMessage msg = new TXCommitMessage(this.proxy.getTxId(), this.proxy.getTxMgr().getDM(), this);
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            LocalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.buildMessage(r, msg);
        }
        return msg;
    }

    private TXCommitMessage buildCompleteMessage() {
        TXCommitMessage msg = new TXCommitMessage(this.proxy.getTxId(), this.proxy.getTxMgr().getDM(), this);
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            LocalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.buildCompleteMessage(r, msg);
        }
        return msg;
    }

    private void applyChanges(List entries) {
        TXRegionState txrs;
        LocalRegion r;
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            r = me.getKey();
            txrs = me.getValue();
            txrs.applyChangesStart(r, this);
        }
        for (TXEntryStateWithRegionAndKey o : entries) {
            try {
                o.es.applyChanges(o.r, o.key, this);
            }
            catch (RegionDestroyedException ex) {
            }
            catch (CancelException ex) {}
        }
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            r = me.getKey();
            txrs = me.getValue();
            txrs.applyChangesEnd(r, this);
        }
    }

    @Override
    public TXEvent getEvent() {
        return new TXEvent(this, this.getCache());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        try {
            this.closed = true;
            this.seenEvents.clear();
            this.seenResults.clear();
            if (this.locks != null) {
                long conflictStart = CachePerfStats.getStatTime();
                this.locks.cleanup();
                if (CachePerfStats.enableClockStats) {
                    this.proxy.getTxMgr().getCachePerfStats().incTxConflictCheckTime(CachePerfStats.getStatTime() - conflictStart);
                }
            }
            for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
                LocalRegion r = me.getKey();
                TXRegionState txrs = me.getValue();
                if (this.gotBucketLocks && r instanceof BucketRegion) {
                    try {
                        ((BucketRegion)r).doUnlockForPrimary();
                    }
                    catch (RegionDestroyedException rde) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("RegionDestroyedException while unlocking bucket region {}", r.getFullPath(), rde);
                        }
                    }
                    catch (Exception rde) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Exception while unlocking bucket region {} this is probably because the bucket was destroyed and never locked initially.", r.getFullPath(), rde);
                        }
                    }
                }
                txrs.cleanup(r);
            }
        }
        finally {
            Object object = this.completionGuard;
            synchronized (object) {
                this.completionGuard.notifyAll();
            }
        }
    }

    @Override
    public List getEvents() {
        ArrayList events = new ArrayList();
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            LocalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.getEvents(r, events, this);
        }
        if (events.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collections.sort(events);
        return Collections.unmodifiableList(events);
    }

    private List getSortedEntries() {
        ArrayList entries = new ArrayList();
        for (Map.Entry<LocalRegion, TXRegionState> me : this.regions.entrySet()) {
            LocalRegion r = me.getKey();
            TXRegionState txrs = me.getValue();
            txrs.getEntries(entries, r);
        }
        if (entries.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collections.sort(entries);
        return entries;
    }

    @Override
    public void beforeCompletion() throws SynchronizationCommitConflictException {
        block7: {
            if (this.closed) {
                throw new TXManagerCancelledException();
            }
            this.proxy.getTxMgr().setTXState(null);
            long opStart = CachePerfStats.getStatTime();
            this.jtaLifeTime = opStart - this.getBeginTime();
            try {
                this.reserveAndCheck();
                TransactionWriter writer = this.proxy.getTxMgr().getWriter();
                if (writer == null) break block7;
                try {
                    this.firedWriter = true;
                    writer.beforeCommit(this.getEvent());
                }
                catch (TransactionWriterException twe) {
                    this.cleanup();
                    throw new CommitConflictException(twe);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    this.cleanup();
                    SystemFailure.checkFailure();
                    throw new CommitConflictException(t);
                }
            }
            catch (CommitConflictException commitConflict) {
                this.proxy.getTxMgr().noteCommitFailure(opStart, this.jtaLifeTime, this);
                throw new SynchronizationCommitConflictException(LocalizedStrings.TXState_CONFLICT_DETECTED_IN_GEMFIRE_TRANSACTION_0.toLocalizedString(this.getTransactionId()), commitConflict);
            }
        }
    }

    @Override
    public void afterCompletion(int status) {
        long opStart = CachePerfStats.getStatTime();
        switch (status) {
            case 3: {
                Assert.assertTrue(this.locks != null, "Gemfire Transaction afterCompletion called with illegal state.");
                try {
                    this.proxy.getTxMgr().setTXState(null);
                    this.commit();
                }
                catch (CommitConflictException error) {
                    Assert.assertTrue(false, "Gemfire Transaction " + this.getTransactionId() + " afterCompletion failed.due to CommitConflictException: " + error);
                }
                this.proxy.getTxMgr().noteCommitSuccess(opStart, this.jtaLifeTime, this);
                this.locks = null;
                break;
            }
            case 4: {
                this.jtaLifeTime = opStart - this.getBeginTime();
                this.proxy.getTxMgr().setTXState(null);
                this.rollback();
                this.proxy.getTxMgr().noteRollbackSuccess(opStart, this.jtaLifeTime, this);
                break;
            }
            default: {
                Assert.assertTrue(false, "Unknown JTA Synchronization status " + status);
            }
        }
    }

    public void setAfterReservation(Runnable afterReservation) {
        this.internalAfterReservation = afterReservation;
    }

    public void setAfterConflictCheck(Runnable afterConflictCheck) {
        this.internalAfterConflictCheck = afterConflictCheck;
    }

    public void setAfterApplyChanges(Runnable afterApplyChanges) {
        this.internalAfterApplyChanges = afterApplyChanges;
    }

    public void setAfterReleaseLocalLocks(Runnable afterReleaseLocalLocks) {
        this.internalAfterReleaseLocalLocks = afterReleaseLocalLocks;
    }

    public void setDuringIndividualSend(Runnable duringIndividualSend) {
        this.internalDuringIndividualSend = duringIndividualSend;
    }

    public void setAfterIndividualSend(Runnable afterIndividualSend) {
        this.internalAfterIndividualSend = afterIndividualSend;
    }

    public void setDuringIndividualCommitProcess(Runnable duringIndividualCommitProcess) {
        this.internalDuringIndividualCommitProcess = duringIndividualCommitProcess;
    }

    public void setAfterIndividualCommitProcess(Runnable afterIndividualCommitProcess) {
        this.internalAfterIndividualCommitProcess = afterIndividualCommitProcess;
    }

    public void setAfterSend(Runnable afterSend) {
        this.internalAfterSend = afterSend;
    }

    public void setBeforeSend(Runnable r) {
        this.internalBeforeSend = r;
    }

    @Override
    public Cache getCache() {
        return this.proxy.getTxMgr().getCache();
    }

    @Override
    public Collection<LocalRegion> getRegions() {
        return this.regions.keySet();
    }

    @Override
    public TXRegionState txWriteRegion(LocalRegion localRegion, KeyInfo entryKey) {
        LocalRegion lr = localRegion.getDataRegionForWrite(entryKey);
        return this.writeRegion(lr);
    }

    @Override
    public TXRegionState txReadRegion(LocalRegion localRegion) {
        return this.readRegion(localRegion);
    }

    final TXEntryState txWriteEntry(LocalRegion region, EntryEventImpl event, boolean ifNew, boolean requireOldValue) {
        try {
            return this.txWriteEntry(region, event, ifNew, requireOldValue, null);
        }
        catch (EntryNotFoundException e) {
            throw new InternalGemFireException("caught unexpected exception", e);
        }
    }

    final TXEntryState txWriteEntry(LocalRegion region, EntryEventImpl event, boolean ifNew, boolean requireOldValue, Object expectedOldValue) throws EntryNotFoundException {
        boolean createIfAbsent = true;
        if (event.hasDelta() && region.getGemFireCache().isSqlfSystem()) {
            createIfAbsent = false;
        } else if (event.getOperation() == Operation.REPLACE) {
            createIfAbsent = false;
        }
        TXEntryState tx = this.txReadEntry(event.getKeyInfo(), region, true, expectedOldValue, createIfAbsent);
        if (tx != null) {
            boolean existsLocally;
            if (requireOldValue && tx.existsLocally()) {
                event.setOldValue(tx.getNearSidePendingValue(), true);
            }
            if (!(existsLocally = tx.existsLocally()) && event.getOperation() == Operation.REPLACE) {
                throw new EntryNotFoundException("No previously created Entry to be updated");
            }
            if (existsLocally && ifNew) {
                return ENTRY_EXISTS;
            }
            tx.updateForWrite(this.nextModSerialNum());
        } else if (!createIfAbsent) {
            throw new EntryNotFoundException("No previously created Entry to be updated");
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean txPutEntry(EntryEventImpl event, boolean ifNew, boolean requireOldValue, boolean checkResources, Object expectedOldValue) {
        LocalRegion region = event.getRegion();
        if (checkResources && !InternalResourceManager.isLowMemoryExceptionDisabled()) {
            region.checkIfAboveThreshold(event);
        }
        if (this.bridgeContext == null) {
            this.bridgeContext = event.getContext();
        }
        if (this.hasSeenEvent(event)) {
            return this.getRecordedResult(event);
        }
        TXEntryState tx = null;
        boolean result = false;
        try {
            tx = this.txWriteEntry(region, event, ifNew, requireOldValue, expectedOldValue);
            result = tx == ENTRY_EXISTS ? false : tx.basicPut(event, ifNew, this.isOriginRemoteForEvents());
        }
        catch (EntryNotFoundException e) {
            if (region.getCache().isSqlfSystem()) {
                throw e;
            }
            result = false;
        }
        finally {
            this.recordEventAndResult(event, result);
        }
        return result;
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo, LocalRegion region) {
        TXEntryState tx = this.txReadEntry(keyInfo, region, true, true);
        if (tx != null) {
            boolean isProxy = false;
            return tx.isLocallyValid(isProxy);
        }
        return region.nonTXContainsValueForKey(keyInfo);
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        if (this.bridgeContext == null) {
            this.bridgeContext = event.getContext();
        }
        if (this.hasSeenEvent(event)) {
            return;
        }
        TXEntryState tx = this.txWriteExistingEntry(event, expectedOldValue);
        LocalRegion region = event.getRegion();
        if (tx.destroy(event, cacheWrite, this.isOriginRemoteForEvents())) {
            Object key2 = event.getKey();
            LocalRegion rr = region.getDataRegionForRead(event.getKeyInfo());
            this.txReadRegion(rr).rmEntryUserAttr(key2);
            this.recordEvent(event);
        }
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        if (this.bridgeContext == null) {
            this.bridgeContext = event.getContext();
        }
        if (this.hasSeenEvent(event)) {
            return;
        }
        TXEntryState tx = this.txWriteExistingEntry(event, null);
        assert (invokeCallbacks && !forceNewEntry);
        tx.invalidate(event);
        this.recordEvent(event);
    }

    private TXEntryState txWriteExistingEntry(EntryEventImpl event, Object expectedOldValue) throws EntryNotFoundException {
        assert (!event.isExpiration());
        Object entryKey = event.getKey();
        LocalRegion region = event.getRegion();
        Operation op = event.getOperation();
        TXEntryState tx = this.txReadEntry(event.getKeyInfo(), region, true, expectedOldValue, true);
        assert (tx != null);
        if (tx.existsLocally()) {
            boolean invalidatingInvalidEntry;
            boolean bl = invalidatingInvalidEntry = op.isInvalidate() && Token.isInvalid(tx.getValueInVM(entryKey));
            if (!invalidatingInvalidEntry) {
                tx.updateForWrite(this.nextModSerialNum());
            }
        } else if (region.isProxy() && !op.isLocal() && !tx.hasOp()) {
            tx.updateForWrite(this.nextModSerialNum());
        } else {
            throw new EntryNotFoundException(entryKey.toString());
        }
        return tx;
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, LocalRegion region, boolean allowTombstones) {
        TXEntryState tx = this.txReadEntry(keyInfo, region, true, true);
        if (tx != null && tx.existsLocally()) {
            return new TXEntry(region, keyInfo, this.getProxy());
        }
        return null;
    }

    @Override
    public Region.Entry accessEntry(KeyInfo keyInfo, LocalRegion localRegion) {
        return this.getEntry(keyInfo, localRegion, false);
    }

    private TXStateInterface getProxy() {
        return this.proxy;
    }

    @Override
    public TXEntryState txReadEntry(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead, boolean createIfAbsent) {
        localRegion.cache.getCancelCriterion().checkCancelInProgress(null);
        return this.txReadEntry(keyInfo, localRegion, rememberRead, null, createIfAbsent);
    }

    private TXEntryState txReadEntry(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead, Object expectedOldValue, boolean createIfAbsent) throws EntryNotFoundException {
        LocalRegion dataReg = localRegion.getDataRegionForRead(keyInfo);
        TXRegionState txr = this.txReadRegion(dataReg);
        TXEntryState result = null;
        if (txr != null) {
            result = txr.readEntry(keyInfo.getKey());
        }
        if (result == null && rememberRead) {
            if (txr == null) {
                txr = this.txWriteRegion(localRegion, keyInfo);
            }
            result = localRegion.createReadEntry(txr, keyInfo, createIfAbsent);
        }
        if (result != null) {
            Object val;
            if (expectedOldValue != null && !AbstractRegionEntry.checkExpectedOldValue(expectedOldValue, val = result.getNearSidePendingValue())) {
                txr.cleanupNonDirtyEntries(localRegion);
                throw new EntryNotFoundException(LocalizedStrings.AbstractRegionMap_THE_CURRENT_VALUE_WAS_NOT_EQUAL_TO_EXPECTED_VALUE.toLocalizedString());
            }
        } else {
            if (txr != null) {
                txr.cleanupNonDirtyEntries(localRegion);
            }
            if (expectedOldValue == null) {
                return result;
            }
            if (!Token.isInvalid(expectedOldValue)) {
                throw new EntryNotFoundException(LocalizedStrings.AbstractRegionMap_THE_CURRENT_VALUE_WAS_NOT_EQUAL_TO_EXPECTED_VALUE.toLocalizedString());
            }
        }
        return result;
    }

    @Override
    public Object getDeserializedValue(KeyInfo keyInfo, LocalRegion localRegion, boolean updateStats, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones) {
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, true, true);
        if (tx != null) {
            Object v = tx.getValue(keyInfo, localRegion, preferCD);
            if (!disableCopyOnRead) {
                v = localRegion.conditionalCopy(v);
            }
            return v;
        }
        return localRegion.getDeserializedValue(keyInfo, updateStats, disableCopyOnRead, preferCD, clientEvent, returnTombstones);
    }

    @Override
    public Object getSerializedValue(LocalRegion localRegion, KeyInfo keyInfo, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws DataLocationException {
        Object key2 = keyInfo.getKey();
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, true, true);
        if (tx != null) {
            Object val = tx.getPendingValue();
            if (val == null || Token.isInvalidOrRemoved(val)) {
                val = this.findObject(keyInfo, localRegion, val != Token.INVALID, true, val, false, false, requestingClient, clientEvent, false);
            }
            return val;
        }
        assert (localRegion instanceof PartitionedRegion);
        PartitionedRegion pr2 = (PartitionedRegion)localRegion;
        return pr2.getDataStore().getSerializedLocally(keyInfo, doNotLockEntry, null, returnTombstones);
    }

    @Override
    public int entryCount(LocalRegion localRegion) {
        int result = localRegion.getRegionSize();
        TXRegionState txr = this.txReadRegion(localRegion);
        if (txr != null) {
            result += txr.entryCountMod();
        }
        if (result > 0) {
            return result;
        }
        return 0;
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo, LocalRegion localRegion) {
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, true, true);
        if (tx != null) {
            return tx.existsLocally();
        }
        return localRegion.nonTXContainsKey(keyInfo);
    }

    @Override
    public Object getValueInVM(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead) {
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, rememberRead, true);
        if (tx != null) {
            return tx.getValueInVM(keyInfo);
        }
        return localRegion.nonTXbasicGetValueInVM(keyInfo);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        this.validateDelta(event);
        return this.txPutEntry(event, ifNew, requireOldValue, true, expectedOldValue);
    }

    private void validateDelta(EntryEventImpl event) {
        if (event.getDeltaBytes() != null && !event.getRegion().getAttributes().getCloningEnabled()) {
            throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_DELTA_WITHOUT_CLONING_CANNOT_BE_USED_IN_TX.toLocalizedString());
        }
    }

    @Override
    public boolean isDeferredStats() {
        return true;
    }

    @Override
    public Object findObject(KeyInfo key2, LocalRegion r, boolean isCreate, boolean generateCallbacks, Object value2, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) {
        return r.findObjectInSystem(key2, isCreate, this, generateCallbacks, value2, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
    }

    private boolean readEntryAndCheckIfDestroyed(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberReads) {
        TXEntryState tx = this.txReadEntry(keyInfo, localRegion, rememberReads, true);
        return tx != null && !tx.existsLocally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getEntryForIterator(KeyInfo curr, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        PartitionedRegion pr2;
        if (currRgn instanceof PartitionedRegion && !(pr2 = (PartitionedRegion)currRgn).getBucketPrimary(curr.getBucketId()).equals(pr2.cache.getMyId())) {
            TXManagerImpl txmgr = pr2.getGemFireCache().getTXMgr();
            TransactionId tid = txmgr.suspend();
            try {
                Region.Entry<?, ?> entry = pr2.nonTXGetEntry(curr, false, allowTombstones);
                return entry;
            }
            finally {
                txmgr.resume(tid);
            }
        }
        if (!this.readEntryAndCheckIfDestroyed(curr, currRgn, rememberReads)) {
            return new TXEntry(currRgn, new KeyInfo(curr.getKey(), curr.getCallbackArg(), curr.getBucketId()), this.proxy, rememberReads);
        }
        return null;
    }

    @Override
    public Object getKeyForIterator(KeyInfo curr, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        if (!this.readEntryAndCheckIfDestroyed(curr, currRgn, rememberReads)) {
            return curr.getKey();
        }
        return null;
    }

    @Override
    public Set getAdditionalKeysForIterator(LocalRegion currRgn) {
        if (currRgn instanceof PartitionedRegion) {
            HashSet ret = new HashSet();
            for (TXRegionState rs : this.regions.values()) {
                TXBucketRegionState brs;
                if (!(rs instanceof TXBucketRegionState) || (brs = (TXBucketRegionState)rs).getPartitionedRegion() != currRgn) continue;
                brs.fillInCreatedEntryKeys(ret);
            }
            return ret;
        }
        TXRegionState txr = this.txReadRegion(currRgn);
        if (txr != null) {
            HashSet ret = new HashSet();
            txr.fillInCreatedEntryKeys(ret);
            return ret;
        }
        return null;
    }

    @Override
    public boolean isInProgressAndSameAs(TXStateInterface otherState) {
        return this.isInProgress() && otherState == this;
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        event.setOriginRemote(true);
        return this.txPutEntry(event, ifNew, requireOldValue, true, expectedOldValue);
    }

    @Override
    public boolean isFireCallbacks() {
        return true;
    }

    public boolean isOriginRemoteForEvents() {
        return this.onBehalfOfRemoteStub || this.proxy.isOnBehalfOfClient();
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        event.setOriginRemote(true);
        this.destroyExistingEntry(event, cacheWrite, expectedOldValue);
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        event.setOriginRemote(true);
        this.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
    }

    @Override
    public void checkSupportsRegionDestroy() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_REGION_DESTROY_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString());
    }

    @Override
    public void checkSupportsRegionInvalidate() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_REGION_INVALIDATE_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString());
    }

    @Override
    public void checkSupportsRegionClear() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(LocalizedStrings.TXState_REGION_CLEAR_NOT_SUPPORTED_IN_A_TRANSACTION.toLocalizedString());
    }

    @Override
    public Set getBucketKeys(LocalRegion localRegion, int bucketId, boolean allowTombstones) {
        PartitionedRegion pr2 = (PartitionedRegion)localRegion;
        return pr2.getBucketKeys(bucketId, allowTombstones);
    }

    @Override
    public Region.Entry getEntryOnRemote(KeyInfo key2, LocalRegion localRegion, boolean allowTombstones) throws DataLocationException {
        PartitionedRegion pr2 = (PartitionedRegion)localRegion;
        Region.Entry txval = this.getEntry(key2, pr2, allowTombstones);
        if (txval == null) {
            throw new EntryNotFoundException(LocalizedStrings.PartitionedRegionDataStore_ENTRY_NOT_FOUND.toLocalizedString());
        }
        NonLocalRegionEntry nlre = new NonLocalRegionEntry(txval, localRegion);
        LocalRegion dataReg = localRegion.getDataRegionForRead(key2);
        return new EntrySnapshot(nlre, dataReg, (LocalRegion)txval.getRegion(), allowTombstones);
    }

    @Override
    public ReentrantLock getLock() {
        return this.proxy.getLock();
    }

    public Set getRegionKeysForIteration(LocalRegion currRegion) {
        return currRegion.getRegionKeysForIteration();
    }

    @Override
    public boolean isRealDealLocal() {
        return true;
    }

    @Override
    public InternalDistributedMember getOriginatingMember() {
        return null;
    }

    @Override
    public boolean isMemberIdForwardingRequired() {
        return false;
    }

    @Override
    public TXCommitMessage getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    public void postPutAll(final DistributedPutAllOperation putallOp, final VersionedObjectList successfulPuts, LocalRegion reg) {
        final LocalRegion theRegion = reg instanceof BucketRegion ? ((BucketRegion)reg).getPartitionedRegion() : reg;
        theRegion.syncBulkOp(new Runnable(){

            @Override
            public void run() {
                InternalDistributedMember myId = theRegion.getDistributionManager().getDistributionManagerId();
                for (int i = 0; i < putallOp.putAllDataSize; ++i) {
                    EntryEventImpl ev = PutAllPRMessage.getEventFromEntry(theRegion, myId, myId, i, putallOp.putAllData, false, putallOp.getBaseEvent().getContext(), false, !putallOp.getBaseEvent().isGenerateCallbacks());
                    ev.setPutAllOperation(putallOp);
                    if (!theRegion.basicPut(ev, false, false, null, false)) continue;
                    successfulPuts.addKeyAndVersion(putallOp.putAllData[i].key, null);
                }
            }
        }, putallOp.getBaseEvent().getEventId());
    }

    @Override
    public void postRemoveAll(final DistributedRemoveAllOperation op, final VersionedObjectList successfulOps, LocalRegion reg) {
        final LocalRegion theRegion = reg instanceof BucketRegion ? ((BucketRegion)reg).getPartitionedRegion() : reg;
        theRegion.syncBulkOp(new Runnable(){

            @Override
            public void run() {
                InternalDistributedMember myId = theRegion.getDistributionManager().getDistributionManagerId();
                for (int i = 0; i < op.removeAllDataSize; ++i) {
                    EntryEventImpl ev = RemoveAllPRMessage.getEventFromEntry(theRegion, myId, myId, i, op.removeAllData, false, op.getBaseEvent().getContext(), false, !op.getBaseEvent().isGenerateCallbacks());
                    ev.setRemoveAllOperation(op);
                    try {
                        theRegion.basicDestroy(ev, true, null);
                    }
                    catch (EntryNotFoundException ignore) {
                        // empty catch block
                    }
                    successfulOps.addKeyAndVersion(op.removeAllData[i].key, null);
                }
            }
        }, op.getBaseEvent().getEventId());
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void recordTXOperation(ServerRegionDataAccess region, TransactionalOperation.ServerRegionOperation op, Object key2, Object[] arguments) {
    }

    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
    }

    static class TXEntryStateWithRegionAndKey
    implements Comparable {
        public final TXEntryState es;
        public final LocalRegion r;
        public final Object key;

        public TXEntryStateWithRegionAndKey(TXEntryState es, LocalRegion r, Object key2) {
            this.es = es;
            this.r = r;
            this.key = key2;
        }

        private int getSortValue() {
            return this.es.getSortValue();
        }

        public int compareTo(Object o) {
            TXEntryStateWithRegionAndKey other = (TXEntryStateWithRegionAndKey)o;
            return this.getSortValue() - other.getSortValue();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TXEntryStateWithRegionAndKey)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return this.getSortValue();
        }
    }
}

