/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.internal.cache.ImageState;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.util.concurrent.StoppableNonReentrantLock;
import com.gemstone.gemfire.internal.util.concurrent.StoppableReentrantReadWriteLock;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;

public class UnsharedImageState
implements ImageState {
    private static final Logger logger = LogService.getLogger();
    private final StoppableNonReentrantLock giiLock;
    private final StoppableReentrantReadWriteLock riLock;
    private volatile ConcurrentMap destroyedEntryKeys;
    private volatile boolean regionInvalidated = false;
    private volatile boolean mayDoRecovery = false;
    private volatile boolean inRecovery = false;
    private volatile boolean clearRegionFlag = false;
    private volatile RegionVersionVector clearRVV;
    private volatile boolean wasRegionClearedDuringGII = false;
    private volatile DiskAccessException dae = null;
    private volatile ConcurrentHashSet<ImageState.VersionTagEntry> versionTags;
    private volatile ConcurrentHashSet<VersionSource> leftMembers;

    UnsharedImageState(boolean isClient, boolean isReplicate, boolean mayDoRecovery, CancelCriterion stopper) {
        this.riLock = isClient ? new StoppableReentrantReadWriteLock(stopper) : null;
        this.giiLock = isReplicate ? new StoppableNonReentrantLock(stopper) : null;
        this.destroyedEntryKeys = new ConcurrentHashMap();
        this.initVersionTagsSet();
        this.initFailedMembersSet();
        this.mayDoRecovery = mayDoRecovery;
        if (mayDoRecovery) {
            this.inRecovery = true;
        }
    }

    @Override
    public boolean isReplicate() {
        return this.giiLock != null;
    }

    @Override
    public boolean isClient() {
        return this.riLock != null;
    }

    @Override
    public void init() {
        if (this.isReplicate()) {
            this.wasRegionClearedDuringGII = false;
        }
    }

    @Override
    public boolean getRegionInvalidated() {
        if (this.isReplicate()) {
            return this.regionInvalidated;
        }
        return false;
    }

    @Override
    public void setRegionInvalidated(boolean b) {
        if (this.isReplicate()) {
            this.regionInvalidated = b;
        }
    }

    @Override
    public void setInRecovery(boolean b) {
        if (this.mayDoRecovery) {
            this.inRecovery = b;
        }
    }

    @Override
    public boolean getInRecovery() {
        if (this.mayDoRecovery) {
            return this.inRecovery;
        }
        return false;
    }

    @Override
    public void addDestroyedEntry(Object key2) {
        if (this.isReplicate() || this.isClient()) {
            this.destroyedEntryKeys.put(key2, Boolean.TRUE);
        }
    }

    @Override
    public void removeDestroyedEntry(Object key2) {
        this.destroyedEntryKeys.remove(key2);
    }

    @Override
    public boolean hasDestroyedEntry(Object key2) {
        return this.destroyedEntryKeys.containsKey(key2);
    }

    @Override
    public Iterator getDestroyedEntries() {
        Iterator result = this.destroyedEntryKeys.keySet().iterator();
        this.destroyedEntryKeys = new ConcurrentHashMap();
        return result;
    }

    private void initVersionTagsSet() {
        this.versionTags = new ConcurrentHashSet(16);
    }

    @Override
    public void addVersionTag(Object key2, VersionTag<?> tag) {
        this.versionTags.add(new VersionTagEntryImpl(key2, (VersionSource<?>)tag.getMemberID(), tag.getRegionVersion()));
    }

    @Override
    public Iterator<ImageState.VersionTagEntry> getVersionTags() {
        Iterator<ImageState.VersionTagEntry> result = this.versionTags.iterator();
        this.initVersionTagsSet();
        return result;
    }

    private void initFailedMembersSet() {
        this.leftMembers = new ConcurrentHashSet(16);
    }

    @Override
    public void addLeftMember(VersionSource<?> mbr) {
        this.leftMembers.add(mbr);
    }

    @Override
    public Set<VersionSource> getLeftMembers() {
        ConcurrentHashSet<VersionSource> result = this.leftMembers;
        this.initFailedMembersSet();
        return result;
    }

    @Override
    public boolean hasLeftMembers() {
        return this.leftMembers.size() > 0;
    }

    public void dumpDestroyedEntryKeys() {
        if (this.destroyedEntryKeys == null) {
            logger.info("region has no destroyedEntryKeys in its image state");
        } else {
            logger.info("dump of image state destroyed entry keys of size {}", this.destroyedEntryKeys.size());
            for (Object key2 : this.destroyedEntryKeys.keySet()) {
                logger.info("key={}", key2);
            }
        }
    }

    @Override
    public int getDestroyedEntriesCount() {
        return this.destroyedEntryKeys.size();
    }

    @Override
    public void setClearRegionFlag(boolean isClearOn, RegionVersionVector rvv) {
        if (this.isReplicate()) {
            this.clearRegionFlag = isClearOn;
            if (isClearOn) {
                this.clearRVV = rvv;
                this.wasRegionClearedDuringGII = true;
            }
        }
    }

    @Override
    public boolean getClearRegionFlag() {
        if (this.isReplicate()) {
            return this.clearRegionFlag;
        }
        return false;
    }

    @Override
    public RegionVersionVector getClearRegionVersionVector() {
        if (this.isReplicate()) {
            return this.clearRVV;
        }
        return null;
    }

    @Override
    public boolean wasRegionClearedDuringGII() {
        if (this.isReplicate()) {
            boolean result = this.wasRegionClearedDuringGII;
            if (result) {
                this.wasRegionClearedDuringGII = false;
            }
            return result;
        }
        return false;
    }

    @Override
    public void lockGII() {
        this.giiLock.lock();
    }

    @Override
    public void unlockGII() {
        this.giiLock.unlock();
    }

    @Override
    public void readLockRI() {
        this.riLock.readLock().lock();
    }

    @Override
    public void readUnlockRI() {
        this.riLock.readLock().unlock();
    }

    @Override
    public void writeLockRI() {
        this.riLock.writeLock().lock();
    }

    @Override
    public void writeUnlockRI() {
        this.riLock.writeLock().unlock();
    }

    private static final class VersionTagEntryImpl
    implements ImageState.VersionTagEntry {
        Object key;
        VersionSource member;
        long regionVersion;

        VersionTagEntryImpl(Object key2, VersionSource<?> member, long regionVersion) {
            this.key = key2;
            this.member = member;
            this.regionVersion = regionVersion;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public VersionSource getMemberID() {
            return this.member;
        }

        @Override
        public long getRegionVersion() {
            return this.regionVersion;
        }

        public String toString() {
            return "{rv" + this.regionVersion + "; mbr=" + this.member + "}";
        }
    }
}

