/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.QueuedOperation;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class UpdateEntryVersionOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();

    public UpdateEntryVersionOperation(CacheEvent event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        return new UpdateEntryVersionMessage(this.event);
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor p) {
        super.initMessage(msg, p);
        UpdateEntryVersionMessage imsg = (UpdateEntryVersionMessage)msg;
        EntryEventImpl eei = this.getEvent();
        imsg.key = eei.getKey();
        imsg.eventId = eei.getEventId();
        imsg.versionTag = eei.getVersionTag();
    }

    public static class UpdateEntryVersionMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected Object key;
        protected EventID eventId = null;
        protected EntryEventImpl event = null;
        private Long tailKey = 0L;

        public UpdateEntryVersionMessage() {
        }

        public UpdateEntryVersionMessage(InternalCacheEvent ev) {
            this.event = (EntryEventImpl)ev;
        }

        @Override
        public int getDSFID() {
            return 158;
        }

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            if (rgn.keyRequiresRegionContext()) {
                ((KeyWithRegionContext)this.key).setRegionContext(rgn);
            }
            EntryEventImpl ev = new EntryEventImpl(rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender(), false);
            ev.setEventId(this.eventId);
            ev.setVersionTag(this.versionTag);
            ev.setTailKey(this.tailKey);
            return ev;
        }

        @Override
        public List getOperations() {
            return Collections.singletonList(new QueuedOperation(this.getOperation(), this.key, null, null, 0, this.callbackArg));
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; key=");
            buff.append(this.key);
            if (this.eventId != null) {
                buff.append("; eventId=").append(this.eventId);
            }
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.region;
            try {
                if (!rgn.isCacheContentProxy()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("UpdateEntryVersionMessage.operationOnRegion; key={}", ev.getKey());
                    }
                    if (rgn.getConcurrencyChecksEnabled()) {
                        rgn.basicUpdateEntryVersion(ev);
                    }
                }
                this.appliedOperation = true;
                return true;
            }
            catch (ConcurrentCacheModificationException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("UpdateEntryVersionMessage.operationOnRegion; ConcurrentCacheModificationException occured for key={}", ev.getKey());
                }
                return true;
            }
            catch (CacheWriterException e) {
                throw new Error(LocalizedStrings.UpdateVersionOperation_CACHEWRITER_SHOULD_NOT_BE_CALLED.toLocalizedString(), e);
            }
            catch (TimeoutException e) {
                throw new Error(LocalizedStrings.UpdateVersionOperation_DISTRIBUTEDLOCK_SHOULD_NOT_BE_ACQUIRED.toLocalizedString(), e);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.key = DataSerializer.readObject(in);
            Boolean hasTailKey = DataSerializer.readBoolean(in);
            if (hasTailKey.booleanValue()) {
                this.tailKey = DataSerializer.readLong(in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventId, out);
            DataSerializer.writeObject(this.key, out);
            DistributedRegion region = (DistributedRegion)this.event.getRegion();
            if (region instanceof BucketRegion) {
                PartitionedRegion pr2 = region.getPartitionedRegion();
                if (pr2.isParallelWanEnabled()) {
                    DataSerializer.writeBoolean(Boolean.TRUE, out);
                    DataSerializer.writeLong(this.event.getTailKey(), out);
                } else {
                    DataSerializer.writeBoolean(Boolean.FALSE, out);
                }
            } else if (region.isUsedForSerialGatewaySenderQueue()) {
                DataSerializer.writeBoolean(Boolean.TRUE, out);
                DataSerializer.writeLong(this.event.getTailKey(), out);
            } else {
                DataSerializer.writeBoolean(Boolean.FALSE, out);
            }
        }
    }
}

